/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.cmstools.tks.TKSCLI;
import com.netscape.cmstools.tks.TKSKeyCreateCLI;
import com.netscape.cmstools.tks.TKSKeyExportCLI;
import com.netscape.cmstools.tks.TKSKeyRemoveCLI;
import com.netscape.cmstools.tks.TKSKeyReplaceCLI;
import com.netscape.cmstools.tks.TKSKeyShowCLI;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSKeyCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(TKSKeyCLI.class);
    public TKSCLI tksCLI;
    public TPSConnectorClient tpsConnectorClient;

    public TKSKeyCLI(TKSCLI tksCLI) {
        super("key", "Key management commands", (CLI)tksCLI);
        this.tksCLI = tksCLI;
        this.addModule((CLI)new TKSKeyCreateCLI(this));
        this.addModule((CLI)new TKSKeyExportCLI(this));
        this.addModule((CLI)new TKSKeyRemoveCLI(this));
        this.addModule((CLI)new TKSKeyReplaceCLI(this));
        this.addModule((CLI)new TKSKeyShowCLI(this));
    }

    public String getFullName() {
        return this.parent.getFullName() + "-" + this.name;
    }

    public TPSConnectorClient getTPSConnectorClient() throws Exception {
        if (this.tpsConnectorClient != null) {
            return this.tpsConnectorClient;
        }
        this.tpsConnectorClient = (TPSConnectorClient)this.parent.getClient("admin/tps-connectors");
        return this.tpsConnectorClient;
    }

    public static void printKeyInfo(String id, KeyData data) {
        RequestId requestID;
        String wrapAlgorithm;
        String encryptAlgorithmOID;
        System.out.println("  Key ID: " + id);
        String type = data.getType();
        if (type != null) {
            System.out.println("  Type: " + type);
        }
        if ((encryptAlgorithmOID = data.getEncryptAlgorithmOID()) != null) {
            System.out.println("  Encrypt Algorithm: " + encryptAlgorithmOID);
        }
        if ((wrapAlgorithm = data.getWrapAlgorithm()) != null) {
            System.out.println("  Wrap Algorithm: " + wrapAlgorithm);
        }
        if ((requestID = data.getRequestID()) != null) {
            System.out.println("  Request ID: " + requestID.toHexString());
        }
    }
}

