/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.user;

import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.user.UserCertData;
import com.netscape.certsrv.user.UserClient;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.user.UserCLI;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(UserAddCLI.class);
    public UserCLI userCLI;

    public UserAddCLI(UserCLI userCLI) {
        super("add", "Add user", (CLI)userCLI);
        this.userCLI = userCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <User ID> --fullName <fullname> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "fullName", true, "Full name");
        option.setArgName("fullName");
        this.options.addOption(option);
        option = new Option(null, "email", true, "Email");
        option.setArgName("email");
        this.options.addOption(option);
        option = new Option(null, "password", true, "Password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "phone", true, "Phone");
        option.setArgName("phone");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "state", true, "State");
        option.setArgName("state");
        this.options.addOption(option);
        option = new Option(null, "cert-file", true, "Path to user certificate");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "User certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "security-domain", true, "Security domain URL");
        option.setArgName("URL");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No User ID specified.");
        }
        String userID = cmdArgs[0];
        String fullName = cmd.getOptionValue("fullName");
        if (fullName == null) {
            throw new Exception("Missing full name");
        }
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        UserData userData = new UserData();
        userData.setUserID(userID);
        userData.setFullName(fullName);
        userData.setEmail(cmd.getOptionValue("email"));
        userData.setPassword(cmd.getOptionValue("password"));
        userData.setPhone(cmd.getOptionValue("phone"));
        userData.setType(cmd.getOptionValue("type"));
        userData.setState(cmd.getOptionValue("state"));
        byte[] binCert = null;
        String filename = cmd.getOptionValue("cert-file");
        if (filename != null) {
            binCert = Files.readAllBytes(Paths.get(filename, new String[0]));
            String format = cmd.getOptionValue("format");
            if (format == null || "PEM".equalsIgnoreCase(format)) {
                binCert = Cert.parseCertificate((String)new String(binCert));
            } else if (!"DER".equalsIgnoreCase(format)) {
                throw new Exception("Unsupported format: " + format);
            }
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String securityDomain = cmd.getOptionValue("security-domain");
        if (securityDomain == null) {
            UserClient userClient = this.userCLI.getUserClient();
            userData = userClient.addUser(userData);
            if (binCert != null) {
                String pemCert = "-----BEGIN CERTIFICATE-----\n" + Utils.base64encodeMultiLine((byte[])binCert) + "-----END CERTIFICATE-----\n";
                UserCertData userCertData = new UserCertData();
                userCertData.setEncoded(pemCert);
                userCertData = userClient.addUserCert(userID, userCertData);
            }
        } else {
            URI uri = new URL(securityDomain).toURI();
            if (binCert == null) {
                throw new Exception("Missing user certificate");
            }
            String b64Cert = Utils.base64encodeSingleLine((byte[])binCert);
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.userCLI.getParent();
            SubsystemClient subsystemClient = subsystemCLI.getSubsystemClient();
            subsystemClient.addUser(uri, userID, fullName, b64Cert, sessionID);
        }
        MainCLI.printMessage("Added user \"" + userID + "\"");
        UserCLI.printUser(userData);
    }
}

