/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.realm;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.logging.event.AuthEvent;
import com.netscape.certsrv.usrgrp.EUsrGrpException;
import com.netscape.cms.realm.PKIPrincipal;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.User;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIRealm
extends RealmBase {
    private static Logger logger = LoggerFactory.getLogger(PKIRealm.class);
    protected CMSEngine engine;

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public Principal authenticate(String username, String password) {
        logger.info("PKIRealm: Authenticating user " + username + " with password");
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = "$Unidentified$";
        String attemptedAuditUID = username;
        try {
            AuthSubsystem authSub = this.engine.getAuthSubsystem();
            AuthManager authMgr = authSub.getAuthManager("passwdUserDBAuthMgr");
            AuthCredentials creds = new AuthCredentials();
            creds.set("uid", username);
            creds.set("pwd", password);
            AuthToken authToken = authMgr.authenticate(creds);
            authToken.set("authManagerId", "passwdUserDBAuthMgr");
            auditSubjectID = authToken.getInString("userid");
            logger.info("PKIRealm: User " + username + " authenticated");
            auditor.log(AuthEvent.createSuccessEvent(auditSubjectID, "passwdUserDBAuthMgr"));
            return this.getPrincipal(username, authToken);
        }
        catch (EInvalidCredentials | EMissingCredential e) {
            logger.warn("Unable to authenticate user " + username + ": " + e.getMessage());
            auditor.log(AuthEvent.createFailureEvent(auditSubjectID, "passwdUserDBAuthMgr", attemptedAuditUID));
            return null;
        }
        catch (Exception e) {
            logger.warn("Unable to authenticate user " + username + ": " + e.getMessage(), (Throwable)e);
            auditor.log(AuthEvent.createFailureEvent(auditSubjectID, "passwdUserDBAuthMgr", attemptedAuditUID));
            throw new RuntimeException(e);
        }
    }

    public Principal authenticate(X509Certificate[] certs) {
        String auditSubjectID;
        logger.info("PKIRealm: Authenticating certificate chain:");
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = certs[i];
            logger.info("PKIRealm: - " + cert.getSubjectDN());
        }
        Auditor auditor = this.engine.getAuditor();
        String attemptedAuditUID = auditSubjectID = this.getAuditUserfromCert(certs[0]);
        try {
            X509CertImpl[] certImpls = new X509CertImpl[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                X509Certificate cert = certs[i];
                certImpls[i] = new X509CertImpl(cert.getEncoded());
            }
            AuthSubsystem authSub = this.engine.getAuthSubsystem();
            AuthManager authMgr = authSub.getAuthManager("certUserDBAuthMgr");
            AuthCredentials creds = new AuthCredentials();
            creds.set("sslClientCert", certImpls);
            AuthToken authToken = authMgr.authenticate(creds);
            authToken.set("authManagerId", "certUserDBAuthMgr");
            String username = authToken.getInString("userid");
            auditSubjectID = authToken.getInString("userid");
            logger.info("PKIRealm: User " + username + " authenticated");
            auditor.log(AuthEvent.createSuccessEvent(auditSubjectID, "certUserDBAuthMgr"));
            return this.getPrincipal(username, authToken);
        }
        catch (EInvalidCredentials | EMissingCredential e) {
            logger.warn("Unable to authenticate user with certificate " + auditSubjectID + ": " + e.getMessage());
            auditor.log(AuthEvent.createFailureEvent(auditSubjectID, "certUserDBAuthMgr", attemptedAuditUID));
            return null;
        }
        catch (Exception e) {
            logger.warn("Unable to authenticate user with certificate " + auditSubjectID + ": " + e.getMessage(), (Throwable)e);
            auditor.log(AuthEvent.createFailureEvent(auditSubjectID, "certUserDBAuthMgr", attemptedAuditUID));
            throw new RuntimeException(e);
        }
    }

    private String getAuditUserfromCert(X509Certificate clientCert) {
        String certUID = clientCert.getSubjectDN().getName();
        return StringUtils.stripToNull((String)certUID);
    }

    protected Principal getPrincipal(String username) {
        logger.info("PKIRealm: Getting principal for " + username);
        try {
            return this.getPrincipal(username, (AuthToken)null);
        }
        catch (Exception e) {
            logger.warn("Unable to get principal for " + username + ": " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    protected Principal getPrincipal(String username, AuthToken authToken) throws Exception {
        User user = this.getUser(username);
        return this.getPrincipal(user, authToken);
    }

    protected Principal getPrincipal(User user, AuthToken authToken) throws EUsrGrpException {
        List<String> roles = this.getRoles(user);
        return new PKIPrincipal(user, null, roles, authToken);
    }

    protected User getUser(String username) throws EUsrGrpException {
        UGSubsystem ugSub = this.engine.getUGSubsystem();
        User user = ugSub.getUser(username);
        logger.info("PKIRealm: User DN: " + user.getUserDN());
        return user;
    }

    protected List<String> getRoles(User user) throws EUsrGrpException {
        ArrayList<String> roles = new ArrayList<String>();
        UGSubsystem ugSub = this.engine.getUGSubsystem();
        Enumeration<Group> groups = ugSub.findGroupsByUser(user.getUserDN(), null);
        logger.info("PKIRealm: Roles:");
        while (groups.hasMoreElements()) {
            Group group = groups.nextElement();
            String name = group.getName();
            logger.info("PKIRealm: - " + name);
            roles.add(name);
        }
        return roles;
    }

    protected String getPassword(String username) {
        return null;
    }
}

