/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.apps;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.PreOpConfig;
import com.netscape.cmscore.apps.SubsystemsConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.SimpleProperties;
import com.netscape.cmscore.jobs.JobsSchedulerConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.logging.LoggingConfig;
import com.netscape.cmscore.security.JssSubsystemConfig;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.authorization.AuthorizationConfig;

public class EngineConfig
extends ConfigStore {
    public EngineConfig() {
    }

    public EngineConfig(ConfigStorage storage) {
        super(storage);
    }

    public EngineConfig(String name, SimpleProperties source) {
        super(name, source);
    }

    public String getHostname() {
        try {
            return this.getString("machineName", "");
        }
        catch (EBaseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHostname(String hostname) throws EBaseException {
        this.putString("machineName", hostname);
    }

    public String getInstanceID() throws EBaseException {
        return this.getString("instanceId");
    }

    public void setInstanceID(String instanceID) throws EBaseException {
        this.putString("instanceId", instanceID);
    }

    public String getType() throws EBaseException {
        return this.getString("cs.type");
    }

    public void setType(String type) throws EBaseException {
        this.putString("cs.type", type);
    }

    public int getState() throws EBaseException {
        return this.getInteger("cs.state");
    }

    public void setState(int state) {
        this.putInteger("cs.state", state);
    }

    public LDAPConfig getInternalDBConfig() {
        return this.getSubStore("internaldb", LDAPConfig.class);
    }

    public SubsystemsConfig getSubsystemsConfig() {
        return this.getSubStore("subsystem", SubsystemsConfig.class);
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.getSubStore("auths", AuthenticationConfig.class);
    }

    public AuthorizationConfig getAuthorizationConfig() {
        return this.getSubStore("authz", AuthorizationConfig.class);
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.getSubStore("dbs", DatabaseConfig.class);
    }

    public PreOpConfig getPreOpConfig() {
        return this.getSubStore("preop", PreOpConfig.class);
    }

    public PKISocketConfig getSocketConfig() {
        return this.getSubStore("tcp", PKISocketConfig.class);
    }

    public UGSubsystemConfig getUGSubsystemConfig() {
        return this.getSubStore("usrgrp", UGSubsystemConfig.class);
    }

    public PasswordStoreConfig getPasswordStoreConfig() throws EBaseException {
        PasswordStoreConfig config = new PasswordStoreConfig();
        config.setID(this.getString("instanceId"));
        config.setClassName(this.getString("passwordClass"));
        config.setFileName(this.getString("passwordFile", null));
        return config;
    }

    public JssSubsystemConfig getJssSubsystemConfig() {
        return this.getSubStore("jss", JssSubsystemConfig.class);
    }

    public JobsSchedulerConfig getJobsSchedulerConfig() {
        return this.getSubStore("jobsScheduler", JobsSchedulerConfig.class);
    }

    public LoggingConfig getLoggingConfig() {
        return this.getSubStore("log", LoggingConfig.class);
    }

    public boolean getUseOAEPKeyWrap() throws EBaseException {
        return this.getBoolean("keyWrap.useOAEP", false);
    }
}

