/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.util;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.util.StatsEvent;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.util.StatsMilestone;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class StatsSubsystem
extends Subsystem {
    public static final String ID = "stats";
    private String mId = null;
    private StatsEvent mAllTrans = new StatsEvent(null);
    private Date mStartTime = new Date();
    private Hashtable<String, Vector<StatsMilestone>> mHashtable = new Hashtable();

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    @Override
    public synchronized void init(ConfigStore config) throws Exception {
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public void startTiming(String id) {
        this.startTiming(id, false);
    }

    public void startTiming(String id, boolean mainAction) {
        StatsEvent newST;
        Thread t = Thread.currentThread();
        Vector<Object> milestones = null;
        if (this.mHashtable.containsKey(t.toString())) {
            milestones = this.mHashtable.get(t.toString());
        } else {
            milestones = new Vector();
            this.mHashtable.put(t.toString(), milestones);
        }
        long startTime = new Date().getTime();
        StatsEvent currentST = null;
        for (int i = 0; i < milestones.size(); ++i) {
            StatsMilestone se = (StatsMilestone)milestones.elementAt(i);
            currentST = currentST == null ? this.mAllTrans.getSubEvent(se.getId()) : currentST.getSubEvent(se.getId());
        }
        if (currentST == null) {
            if (!mainAction) {
                return;
            }
            currentST = this.mAllTrans;
        }
        if ((newST = currentST.getSubEvent(id)) == null) {
            newST = new StatsEvent(currentST);
            newST.setName(id);
            currentST.addSubEvent(newST);
        }
        milestones.addElement(new StatsMilestone(id, startTime, newST));
    }

    public void endTiming(String id) {
        long endTime = new Date().getTime();
        Thread t = Thread.currentThread();
        if (!this.mHashtable.containsKey(t.toString())) {
            return;
        }
        Vector<StatsMilestone> milestones = this.mHashtable.get(t.toString());
        if (milestones.size() == 0) {
            return;
        }
        StatsMilestone last = milestones.remove(milestones.size() - 1);
        StatsEvent st = last.getStatsEvent();
        st.incNoOfOperations(1L);
        st.incTimeTaken(endTime - last.getStartTime());
        if (milestones.size() == 0) {
            this.mHashtable.remove(t.toString());
        }
    }

    public void resetCounters() {
        this.mStartTime = new Date();
        this.mAllTrans.resetCounters();
    }

    public StatsEvent getMainStatsEvent() {
        return this.mAllTrans;
    }

    @Override
    public void startup() throws EBaseException {
    }

    @Override
    public synchronized void shutdown() {
    }

    @Override
    public ConfigStore getConfigStore() {
        return null;
    }
}

