/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.core.policy;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.core.policy.PolicyInstance;
import org.dogtagpki.legacy.core.policy.PolicyPredicateParser;
import org.dogtagpki.legacy.core.policy.PolicySet;
import org.dogtagpki.legacy.core.policy.RegisteredPolicy;
import org.dogtagpki.legacy.core.policy.SimpleExpression;
import org.dogtagpki.legacy.policy.EPolicyException;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IExpression;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.policy.IPolicyRule;
import org.dogtagpki.legacy.policy.IRenewalPolicy;
import org.dogtagpki.legacy.policy.IRevocationPolicy;
import org.dogtagpki.legacy.server.policy.constraints.ManualAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPolicyProcessor
implements IPolicyProcessor {
    public static Logger logger = LoggerFactory.getLogger(GenericPolicyProcessor.class);
    protected CMSEngine engine;
    protected ConfigStore mConfig;
    protected EngineConfig mGlobalStore = null;
    protected IAuthority mAuthority = null;
    public static final String[] DEF_POLICIES = new String[]{ManualAuthentication.class.getName()};
    public static final Hashtable<String, IExpression> DEF_UNDELETABLE_POLICIES = new Hashtable();
    private String mId = "Policy";
    private Vector<String> mPolicyOrder = new Vector();
    private Hashtable<String, RegisteredPolicy> mImplTable = new Hashtable();
    private Hashtable<String, PolicyInstance> mInstanceTable = new Hashtable();
    PolicySet mEnrollmentRules = new PolicySet("EnrollmentRules");
    PolicySet mRenewalRules = new PolicySet("RenewalRules");
    PolicySet mRevocationRules = new PolicySet("RevocationRules");
    private String[] mSystemDefaults = null;
    private boolean mInitSystemPolicies;
    private Hashtable<String, IExpression> mUndeletablePolicies = null;

    public GenericPolicyProcessor() {
        this.mInitSystemPolicies = true;
    }

    public GenericPolicyProcessor(boolean initSystemPolicies) {
        this.mInitSystemPolicies = initSystemPolicies;
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    public void startup() throws EBaseException {
    }

    public void shutdown() {
    }

    @Override
    public IAuthority getAuthority() {
        return this.mAuthority;
    }

    public synchronized ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public synchronized void init(IAuthority owner, ConfigStore config) throws EBaseException {
        block22: {
            logger.debug("GenericPolicyProcessor::init begins");
            EngineConfig configStore = this.engine.getConfig();
            this.mAuthority = owner;
            this.mConfig = config;
            this.mGlobalStore = configStore;
            String PKI_Subsystem = configStore.getString("subsystem.0.id", null);
            if (!PKI_Subsystem.trim().equalsIgnoreCase("ca") && !PKI_Subsystem.trim().equalsIgnoreCase("kra")) break block22;
            String policyStatus = PKI_Subsystem.trim().toLowerCase() + ".Policy.enable";
            if (configStore.getBoolean(policyStatus, true)) {
                logger.debug("GenericPolicyProcessor::init Certificate Policy Framework (deprecated) is ENABLED");
                break block22;
            }
            logger.debug("GenericPolicyProcessor::init Certificate Policy Framework (deprecated) is DISABLED");
            return;
        }
        if (this.mInitSystemPolicies) {
            this.initSystemPolicies(this.mConfig);
        }
        this.initUndeletablePolicies(this.mConfig);
        ConfigStore c = config.getSubStore("impl", ConfigStore.class);
        Enumeration<String> mImpls = c.getSubStoreNames().elements();
        while (mImpls.hasMoreElements()) {
            String id = mImpls.nextElement();
            if (this.mImplTable.containsKey(id)) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_DUPLICATE_IMPL_ID", id));
            }
            String clPath = c.getString(id + ".class");
            if (this.isSystemDefaultPolicy(clPath)) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_SYSTEM_POLICY_CONFIG_ERROR", clPath));
            }
            try {
                Object o = Class.forName(clPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof IEnrollmentPolicy || o instanceof IRenewalPolicy || o instanceof IRevocationPolicy)) {
                    throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_IMPL", clPath));
                }
            }
            catch (EBaseException e) {
                throw e;
            }
            catch (Exception e) {
                String message = CMS.getUserMessage("CMS_POLICY_NO_POLICY_IMPL", id);
                logger.error(message + ": " + e.getMessage(), (Throwable)e);
                throw new EPolicyException(message, e);
            }
            RegisteredPolicy regPolicy = new RegisteredPolicy(id, clPath);
            this.mImplTable.put(id, regPolicy);
        }
        String policyOrder = config.getString("order", null);
        if (policyOrder == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(policyOrder, ",");
        while (tokens.hasMoreTokens()) {
            this.mPolicyOrder.addElement(tokens.nextToken().trim());
        }
        int numPolicies = this.mPolicyOrder.size();
        ConfigStore ruleStore = config.getSubStore("rule", ConfigStore.class);
        for (int i = 0; i < numPolicies; ++i) {
            String instanceName = this.mPolicyOrder.elementAt(i);
            if (this.mInstanceTable.containsKey(instanceName)) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_DUPLICATE_INST_ID", instanceName));
            }
            c = ruleStore.getSubStore(instanceName, ConfigStore.class);
            if (c == null || c.size() == 0) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_NO_POLICY_CONFIG", instanceName));
            }
            IPolicyRule rule = null;
            String enabledStr = c.getString("enable", null);
            boolean enabled = enabledStr == null || enabledStr.trim().length() == 0 || enabledStr.trim().equalsIgnoreCase("true");
            String implName = c.getString("implName", null);
            if (implName == null) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_NO_POLICY_CONFIG", instanceName));
            }
            RegisteredPolicy regPolicy = this.mImplTable.get(implName);
            if (regPolicy == null) {
                String[] params = new String[]{implName, instanceName};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_IMPL_NOT_FOUND", params));
            }
            String classpath = regPolicy.getClassPath();
            try {
                rule = (IPolicyRule)Class.forName(classpath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                rule.setInstanceName(instanceName);
                rule.init(this, c);
            }
            catch (Throwable e) {
                logger.warn(CMS.getLogMessage("CMSCORE_POLICY_INIT_FAILED", instanceName, e.toString()), e);
                enabled = false;
                c.putString("enable", "false");
            }
            if (rule == null) continue;
            String exp = c.getString("predicate", null);
            if (exp != null) {
                exp = exp.trim();
            }
            if (exp != null && exp.length() > 0) {
                IExpression filterExp = PolicyPredicateParser.parse(exp);
                rule.setPredicate(filterExp);
            }
            this.mInstanceTable.put(instanceName, new PolicyInstance(instanceName, implName, rule, enabled));
            if (!enabled) continue;
            this.addRule(instanceName, rule);
        }
        this.verifyDefaultPolicyConfig();
    }

    public boolean isProfileRequest(Request request) {
        String profileId = request.getExtDataInString("profileId");
        return profileId != null && !profileId.equals("");
    }

    @Override
    public PolicyResult apply(Request request) {
        PolicySet rules = null;
        String op = request.getRequestType();
        logger.debug("GenericPolicyProcessor: apply begins");
        if (op == null) {
            logger.debug("GenericPolicyProcessor: apply op null");
            return PolicyResult.ACCEPTED;
        }
        if (this.isProfileRequest(request)) {
            logger.debug("GenericPolicyProcessor: Profile-base Request " + request.getRequestId().toString());
            return PolicyResult.ACCEPTED;
        }
        logger.debug("GenericPolicyProcessor: apply not ProfileRequest. op=" + op);
        if (op.equalsIgnoreCase("enrollment")) {
            rules = this.mEnrollmentRules;
        } else if (op.equalsIgnoreCase("renewal")) {
            rules = this.mRenewalRules;
        } else if (op.equalsIgnoreCase("revocation")) {
            rules = this.mRevocationRules;
        } else {
            return PolicyResult.ACCEPTED;
        }
        if (rules.count() == 0) {
            logger.debug("GenericPolicyProcessor: apply: rule count 0");
            return PolicyResult.ACCEPTED;
        }
        logger.debug("GenericPolicyProcessor: apply: rules.count=" + rules.count());
        PolicyResult res = PolicyResult.ACCEPTED;
        String mVersion = "1.0.0";
        String vers = request.getRequestVersion();
        if (vers == null || !vers.equals(mVersion)) {
            if (vers == null || vers.length() == 0) {
                vers = "none";
            }
            res = PolicyResult.REJECTED;
        }
        if (res == PolicyResult.REJECTED) {
            return res;
        }
        logger.debug("GenericPolicyProcessor: apply: calling rules.apply()");
        return rules.apply(request);
    }

    public void printPolicies() {
        this.mEnrollmentRules.printPolicies();
        this.mRenewalRules.printPolicies();
        this.mRevocationRules.printPolicies();
    }

    @Override
    public String getPolicySubstoreId() {
        return this.mAuthority.getId() + ".Policy";
    }

    @Override
    public Enumeration<IPolicyRule> getPolicyImpls() {
        Vector<IPolicyRule> impls = new Vector<IPolicyRule>();
        Enumeration<RegisteredPolicy> enum1 = this.mImplTable.elements();
        Enumeration<IPolicyRule> ret = null;
        try {
            while (enum1.hasMoreElements()) {
                RegisteredPolicy regPolicy = enum1.nextElement();
                IPolicyRule ruleImpl = (IPolicyRule)Class.forName(regPolicy.getClassPath()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                impls.addElement(ruleImpl);
            }
            ret = impls.elements();
        }
        catch (Exception e) {
            logger.warn("Unable to get policy implementations: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    public Enumeration<String> getPolicyImplsInfo() {
        Vector<String> impls = new Vector<String>();
        Enumeration<RegisteredPolicy> enum1 = this.mImplTable.elements();
        Enumeration<String> ret = null;
        try {
            while (enum1.hasMoreElements()) {
                RegisteredPolicy regPolicy = enum1.nextElement();
                impls.addElement(regPolicy.getId());
            }
            ret = impls.elements();
        }
        catch (Exception e) {
            logger.warn("Unable to get policy implementation infos: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    public IPolicyRule getPolicyImpl(String id) {
        RegisteredPolicy regImpl = this.mImplTable.get(id);
        if (regImpl == null) {
            return null;
        }
        IPolicyRule impl = null;
        try {
            impl = (IPolicyRule)Class.forName(regImpl.getClassPath()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Unable to get policy implementation: " + e.getMessage(), (Throwable)e);
        }
        return impl;
    }

    @Override
    public Vector<String> getPolicyImplConfig(String id) {
        IPolicyRule rp = this.getPolicyImpl(id);
        if (rp == null) {
            return null;
        }
        Vector<String> v = rp.getDefaultParams();
        if (v == null) {
            v = new Vector();
        }
        v.insertElementAt("enable=true", 0);
        v.insertElementAt("predicate= ", 1);
        return v;
    }

    @Override
    public void deletePolicyImpl(String id) throws EBaseException {
        RegisteredPolicy regPolicy = this.mImplTable.get(id);
        if (regPolicy == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_NO_POLICY_IMPL", id));
        }
        boolean instanceExist = false;
        Enumeration<PolicyInstance> e = this.mInstanceTable.elements();
        while (e.hasMoreElements()) {
            PolicyInstance inst = e.nextElement();
            if (!inst.isInstanceOf(id)) continue;
            instanceExist = true;
            break;
        }
        if (instanceExist) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_ACTIVE_POLICY_RULES_EXIST", id));
        }
        this.mImplTable.remove(id);
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        ConfigStore implStore = policyStore.getSubStore("impl", ConfigStore.class);
        implStore.removeSubStore(id);
        try {
            this.mGlobalStore.commit(true);
        }
        catch (Exception ex) {
            String[] params = new String[]{"implementation", id};
            String message = CMS.getUserMessage("CMS_POLICY_DELETING_POLICY_ERROR", params);
            logger.error(message + ": " + ex.getMessage(), (Throwable)ex);
            throw new EPolicyException(message, ex);
        }
    }

    @Override
    public void addPolicyImpl(String id, String classPath) throws EBaseException {
        if (this.mImplTable.containsKey(id)) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_DUPLICATE_IMPL_ID", id));
        }
        Object impl = null;
        try {
            impl = Class.forName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_NO_POLICY_IMPL", id), e);
        }
        if (!(impl instanceof IEnrollmentPolicy || impl instanceof IRenewalPolicy || impl instanceof IRevocationPolicy)) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_IMPL", classPath));
        }
        RegisteredPolicy regPolicy = new RegisteredPolicy(id, classPath);
        this.mImplTable.put(id, regPolicy);
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        ConfigStore implStore = policyStore.getSubStore("impl", ConfigStore.class);
        ConfigStore newStore = implStore.makeSubStore(id);
        newStore.put("class", classPath);
        try {
            this.mGlobalStore.commit(true);
        }
        catch (Exception e) {
            String[] params = new String[]{"implementation", id};
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_ADDING_POLICY_ERROR", params));
        }
    }

    @Override
    public Enumeration<IPolicyRule> getPolicyInstances() {
        Vector<IPolicyRule> rules = new Vector<IPolicyRule>();
        Enumeration<String> enum1 = this.mPolicyOrder.elements();
        Enumeration<IPolicyRule> ret = null;
        try {
            while (enum1.hasMoreElements()) {
                PolicyInstance instance = this.mInstanceTable.get(enum1.nextElement());
                rules.addElement(instance.getRule());
            }
            ret = rules.elements();
        }
        catch (Exception e) {
            logger.warn("Unable to get policy instances: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    public Enumeration<String> getPolicyInstancesInfo() {
        Vector<String> rules = new Vector<String>();
        Enumeration<String> enum1 = this.mPolicyOrder.elements();
        Enumeration<String> ret = null;
        try {
            while (enum1.hasMoreElements()) {
                String ruleName = enum1.nextElement();
                PolicyInstance instance = this.mInstanceTable.get(ruleName);
                rules.addElement(instance.getRuleInfo());
            }
            ret = rules.elements();
        }
        catch (Exception e) {
            logger.warn("Unable to get policy instance infos: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    public IPolicyRule getPolicyInstance(String id) {
        PolicyInstance policyInstance = this.mInstanceTable.get(id);
        return policyInstance == null ? null : policyInstance.getRule();
    }

    @Override
    public Vector<String> getPolicyInstanceConfig(String id) {
        PolicyInstance policyInstance = this.mInstanceTable.get(id);
        if (policyInstance == null) {
            return null;
        }
        Vector<String> v = policyInstance.getRule().getInstanceParams();
        if (v == null) {
            v = new Vector();
        }
        v.insertElementAt("implName=" + policyInstance.getImplId(), 0);
        v.insertElementAt("enable=" + policyInstance.isActive(), 1);
        String predicate = " ";
        if (policyInstance.getRule().getPredicate() != null) {
            predicate = policyInstance.getRule().getPredicate().toString();
        }
        v.insertElementAt("predicate=" + predicate, 2);
        return v;
    }

    @Override
    public void deletePolicyInstance(String id) throws EBaseException {
        if (this.mUndeletablePolicies.containsKey(id)) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_CANT_DELETE_PERSISTENT_POLICY", id));
        }
        PolicyInstance instance = this.mInstanceTable.get(id);
        if (instance == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_INSTANCE", id));
        }
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        ConfigStore instanceStore = policyStore.getSubStore("rule", ConfigStore.class);
        instanceStore.removeSubStore(id);
        int index = this.mPolicyOrder.indexOf(id);
        this.mPolicyOrder.removeElement(id);
        policyStore.put("order", this.getRuleOrderString(this.mPolicyOrder));
        try {
            this.mGlobalStore.commit(true);
        }
        catch (Exception e) {
            this.mPolicyOrder.insertElementAt(id, index);
            String[] params = new String[]{"instance", id};
            String message = CMS.getUserMessage("CMS_POLICY_DELETING_POLICY_ERROR", params);
            logger.error(message + ": " + e.getMessage(), (Throwable)e);
            throw new EPolicyException(message, e);
        }
        IPolicyRule rule = instance.getRule();
        if (rule instanceof IEnrollmentPolicy) {
            this.mEnrollmentRules.removeRule(id);
        }
        if (rule instanceof IRenewalPolicy) {
            this.mRenewalRules.removeRule(id);
        }
        if (rule instanceof IRevocationPolicy) {
            this.mRevocationRules.removeRule(id);
        }
        this.mInstanceTable.remove(id);
    }

    @Override
    public void addPolicyInstance(String id, Hashtable<String, String> ht) throws EBaseException {
        if (this.getPolicyInstance(id) != null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_DUPLICATE_INST_ID", id));
        }
        String implName = ht.get("implName");
        IPolicyRule rule = this.getPolicyImpl(implName);
        if (rule == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_NO_POLICY_IMPL", implName));
        }
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        ConfigStore instanceStore = policyStore.getSubStore("rule", ConfigStore.class);
        ConfigStore newStore = instanceStore.makeSubStore(id);
        Enumeration<String> keys = ht.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String val = ht.get(key);
            newStore.put(key, val);
        }
        policyStore.put("order", this.getRuleOrderString(this.mPolicyOrder, id));
        rule.init(this, newStore);
        String enabledStr = ht.get("enable");
        boolean active = false;
        if (enabledStr == null || enabledStr.trim().length() == 0 || enabledStr.equalsIgnoreCase("true")) {
            active = true;
        }
        String predicate = ht.get("predicate").trim();
        IExpression exp = null;
        if (predicate.trim().length() > 0) {
            exp = PolicyPredicateParser.parse(predicate.trim());
        }
        rule.setPredicate(exp);
        try {
            this.mGlobalStore.commit(true);
        }
        catch (Exception e) {
            String[] params = new String[]{"instance", id};
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_ADDING_POLICY_ERROR", params));
        }
        PolicyInstance policyInst = new PolicyInstance(id, implName, rule, active);
        this.mInstanceTable.put(id, policyInst);
        this.mPolicyOrder.addElement(id);
        if (!active) {
            return;
        }
        this.addRule(id, rule);
    }

    @Override
    public void modifyPolicyInstance(String id, Hashtable<String, String> ht) throws EBaseException {
        String v;
        String k;
        PolicyInstance policyInstance = this.mInstanceTable.get(id);
        if (policyInstance == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_INSTANCE", id));
        }
        IPolicyRule rule = policyInstance.getRule();
        String implId = ht.get("implName");
        if (!implId.equals(policyInstance.getImplId())) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_IMPLCHANGE_ERROR", id));
        }
        IPolicyRule newRule = this.getPolicyImpl(implId);
        if (newRule == null) {
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_IMPL", implId));
        }
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        ConfigStore instanceStore = policyStore.getSubStore("rule", ConfigStore.class);
        ConfigStore oldStore = instanceStore.getSubStore(id, ConfigStore.class);
        ConfigStore newStore = new ConfigStore(id);
        String enabledStr = ht.get("enable");
        boolean active = false;
        if (enabledStr == null || enabledStr.trim().length() == 0 || enabledStr.equalsIgnoreCase("true")) {
            active = true;
        }
        String predicate = ht.get("predicate").trim();
        IExpression exp = null;
        if (predicate.trim().length() > 0) {
            exp = PolicyPredicateParser.parse(predicate.trim());
        }
        if (this.mUndeletablePolicies.containsKey(id)) {
            if (!active) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_INACTIVE", id));
            }
            IExpression defPred = this.mUndeletablePolicies.get(id);
            if (defPred == SimpleExpression.NULL_EXPRESSION) {
                defPred = null;
            }
            if (exp == null && defPred != null) {
                String[] params = new String[]{id, defPred.toString(), "null"};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
            }
            if (exp != null && defPred == null) {
                String[] params = new String[]{id, "null", exp.toString()};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
            }
            if (exp != null && defPred != null && !defPred.toString().equals(exp.toString())) {
                String[] params = new String[]{id, defPred.toString(), exp.toString()};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
            }
        }
        ht.put("enable", String.valueOf(active));
        Enumeration<String> oldkeys = oldStore.keys();
        while (oldkeys.hasMoreElements()) {
            k = oldkeys.nextElement();
            v = oldStore.getString(k);
            newStore.put(k, v);
        }
        Enumeration<String> newkeys = ht.keys();
        while (newkeys.hasMoreElements()) {
            k = newkeys.nextElement();
            v = ht.get(k);
            logger.debug("newstore key " + k + "=" + v);
            if (v == null || k.equals("OP_TYPE") || k.equals("OP_SCOPE") || k.equals("RS_ID") || k.equals("RULENAME")) continue;
            logger.debug("newstore.put(" + k + "=" + v + ")");
            newStore.put(k, v);
        }
        newRule.init(this, newStore);
        policyInstance.setRule(newRule);
        policyInstance.setActive(active);
        if (exp != null) {
            newRule.setPredicate(exp);
        }
        try {
            Enumeration<String> e = newStore.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (key == null) continue;
                logger.debug("oldstore.put(" + key + "," + newStore.getString(key) + ")");
                oldStore.put(key, newStore.getString(key));
            }
            this.mGlobalStore.commit(true);
        }
        catch (Exception e) {
            String[] params = new String[]{"instance", id};
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_ADDING_POLICY_ERROR", params));
        }
        if (!active) {
            if (rule instanceof IEnrollmentPolicy) {
                this.mEnrollmentRules.removeRule(id);
            }
            if (rule instanceof IRenewalPolicy) {
                this.mRenewalRules.removeRule(id);
            }
            if (rule instanceof IRevocationPolicy) {
                this.mRevocationRules.removeRule(id);
            }
        } else {
            if (rule instanceof IEnrollmentPolicy) {
                this.mEnrollmentRules.replaceRule(id, newRule);
            }
            if (rule instanceof IRenewalPolicy) {
                this.mRenewalRules.replaceRule(id, newRule);
            }
            if (rule instanceof IRevocationPolicy) {
                this.mRevocationRules.replaceRule(id, newRule);
            }
        }
    }

    @Override
    public synchronized void changePolicyInstanceOrdering(String policyOrderStr) throws EBaseException {
        Vector<String> policyOrder = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(policyOrderStr, ",");
        while (tokens.hasMoreTokens()) {
            String instanceId = tokens.nextToken().trim();
            if (!this.mInstanceTable.containsKey(instanceId)) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_INVALID_POLICY_INSTANCE", instanceId));
            }
            policyOrder.addElement(instanceId);
        }
        if (policyOrder.size() == this.mPolicyOrder.size() && this.areSameVectors(policyOrder, this.mPolicyOrder)) {
            return;
        }
        PolicySet enrollmentRules = new PolicySet("EnrollmentRules");
        PolicySet renewalRules = new PolicySet("RenewalRules");
        PolicySet revocationRules = new PolicySet("RevocationRules");
        try {
            for (int i = 0; i < this.mSystemDefaults.length; ++i) {
                String defRuleName = this.mSystemDefaults[i].substring(this.mSystemDefaults[i].lastIndexOf(46) + 1);
                IPolicyRule defRule = (IPolicyRule)Class.forName(this.mSystemDefaults[i]).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigStore ruleConfig = this.mConfig.getSubStore("systemPolicies." + defRuleName, ConfigStore.class);
                defRule.init(this, ruleConfig);
                if (defRule instanceof IEnrollmentPolicy) {
                    enrollmentRules.addRule(defRuleName, defRule);
                    continue;
                }
                if (defRule instanceof IRenewalPolicy) {
                    renewalRules.addRule(defRuleName, defRule);
                    continue;
                }
                if (!(defRule instanceof IRevocationPolicy)) continue;
                revocationRules.addRule(defRuleName, defRule);
            }
        }
        catch (Throwable e) {
            EBaseException ex = new EBaseException(CMS.getUserMessage("CMS_BASE_INTERNAL_ERROR", "Cannot create default policy rule. Error: " + e.getMessage()), e);
            String message = CMS.getLogMessage("CMSCORE_POLICY_DEF_CREATE", e.getMessage());
            logger.error(message, e);
            throw ex;
        }
        Enumeration<String> enum1 = policyOrder.elements();
        while (enum1.hasMoreElements()) {
            String instanceName = enum1.nextElement();
            PolicyInstance pInstance = this.mInstanceTable.get(instanceName);
            if (!pInstance.isActive()) continue;
            IPolicyRule rule = pInstance.getRule();
            if (rule instanceof IEnrollmentPolicy) {
                enrollmentRules.addRule(instanceName, rule);
                continue;
            }
            if (rule instanceof IRenewalPolicy) {
                renewalRules.addRule(instanceName, rule);
                continue;
            }
            if (!(rule instanceof IRevocationPolicy)) continue;
            revocationRules.addRule(instanceName, rule);
        }
        this.mEnrollmentRules = enrollmentRules;
        this.mRenewalRules = renewalRules;
        this.mRevocationRules = revocationRules;
        this.mPolicyOrder = policyOrder;
        ConfigStore policyStore = this.mGlobalStore.getSubStore(this.getPolicySubstoreId(), ConfigStore.class);
        policyStore.put("order", policyOrderStr);
        try {
            this.mGlobalStore.commit(true);
        }
        catch (Exception ex) {
            String message = CMS.getUserMessage("CMS_POLICY_ORDER_ERROR", policyOrderStr);
            logger.error(message + ": " + ex.getMessage(), (Throwable)ex);
            throw new EPolicyException(message, ex);
        }
    }

    private boolean areSameVectors(Vector<String> v1, Vector<String> v2) {
        int i;
        if (v1.size() != v2.size()) {
            return false;
        }
        int size = v1.size();
        for (i = 0; i < size && v2.indexOf(v1.elementAt(i)) == i; ++i) {
        }
        return i == size;
    }

    private String getRuleOrderString(Vector<String> rules) {
        StringBuffer sb = new StringBuffer();
        Enumeration<String> e = rules.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return new String(sb);
    }

    private String getRuleOrderString(Vector<String> rules, String newRule) {
        String currentRules = this.getRuleOrderString(rules);
        return currentRules.length() == 0 ? newRule : currentRules + "," + newRule;
    }

    private void initSystemPolicies(ConfigStore mConfig) throws EBaseException {
        String enable = mConfig.getString("systemPolicies.enable", "true").trim();
        if (enable.equalsIgnoreCase("false")) {
            this.mSystemDefaults = DEF_POLICIES;
            return;
        }
        String configuredDefaults = mConfig.getString("systemPolicies", null);
        if (configuredDefaults == null || configuredDefaults.trim().length() == 0) {
            this.mSystemDefaults = DEF_POLICIES;
        } else {
            Vector<String> rules = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(configuredDefaults.trim(), ",");
            while (tokenizer.hasMoreTokens()) {
                String rule = tokenizer.nextToken().trim();
                rules.addElement(rule);
            }
            if (rules.size() > 0) {
                this.mSystemDefaults = new String[rules.size()];
                rules.copyInto(this.mSystemDefaults);
            } else {
                this.mSystemDefaults = DEF_POLICIES;
            }
        }
        for (int i = 0; i < this.mSystemDefaults.length; ++i) {
            String className = this.mSystemDefaults[i];
            logger.info("GenericPolicyProcessor: Creating system policy " + className);
            try {
                Class<?> clazz = Class.forName(this.mSystemDefaults[i]);
                Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(o instanceof IPolicyRule)) {
                    throw new EPolicyException(className + " does not implement IPolicyRule");
                }
                IPolicyRule rule = (IPolicyRule)o;
                String ruleName = className.substring(className.lastIndexOf(46) + 1);
                ConfigStore ruleConfig = mConfig.getSubStore("systemPolicies." + ruleName, ConfigStore.class);
                logger.info("GenericPolicyProcessor: Initializing system policy " + ruleName);
                rule.init(this, ruleConfig);
                this.addRule(ruleName, rule);
                continue;
            }
            catch (EBaseException e) {
                throw e;
            }
            catch (Exception e) {
                String message = "Unable to create system policy " + className + ": " + e.getMessage();
                logger.error(message, (Throwable)e);
                throw new EPolicyException(message, e);
            }
        }
    }

    private void initUndeletablePolicies(ConfigStore mConfig) throws EBaseException {
        String configuredUndeletables = mConfig.getString("undeletablePolicies", null);
        if (configuredUndeletables == null || configuredUndeletables.trim().length() == 0) {
            this.mUndeletablePolicies = DEF_UNDELETABLE_POLICIES;
            return;
        }
        Vector<String> rules = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(configuredUndeletables.trim(), ",");
        while (tokenizer.hasMoreTokens()) {
            String rule = tokenizer.nextToken().trim();
            rules.addElement(rule);
        }
        if (rules.size() == 0) {
            this.mUndeletablePolicies = DEF_UNDELETABLE_POLICIES;
            return;
        }
        this.mUndeletablePolicies = new Hashtable();
        Enumeration e = rules.elements();
        while (e.hasMoreElements()) {
            String urn = (String)e.nextElement();
            String pred = mConfig.getString("undeletablePolicies." + urn + ".predicate", null);
            IExpression exp = SimpleExpression.NULL_EXPRESSION;
            if (pred != null) {
                exp = PolicyPredicateParser.parse(pred);
            }
            this.mUndeletablePolicies.put(urn, exp);
        }
    }

    private void addRule(String ruleName, IPolicyRule rule) {
        if (rule instanceof IEnrollmentPolicy) {
            this.mEnrollmentRules.addRule(ruleName, rule);
        }
        if (rule instanceof IRenewalPolicy) {
            this.mRenewalRules.addRule(ruleName, rule);
        }
        if (rule instanceof IRevocationPolicy) {
            this.mRevocationRules.addRule(ruleName, rule);
        }
    }

    private boolean isSystemDefaultPolicy(String clPath) {
        boolean ret = false;
        if (this.mSystemDefaults == null) {
            return false;
        }
        for (int i = 0; i < this.mSystemDefaults.length; ++i) {
            if (!clPath.equals(this.mSystemDefaults[i])) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void verifyDefaultPolicyConfig() throws EPolicyException {
        Enumeration<String> e = this.mUndeletablePolicies.keys();
        while (e.hasMoreElements()) {
            String urn = e.nextElement();
            PolicyInstance inst = this.mInstanceTable.get(urn);
            if (inst == null) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_MISSING_PERSISTENT_RULE", urn));
            }
            if (!inst.isActive()) {
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_INACTIVE", urn));
            }
            IExpression defPred = this.mUndeletablePolicies.get(urn);
            if (defPred == SimpleExpression.NULL_EXPRESSION) {
                defPred = null;
            }
            IExpression confPred = inst.getRule().getPredicate();
            if (defPred == null && confPred != null) {
                String[] params = new String[]{urn, "null", confPred.toString()};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
            }
            if (defPred != null && confPred == null) {
                String[] params = new String[]{urn, defPred.toString(), "null"};
                throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
            }
            if (defPred == null || confPred == null || defPred.toString().equals(confPred.toString())) continue;
            String[] params = new String[]{urn, defPred.toString(), confPred.toString()};
            throw new EPolicyException(CMS.getUserMessage("CMS_POLICY_PERSISTENT_RULE_MISCONFIG", params));
        }
    }
}

