// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_builder_autogen.h:
//   Functions to generate SPIR-V binary for each instruction.

#ifndef COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_
#define COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_

#include <spirv/unified1/spirv.hpp>

#include "spirv_types.h"

namespace angle
{
namespace spirv
{

void WriteSpirvHeader(std::vector<uint32_t> *blob, uint32_t version, uint32_t idCount);
void WriteNop(Blob *blob);
void WriteUndef(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteSourceContinued(Blob *blob, LiteralString continuedSource);
void WriteSource(Blob *blob,
                 spv::SourceLanguage sourceLanguage1,
                 LiteralInteger version,
                 const IdRef *file,
                 const LiteralString *source);
void WriteSourceExtension(Blob *blob, LiteralString extension);
void WriteName(Blob *blob, IdRef target, LiteralString name);
void WriteMemberName(Blob *blob, IdRef type, LiteralInteger member, LiteralString name);
void WriteString(Blob *blob, IdResult idResult1, LiteralString string);
void WriteLine(Blob *blob, IdRef file, LiteralInteger line, LiteralInteger column);
void WriteExtension(Blob *blob, LiteralString name);
void WriteExtInstImport(Blob *blob, IdResult idResult1, LiteralString name);
void WriteExtInst(Blob *blob,
                  IdResultType idResultType1,
                  IdResult idResult2,
                  IdRef set,
                  LiteralExtInstInteger instruction,
                  const IdRefList &operandList);
void WriteMemoryModel(Blob *blob,
                      spv::AddressingModel addressingModel1,
                      spv::MemoryModel memoryModel2);
void WriteEntryPoint(Blob *blob,
                     spv::ExecutionModel executionModel1,
                     IdRef entryPoint,
                     LiteralString name,
                     const IdRefList &interfaceList);
void WriteExecutionMode(Blob *blob,
                        IdRef entryPoint,
                        spv::ExecutionMode mode,
                        const LiteralIntegerList &operandsList);
void WriteCapability(Blob *blob, spv::Capability capability);
void WriteTypeVoid(Blob *blob, IdResult idResult1);
void WriteTypeBool(Blob *blob, IdResult idResult1);
void WriteTypeInt(Blob *blob, IdResult idResult1, LiteralInteger width, LiteralInteger signedness);
void WriteTypeFloat(Blob *blob,
                    IdResult idResult1,
                    LiteralInteger width,
                    const spv::FPEncoding *floatingPointEncoding);
void WriteTypeVector(Blob *blob,
                     IdResult idResult1,
                     IdRef componentType,
                     LiteralInteger componentCount);
void WriteTypeMatrix(Blob *blob, IdResult idResult1, IdRef columnType, LiteralInteger columnCount);
void WriteTypeImage(Blob *blob,
                    IdResult idResult1,
                    IdRef sampledType,
                    spv::Dim dim3,
                    LiteralInteger depth,
                    LiteralInteger arrayed,
                    LiteralInteger mS,
                    LiteralInteger sampled,
                    spv::ImageFormat imageFormat8,
                    const spv::AccessQualifier *accessQualifier9);
void WriteTypeSampler(Blob *blob, IdResult idResult1);
void WriteTypeSampledImage(Blob *blob, IdResult idResult1, IdRef imageType);
void WriteTypeArray(Blob *blob, IdResult idResult1, IdRef elementType, IdRef length);
void WriteTypeRuntimeArray(Blob *blob, IdResult idResult1, IdRef elementType);
void WriteTypeStruct(Blob *blob, IdResult idResult1, const IdRefList &memberList);
void WriteTypePointer(Blob *blob, IdResult idResult1, spv::StorageClass storageClass2, IdRef type);
void WriteTypeFunction(Blob *blob,
                       IdResult idResult1,
                       IdRef returnType,
                       const IdRefList &parameterList);
void WriteConstantTrue(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteConstantFalse(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteConstant(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   LiteralContextDependentNumber value);
void WriteConstantComposite(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            const IdRefList &constituentsList);
void WriteConstantNull(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteSpecConstantTrue(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteSpecConstantFalse(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteSpecConstant(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       LiteralContextDependentNumber value);
void WriteSpecConstantComposite(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                const IdRefList &constituentsList);
void WriteFunction(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   spv::FunctionControlMask functionControl3,
                   IdRef functionType);
void WriteFunctionParameter(Blob *blob, IdResultType idResultType1, IdResult idResult2);
void WriteFunctionEnd(Blob *blob);
void WriteFunctionCall(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef function,
                       const IdRefList &argumentList);
void WriteVariable(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   spv::StorageClass storageClass3,
                   const IdRef *initializer);
void WriteImageTexelPointer(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef image,
                            IdRef coordinate,
                            IdRef sample);
void WriteLoad(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef pointer,
               const spv::MemoryAccessMask *memoryAccess4);
void WriteStore(Blob *blob,
                IdRef pointer,
                IdRef object,
                const spv::MemoryAccessMask *memoryAccess3);
void WriteCopyMemory(Blob *blob,
                     IdRef target,
                     IdRef source,
                     const spv::MemoryAccessMask *memoryAccess3,
                     const spv::MemoryAccessMask *memoryAccess4);
void WriteAccessChain(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef base,
                      const IdRefList &indexesList);
void WriteInBoundsAccessChain(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef base,
                              const IdRefList &indexesList);
void WriteArrayLength(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef structure,
                      LiteralInteger arraymember);
void WriteDecorate(Blob *blob,
                   IdRef target,
                   spv::Decoration decoration2,
                   const LiteralIntegerList &valuesList);
void WriteMemberDecorate(Blob *blob,
                         IdRef structureType,
                         LiteralInteger member,
                         spv::Decoration decoration3,
                         const LiteralIntegerList &valuesList);
void WriteDecorationGroup(Blob *blob, IdResult idResult1);
void WriteGroupDecorate(Blob *blob, IdRef decorationGroup, const IdRefList &targetsList);
void WriteGroupMemberDecorate(Blob *blob,
                              IdRef decorationGroup,
                              const PairIdRefLiteralIntegerList &targetsPairList);
void WriteVectorExtractDynamic(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef vector,
                               IdRef index);
void WriteVectorInsertDynamic(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef vector,
                              IdRef component,
                              IdRef index);
void WriteVectorShuffle(Blob *blob,
                        IdResultType idResultType1,
                        IdResult idResult2,
                        IdRef vector1,
                        IdRef vector2,
                        const LiteralIntegerList &componentsList);
void WriteCompositeConstruct(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             const IdRefList &constituentsList);
void WriteCompositeExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef composite,
                           const LiteralIntegerList &indexesList);
void WriteCompositeInsert(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef object,
                          IdRef composite,
                          const LiteralIntegerList &indexesList);
void WriteCopyObject(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteTranspose(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef matrix);
void WriteSampledImage(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef image,
                       IdRef sampler);
void WriteImageSampleImplicitLod(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 const spv::ImageOperandsMask *imageOperands5,
                                 const IdRefList &imageOperandIdsList);
void WriteImageSampleExplicitLod(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 spv::ImageOperandsMask imageOperands5,
                                 const IdRefList &imageOperandIdsList);
void WriteImageSampleDrefImplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     const spv::ImageOperandsMask *imageOperands6,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleDrefExplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     spv::ImageOperandsMask imageOperands6,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjImplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     const spv::ImageOperandsMask *imageOperands5,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjExplicitLod(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     spv::ImageOperandsMask imageOperands5,
                                     const IdRefList &imageOperandIdsList);
void WriteImageSampleProjDrefImplicitLod(Blob *blob,
                                         IdResultType idResultType1,
                                         IdResult idResult2,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         const spv::ImageOperandsMask *imageOperands6,
                                         const IdRefList &imageOperandIdsList);
void WriteImageSampleProjDrefExplicitLod(Blob *blob,
                                         IdResultType idResultType1,
                                         IdResult idResult2,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         spv::ImageOperandsMask imageOperands6,
                                         const IdRefList &imageOperandIdsList);
void WriteImageFetch(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef image,
                     IdRef coordinate,
                     const spv::ImageOperandsMask *imageOperands5,
                     const IdRefList &imageOperandIdsList);
void WriteImageGather(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef sampledImage,
                      IdRef coordinate,
                      IdRef component,
                      const spv::ImageOperandsMask *imageOperands6,
                      const IdRefList &imageOperandIdsList);
void WriteImageDrefGather(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef sampledImage,
                          IdRef coordinate,
                          IdRef dref,
                          const spv::ImageOperandsMask *imageOperands6,
                          const IdRefList &imageOperandIdsList);
void WriteImageRead(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef image,
                    IdRef coordinate,
                    const spv::ImageOperandsMask *imageOperands5,
                    const IdRefList &imageOperandIdsList);
void WriteImageWrite(Blob *blob,
                     IdRef image,
                     IdRef coordinate,
                     IdRef texel,
                     const spv::ImageOperandsMask *imageOperands4,
                     const IdRefList &imageOperandIdsList);
void WriteImage(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef sampledImage);
void WriteImageQuerySizeLod(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef image,
                            IdRef levelofDetail);
void WriteImageQuerySize(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef image);
void WriteImageQueryLod(Blob *blob,
                        IdResultType idResultType1,
                        IdResult idResult2,
                        IdRef sampledImage,
                        IdRef coordinate);
void WriteImageQueryLevels(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef image);
void WriteImageQuerySamples(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef image);
void WriteConvertFToU(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue);
void WriteConvertFToS(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue);
void WriteConvertSToF(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef signedValue);
void WriteConvertUToF(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef unsignedValue);
void WriteUConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef unsignedValue);
void WriteSConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef signedValue);
void WriteFConvert(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef floatValue);
void WriteQuantizeToF16(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef value);
void WriteBitcast(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteSNegate(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteFNegate(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteIAdd(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFAdd(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteISub(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFSub(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteIMul(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFMul(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteUDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteSDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFDiv(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteUMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteSRem(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteSMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFRem(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteFMod(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef operand1,
               IdRef operand2);
void WriteVectorTimesScalar(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef vector,
                            IdRef scalar);
void WriteMatrixTimesScalar(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef matrix,
                            IdRef scalar);
void WriteVectorTimesMatrix(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef vector,
                            IdRef matrix);
void WriteMatrixTimesVector(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef matrix,
                            IdRef vector);
void WriteMatrixTimesMatrix(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef leftMatrix,
                            IdRef rightMatrix);
void WriteOuterProduct(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef vector1,
                       IdRef vector2);
void WriteDot(Blob *blob,
              IdResultType idResultType1,
              IdResult idResult2,
              IdRef vector1,
              IdRef vector2);
void WriteIAddCarry(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteISubBorrow(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2);
void WriteUMulExtended(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteSMulExtended(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteAny(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef vector);
void WriteAll(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef vector);
void WriteIsNan(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef x);
void WriteIsInf(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef x);
void WriteLogicalEqual(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteLogicalNotEqual(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef operand1,
                          IdRef operand2);
void WriteLogicalOr(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteLogicalAnd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2);
void WriteLogicalNot(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteSelect(Blob *blob,
                 IdResultType idResultType1,
                 IdResult idResult2,
                 IdRef condition,
                 IdRef object1,
                 IdRef object2);
void WriteIEqual(Blob *blob,
                 IdResultType idResultType1,
                 IdResult idResult2,
                 IdRef operand1,
                 IdRef operand2);
void WriteINotEqual(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteUGreaterThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteSGreaterThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteUGreaterThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2);
void WriteSGreaterThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2);
void WriteULessThan(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteSLessThan(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteULessThanEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2);
void WriteSLessThanEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdEqual(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteFUnordEqual(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef operand1,
                      IdRef operand2);
void WriteFOrdNotEqual(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteFUnordNotEqual(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdLessThan(Blob *blob,
                       IdResultType idResultType1,
                       IdResult idResult2,
                       IdRef operand1,
                       IdRef operand2);
void WriteFUnordLessThan(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef operand1,
                         IdRef operand2);
void WriteFOrdGreaterThan(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef operand1,
                          IdRef operand2);
void WriteFUnordGreaterThan(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2);
void WriteFOrdLessThanEqual(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef operand1,
                            IdRef operand2);
void WriteFUnordLessThanEqual(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdRef operand1,
                              IdRef operand2);
void WriteFOrdGreaterThanEqual(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef operand1,
                               IdRef operand2);
void WriteFUnordGreaterThanEqual(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdRef operand1,
                                 IdRef operand2);
void WriteShiftRightLogical(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef base,
                            IdRef shift);
void WriteShiftRightArithmetic(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdRef base,
                               IdRef shift);
void WriteShiftLeftLogical(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef shift);
void WriteBitwiseOr(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef operand1,
                    IdRef operand2);
void WriteBitwiseXor(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2);
void WriteBitwiseAnd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef operand1,
                     IdRef operand2);
void WriteNot(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WriteBitFieldInsert(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef base,
                         IdRef insert,
                         IdRef offset,
                         IdRef count);
void WriteBitFieldSExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef offset,
                           IdRef count);
void WriteBitFieldUExtract(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef base,
                           IdRef offset,
                           IdRef count);
void WriteBitReverse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef base);
void WriteBitCount(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef base);
void WriteDPdx(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteDPdy(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteFwidth(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteDPdxFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteDPdyFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteFwidthFine(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteDPdxCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteDPdyCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteFwidthCoarse(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef p);
void WriteEmitVertex(Blob *blob);
void WriteEndPrimitive(Blob *blob);
void WriteEmitStreamVertex(Blob *blob, IdRef stream);
void WriteEndStreamPrimitive(Blob *blob, IdRef stream);
void WriteControlBarrier(Blob *blob,
                         IdScope execution,
                         IdScope memory,
                         IdMemorySemantics semantics);
void WriteMemoryBarrier(Blob *blob, IdScope memory, IdMemorySemantics semantics);
void WriteAtomicLoad(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics);
void WriteAtomicStore(Blob *blob,
                      IdRef pointer,
                      IdScope memory,
                      IdMemorySemantics semantics,
                      IdRef value);
void WriteAtomicExchange(Blob *blob,
                         IdResultType idResultType1,
                         IdResult idResult2,
                         IdRef pointer,
                         IdScope memory,
                         IdMemorySemantics semantics,
                         IdRef value);
void WriteAtomicCompareExchange(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdRef pointer,
                                IdScope memory,
                                IdMemorySemantics equal,
                                IdMemorySemantics unequal,
                                IdRef value,
                                IdRef comparator);
void WriteAtomicIIncrement(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef pointer,
                           IdScope memory,
                           IdMemorySemantics semantics);
void WriteAtomicIDecrement(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef pointer,
                           IdScope memory,
                           IdMemorySemantics semantics);
void WriteAtomicIAdd(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicISub(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicSMin(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicUMin(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicSMax(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicUMax(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef pointer,
                     IdScope memory,
                     IdMemorySemantics semantics,
                     IdRef value);
void WriteAtomicAnd(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef pointer,
                    IdScope memory,
                    IdMemorySemantics semantics,
                    IdRef value);
void WriteAtomicOr(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   IdRef pointer,
                   IdScope memory,
                   IdMemorySemantics semantics,
                   IdRef value);
void WriteAtomicXor(Blob *blob,
                    IdResultType idResultType1,
                    IdResult idResult2,
                    IdRef pointer,
                    IdScope memory,
                    IdMemorySemantics semantics,
                    IdRef value);
void WritePhi(Blob *blob,
              IdResultType idResultType1,
              IdResult idResult2,
              const PairIdRefIdRefList &variableParentPairList);
void WriteLoopMerge(Blob *blob,
                    IdRef mergeBlock,
                    IdRef continueTarget,
                    spv::LoopControlMask loopControl3);
void WriteSelectionMerge(Blob *blob, IdRef mergeBlock, spv::SelectionControlMask selectionControl2);
void WriteLabel(Blob *blob, IdResult idResult1);
void WriteBranch(Blob *blob, IdRef targetLabel);
void WriteBranchConditional(Blob *blob,
                            IdRef condition,
                            IdRef trueLabel,
                            IdRef falseLabel,
                            const LiteralIntegerList &branchweightsList);
void WriteSwitch(Blob *blob,
                 IdRef selector,
                 IdRef default_,
                 const PairLiteralIntegerIdRefList &targetPairList);
void WriteKill(Blob *blob);
void WriteReturn(Blob *blob);
void WriteReturnValue(Blob *blob, IdRef value);
void WriteUnreachable(Blob *blob);
void WriteImageSparseSampleImplicitLod(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       const spv::ImageOperandsMask *imageOperands5,
                                       const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleExplicitLod(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       spv::ImageOperandsMask imageOperands5,
                                       const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleDrefImplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           const spv::ImageOperandsMask *imageOperands6,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleDrefExplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           spv::ImageOperandsMask imageOperands6,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjImplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           const spv::ImageOperandsMask *imageOperands5,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjExplicitLod(Blob *blob,
                                           IdResultType idResultType1,
                                           IdResult idResult2,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           spv::ImageOperandsMask imageOperands5,
                                           const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjDrefImplicitLod(Blob *blob,
                                               IdResultType idResultType1,
                                               IdResult idResult2,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               const spv::ImageOperandsMask *imageOperands6,
                                               const IdRefList &imageOperandIdsList);
void WriteImageSparseSampleProjDrefExplicitLod(Blob *blob,
                                               IdResultType idResultType1,
                                               IdResult idResult2,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               spv::ImageOperandsMask imageOperands6,
                                               const IdRefList &imageOperandIdsList);
void WriteImageSparseFetch(Blob *blob,
                           IdResultType idResultType1,
                           IdResult idResult2,
                           IdRef image,
                           IdRef coordinate,
                           const spv::ImageOperandsMask *imageOperands5,
                           const IdRefList &imageOperandIdsList);
void WriteImageSparseGather(Blob *blob,
                            IdResultType idResultType1,
                            IdResult idResult2,
                            IdRef sampledImage,
                            IdRef coordinate,
                            IdRef component,
                            const spv::ImageOperandsMask *imageOperands6,
                            const IdRefList &imageOperandIdsList);
void WriteImageSparseDrefGather(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdRef sampledImage,
                                IdRef coordinate,
                                IdRef dref,
                                const spv::ImageOperandsMask *imageOperands6,
                                const IdRefList &imageOperandIdsList);
void WriteImageSparseTexelsResident(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdRef residentCode);
void WriteNoLine(Blob *blob);
void WriteImageSparseRead(Blob *blob,
                          IdResultType idResultType1,
                          IdResult idResult2,
                          IdRef image,
                          IdRef coordinate,
                          const spv::ImageOperandsMask *imageOperands5,
                          const IdRefList &imageOperandIdsList);
void WriteModuleProcessed(Blob *blob, LiteralString process);
void WriteExecutionModeId(Blob *blob,
                          IdRef entryPoint,
                          spv::ExecutionMode mode,
                          const LiteralIntegerList &operandsList);
void WriteGroupNonUniformElect(Blob *blob,
                               IdResultType idResultType1,
                               IdResult idResult2,
                               IdScope execution);
void WriteGroupNonUniformAll(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             IdScope execution,
                             IdRef predicate);
void WriteGroupNonUniformAny(Blob *blob,
                             IdResultType idResultType1,
                             IdResult idResult2,
                             IdScope execution,
                             IdRef predicate);
void WriteGroupNonUniformAllEqual(Blob *blob,
                                  IdResultType idResultType1,
                                  IdResult idResult2,
                                  IdScope execution,
                                  IdRef value);
void WriteGroupNonUniformBroadcast(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   IdRef value,
                                   IdRef id);
void WriteGroupNonUniformBroadcastFirst(Blob *blob,
                                        IdResultType idResultType1,
                                        IdResult idResult2,
                                        IdScope execution,
                                        IdRef value);
void WriteGroupNonUniformBallot(Blob *blob,
                                IdResultType idResultType1,
                                IdResult idResult2,
                                IdScope execution,
                                IdRef predicate);
void WriteGroupNonUniformInverseBallot(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value);
void WriteGroupNonUniformBallotBitExtract(Blob *blob,
                                          IdResultType idResultType1,
                                          IdResult idResult2,
                                          IdScope execution,
                                          IdRef value,
                                          IdRef index);
void WriteGroupNonUniformBallotBitCount(Blob *blob,
                                        IdResultType idResultType1,
                                        IdResult idResult2,
                                        IdScope execution,
                                        spv::GroupOperation operation,
                                        IdRef value);
void WriteGroupNonUniformBallotFindLSB(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value);
void WriteGroupNonUniformBallotFindMSB(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value);
void WriteGroupNonUniformShuffle(Blob *blob,
                                 IdResultType idResultType1,
                                 IdResult idResult2,
                                 IdScope execution,
                                 IdRef value,
                                 IdRef id);
void WriteGroupNonUniformShuffleXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    IdRef value,
                                    IdRef mask);
void WriteGroupNonUniformShuffleUp(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   IdRef value,
                                   IdRef delta);
void WriteGroupNonUniformShuffleDown(Blob *blob,
                                     IdResultType idResultType1,
                                     IdResult idResult2,
                                     IdScope execution,
                                     IdRef value,
                                     IdRef delta);
void WriteGroupNonUniformIAdd(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformFAdd(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformIMul(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformFMul(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformSMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformUMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformFMin(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformSMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformUMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformFMax(Blob *blob,
                              IdResultType idResultType1,
                              IdResult idResult2,
                              IdScope execution,
                              spv::GroupOperation operation,
                              IdRef value,
                              const IdRef *clusterSize);
void WriteGroupNonUniformBitwiseAnd(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize);
void WriteGroupNonUniformBitwiseOr(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   spv::GroupOperation operation,
                                   IdRef value,
                                   const IdRef *clusterSize);
void WriteGroupNonUniformBitwiseXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize);
void WriteGroupNonUniformLogicalAnd(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize);
void WriteGroupNonUniformLogicalOr(Blob *blob,
                                   IdResultType idResultType1,
                                   IdResult idResult2,
                                   IdScope execution,
                                   spv::GroupOperation operation,
                                   IdRef value,
                                   const IdRef *clusterSize);
void WriteGroupNonUniformLogicalXor(Blob *blob,
                                    IdResultType idResultType1,
                                    IdResult idResult2,
                                    IdScope execution,
                                    spv::GroupOperation operation,
                                    IdRef value,
                                    const IdRef *clusterSize);
void WriteGroupNonUniformQuadBroadcast(Blob *blob,
                                       IdResultType idResultType1,
                                       IdResult idResult2,
                                       IdScope execution,
                                       IdRef value,
                                       IdRef index);
void WriteGroupNonUniformQuadSwap(Blob *blob,
                                  IdResultType idResultType1,
                                  IdResult idResult2,
                                  IdScope execution,
                                  IdRef value,
                                  IdRef direction);
void WriteCopyLogical(Blob *blob, IdResultType idResultType1, IdResult idResult2, IdRef operand);
void WritePtrEqual(Blob *blob,
                   IdResultType idResultType1,
                   IdResult idResult2,
                   IdRef operand1,
                   IdRef operand2);
void WritePtrNotEqual(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef operand1,
                      IdRef operand2);
void WriteSDot(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef vector1,
               IdRef vector2,
               const spv::PackedVectorFormat *packedVectorFormat);
void WriteUDot(Blob *blob,
               IdResultType idResultType1,
               IdResult idResult2,
               IdRef vector1,
               IdRef vector2,
               const spv::PackedVectorFormat *packedVectorFormat);
void WriteSUDot(Blob *blob,
                IdResultType idResultType1,
                IdResult idResult2,
                IdRef vector1,
                IdRef vector2,
                const spv::PackedVectorFormat *packedVectorFormat);
void WriteSDotAccSat(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef vector1,
                     IdRef vector2,
                     IdRef accumulator,
                     const spv::PackedVectorFormat *packedVectorFormat);
void WriteUDotAccSat(Blob *blob,
                     IdResultType idResultType1,
                     IdResult idResult2,
                     IdRef vector1,
                     IdRef vector2,
                     IdRef accumulator,
                     const spv::PackedVectorFormat *packedVectorFormat);
void WriteSUDotAccSat(Blob *blob,
                      IdResultType idResultType1,
                      IdResult idResult2,
                      IdRef vector1,
                      IdRef vector2,
                      IdRef accumulator,
                      const spv::PackedVectorFormat *packedVectorFormat);
void WriteBeginInvocationInterlockEXT(Blob *blob);
void WriteEndInvocationInterlockEXT(Blob *blob);
void WriteDemoteToHelperInvocation(Blob *blob);

}  // namespace spirv
}  // namespace angle

#endif  // COMMON_SPIRV_SPIRVINSTRUCTIONBUILDERAUTOGEN_H_
