; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -mattr=+zbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64ZBS

define signext i32 @bclr_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bclr_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclr_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    not a1, a1
; RV64ZBS-NEXT:    and a0, a1, a0
; RV64ZBS-NEXT:    ret
  %and = and i32 %b, 31
  %shl = shl nuw i32 1, %and
  %neg = xor i32 %shl, -1
  %and1 = and i32 %neg, %a
  ret i32 %and1
}

define signext i32 @bclr_i32_no_mask(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bclr_i32_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclr_i32_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    not a1, a1
; RV64ZBS-NEXT:    and a0, a1, a0
; RV64ZBS-NEXT:    ret
  %shl = shl i32 1, %b
  %neg = xor i32 %shl, -1
  %and1 = and i32 %neg, %a
  ret i32 %and1
}

define signext i32 @bclr_i32_load(i32* %p, i32 signext %b) nounwind {
; RV64I-LABEL: bclr_i32_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclr_i32_load:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lw a0, 0(a0)
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    not a1, a1
; RV64ZBS-NEXT:    and a0, a1, a0
; RV64ZBS-NEXT:    ret
  %a = load i32, i32* %p
  %shl = shl i32 1, %b
  %neg = xor i32 %shl, -1
  %and1 = and i32 %neg, %a
  ret i32 %and1
}

define i64 @bclr_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bclr_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclr_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclr a0, a0, a1
; RV64ZBS-NEXT:    ret
  %and = and i64 %b, 63
  %shl = shl nuw i64 1, %and
  %neg = xor i64 %shl, -1
  %and1 = and i64 %neg, %a
  ret i64 %and1
}

define i64 @bclr_i64_no_mask(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bclr_i64_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclr_i64_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclr a0, a0, a1
; RV64ZBS-NEXT:    ret
  %shl = shl i64 1, %b
  %neg = xor i64 %shl, -1
  %and1 = and i64 %neg, %a
  ret i64 %and1
}

define signext i32 @bset_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bset_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    or a0, a1, a0
; RV64ZBS-NEXT:    ret
  %and = and i32 %b, 31
  %shl = shl nuw i32 1, %and
  %or = or i32 %shl, %a
  ret i32 %or
}

define signext i32 @bset_i32_no_mask(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bset_i32_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i32_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    or a0, a1, a0
; RV64ZBS-NEXT:    ret
  %shl = shl i32 1, %b
  %or = or i32 %shl, %a
  ret i32 %or
}

define signext i32 @bset_i32_load(i32* %p, i32 signext %b) nounwind {
; RV64I-LABEL: bset_i32_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i32_load:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lw a0, 0(a0)
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    or a0, a1, a0
; RV64ZBS-NEXT:    ret
  %a = load i32, i32* %p
  %shl = shl i32 1, %b
  %or = or i32 %shl, %a
  ret i32 %or
}

; We can use bsetw for 1 << x by setting the first source to zero.
define signext i32 @bset_i32_zero(i32 signext %a) nounwind {
; RV64I-LABEL: bset_i32_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    sllw a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i32_zero:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a1, 1
; RV64ZBS-NEXT:    sllw a0, a1, a0
; RV64ZBS-NEXT:    ret
  %shl = shl i32 1, %a
  ret i32 %shl
}

define i64 @bset_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bset_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bset a0, a0, a1
; RV64ZBS-NEXT:    ret
  %conv = and i64 %b, 63
  %shl = shl nuw i64 1, %conv
  %or = or i64 %shl, %a
  ret i64 %or
}

define i64 @bset_i64_no_mask(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bset_i64_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i64_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bset a0, a0, a1
; RV64ZBS-NEXT:    ret
  %shl = shl i64 1, %b
  %or = or i64 %shl, %a
  ret i64 %or
}

; We can use bsetw for 1 << x by setting the first source to zero.
define signext i64 @bset_i64_zero(i64 signext %a) nounwind {
; RV64I-LABEL: bset_i64_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    sll a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bset_i64_zero:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bset a0, zero, a0
; RV64ZBS-NEXT:    ret
  %shl = shl i64 1, %a
  ret i64 %shl
}

define signext i32 @binv_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: binv_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binv_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    xor a0, a1, a0
; RV64ZBS-NEXT:    ret
  %and = and i32 %b, 31
  %shl = shl nuw i32 1, %and
  %xor = xor i32 %shl, %a
  ret i32 %xor
}

define signext i32 @binv_i32_no_mask(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: binv_i32_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binv_i32_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    xor a0, a1, a0
; RV64ZBS-NEXT:    ret
  %shl = shl i32 1, %b
  %xor = xor i32 %shl, %a
  ret i32 %xor
}

define signext i32 @binv_i32_load(i32* %p, i32 signext %b) nounwind {
; RV64I-LABEL: binv_i32_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sllw a1, a2, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binv_i32_load:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lw a0, 0(a0)
; RV64ZBS-NEXT:    li a2, 1
; RV64ZBS-NEXT:    sllw a1, a2, a1
; RV64ZBS-NEXT:    xor a0, a1, a0
; RV64ZBS-NEXT:    ret
  %a = load i32, i32* %p
  %shl = shl i32 1, %b
  %xor = xor i32 %shl, %a
  ret i32 %xor
}

define i64 @binv_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: binv_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binv_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binv a0, a0, a1
; RV64ZBS-NEXT:    ret
  %conv = and i64 %b, 63
  %shl = shl nuw i64 1, %conv
  %xor = xor i64 %shl, %a
  ret i64 %xor
}

define i64 @binv_i64_no_mask(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: binv_i64_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a2, 1
; RV64I-NEXT:    sll a1, a2, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binv_i64_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binv a0, a0, a1
; RV64ZBS-NEXT:    ret
  %shl = shl nuw i64 1, %b
  %xor = xor i64 %shl, %a
  ret i64 %xor
}

define signext i32 @bext_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bext_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bext_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    srlw a0, a0, a1
; RV64ZBS-NEXT:    andi a0, a0, 1
; RV64ZBS-NEXT:    ret
  %and = and i32 %b, 31
  %shr = lshr i32 %a, %and
  %and1 = and i32 %shr, 1
  ret i32 %and1
}

define signext i32 @bext_i32_no_mask(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: bext_i32_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bext_i32_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    srlw a0, a0, a1
; RV64ZBS-NEXT:    andi a0, a0, 1
; RV64ZBS-NEXT:    ret
  %shr = lshr i32 %a, %b
  %and1 = and i32 %shr, 1
  ret i32 %and1
}

define i64 @bext_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bext_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bext_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bext a0, a0, a1
; RV64ZBS-NEXT:    ret
  %conv = and i64 %b, 63
  %shr = lshr i64 %a, %conv
  %and1 = and i64 %shr, 1
  ret i64 %and1
}

define i64 @bext_i64_no_mask(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: bext_i64_no_mask:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bext_i64_no_mask:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bext a0, a0, a1
; RV64ZBS-NEXT:    ret
  %shr = lshr i64 %a, %b
  %and1 = and i64 %shr, 1
  ret i64 %and1
}

define signext i32 @bexti_i32(i32 signext %a) nounwind {
; RV64I-LABEL: bexti_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 5
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 5
; RV64ZBS-NEXT:    ret
  %shr = lshr i32 %a, 5
  %and = and i32 %shr, 1
  ret i32 %and
}

define i64 @bexti_i64(i64 %a) nounwind {
; RV64I-LABEL: bexti_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 5
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 5
; RV64ZBS-NEXT:    ret
  %shr = lshr i64 %a, 5
  %and = and i64 %shr, 1
  ret i64 %and
}

define signext i32 @bexti_xor_i32(i32 signext %a) nounwind {
; RV64I-LABEL: bexti_xor_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 7
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_xor_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 7
; RV64ZBS-NEXT:    xori a0, a0, 1
; RV64ZBS-NEXT:    ret
  %shr = lshr i32 %a, 7
  %not = xor i32 %shr, -1
  %and = and i32 %not, 1
  ret i32 %and
}

define i64 @bexti_xor_i64(i64 %a) nounwind {
; RV64I-LABEL: bexti_xor_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 7
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_xor_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 7
; RV64ZBS-NEXT:    xori a0, a0, 1
; RV64ZBS-NEXT:    ret
  %shr = lshr i64 %a, 7
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define signext i32 @bexti_xor_i32_1(i32 signext %a) nounwind {
; RV64I-LABEL: bexti_xor_i32_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 7
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_xor_i32_1:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 7
; RV64ZBS-NEXT:    xori a0, a0, 1
; RV64ZBS-NEXT:    ret
  %shr = lshr i32 %a, 7
  %and = and i32 %shr, 1
  %xor = xor i32 %and, 1
  ret i32 %xor
}

define i64 @bexti_xor_i64_1(i64 %a) nounwind {
; RV64I-LABEL: bexti_xor_i64_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 7
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bexti_xor_i64_1:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bexti a0, a0, 7
; RV64ZBS-NEXT:    xori a0, a0, 1
; RV64ZBS-NEXT:    ret
  %shr = lshr i64 %a, 7
  %and = and i64 %shr, 1
  %xor = xor i64 %and, 1
  ret i64 %xor
}

define signext i32 @bclri_i32_10(i32 signext %a) nounwind {
; RV64I-LABEL: bclri_i32_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, -1025
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i32_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    andi a0, a0, -1025
; RV64ZBS-NEXT:    ret
  %and = and i32 %a, -1025
  ret i32 %and
}

define signext i32 @bclri_i32_11(i32 signext %a) nounwind {
; RV64I-LABEL: bclri_i32_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i32_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 11
; RV64ZBS-NEXT:    ret
  %and = and i32 %a, -2049
  ret i32 %and
}

define signext i32 @bclri_i32_30(i32 signext %a) nounwind {
; RV64I-LABEL: bclri_i32_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 786432
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i32_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 30
; RV64ZBS-NEXT:    ret
  %and = and i32 %a, -1073741825
  ret i32 %and
}

define signext i32 @bclri_i32_31(i32 signext %a) nounwind {
; RV64I-LABEL: bclri_i32_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 33
; RV64I-NEXT:    srli a0, a0, 33
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i32_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    slli a0, a0, 33
; RV64ZBS-NEXT:    srli a0, a0, 33
; RV64ZBS-NEXT:    ret
  %and = and i32 %a, -2147483649
  ret i32 %and
}

define i64 @bclri_i64_10(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, -1025
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    andi a0, a0, -1025
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -1025
  ret i64 %and
}

define i64 @bclri_i64_11(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 11
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -2049
  ret i64 %and
}

define i64 @bclri_i64_30(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 786432
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 30
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -1073741825
  ret i64 %and
}

define i64 @bclri_i64_31(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    slli a1, a1, 31
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 31
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -2147483649
  ret i64 %and
}

define i64 @bclri_i64_62(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_62:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    slli a1, a1, 62
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_62:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 62
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -4611686018427387905
  ret i64 %and
}

define i64 @bclri_i64_63(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_63:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 1
; RV64I-NEXT:    srli a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_63:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 63
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -9223372036854775809
  ret i64 %and
}

define i64 @bclri_i64_large0(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_large0:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1044480
; RV64I-NEXT:    addiw a1, a1, -256
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_large0:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    andi a0, a0, -256
; RV64ZBS-NEXT:    bclri a0, a0, 24
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -16777472
  ret i64 %and
}

define i64 @bclri_i64_large1(i64 %a) nounwind {
; RV64I-LABEL: bclri_i64_large1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1044464
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bclri_i64_large1:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bclri a0, a0, 16
; RV64ZBS-NEXT:    bclri a0, a0, 24
; RV64ZBS-NEXT:    ret
  %and = and i64 %a, -16842753
  ret i64 %and
}

define signext i32 @bseti_i32_10(i32 signext %a) nounwind {
; RV64I-LABEL: bseti_i32_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a0, a0, 1024
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i32_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    ori a0, a0, 1024
; RV64ZBS-NEXT:    ret
  %or = or i32 %a, 1024
  ret i32 %or
}

define signext i32 @bseti_i32_11(i32 signext %a) nounwind {
; RV64I-LABEL: bseti_i32_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i32_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 11
; RV64ZBS-NEXT:    ret
  %or = or i32 %a, 2048
  ret i32 %or
}

define signext i32 @bseti_i32_30(i32 signext %a) nounwind {
; RV64I-LABEL: bseti_i32_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 262144
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i32_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 30
; RV64ZBS-NEXT:    ret
  %or = or i32 %a, 1073741824
  ret i32 %or
}

define signext i32 @bseti_i32_31(i32 signext %a) nounwind {
; RV64I-LABEL: bseti_i32_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i32_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 524288
; RV64ZBS-NEXT:    or a0, a0, a1
; RV64ZBS-NEXT:    ret
  %or = or i32 %a, 2147483648
  ret i32 %or
}

define i64 @bseti_i64_10(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a0, a0, 1024
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    ori a0, a0, 1024
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 1024
  ret i64 %or
}

define i64 @bseti_i64_11(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 11
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 2048
  ret i64 %or
}

define i64 @bseti_i64_30(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 262144
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 30
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 1073741824
  ret i64 %or
}

define i64 @bseti_i64_31(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 31
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 31
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 2147483648
  ret i64 %or
}

define i64 @bseti_i64_62(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_62:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 62
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_62:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 62
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 4611686018427387904
  ret i64 %or
}

define i64 @bseti_i64_63(i64 %a) nounwind {
; RV64I-LABEL: bseti_i64_63:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    slli a1, a1, 63
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bseti_i64_63:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 63
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 9223372036854775808
  ret i64 %or
}

define signext i32 @binvi_i32_10(i32 signext %a) nounwind {
; RV64I-LABEL: binvi_i32_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xori a0, a0, 1024
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i32_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    xori a0, a0, 1024
; RV64ZBS-NEXT:    ret
  %xor = xor i32 %a, 1024
  ret i32 %xor
}

define signext i32 @binvi_i32_11(i32 signext %a) nounwind {
; RV64I-LABEL: binvi_i32_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i32_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 11
; RV64ZBS-NEXT:    ret
  %xor = xor i32 %a, 2048
  ret i32 %xor
}

define signext i32 @binvi_i32_30(i32 signext %a) nounwind {
; RV64I-LABEL: binvi_i32_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 262144
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i32_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 30
; RV64ZBS-NEXT:    ret
  %xor = xor i32 %a, 1073741824
  ret i32 %xor
}

define signext i32 @binvi_i32_31(i32 signext %a) nounwind {
; RV64I-LABEL: binvi_i32_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 524288
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i32_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 524288
; RV64ZBS-NEXT:    xor a0, a0, a1
; RV64ZBS-NEXT:    ret
  %xor = xor i32 %a, 2147483648
  ret i32 %xor
}

define i64 @binvi_i64_10(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_10:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xori a0, a0, 1024
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_10:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    xori a0, a0, 1024
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 1024
  ret i64 %xor
}

define i64 @binvi_i64_11(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_11:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_11:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 11
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 2048
  ret i64 %xor
}

define i64 @binvi_i64_30(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_30:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 262144
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_30:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 30
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 1073741824
  ret i64 %xor
}

define i64 @binvi_i64_31(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_31:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 31
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_31:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 31
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 2147483648
  ret i64 %xor
}

define i64 @binvi_i64_62(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_62:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 62
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_62:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 62
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 4611686018427387904
  ret i64 %xor
}

define i64 @binvi_i64_63(i64 %a) nounwind {
; RV64I-LABEL: binvi_i64_63:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -1
; RV64I-NEXT:    slli a1, a1, 63
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: binvi_i64_63:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 63
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 9223372036854775808
  ret i64 %xor
}

define i64 @xor_i64_large(i64 %a) nounwind {
; RV64I-LABEL: xor_i64_large:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    addi a1, a1, 1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: xor_i64_large:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    binvi a0, a0, 0
; RV64ZBS-NEXT:    binvi a0, a0, 32
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 4294967297
  ret i64 %xor
}

define i64 @xor_i64_4099(i64 %a) nounwind {
; RV64I-LABEL: xor_i64_4099:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, 3
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: xor_i64_4099:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    xori a0, a0, 3
; RV64ZBS-NEXT:    binvi a0, a0, 12
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 4099
  ret i64 %xor
}

define i64 @xor_i64_96(i64 %a) nounwind {
; RV64I-LABEL: xor_i64_96:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xori a0, a0, 96
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: xor_i64_96:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    xori a0, a0, 96
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 96
  ret i64 %xor
}

define i64 @or_i64_large(i64 %a) nounwind {
; RV64I-LABEL: or_i64_large:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    slli a1, a1, 32
; RV64I-NEXT:    addi a1, a1, 1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: or_i64_large:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    bseti a0, a0, 0
; RV64ZBS-NEXT:    bseti a0, a0, 32
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 4294967297
  ret i64 %or
}

define i64 @xor_i64_66901(i64 %a) nounwind {
; RV64I-LABEL: xor_i64_66901:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, 1365
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: xor_i64_66901:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    xori a0, a0, 1365
; RV64ZBS-NEXT:    binvi a0, a0, 16
; RV64ZBS-NEXT:    ret
  %xor = xor i64 %a, 66901
  ret i64 %xor
}

define i64 @or_i64_4099(i64 %a) nounwind {
; RV64I-LABEL: or_i64_4099:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, 3
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: or_i64_4099:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    ori a0, a0, 3
; RV64ZBS-NEXT:    bseti a0, a0, 12
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 4099
  ret i64 %or
}

define i64 @or_i64_96(i64 %a) nounwind {
; RV64I-LABEL: or_i64_96:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a0, a0, 96
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: or_i64_96:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    ori a0, a0, 96
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 96
  ret i64 %or
}

define i64 @or_i64_66901(i64 %a) nounwind {
; RV64I-LABEL: or_i64_66901:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, 1365
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: or_i64_66901:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    ori a0, a0, 1365
; RV64ZBS-NEXT:    bseti a0, a0, 16
; RV64ZBS-NEXT:    ret
  %or = or i64 %a, 66901
  ret i64 %or
}
