; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=verify -opaque-pointers -S < %s | FileCheck %s

define i32 @load(ptr %a) {
; CHECK-LABEL: @load(
; CHECK-NEXT:    [[I:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    ret i32 [[I]]
;
  %i = load i32, ptr %a
  ret i32 %i
}

define void @store(ptr %a, i32 %i) {
; CHECK-LABEL: @store(
; CHECK-NEXT:    store i32 [[I:%.*]], ptr [[A:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 %i, ptr %a
  ret void
}

define void @cmpxchg(ptr %p, i32 %a, i32 %b) {
; CHECK-LABEL: @cmpxchg(
; CHECK-NEXT:    [[VAL_SUCCESS:%.*]] = cmpxchg ptr [[P:%.*]], i32 [[A:%.*]], i32 [[B:%.*]] acq_rel monotonic, align 4
; CHECK-NEXT:    ret void
;
  %val_success = cmpxchg ptr %p, i32 %a, i32 %b acq_rel monotonic
  ret void
}

define void @atomicrmw(ptr %a, i32 %i) {
; CHECK-LABEL: @atomicrmw(
; CHECK-NEXT:    [[B:%.*]] = atomicrmw add ptr [[A:%.*]], i32 [[I:%.*]] acquire, align 4
; CHECK-NEXT:    ret void
;
  %b = atomicrmw add ptr %a, i32 %i acquire
  ret void
}

define void @opaque_mangle(ptr %a) {
; CHECK-LABEL: @opaque_mangle(
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 8, ptr [[A:%.*]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 8, ptr [[A]])
; CHECK-NEXT:    ret void
;
  call void @llvm.lifetime.start.p0(i64 8, ptr %a)
  call void @llvm.lifetime.end.p0(i64 8, ptr %a)
  ret void
}

define void @intrinsic_calls(ptr %a) {
; CHECK-LABEL: @intrinsic_calls(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x i32> @llvm.masked.load.v2i32.p0(ptr [[A:%.*]], i32 4, <2 x i1> zeroinitializer, <2 x i32> zeroinitializer)
; CHECK-NEXT:    call void @llvm.masked.store.v2i32.p0(<2 x i32> zeroinitializer, ptr [[A]], i32 4, <2 x i1> zeroinitializer)
; CHECK-NEXT:    [[TMP2:%.*]] = call <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr> zeroinitializer, i32 4, <2 x i1> zeroinitializer, <2 x i64> zeroinitializer)
; CHECK-NEXT:    [[TMP3:%.*]] = call ptr @llvm.preserve.array.access.index.p0.p0(ptr elementtype(i32) null, i32 0, i32 0)
; CHECK-NEXT:    ret void
;
  call <2 x i32> @llvm.masked.load.v2i32.p0(ptr %a, i32 4, <2 x i1> zeroinitializer, <2 x i32> zeroinitializer)
  call void @llvm.masked.store.v2i32.p0(<2 x i32> zeroinitializer, ptr %a, i32 4, <2 x i1> zeroinitializer)
  call <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr> zeroinitializer, i32 4, <2 x i1> zeroinitializer, <2 x i64> zeroinitializer)
  call ptr @llvm.preserve.array.access.index.p0.p0(ptr elementtype(i32) null, i32 0, i32 0)
  ret void
}

; CHECK: @llvm.lifetime.start.p0
; CHECK: @llvm.lifetime.end.p0
declare void @llvm.lifetime.start.p0(i64, ptr nocapture)
declare void @llvm.lifetime.end.p0(i64, ptr nocapture)

declare <2 x i32> @llvm.masked.load.v2i32.p0(ptr, i32, <2 x i1>, <2 x i32>)
declare void @llvm.masked.store.v2i32.p0(<2 x i32>, ptr, i32, <2 x i1>)
declare <2 x i64> @llvm.masked.gather.v2i64.v2p0(<2 x ptr>, i32, <2 x i1>, <2 x i64>)
declare ptr @llvm.preserve.array.access.index.p0.p0(ptr, i32, i32)
