"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chainFirstTaskK = exports.chainTaskK = exports.fromTaskK = void 0;
/**
 * Lift a computation from the `Task` monad
 *
 * @since 2.10.0
 */
var Chain_1 = require("./Chain");
var function_1 = require("./function");
function fromTaskK(F) {
    return function (f) { return function_1.flow(f, F.fromTask); };
}
exports.fromTaskK = fromTaskK;
function chainTaskK(F, M) {
    return function (f) {
        var g = function_1.flow(f, F.fromTask);
        return function (first) { return M.chain(first, g); };
    };
}
exports.chainTaskK = chainTaskK;
function chainFirstTaskK(F, M) {
    var chainFirstM = Chain_1.chainFirst(M);
    return function (f) { return chainFirstM(function_1.flow(f, F.fromTask)); };
}
exports.chainFirstTaskK = chainFirstTaskK;
