import { HTTPMethod } from './utils/constants.js';
import { Handler, HandlerObject, MatchCallback } from './_types.js';
import './_version.js';
/**
 * A `Route` consists of a pair of callback functions, "match" and "handler".
 * The "match" callback determine if a route should be used to "handle" a
 * request by returning a non-falsy value if it can. The "handler" callback
 * is called when there is a match and should return a Promise that resolves
 * to a `Response`.
 *
 * @memberof module:workbox-routing
 */
declare class Route {
    handler: HandlerObject;
    match: MatchCallback;
    method: HTTPMethod;
    /**
     * Constructor for Route class.
     *
     * @param {module:workbox-routing~matchCallback} match
     * A callback function that determines whether the route matches a given
     * `fetch` event by returning a non-falsy value.
     * @param {module:workbox-routing~handlerCallback} handler A callback
     * function that returns a Promise resolving to a Response.
     * @param {string} [method='GET'] The HTTP method to match the Route
     * against.
     */
    constructor(match: MatchCallback, handler: Handler, method?: HTTPMethod);
}
export { Route };
