/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.CoroutineExitException;
import java.dyn.CoroutineSupport;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public abstract class CoroutineBase {
    transient long nativeCoroutine;
    boolean finished = false;
    boolean needsUnlock = false;
    transient CoroutineSupport threadSupport;

    CoroutineBase() {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        Thread thread = javaLangAccess.currentThread0();
        assert (javaLangAccess.getCoroutineSupport(thread) != null);
        this.threadSupport = javaLangAccess.getCoroutineSupport(thread);
    }

    CoroutineBase(CoroutineSupport coroutineSupport, long l) {
        this.threadSupport = coroutineSupport;
        this.nativeCoroutine = l;
    }

    protected abstract void run();

    private final void startInternal() {
        assert (this.threadSupport.getThread() == SharedSecrets.getJavaLangAccess().currentThread0());
        try {
            this.threadSupport.beforeResume(this);
            this.run();
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof CoroutineExitException)) {
                throwable.printStackTrace();
            }
        }
        finally {
            this.finished = true;
            this.threadSupport.beforeResume(this);
            this.threadSupport.terminateCoroutine(null);
        }
        assert (this.threadSupport.getThread() == SharedSecrets.getJavaLangAccess().currentThread0());
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public Thread getThread() {
        return this.threadSupport.getThread();
    }

    public static CoroutineBase current() {
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        return javaLangAccess.getCoroutineSupport(javaLangAccess.currentThread0()).getCurrent();
    }
}

