/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import sun.misc.SharedSecrets;
import sun.net.ext.RdmaSocketOptions;
import sun.nio.ch.NetAccess;
import sun.nio.ch.rdma.RdmaInetAddressContainer;
import sun.nio.ch.rdma.RdmaSocketInputStream;
import sun.nio.ch.rdma.RdmaSocketOutputStream;

public abstract class RdmaSocketImpl
extends SocketImpl {
    private static final NetAccess NET_ACCESS = SharedSecrets.getNetAccess();
    private ProtocolFamily family;
    Socket socket = null;
    ServerSocket serverSocket = null;
    int timeout;
    int trafficClass;
    InputStream socketInputStream;
    OutputStream socketOutputStream;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    protected int fdUseCount = 0;
    protected final Object fdLock = new Object();
    protected boolean closePending = false;
    private int CONNECTION_NOT_RESET = 0;
    private int CONNECTION_RESET_PENDING = 1;
    private int CONNECTION_RESET = 2;
    private int resetState;
    private final Object resetLock = new Object();
    protected boolean stream;
    private static UnsupportedOperationException unsupported;
    static final RdmaSocketOptions rdmaOptions;
    private static volatile boolean checkedRdma;
    private static volatile boolean isRdmaAvailable;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    private static final Void checkSupported() {
        if (unsupported != null) {
            UnsupportedOperationException unsupportedOperationException = unsupported;
            throw new UnsupportedOperationException(unsupportedOperationException.getMessage(), unsupportedOperationException);
        }
        return null;
    }

    public RdmaSocketImpl(ProtocolFamily protocolFamily) {
        this(RdmaSocketImpl.checkSupported(), protocolFamily);
    }

    private RdmaSocketImpl(Void void_, ProtocolFamily protocolFamily) {
        Objects.requireNonNull(protocolFamily, "null family");
        if (protocolFamily != StandardProtocolFamily.INET && protocolFamily != StandardProtocolFamily.INET6) {
            throw new UnsupportedOperationException("Protocol family not supported");
        }
        if (protocolFamily == StandardProtocolFamily.INET6 && !NET_ACCESS.isIPv6Available()) {
            throw new UnsupportedOperationException("IPv6 not available");
        }
        this.family = protocolFamily;
    }

    boolean isRdmaAvailable() {
        if (!checkedRdma) {
            isRdmaAvailable = RdmaSocketImpl.isRdmaAvailable0();
            checkedRdma = true;
        }
        return isRdmaAvailable;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    Socket getSocket() {
        return this.socket;
    }

    void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    protected synchronized void create(boolean bl) throws IOException {
        this.stream = bl;
        if (bl) {
            this.fd = new FileDescriptor();
            boolean bl2 = NET_ACCESS.isIPv6Available() && this.family != StandardProtocolFamily.INET;
            this.rdmaSocketCreate(bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String string, int n) throws UnknownHostException, IOException {
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.port = n;
            this.address = inetAddress;
            this.connectToAddress(inetAddress, n, this.timeout);
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void connect(InetAddress inetAddress, int n) throws IOException {
        if (this.family == StandardProtocolFamily.INET && !(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("address type mismatch");
        }
        if (this.family == StandardProtocolFamily.INET6 && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("address type mismatch");
        }
        this.port = n;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n, this.timeout);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        boolean bl = false;
        try {
            if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("unsupported address type");
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (this.family == StandardProtocolFamily.INET && !(inetAddress instanceof Inet4Address)) {
                throw new IllegalArgumentException("address type mismatch");
            }
            if (this.family == StandardProtocolFamily.INET6 && !(inetAddress instanceof Inet6Address)) {
                throw new IllegalArgumentException("address type mismatch");
            }
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException(inetSocketAddress.getHostName());
            }
            this.port = inetSocketAddress.getPort();
            this.address = inetSocketAddress.getAddress();
            this.connectToAddress(this.address, this.port, n);
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n, int n2) throws IOException {
        this.doConnect(inetAddress, n, n2);
    }

    abstract boolean isOptionSupported(int var1);

    @Override
    public void setOption(int n, Object object) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        boolean bl = true;
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                break;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl = (Boolean)object;
                break;
            }
            case 4097: 
            case 4098: {
                int n3 = (Integer)object;
                int n4 = 0x3FFFFFFF;
                if (object == null || !(object instanceof Integer) || n3 <= 0) {
                    throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
                }
                if (n3 < n4) break;
                n3 = n4;
                break;
            }
            case 4: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEADDR");
                }
                bl = (Boolean)object;
                if (this.serverSocket != null && this.serverSocket.isBound()) {
                    throw new UnsupportedOperationException("RDMA server socket cannot set SO_REUSEADDR after bind.");
                }
                if (this.socket == null || !this.socket.isConnected()) break;
                throw new UnsupportedOperationException("RDMA socket cannot set SO_REUSEADDR after connect.");
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n);
            }
        }
        this.socketSetOption(n, bl, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4102) {
            return this.timeout;
        }
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.rdmaSocketGetOption(n, null);
                return n2 != -1;
            }
            case 4: {
                n2 = this.rdmaSocketGetOption(n, null);
                return n2 != -1;
            }
            case 15: {
                RdmaInetAddressContainer rdmaInetAddressContainer = new RdmaInetAddressContainer();
                n2 = this.rdmaSocketGetOption(n, rdmaInetAddressContainer);
                return rdmaInetAddressContainer.addr;
            }
            case 4097: 
            case 4098: {
                n2 = this.rdmaSocketGetOption(n, null);
                return n2;
            }
        }
        return null;
    }

    protected void socketSetOption(int n, boolean bl, Object object) throws SocketException {
        block2: {
            try {
                this.rdmaSocketSetOption(n, bl, object);
            }
            catch (SocketException socketException) {
                if (this.socket != null && this.socket.isConnected()) break block2;
                throw socketException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doConnect(InetAddress inetAddress, int n, int n2) throws IOException {
        try {
            this.acquireFD();
            boolean bl = NET_ACCESS.isIPv6Available() && this.family != StandardProtocolFamily.INET;
            try {
                this.rdmaSocketConnect(bl, inetAddress, n, n2);
                Object object = this.fdLock;
                synchronized (object) {
                    if (this.closePending) {
                        throw new SocketException("Socket closed");
                    }
                }
            }
            finally {
                this.releaseFD();
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private final InetAddress anyLocalAddress() throws IOException {
        if (this.family == StandardProtocolFamily.INET) {
            return InetAddress.getByName("0.0.0.0");
        }
        if (this.family == StandardProtocolFamily.INET6) {
            return InetAddress.getByName("::");
        }
        throw new IllegalArgumentException("Unsupported address type " + this.family);
    }

    @Override
    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException("address is null");
        }
        if (inetAddress.isAnyLocalAddress()) {
            inetAddress = this.anyLocalAddress();
        }
        if (this.family == StandardProtocolFamily.INET && !(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("address type mismatch");
        }
        if (this.family == StandardProtocolFamily.INET6 && !(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("address type mismatch");
        }
        boolean bl = NET_ACCESS.isIPv6Available() && this.family != StandardProtocolFamily.INET;
        this.rdmaSocketBind(bl, inetAddress, n);
    }

    @Override
    protected synchronized void listen(int n) throws IOException {
        this.rdmaSocketListen(n);
    }

    @Override
    protected void accept(SocketImpl socketImpl) throws IOException {
        this.acquireFD();
        try {
            this.rdmaSocketAccept(socketImpl);
        }
        finally {
            this.releaseFD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_rd) {
                throw new IOException("Socket input is shutdown");
            }
            if (this.socketInputStream == null) {
                this.socketInputStream = new RdmaSocketInputStream(this);
            }
        }
        return this.socketInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_wr) {
                throw new IOException("Socket output is shutdown");
            }
            if (this.socketOutputStream == null) {
                this.socketOutputStream = new RdmaSocketOutputStream(this);
            }
        }
        return this.socketOutputStream;
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    protected void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    void setPort(int n) {
        this.port = n;
    }

    void setLocalPort(int n) {
        this.localport = n;
    }

    @Override
    protected synchronized int available() throws IOException {
        throw new UnsupportedOperationException("unsupported socket operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null) {
                if (this.fdUseCount == 0) {
                    if (this.closePending) {
                        return;
                    }
                    this.closePending = true;
                    this.rdmaSocketClose();
                    this.fd = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.rdmaSocketClose();
                }
            }
        }
    }

    void reset() throws IOException {
        if (this.fd != null) {
            this.rdmaSocketClose();
        }
        this.fd = null;
        this.postReset();
    }

    void postReset() throws IOException {
        this.address = null;
        this.port = 0;
        this.localport = 0;
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (this.fd != null) {
            this.rdmaSocketShutdown(0);
            if (this.socketInputStream != null) {
                ((RdmaSocketInputStream)this.socketInputStream).setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.fd != null) {
            this.rdmaSocketShutdown(1);
            this.shut_wr = true;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int n) throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        this.rdmaSocketSendUrgentData(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor acquireFD() {
        Object object = this.fdLock;
        synchronized (object) {
            ++this.fdUseCount;
            return this.fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFD() {
        Object object = this.fdLock;
        synchronized (object) {
            --this.fdUseCount;
            if (this.fdUseCount == -1 && this.fd != null) {
                try {
                    this.rdmaSocketClose();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.fd = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET_PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            this.resetState = this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            if (this.resetState == this.CONNECTION_NOT_RESET) {
                this.resetState = this.CONNECTION_RESET_PENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null;
            {
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Override
    protected InetAddress getInetAddress() {
        return this.address;
    }

    @Override
    protected int getPort() {
        return this.port;
    }

    @Override
    protected int getLocalPort() {
        return this.localport;
    }

    static native void initProto() throws UnsupportedOperationException;

    private static native boolean isRdmaAvailable0();

    native void rdmaSocketCreate(boolean var1, boolean var2) throws IOException;

    native void rdmaSocketConnect(boolean var1, InetAddress var2, int var3, int var4) throws IOException;

    native void rdmaSocketBind(boolean var1, InetAddress var2, int var3) throws IOException;

    native void rdmaSocketListen(int var1) throws IOException;

    native void rdmaSocketAccept(SocketImpl var1) throws IOException;

    native void rdmaSocketClose() throws IOException;

    native void rdmaSocketShutdown(int var1) throws IOException;

    native void rdmaSocketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    native int rdmaSocketGetOption(int var1, Object var2) throws SocketException;

    native void rdmaSocketSendUrgentData(int var1) throws IOException;

    static {
        rdmaOptions = RdmaSocketOptions.getInstance();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                System.loadLibrary("extnet");
                return null;
            }
        });
        UnsupportedOperationException unsupportedOperationException = null;
        try {
            RdmaSocketImpl.initProto();
        }
        catch (UnsupportedOperationException unsupportedOperationException2) {
            unsupportedOperationException = unsupportedOperationException2;
        }
        unsupported = unsupportedOperationException;
    }
}

