/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.alibaba.wisp.engine.WispEngine;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SinkChannelImpl
extends Pipe.SinkChannel
implements SelChImpl {
    private static final WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    private static final NativeDispatcher nd = new FileDispatcherImpl();
    FileDescriptor fd;
    int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = -1;

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    SinkChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
        try {
            if (WispEngine.transparentWispSwitch()) {
                IOUtil.configureBlocking(fileDescriptor, false);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Unexpected error at configureAsNonBlockingForWisp", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long l;
            if (this.state != 1) {
                nd.preClose(this.fd);
            }
            if ((l = this.thread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 1;
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        if (n == 4) {
            n = Net.POLLOUT;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            int n3;
            int n;
            block10: {
                n = 0;
                this.begin();
                if (this.isOpen()) break block10;
                int n2 = 0;
                this.thread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                return n2;
            }
            try {
                this.thread = NativeThread.current();
                do {
                    n = IOUtil.write(this.fd, byteBuffer, -1L, nd);
                    if (!WispEngine.transparentWispSwitch() || !this.isBlocking()) continue;
                    while (IOStatus.okayToRetry(n) && this.isOpen()) {
                        WEA.poll(this, Net.POLLOUT, -1L);
                        n = IOUtil.write(this.fd, byteBuffer, -1L, nd);
                    }
                } while (n == -3 && this.isOpen());
                n3 = IOStatus.normalize(n);
                this.thread = 0L;
                this.end(n > 0 || n == -2);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                throw throwable;
            }
            assert (IOStatus.check(n));
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l3;
            long l;
            block11: {
                l = 0L;
                this.begin();
                if (this.isOpen()) break block11;
                long l2 = 0L;
                this.thread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                return l2;
            }
            try {
                this.thread = NativeThread.current();
                do {
                    l = IOUtil.write(this.fd, byteBufferArray, nd);
                    if (!WispEngine.transparentWispSwitch() || !this.isBlocking()) continue;
                    while (IOStatus.okayToRetry(l) && this.isOpen()) {
                        WEA.poll(this, Net.POLLOUT, -1L);
                        l = IOUtil.write(this.fd, byteBufferArray, nd);
                    }
                } while (l == -3L && this.isOpen());
                l3 = IOStatus.normalize(l);
                this.thread = 0L;
                this.end(l > 0L || l == -2L);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(l > 0L || l == -2L);
                assert (IOStatus.check(l));
                throw throwable;
            }
            assert (IOStatus.check(l));
            return l3;
        }
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.write(Util.subsequence(byteBufferArray, n, n2));
    }
}

