/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.WispSocketLockSupport;

public class WispServerSocketImpl {
    private static WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    private WispSocketLockSupport wispSocketLockSupport = new WispSocketLockSupport();
    private ServerSocketChannelImpl ssc = null;
    private volatile int timeout = 0;

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        try {
            this.getChannelImpl().bind(socketAddress, n);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public InetAddress getInetAddress() {
        if (this.ssc == null || !this.ssc.isBound()) {
            return null;
        }
        return Net.getRevealedLocalAddress(this.ssc.localAddress()).getAddress();
    }

    public int getLocalPort() {
        if (this.ssc == null || !this.ssc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getPort();
    }

    public Socket accept() throws IOException {
        try {
            this.wispSocketLockSupport.beginRead();
            Socket socket = this.accept0();
            return socket;
        }
        finally {
            this.wispSocketLockSupport.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket accept0() throws IOException {
        ServerSocketChannelImpl serverSocketChannelImpl = this.getChannelImpl();
        try {
            SocketChannel socketChannel;
            if (this.getSoTimeout() > 0) {
                WEA.addTimer(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.getSoTimeout()));
            }
            while ((socketChannel = ((ServerSocketChannel)serverSocketChannelImpl).accept()) == null) {
                WEA.registerEvent(serverSocketChannelImpl, 16);
                WEA.park(-1L);
                if (this.getSoTimeout() <= 0 || !WEA.isTimeout()) continue;
                throw new SocketTimeoutException("time out");
            }
            socketChannel.configureBlocking(false);
            Socket socket = SharedSecrets.getJavaNetSocketAccess().createSocketFromChannel(socketChannel);
            return socket;
        }
        catch (Exception exception) {
            Net.translateException(exception, true);
            Socket socket = null;
            return socket;
        }
        finally {
            if (this.getSoTimeout() > 0) {
                WEA.cancelTimer();
            }
            WEA.unregisterEvent();
        }
    }

    public void close() throws IOException {
        if (this.ssc != null) {
            this.ssc.close();
            this.wispSocketLockSupport.unparkBlockedWispTask();
        }
    }

    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    public boolean isBound() {
        return this.ssc != null && this.ssc.isBound();
    }

    public boolean isClosed() {
        return this.ssc != null && !this.ssc.isOpen();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    public int getSoTimeout() throws IOException {
        return this.timeout;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        try {
            this.getChannelImpl().setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        try {
            return this.getChannelImpl().getOption(StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("size can not be 0 or negative");
        }
        try {
            this.getChannelImpl().setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.getChannelImpl().getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }

    private ServerSocketChannelImpl getChannelImpl() throws SocketException {
        if (this.ssc == null) {
            try {
                this.ssc = (ServerSocketChannelImpl)ServerSocketChannel.open();
                this.ssc.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new SocketException(iOException.getMessage());
            }
        }
        return this.ssc;
    }
}

