/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherForKeyProtector;
import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.PBEKey;
import com.sun.crypto.provider.PBEWithMD5AndTripleDESCipher;
import com.sun.crypto.provider.PrivateKeyInfo;
import com.sun.crypto.provider.SealedObjectForKeyProtector;
import com.sun.crypto.provider.SunJCE;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.SealedObject;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import sun.security.util.ObjectIdentifier;
import sun.security.util.SecurityProperties;
import sun.security.x509.AlgorithmId;

final class KeyProtector {
    private static final String PBE_WITH_MD5_AND_DES3_CBC_OID = "1.3.6.1.4.1.42.2.19.1";
    private static final String KEY_PROTECTOR_OID = "1.3.6.1.4.1.42.2.17.1.1";
    private static final int MAX_ITERATION_COUNT = 5000000;
    private static final int MIN_ITERATION_COUNT = 10000;
    private static final int DEFAULT_ITERATION_COUNT = 200000;
    private static final int SALT_LEN = 20;
    private static final int DIGEST_LEN = 20;
    private static final int ITERATION_COUNT;
    private char[] password;

    KeyProtector(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        this.password = cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] protect(PrivateKey privateKey) throws Exception {
        PBEWithMD5AndTripleDESCipher pBEWithMD5AndTripleDESCipher;
        byte[] byArray = new byte[8];
        SunJCE.getRandom().nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, ITERATION_COUNT);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password);
        PBEKey pBEKey = null;
        try {
            pBEKey = new PBEKey(pBEKeySpec, "PBEWithMD5AndTripleDES");
            pBEWithMD5AndTripleDESCipher = new PBEWithMD5AndTripleDESCipher();
            pBEWithMD5AndTripleDESCipher.engineInit(1, (Key)pBEKey, pBEParameterSpec, null);
        }
        finally {
            pBEKeySpec.clearPassword();
            if (pBEKey != null) {
                pBEKey.destroy();
            }
        }
        byte[] byArray2 = privateKey.getEncoded();
        byte[] byArray3 = pBEWithMD5AndTripleDESCipher.engineDoFinal(byArray2, 0, byArray2.length);
        Arrays.fill(byArray2, (byte)0);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBE", SunJCE.getInstance());
        algorithmParameters.init(pBEParameterSpec);
        AlgorithmId algorithmId = new AlgorithmId(new ObjectIdentifier(PBE_WITH_MD5_AND_DES3_CBC_OID), algorithmParameters);
        return new EncryptedPrivateKeyInfo(algorithmId, byArray3).getEncoded();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Key recover(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        Object object;
        Destroyable destroyable;
        block15: {
            byte[] byArray = null;
            destroyable = null;
            try {
                Object object2;
                Object object3;
                String string = encryptedPrivateKeyInfo.getAlgorithm().getOID().toString();
                if (!string.equals(PBE_WITH_MD5_AND_DES3_CBC_OID) && !string.equals(KEY_PROTECTOR_OID)) {
                    throw new UnrecoverableKeyException("Unsupported encryption algorithm");
                }
                if (string.equals(KEY_PROTECTOR_OID)) {
                    byArray = this.recover(encryptedPrivateKeyInfo.getEncryptedData());
                } else {
                    object3 = encryptedPrivateKeyInfo.getAlgorithm().getEncodedParams();
                    object2 = AlgorithmParameters.getInstance("PBE");
                    ((AlgorithmParameters)object2).init((byte[])object3);
                    object = ((AlgorithmParameters)object2).getParameterSpec(PBEParameterSpec.class);
                    if (((PBEParameterSpec)object).getIterationCount() > 5000000) {
                        throw new IOException("PBE iteration count too large");
                    }
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password);
                    destroyable = new PBEKey(pBEKeySpec, "PBEWithMD5AndTripleDES");
                    pBEKeySpec.clearPassword();
                    PBEWithMD5AndTripleDESCipher pBEWithMD5AndTripleDESCipher = new PBEWithMD5AndTripleDESCipher();
                    pBEWithMD5AndTripleDESCipher.engineInit(2, (Key)((Object)destroyable), (AlgorithmParameterSpec)object, null);
                    byArray = pBEWithMD5AndTripleDESCipher.engineDoFinal(encryptedPrivateKeyInfo.getEncryptedData(), 0, encryptedPrivateKeyInfo.getEncryptedData().length);
                }
                object3 = new AlgorithmId(new PrivateKeyInfo(byArray).getAlgorithm().getOID()).getName();
                object2 = KeyFactory.getInstance((String)object3);
                object = ((KeyFactory)object2).generatePrivate(new PKCS8EncodedKeySpec(byArray));
                if (byArray == null) break block15;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    throw noSuchAlgorithmException;
                    catch (IOException iOException) {
                        throw new UnrecoverableKeyException(iOException.getMessage());
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new UnrecoverableKeyException(generalSecurityException.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (byArray != null) {
                        Arrays.fill(byArray, (byte)0);
                    }
                    if (destroyable == null) throw throwable;
                    try {
                        destroyable.destroy();
                        throw throwable;
                    }
                    catch (DestroyFailedException destroyFailedException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Arrays.fill(byArray, (byte)0);
        }
        if (destroyable == null) return object;
        try {
            destroyable.destroy();
            return object;
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
        return object;
    }

    private byte[] recover(byte[] byArray) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        int n;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray2 = new byte[20];
        System.arraycopy(byArray, 0, byArray2, 0, 20);
        int n2 = byArray.length - 20 - 20;
        int n3 = n2 / 20;
        if (n2 % 20 != 0) {
            ++n3;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 20, byArray3, 0, n2);
        byte[] byArray4 = new byte[byArray3.length];
        byte[] byArray5 = new byte[this.password.length * 2];
        int n4 = 0;
        for (n = 0; n < this.password.length; ++n) {
            byArray5[n4++] = (byte)(this.password[n] >> 8);
            byArray5[n4++] = (byte)this.password[n];
        }
        n = 0;
        int n5 = 0;
        byte[] byArray6 = byArray2;
        while (n < n3) {
            messageDigest.update(byArray5);
            messageDigest.update(byArray6);
            byArray6 = messageDigest.digest();
            messageDigest.reset();
            if (n < n3 - 1) {
                System.arraycopy(byArray6, 0, byArray4, n5, byArray6.length);
            } else {
                System.arraycopy(byArray6, 0, byArray4, n5, byArray4.length - n5);
            }
            ++n;
            n5 += 20;
        }
        byte[] byArray7 = new byte[byArray3.length];
        for (n = 0; n < byArray7.length; ++n) {
            byArray7[n] = (byte)(byArray3[n] ^ byArray4[n]);
        }
        messageDigest.update(byArray5);
        Arrays.fill(byArray5, (byte)0);
        byArray5 = null;
        messageDigest.update(byArray7);
        byArray6 = messageDigest.digest();
        messageDigest.reset();
        for (n = 0; n < byArray6.length; ++n) {
            if (byArray6[n] == byArray[20 + n2 + n]) continue;
            throw new UnrecoverableKeyException("Cannot recover key");
        }
        return byArray7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SealedObject seal(Key key) throws Exception {
        CipherForKeyProtector cipherForKeyProtector;
        byte[] byArray = new byte[8];
        SunJCE.getRandom().nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, ITERATION_COUNT);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password);
        PBEKey pBEKey = null;
        try {
            pBEKey = new PBEKey(pBEKeySpec, "PBEWithMD5AndTripleDES");
            pBEKeySpec.clearPassword();
            PBEWithMD5AndTripleDESCipher pBEWithMD5AndTripleDESCipher = new PBEWithMD5AndTripleDESCipher();
            cipherForKeyProtector = new CipherForKeyProtector(pBEWithMD5AndTripleDESCipher, SunJCE.getInstance(), "PBEWithMD5AndTripleDES");
            cipherForKeyProtector.init(1, (Key)pBEKey, pBEParameterSpec);
        }
        finally {
            if (pBEKey != null) {
                pBEKey.destroy();
            }
        }
        return new SealedObjectForKeyProtector(key, cipherForKeyProtector);
    }

    Key unseal(SealedObject sealedObject, int n) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Destroyable destroyable = null;
        try {
            PBEParameterSpec pBEParameterSpec;
            PBEKeySpec pBEKeySpec = new PBEKeySpec(this.password);
            destroyable = new PBEKey(pBEKeySpec, "PBEWithMD5AndTripleDES");
            pBEKeySpec.clearPassword();
            SealedObjectForKeyProtector sealedObjectForKeyProtector = null;
            sealedObjectForKeyProtector = !(sealedObject instanceof SealedObjectForKeyProtector) ? new SealedObjectForKeyProtector(sealedObject) : (SealedObjectForKeyProtector)sealedObject;
            AlgorithmParameters algorithmParameters = sealedObjectForKeyProtector.getParameters();
            if (algorithmParameters == null) {
                throw new UnrecoverableKeyException("Cannot get algorithm parameters");
            }
            try {
                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new IOException("Invalid PBE algorithm parameters");
            }
            if (pBEParameterSpec.getIterationCount() > 5000000) {
                throw new IOException("PBE iteration count too large");
            }
            PBEWithMD5AndTripleDESCipher pBEWithMD5AndTripleDESCipher = new PBEWithMD5AndTripleDESCipher();
            CipherForKeyProtector cipherForKeyProtector = new CipherForKeyProtector(pBEWithMD5AndTripleDESCipher, SunJCE.getInstance(), "PBEWithMD5AndTripleDES");
            cipherForKeyProtector.init(2, (Key)((Object)destroyable), algorithmParameters);
            Key key = sealedObjectForKeyProtector.getKey(cipherForKeyProtector, n);
            return key;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnrecoverableKeyException(classNotFoundException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UnrecoverableKeyException(generalSecurityException.getMessage());
        }
        finally {
            if (destroyable != null) {
                try {
                    destroyable.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            }
        }
    }

    static {
        int n = 200000;
        String string = SecurityProperties.privilegedGetOverridable("jdk.jceks.iterationCount");
        if (string != null && !string.isEmpty()) {
            try {
                n = Integer.parseInt(string);
                if (n < 10000 || n > 5000000) {
                    n = 200000;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ITERATION_COUNT = n;
    }
}

