export default class SupportedNamespaces {
  supportedMetricNamespaces: any = {
    azuremonitor: [
      'Microsoft.AnalysisServices/servers',
      'Microsoft.ApiManagement/service',
      'Microsoft.AppConfiguration/configurationStores',
      'Microsoft.Automation/automationAccounts',
      'Microsoft.Batch/batchAccounts',
      'Microsoft.Cache/redis',
      'Microsoft.ClassicCompute/virtualMachines',
      'Microsoft.ClassicCompute/domainNames/slots/roles',
      'Microsoft.CognitiveServices/accounts',
      'Microsoft.Compute/virtualMachines',
      'Microsoft.Compute/virtualMachineScaleSets',
      'Microsoft.ContainerInstance/containerGroups',
      'Microsoft.ContainerRegistry/registries',
      'Microsoft.ContainerService/managedClusters',
      'Microsoft.CustomerInsights/hubs',
      'Microsoft.DataBoxEdge/dataBoxEdgeDevices',
      'Microsoft.DataFactory/datafactories',
      'Microsoft.DataFactory/factories',
      'Microsoft.DataLakeAnalytics/accounts',
      'Microsoft.DataLakeStore/accounts',
      'Microsoft.DBforMariaDB/servers',
      'Microsoft.DBforMySQL/servers',
      'Microsoft.DBforPostgreSQL/servers',
      'Microsoft.Devices/IotHubs',
      'Microsoft.Devices/provisioningServices',
      'Microsoft.DocumentDB/databaseAccounts',
      'Microsoft.EventGrid/topics',
      'Microsoft.EventGrid/eventSubscriptions',
      'Microsoft.EventGrid/extensionTopics',
      'Microsoft.EventHub/namespaces',
      'Microsoft.EventHub/clusters',
      'Microsoft.HDInsight/clusters',
      'Microsoft.Insights/AutoscaleSettings',
      'Microsoft.Insights/components',
      'Microsoft.KeyVault/vaults',
      'Microsoft.Kusto/clusters',
      'Microsoft.LocationBasedServices/accounts',
      'Microsoft.Logic/workflows',
      'Microsoft.Logic/integrationServiceEnvironments',
      'Microsoft.NetApp/netAppAccounts/capacityPools',
      'Microsoft.NetApp/netAppAccounts/capacityPools/volumes',
      'Microsoft.Network/networkInterfaces',
      'Microsoft.Network/loadBalancers',
      'Microsoft.Network/dnsZones',
      'Microsoft.Network/publicIPAddresses',
      'Microsoft.Network/azureFirewalls',
      'Microsoft.Network/applicationGateways',
      'Microsoft.Network/virtualNetworkGateways',
      'Microsoft.Network/expressRouteCircuits',
      'Microsoft.Network/expressRouteCircuits/Peerings',
      'Microsoft.Network/connections',
      'Microsoft.Network/trafficManagerProfiles',
      'Microsoft.Network/networkWatchers/connectionMonitors',
      'Microsoft.Network/frontdoors',
      'Microsoft.Network/natGateways',
      'Microsoft.Network/vpngateways',
      'Microsoft.Network/virtualNetworkGateways',
      'Microsoft.NotificationHubs/namespaces/notificationHubs',
      'Microsoft.OperationalInsights/workspaces',
      'Microsoft.PowerBIDedicated/capacities',
      'Microsoft.Relay/namespaces',
      'Microsoft.Search/searchServices',
      'Microsoft.ServiceBus/namespaces',
      'Microsoft.Sql/servers/databases',
      'Microsoft.Sql/servers/elasticPools',
      'Microsoft.Sql/managedInstances',
      'Microsoft.Storage/storageAccounts',
      'Microsoft.Storage/storageAccounts/blobServices',
      'Microsoft.Storage/storageAccounts/fileServices',
      'Microsoft.Storage/storageAccounts/queueServices',
      'Microsoft.Storage/storageAccounts/tableServices',
      'Microsoft.StorageSync/storageSyncServices',
      'Microsoft.StorageSync/storageSyncServices/syncGroups',
      'Microsoft.StorageSync/storageSyncServices/syncGroups/serverEndpoints',
      'Microsoft.StorageSync/storageSyncServices/registeredServers',
      'Microsoft.StreamAnalytics/streamingJobs',
      'Microsoft.Web/serverfarms',
      'Microsoft.Web/sites',
      'Microsoft.Web/sites/slots',
      'Microsoft.Web/hostingEnvironments/multiRolePools',
      'Microsoft.Web/hostingEnvironments/workerPools',
    ],
    govazuremonitor: [
      'Microsoft.AnalysisServices/servers',
      'Microsoft.ApiManagement/service',
      'Microsoft.Batch/batchAccounts',
      'Microsoft.Cache/redis',
      'Microsoft.ClassicCompute/virtualMachines',
      'Microsoft.ClassicCompute/domainNames/slots/roles',
      'Microsoft.CognitiveServices/accounts',
      'Microsoft.Compute/virtualMachines',
      'Microsoft.Compute/virtualMachineScaleSets',
      'Microsoft.ContainerRegistry/registries',
      'Microsoft.DBforMySQL/servers',
      'Microsoft.DBforPostgreSQL/servers',
      'Microsoft.Devices/IotHubs',
      'Microsoft.Devices/provisioningServices',
      'Microsoft.EventGrid/topics',
      'Microsoft.EventGrid/eventSubscriptions',
      'Microsoft.EventGrid/extensionTopics',
      'Microsoft.EventHub/namespaces',
      'Microsoft.EventHub/clusters',
      'Microsoft.Insights/AutoscaleSettings',
      'Microsoft.KeyVault/vaults',
      'Microsoft.Logic/workflows',
      'Microsoft.Network/networkInterfaces',
      'Microsoft.Network/loadBalancers',
      'Microsoft.Network/dnsZones',
      'Microsoft.Network/publicIPAddresses',
      'Microsoft.Network/azureFirewalls',
      'Microsoft.Network/applicationGateways',
      'Microsoft.Network/virtualNetworkGateways',
      'Microsoft.Network/expressRouteCircuits',
      'Microsoft.Network/expressRouteCircuits/Peerings',
      'Microsoft.Network/connections',
      'Microsoft.Network/trafficManagerProfiles',
      'Microsoft.Network/networkWatchers/connectionMonitors',
      'Microsoft.Network/frontdoors',
      'Microsoft.NotificationHubs/namespaces/notificationHubs',
      'Microsoft.OperationalInsights/workspaces',
      'Microsoft.PowerBIDedicated/capacities',
      'Microsoft.Relay/namespaces',
      'Microsoft.ServiceBus/namespaces',
      'Microsoft.Sql/servers/databases',
      'Microsoft.Sql/servers/elasticPools',
      'Microsoft.Sql/managedInstances',
      'Microsoft.Storage/storageAccounts',
      'Microsoft.Storage/storageAccounts/blobServices',
      'Microsoft.Storage/storageAccounts/fileServices',
      'Microsoft.Storage/storageAccounts/queueServices',
      'Microsoft.Storage/storageAccounts/tableServices',
      'Microsoft.Web/serverfarms',
      'Microsoft.Web/sites',
      'Microsoft.Web/sites/slots',
      'Microsoft.Web/hostingEnvironments/multiRolePools',
      'Microsoft.Web/hostingEnvironments/workerPools',
    ],
    germanyazuremonitor: [
      'Microsoft.AnalysisServices/servers',
      'Microsoft.Batch/batchAccounts',
      'Microsoft.Cache/redis',
      'Microsoft.ClassicCompute/virtualMachines',
      'Microsoft.ClassicCompute/domainNames/slots/roles',
      'Microsoft.Compute/virtualMachines',
      'Microsoft.Compute/virtualMachineScaleSets',
      'Microsoft.DBforMySQL/servers',
      'Microsoft.DBforPostgreSQL/servers',
      'Microsoft.Devices/IotHubs',
      'Microsoft.Devices/provisioningServices',
      'Microsoft.EventHub/namespaces',
      'Microsoft.EventHub/clusters',
      'Microsoft.Insights/AutoscaleSettings',
      'Microsoft.KeyVault/vaults',
      'Microsoft.Network/networkInterfaces',
      'Microsoft.Network/loadBalancers',
      'Microsoft.Network/dnsZones',
      'Microsoft.Network/publicIPAddresses',
      'Microsoft.Network/azureFirewalls',
      'Microsoft.Network/applicationGateways',
      'Microsoft.Network/virtualNetworkGateways',
      'Microsoft.Network/expressRouteCircuits',
      'Microsoft.Network/expressRouteCircuits/Peerings',
      'Microsoft.Network/connections',
      'Microsoft.Network/trafficManagerProfiles',
      'Microsoft.Network/networkWatchers/connectionMonitors',
      'Microsoft.Network/frontdoors',
      'Microsoft.NotificationHubs/namespaces/notificationHubs',
      'Microsoft.OperationalInsights/workspaces',
      'Microsoft.PowerBIDedicated/capacities',
      'Microsoft.Relay/namespaces',
      'Microsoft.ServiceBus/namespaces',
      'Microsoft.Sql/servers/databases',
      'Microsoft.Sql/servers/elasticPools',
      'Microsoft.Sql/managedInstances',
      'Microsoft.Storage/storageAccounts',
      'Microsoft.Storage/storageAccounts/blobServices',
      'Microsoft.Storage/storageAccounts/fileServices',
      'Microsoft.Storage/storageAccounts/queueServices',
      'Microsoft.Storage/storageAccounts/tableServices',
      'Microsoft.StreamAnalytics/streamingJobs',
      'Microsoft.Web/serverfarms',
      'Microsoft.Web/sites',
      'Microsoft.Web/sites/slots',
      'Microsoft.Web/hostingEnvironments/multiRolePools',
      'Microsoft.Web/hostingEnvironments/workerPools',
    ],
    chinaazuremonitor: [
      'Microsoft.AnalysisServices/servers',
      'Microsoft.Batch/batchAccounts',
      'Microsoft.Cache/redis',
      'Microsoft.ClassicCompute/virtualMachines',
      'Microsoft.ClassicCompute/domainNames/slots/roles',
      'Microsoft.CognitiveServices/accounts',
      'Microsoft.Compute/virtualMachines',
      'Microsoft.Compute/virtualMachineScaleSets',
      'Microsoft.ContainerRegistry/registries',
      'Microsoft.DBforMySQL/servers',
      'Microsoft.DBforPostgreSQL/servers',
      'Microsoft.Devices/IotHubs',
      'Microsoft.Devices/provisioningServices',
      'Microsoft.EventHub/namespaces',
      'Microsoft.Insights/AutoscaleSettings',
      'Microsoft.KeyVault/vaults',
      'Microsoft.Logic/workflows',
      'Microsoft.Network/networkInterfaces',
      'Microsoft.Network/loadBalancers',
      'Microsoft.Network/dnsZones',
      'Microsoft.Network/publicIPAddresses',
      'Microsoft.Network/azureFirewalls',
      'Microsoft.Network/applicationGateways',
      'Microsoft.Network/virtualNetworkGateways',
      'Microsoft.Network/expressRouteCircuits',
      'Microsoft.Network/expressRouteCircuits/Peerings',
      'Microsoft.Network/connections',
      'Microsoft.Network/trafficManagerProfiles',
      'Microsoft.Network/networkWatchers/connectionMonitors',
      'Microsoft.Network/frontdoors',
      'Microsoft.NotificationHubs/namespaces/notificationHubs',
      'Microsoft.PowerBIDedicated/capacities',
      'Microsoft.Relay/namespaces',
      'Microsoft.ServiceBus/namespaces',
      'Microsoft.Sql/servers/databases',
      'Microsoft.Sql/servers/elasticPools',
      'Microsoft.Sql/managedInstances',
      'Microsoft.Storage/storageAccounts',
      'Microsoft.Storage/storageAccounts/blobServices',
      'Microsoft.Storage/storageAccounts/fileServices',
      'Microsoft.Storage/storageAccounts/queueServices',
      'Microsoft.Storage/storageAccounts/tableServices',
      'Microsoft.StreamAnalytics/streamingJobs',
      'Microsoft.Web/serverfarms',
      'Microsoft.Web/sites',
      'Microsoft.Web/sites/slots',
      'Microsoft.Web/hostingEnvironments/multiRolePools',
      'Microsoft.Web/hostingEnvironments/workerPools',
    ],
  };

  constructor(private cloudName: string) {}

  get(): string[] {
    return this.supportedMetricNamespaces[this.cloudName];
  }
}
