import type { Span, ContextAPI as OTELContextAPI, TraceAPI as OTELTraceAPI } from '@opentelemetry/api';
import type { IInstrumentationScope, IScopeSpans, IResourceSpans } from '@opentelemetry/otlp-transformer';
export interface TraceEvent {
    resourceSpans?: ResourceSpan[];
}
export declare type ResourceSpan = Omit<IResourceSpans, 'scopeSpans'> & {
    instrumentationLibrarySpans: InstrumentationLibrarySpan[];
};
export declare type InstrumentationLibrarySpan = Omit<IScopeSpans, 'scope'> & {
    instrumentationLibrary?: IInstrumentationScope;
};
export declare type GetActiveSpan = () => Span | undefined;
export declare type OTELApi = {
    trace: OTELTraceAPI;
    context: OTELContextAPI;
};
export interface TracesAPI {
    initOTEL: (trace: OTELTraceAPI, context: OTELContextAPI) => void;
    getOTEL: () => OTELApi | undefined;
    getTraceContext: () => TraceContext | undefined;
    pushTraces: (traces: TraceEvent) => void;
}
export interface TraceContext {
    trace_id: string;
    span_id: string;
}
