"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pluginDevTask = void 0;
const tslib_1 = require("tslib");
const useSpinner_1 = require("../utils/useSpinner");
const plugin_build_1 = require("./plugin.build");
const bundle_1 = require("./plugin/bundle");
const task_1 = require("./task");
const bundlePlugin = (options) => (0, useSpinner_1.useSpinner)('Bundling plugin in dev mode', () => (0, bundle_1.bundlePlugin)(options));
const pluginDevRunner = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    if (options.watch) {
        yield (0, bundle_1.bundlePlugin)(options);
    }
    else {
        // Always fix lint in dev mode
        yield (0, plugin_build_1.lintPlugin)({ fix: true });
        const result = yield bundlePlugin(options);
        return result;
    }
});
exports.pluginDevTask = new task_1.Task('Dev plugin', pluginDevRunner);
//# sourceMappingURL=plugin.dev.js.map