/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
	"reflect"
)


// PypiSimpleAPIService PypiSimpleAPI service
type PypiSimpleAPIService service

type PypiSimpleAPIPypiSimpleCreateRequest struct {
	ctx context.Context
	ApiService *PypiSimpleAPIService
	path string
	content *os.File
	sha256Digest *string
	action *string
}

// A Python package release file to upload to the index.
func (r PypiSimpleAPIPypiSimpleCreateRequest) Content(content *os.File) PypiSimpleAPIPypiSimpleCreateRequest {
	r.content = content
	return r
}

// SHA256 of package to validate upload integrity.
func (r PypiSimpleAPIPypiSimpleCreateRequest) Sha256Digest(sha256Digest string) PypiSimpleAPIPypiSimpleCreateRequest {
	r.sha256Digest = &sha256Digest
	return r
}

// Defaults to &#x60;file_upload&#x60;, don&#39;t change it or request will fail!
func (r PypiSimpleAPIPypiSimpleCreateRequest) Action(action string) PypiSimpleAPIPypiSimpleCreateRequest {
	r.action = &action
	return r
}

func (r PypiSimpleAPIPypiSimpleCreateRequest) Execute() (*PackageUploadTaskResponse, *http.Response, error) {
	return r.ApiService.PypiSimpleCreateExecute(r)
}

/*
PypiSimpleCreate Upload a package

Upload package to the index.
This endpoint has the same functionality as the upload endpoint at the `/legacy` url of the
index. This is provided for convenience for users who want a single index url for all their
Python tools. (pip, twine, poetry, pipenv, ...)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param path
 @return PypiSimpleAPIPypiSimpleCreateRequest
*/
func (a *PypiSimpleAPIService) PypiSimpleCreate(ctx context.Context, path string) PypiSimpleAPIPypiSimpleCreateRequest {
	return PypiSimpleAPIPypiSimpleCreateRequest{
		ApiService: a,
		ctx: ctx,
		path: path,
	}
}

// Execute executes the request
//  @return PackageUploadTaskResponse
func (a *PypiSimpleAPIService) PypiSimpleCreateExecute(r PypiSimpleAPIPypiSimpleCreateRequest) (*PackageUploadTaskResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PackageUploadTaskResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PypiSimpleAPIService.PypiSimpleCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pypi/{path}/simple/"
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.content == nil {
		return localVarReturnValue, nil, reportError("content is required and must be specified")
	}
	if r.sha256Digest == nil {
		return localVarReturnValue, nil, reportError("sha256Digest is required and must be specified")
	}
	if strlen(*r.sha256Digest) < 64 {
		return localVarReturnValue, nil, reportError("sha256Digest must have at least 64 elements")
	}
	if strlen(*r.sha256Digest) > 64 {
		return localVarReturnValue, nil, reportError("sha256Digest must have less than 64 elements")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	var contentLocalVarFormFileName string
	var contentLocalVarFileName     string
	var contentLocalVarFileBytes    []byte

	contentLocalVarFormFileName = "content"


	contentLocalVarFile := r.content

	if contentLocalVarFile != nil {
		fbs, _ := io.ReadAll(contentLocalVarFile)

		contentLocalVarFileBytes = fbs
		contentLocalVarFileName = contentLocalVarFile.Name()
		contentLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: contentLocalVarFileBytes, fileName: contentLocalVarFileName, formFileName: contentLocalVarFormFileName})
	}
	if r.action != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "action", r.action, "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "sha256_digest", r.sha256Digest, "")
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PypiSimpleAPIPypiSimplePackageReadRequest struct {
	ctx context.Context
	ApiService *PypiSimpleAPIService
	package_ string
	path string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PypiSimpleAPIPypiSimplePackageReadRequest) Fields(fields []string) PypiSimpleAPIPypiSimplePackageReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PypiSimpleAPIPypiSimplePackageReadRequest) ExcludeFields(excludeFields []string) PypiSimpleAPIPypiSimplePackageReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PypiSimpleAPIPypiSimplePackageReadRequest) Execute() (*http.Response, error) {
	return r.ApiService.PypiSimplePackageReadExecute(r)
}

/*
PypiSimplePackageRead Get package simple page

Retrieves the simple api html page for a package.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param package_
 @param path
 @return PypiSimpleAPIPypiSimplePackageReadRequest
*/
func (a *PypiSimpleAPIService) PypiSimplePackageRead(ctx context.Context, package_ string, path string) PypiSimpleAPIPypiSimplePackageReadRequest {
	return PypiSimpleAPIPypiSimplePackageReadRequest{
		ApiService: a,
		ctx: ctx,
		package_: package_,
		path: path,
	}
}

// Execute executes the request
func (a *PypiSimpleAPIService) PypiSimplePackageReadExecute(r PypiSimpleAPIPypiSimplePackageReadRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PypiSimpleAPIService.PypiSimplePackageRead")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pypi/{path}/simple/{package}/"
	localVarPath = strings.Replace(localVarPath, "{"+"package"+"}", parameterValueToString(r.package_, "package_"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type PypiSimpleAPIPypiSimpleReadRequest struct {
	ctx context.Context
	ApiService *PypiSimpleAPIService
	path string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PypiSimpleAPIPypiSimpleReadRequest) Fields(fields []string) PypiSimpleAPIPypiSimpleReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PypiSimpleAPIPypiSimpleReadRequest) ExcludeFields(excludeFields []string) PypiSimpleAPIPypiSimpleReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PypiSimpleAPIPypiSimpleReadRequest) Execute() (*http.Response, error) {
	return r.ApiService.PypiSimpleReadExecute(r)
}

/*
PypiSimpleRead Get index simple page

Gets the simple api html page for the index.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param path
 @return PypiSimpleAPIPypiSimpleReadRequest
*/
func (a *PypiSimpleAPIService) PypiSimpleRead(ctx context.Context, path string) PypiSimpleAPIPypiSimpleReadRequest {
	return PypiSimpleAPIPypiSimpleReadRequest{
		ApiService: a,
		ctx: ctx,
		path: path,
	}
}

// Execute executes the request
func (a *PypiSimpleAPIService) PypiSimpleReadExecute(r PypiSimpleAPIPypiSimpleReadRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PypiSimpleAPIService.PypiSimpleRead")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pypi/{path}/simple/"
	localVarPath = strings.Replace(localVarPath, "{"+"path"+"}", parameterValueToString(r.path, "path"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
