/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"os"
	"reflect"
)


// RepositoriesContainerAPIService RepositoriesContainerAPI service
type RepositoriesContainerAPIService service

type RepositoriesContainerAPIRepositoriesContainerContainerAddRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	recursiveManage *RecursiveManage
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerAddRequest) RecursiveManage(recursiveManage RecursiveManage) RepositoriesContainerAPIRepositoriesContainerContainerAddRequest {
	r.recursiveManage = &recursiveManage
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerAddRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerAddExecute(r)
}

/*
RepositoriesContainerContainerAdd Add content

Trigger an asynchronous task to recursively add container content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerAddRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerAdd(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerAddRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerAddRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerAddExecute(r RepositoriesContainerAPIRepositoriesContainerContainerAddRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerAdd")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}add/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.recursiveManage == nil {
		return localVarReturnValue, nil, reportError("recursiveManage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.recursiveManage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerAddRoleExecute(r)
}

/*
RepositoriesContainerContainerAddRole Method for RepositoriesContainerContainerAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerAddRole(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerAddRoleExecute(r RepositoriesContainerAPIRepositoriesContainerContainerAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	containerfileArtifact *string
	containerfile *os.File
	tag *string
	artifacts *map[string]interface{}
}

// Artifact representing the Containerfile that should be used to run podman-build.
func (r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) ContainerfileArtifact(containerfileArtifact string) RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest {
	r.containerfileArtifact = &containerfileArtifact
	return r
}

// An uploaded Containerfile that should be used to run podman-build.
func (r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) Containerfile(containerfile *os.File) RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest {
	r.containerfile = containerfile
	return r
}

// A tag name for the new image being built.
func (r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) Tag(tag string) RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest {
	r.tag = &tag
	return r
}

// A JSON string where each key is an artifact href and the value is it&#39;s relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.
func (r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) Artifacts(artifacts map[string]interface{}) RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest {
	r.artifacts = &artifacts
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerBuildImageExecute(r)
}

/*
RepositoriesContainerContainerBuildImage Build an Image

Trigger an asynchronous task to build an OCI image from a Containerfile. A new repository version is created with the new image and tag. This API is in tech preview. Backwards compatibility when upgrading is not guaranteed.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerBuildImage(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerBuildImageExecute(r RepositoriesContainerAPIRepositoriesContainerContainerBuildImageRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerBuildImage")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}build_image/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data", "application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.containerfileArtifact != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "containerfile_artifact", r.containerfileArtifact, "")
	}
	var containerfileLocalVarFormFileName string
	var containerfileLocalVarFileName     string
	var containerfileLocalVarFileBytes    []byte

	containerfileLocalVarFormFileName = "containerfile"


	containerfileLocalVarFile := r.containerfile

	if containerfileLocalVarFile != nil {
		fbs, _ := io.ReadAll(containerfileLocalVarFile)

		containerfileLocalVarFileBytes = fbs
		containerfileLocalVarFileName = containerfileLocalVarFile.Name()
		containerfileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: containerfileLocalVarFileBytes, fileName: containerfileLocalVarFileName, formFileName: containerfileLocalVarFormFileName})
	}
	if r.tag != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "tag", r.tag, "")
	}
	if r.artifacts != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "artifacts", r.artifacts, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	manifestCopy *ManifestCopy
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest) ManifestCopy(manifestCopy ManifestCopy) RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest {
	r.manifestCopy = &manifestCopy
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerCopyManifestsExecute(r)
}

/*
RepositoriesContainerContainerCopyManifests Copy manifests

Trigger an asynchronous task to copy manifests

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCopyManifests(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCopyManifestsExecute(r RepositoriesContainerAPIRepositoriesContainerContainerCopyManifestsRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerCopyManifests")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}copy_manifests/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.manifestCopy == nil {
		return localVarReturnValue, nil, reportError("manifestCopy is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.manifestCopy
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	tagCopy *TagCopy
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest) TagCopy(tagCopy TagCopy) RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest {
	r.tagCopy = &tagCopy
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerCopyTagsExecute(r)
}

/*
RepositoriesContainerContainerCopyTags Copy tags

Trigger an asynchronous task to copy tags

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCopyTags(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCopyTagsExecute(r RepositoriesContainerAPIRepositoriesContainerContainerCopyTagsRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerCopyTags")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}copy_tags/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.tagCopy == nil {
		return localVarReturnValue, nil, reportError("tagCopy is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.tagCopy
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepository *ContainerContainerRepository
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest) ContainerContainerRepository(containerContainerRepository ContainerContainerRepository) RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest {
	r.containerContainerRepository = &containerContainerRepository
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest) Execute() (*ContainerContainerRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerCreateExecute(r)
}

/*
RepositoriesContainerContainerCreate Create a container repository

ViewSet for container repo.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCreate(ctx context.Context) RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return ContainerContainerRepositoryResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerCreateExecute(r RepositoriesContainerAPIRepositoriesContainerContainerCreateRequest) (*ContainerContainerRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/container/container/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerRepository == nil {
		return localVarReturnValue, nil, reportError("containerContainerRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerDeleteExecute(r)
}

/*
RepositoriesContainerContainerDelete Delete a container repository

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerDelete(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerDeleteExecute(r RepositoriesContainerAPIRepositoriesContainerContainerDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerListRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	latestWithContent *string
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	remote *string
	retainRepoVersions *int32
	retainRepoVersionsGt *int32
	retainRepoVersionsGte *int32
	retainRepoVersionsIsnull *bool
	retainRepoVersionsLt *int32
	retainRepoVersionsLte *int32
	retainRepoVersionsNe *int32
	retainRepoVersionsRange *[]int32
	withContent *string
	fields *[]string
	excludeFields *[]string
}

// Content Unit referenced by HREF
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) LatestWithContent(latestWithContent string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.latestWithContent = &latestWithContent
	return r
}

// Number of results to return per page.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Limit(limit int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Name(name string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) NameContains(nameContains string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) NameIcontains(nameIcontains string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) NameIn(nameIn []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) NameStartswith(nameStartswith string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Offset(offset int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;next_version&#x60; - Next version * &#x60;-next_version&#x60; - Next version (descending) * &#x60;retain_repo_versions&#x60; - Retain repo versions * &#x60;-retain_repo_versions&#x60; - Retain repo versions (descending) * &#x60;user_hidden&#x60; - User hidden * &#x60;-user_hidden&#x60; - User hidden (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Ordering(ordering []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) PulpHrefIn(pulpHrefIn []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) PulpIdIn(pulpIdIn []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) PulpLabelSelect(pulpLabelSelect string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Foreign Key referenced by HREF
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Remote(remote string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.remote = &remote
	return r
}

// Filter results where retain_repo_versions matches value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersions(retainRepoVersions int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersions = &retainRepoVersions
	return r
}

// Filter results where retain_repo_versions is greater than value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsGt(retainRepoVersionsGt int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsGt = &retainRepoVersionsGt
	return r
}

// Filter results where retain_repo_versions is greater than or equal to value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsGte(retainRepoVersionsGte int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsGte = &retainRepoVersionsGte
	return r
}

// Filter results where retain_repo_versions has a null value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsIsnull(retainRepoVersionsIsnull bool) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsIsnull = &retainRepoVersionsIsnull
	return r
}

// Filter results where retain_repo_versions is less than value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsLt(retainRepoVersionsLt int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsLt = &retainRepoVersionsLt
	return r
}

// Filter results where retain_repo_versions is less than or equal to value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsLte(retainRepoVersionsLte int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsLte = &retainRepoVersionsLte
	return r
}

// Filter results where retain_repo_versions not equal to value
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsNe(retainRepoVersionsNe int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsNe = &retainRepoVersionsNe
	return r
}

// Filter results where retain_repo_versions is between two comma separated values
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) RetainRepoVersionsRange(retainRepoVersionsRange []int32) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.retainRepoVersionsRange = &retainRepoVersionsRange
	return r
}

// Content Unit referenced by HREF
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) WithContent(withContent string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.withContent = &withContent
	return r
}

// A list of fields to include in the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Fields(fields []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) ExcludeFields(excludeFields []string) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) Execute() (*PaginatedcontainerContainerRepositoryResponseList, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerListExecute(r)
}

/*
RepositoriesContainerContainerList List container repositorys

ViewSet for container repo.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RepositoriesContainerAPIRepositoriesContainerContainerListRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerList(ctx context.Context) RepositoriesContainerAPIRepositoriesContainerContainerListRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerContainerRepositoryResponseList
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerListExecute(r RepositoriesContainerAPIRepositoriesContainerContainerListRequest) (*PaginatedcontainerContainerRepositoryResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerContainerRepositoryResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/repositories/container/container/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.latestWithContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "latest_with_content", r.latestWithContent, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.remote != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "remote", r.remote, "")
	}
	if r.retainRepoVersions != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions", r.retainRepoVersions, "")
	}
	if r.retainRepoVersionsGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gt", r.retainRepoVersionsGt, "")
	}
	if r.retainRepoVersionsGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__gte", r.retainRepoVersionsGte, "")
	}
	if r.retainRepoVersionsIsnull != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__isnull", r.retainRepoVersionsIsnull, "")
	}
	if r.retainRepoVersionsLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lt", r.retainRepoVersionsLt, "")
	}
	if r.retainRepoVersionsLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__lte", r.retainRepoVersionsLte, "")
	}
	if r.retainRepoVersionsNe != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__ne", r.retainRepoVersionsNe, "")
	}
	if r.retainRepoVersionsRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "retain_repo_versions__range", r.retainRepoVersionsRange, "csv")
	}
	if r.withContent != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "with_content", r.withContent, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest) Fields(fields []string) RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest) ExcludeFields(excludeFields []string) RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerListRolesExecute(r)
}

/*
RepositoriesContainerContainerListRoles Method for RepositoriesContainerContainerListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerListRoles(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerListRolesExecute(r RepositoriesContainerAPIRepositoriesContainerContainerListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest) Fields(fields []string) RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest) ExcludeFields(excludeFields []string) RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerMyPermissionsExecute(r)
}

/*
RepositoriesContainerContainerMyPermissions Method for RepositoriesContainerContainerMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerMyPermissions(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerMyPermissionsExecute(r RepositoriesContainerAPIRepositoriesContainerContainerMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	patchedcontainerContainerRepository *PatchedcontainerContainerRepository
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest) PatchedcontainerContainerRepository(patchedcontainerContainerRepository PatchedcontainerContainerRepository) RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest {
	r.patchedcontainerContainerRepository = &patchedcontainerContainerRepository
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerPartialUpdateExecute(r)
}

/*
RepositoriesContainerContainerPartialUpdate Update a container repository

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerPartialUpdate(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerPartialUpdateExecute(r RepositoriesContainerAPIRepositoriesContainerContainerPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedcontainerContainerRepository == nil {
		return localVarReturnValue, nil, reportError("patchedcontainerContainerRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedcontainerContainerRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerReadRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerReadRequest) Fields(fields []string) RepositoriesContainerAPIRepositoriesContainerContainerReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RepositoriesContainerAPIRepositoriesContainerContainerReadRequest) ExcludeFields(excludeFields []string) RepositoriesContainerAPIRepositoriesContainerContainerReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerReadRequest) Execute() (*ContainerContainerRepositoryResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerReadExecute(r)
}

/*
RepositoriesContainerContainerRead Inspect a container repository

ViewSet for container repo.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerReadRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerRead(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerReadRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerReadRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return ContainerContainerRepositoryResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerReadExecute(r RepositoriesContainerAPIRepositoriesContainerContainerReadRequest) (*ContainerContainerRepositoryResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerContainerRepositoryResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	recursiveManage *RecursiveManage
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest) RecursiveManage(recursiveManage RecursiveManage) RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest {
	r.recursiveManage = &recursiveManage
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerRemoveExecute(r)
}

/*
RepositoriesContainerContainerRemove Remove content

Trigger an async task to recursively remove container content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerRemove(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerRemoveExecute(r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerRemove")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}remove/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.recursiveManage == nil {
		return localVarReturnValue, nil, reportError("recursiveManage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.recursiveManage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	nestedRole *NestedRole
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest) NestedRole(nestedRole NestedRole) RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerRemoveRoleExecute(r)
}

/*
RepositoriesContainerContainerRemoveRole Method for RepositoriesContainerContainerRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerRemoveRole(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerRemoveRoleExecute(r RepositoriesContainerAPIRepositoriesContainerContainerRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerSignRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	repositorySign *RepositorySign
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerSignRequest) RepositorySign(repositorySign RepositorySign) RepositoriesContainerAPIRepositoriesContainerContainerSignRequest {
	r.repositorySign = &repositorySign
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerSignRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerSignExecute(r)
}

/*
RepositoriesContainerContainerSign Sign images in the repo

Trigger an asynchronous task to sign content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerSignRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerSign(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerSignRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerSignRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerSignExecute(r RepositoriesContainerAPIRepositoriesContainerContainerSignRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerSign")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}sign/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.repositorySign == nil {
		return localVarReturnValue, nil, reportError("repositorySign is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.repositorySign
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	containerRepositorySyncURL *ContainerRepositorySyncURL
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest) ContainerRepositorySyncURL(containerRepositorySyncURL ContainerRepositorySyncURL) RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest {
	r.containerRepositorySyncURL = &containerRepositorySyncURL
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerSyncExecute(r)
}

/*
RepositoriesContainerContainerSync Sync from a remote

Trigger an asynchronous task to sync content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerSync(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerSyncExecute(r RepositoriesContainerAPIRepositoriesContainerContainerSyncRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerSync")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}sync/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerRepositorySyncURL == nil {
		return localVarReturnValue, nil, reportError("containerRepositorySyncURL is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerRepositorySyncURL
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerTagRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	tagImage *TagImage
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerTagRequest) TagImage(tagImage TagImage) RepositoriesContainerAPIRepositoriesContainerContainerTagRequest {
	r.tagImage = &tagImage
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerTagRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerTagExecute(r)
}

/*
RepositoriesContainerContainerTag Create a Tag

Trigger an asynchronous task to tag an image in the repository

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerTagRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerTag(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerTagRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerTagRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerTagExecute(r RepositoriesContainerAPIRepositoriesContainerContainerTagRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerTag")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}tag/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.tagImage == nil {
		return localVarReturnValue, nil, reportError("tagImage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.tagImage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	unTagImage *UnTagImage
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest) UnTagImage(unTagImage UnTagImage) RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest {
	r.unTagImage = &unTagImage
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerUntagExecute(r)
}

/*
RepositoriesContainerContainerUntag Delete a tag

Trigger an asynchronous task to untag an image in the repository

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerUntag(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerUntagExecute(r RepositoriesContainerAPIRepositoriesContainerContainerUntagRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerUntag")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}untag/"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.unTagImage == nil {
		return localVarReturnValue, nil, reportError("unTagImage is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.unTagImage
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest struct {
	ctx context.Context
	ApiService *RepositoriesContainerAPIService
	containerContainerRepositoryHref string
	containerContainerRepository *ContainerContainerRepository
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest) ContainerContainerRepository(containerContainerRepository ContainerContainerRepository) RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest {
	r.containerContainerRepository = &containerContainerRepository
	return r
}

func (r RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RepositoriesContainerContainerUpdateExecute(r)
}

/*
RepositoriesContainerContainerUpdate Update a container repository

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerContainerRepositoryHref
 @return RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest
*/
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerUpdate(ctx context.Context, containerContainerRepositoryHref string) RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest {
	return RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest{
		ApiService: a,
		ctx: ctx,
		containerContainerRepositoryHref: containerContainerRepositoryHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RepositoriesContainerAPIService) RepositoriesContainerContainerUpdateExecute(r RepositoriesContainerAPIRepositoriesContainerContainerUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RepositoriesContainerAPIService.RepositoriesContainerContainerUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_container_repository_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_container_repository_href"+"}", parameterValueToString(r.containerContainerRepositoryHref, "containerContainerRepositoryHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.containerContainerRepository == nil {
		return localVarReturnValue, nil, reportError("containerContainerRepository is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.containerContainerRepository
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
