/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the OCIBuildImage type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &OCIBuildImage{}

// OCIBuildImage Serializer for building an OCI container image from a Containerfile.  The Containerfile can either be specified via an artifact url, or a new file can be uploaded. A repository must be specified, to which the container image content will be added.
type OCIBuildImage struct {
	// Artifact representing the Containerfile that should be used to run podman-build.
	ContainerfileArtifact *string `json:"containerfile_artifact,omitempty"`
	// An uploaded Containerfile that should be used to run podman-build.
	Containerfile **os.File `json:"containerfile,omitempty"`
	// A tag name for the new image being built.
	Tag *string `json:"tag,omitempty"`
	// A JSON string where each key is an artifact href and the value is it's relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.
	Artifacts map[string]interface{} `json:"artifacts,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _OCIBuildImage OCIBuildImage

// NewOCIBuildImage instantiates a new OCIBuildImage object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewOCIBuildImage() *OCIBuildImage {
	this := OCIBuildImage{}
	var tag string = "latest"
	this.Tag = &tag
	return &this
}

// NewOCIBuildImageWithDefaults instantiates a new OCIBuildImage object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewOCIBuildImageWithDefaults() *OCIBuildImage {
	this := OCIBuildImage{}
	var tag string = "latest"
	this.Tag = &tag
	return &this
}

// GetContainerfileArtifact returns the ContainerfileArtifact field value if set, zero value otherwise.
func (o *OCIBuildImage) GetContainerfileArtifact() string {
	if o == nil || IsNil(o.ContainerfileArtifact) {
		var ret string
		return ret
	}
	return *o.ContainerfileArtifact
}

// GetContainerfileArtifactOk returns a tuple with the ContainerfileArtifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OCIBuildImage) GetContainerfileArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.ContainerfileArtifact) {
		return nil, false
	}
	return o.ContainerfileArtifact, true
}

// HasContainerfileArtifact returns a boolean if a field has been set.
func (o *OCIBuildImage) HasContainerfileArtifact() bool {
	if o != nil && !IsNil(o.ContainerfileArtifact) {
		return true
	}

	return false
}

// SetContainerfileArtifact gets a reference to the given string and assigns it to the ContainerfileArtifact field.
func (o *OCIBuildImage) SetContainerfileArtifact(v string) {
	o.ContainerfileArtifact = &v
}

// GetContainerfile returns the Containerfile field value if set, zero value otherwise.
func (o *OCIBuildImage) GetContainerfile() *os.File {
	if o == nil || IsNil(o.Containerfile) {
		var ret *os.File
		return ret
	}
	return *o.Containerfile
}

// GetContainerfileOk returns a tuple with the Containerfile field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OCIBuildImage) GetContainerfileOk() (**os.File, bool) {
	if o == nil || IsNil(o.Containerfile) {
		return nil, false
	}
	return o.Containerfile, true
}

// HasContainerfile returns a boolean if a field has been set.
func (o *OCIBuildImage) HasContainerfile() bool {
	if o != nil && !IsNil(o.Containerfile) {
		return true
	}

	return false
}

// SetContainerfile gets a reference to the given *os.File and assigns it to the Containerfile field.
func (o *OCIBuildImage) SetContainerfile(v *os.File) {
	o.Containerfile = &v
}

// GetTag returns the Tag field value if set, zero value otherwise.
func (o *OCIBuildImage) GetTag() string {
	if o == nil || IsNil(o.Tag) {
		var ret string
		return ret
	}
	return *o.Tag
}

// GetTagOk returns a tuple with the Tag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OCIBuildImage) GetTagOk() (*string, bool) {
	if o == nil || IsNil(o.Tag) {
		return nil, false
	}
	return o.Tag, true
}

// HasTag returns a boolean if a field has been set.
func (o *OCIBuildImage) HasTag() bool {
	if o != nil && !IsNil(o.Tag) {
		return true
	}

	return false
}

// SetTag gets a reference to the given string and assigns it to the Tag field.
func (o *OCIBuildImage) SetTag(v string) {
	o.Tag = &v
}

// GetArtifacts returns the Artifacts field value if set, zero value otherwise.
func (o *OCIBuildImage) GetArtifacts() map[string]interface{} {
	if o == nil || IsNil(o.Artifacts) {
		var ret map[string]interface{}
		return ret
	}
	return o.Artifacts
}

// GetArtifactsOk returns a tuple with the Artifacts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *OCIBuildImage) GetArtifactsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Artifacts) {
		return map[string]interface{}{}, false
	}
	return o.Artifacts, true
}

// HasArtifacts returns a boolean if a field has been set.
func (o *OCIBuildImage) HasArtifacts() bool {
	if o != nil && !IsNil(o.Artifacts) {
		return true
	}

	return false
}

// SetArtifacts gets a reference to the given map[string]interface{} and assigns it to the Artifacts field.
func (o *OCIBuildImage) SetArtifacts(v map[string]interface{}) {
	o.Artifacts = v
}

func (o OCIBuildImage) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o OCIBuildImage) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.ContainerfileArtifact) {
		toSerialize["containerfile_artifact"] = o.ContainerfileArtifact
	}
	if !IsNil(o.Containerfile) {
		toSerialize["containerfile"] = o.Containerfile
	}
	if !IsNil(o.Tag) {
		toSerialize["tag"] = o.Tag
	}
	if !IsNil(o.Artifacts) {
		toSerialize["artifacts"] = o.Artifacts
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *OCIBuildImage) UnmarshalJSON(bytes []byte) (err error) {
	varOCIBuildImage := _OCIBuildImage{}

	if err = json.Unmarshal(bytes, &varOCIBuildImage); err == nil {
		*o = OCIBuildImage(varOCIBuildImage)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "containerfile_artifact")
		delete(additionalProperties, "containerfile")
		delete(additionalProperties, "tag")
		delete(additionalProperties, "artifacts")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableOCIBuildImage struct {
	value *OCIBuildImage
	isSet bool
}

func (v NullableOCIBuildImage) Get() *OCIBuildImage {
	return v.value
}

func (v *NullableOCIBuildImage) Set(val *OCIBuildImage) {
	v.value = val
	v.isSet = true
}

func (v NullableOCIBuildImage) IsSet() bool {
	return v.isSet
}

func (v *NullableOCIBuildImage) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOCIBuildImage(val *OCIBuildImage) *NullableOCIBuildImage {
	return &NullableOCIBuildImage{value: val, isSet: true}
}

func (v NullableOCIBuildImage) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOCIBuildImage) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


