/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the RpmPackageResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmPackageResponse{}

// RpmPackageResponse A Serializer for Package.  Add serializers for the new fields defined in Package and add those fields to the Meta class keeping fields from the parent class as well. Provide help_text.
type RpmPackageResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// The MD5 checksum if available.
	Md5 *string `json:"md5,omitempty"`
	// The SHA-1 checksum if available.
	Sha1 *string `json:"sha1,omitempty"`
	// The SHA-224 checksum if available.
	Sha224 *string `json:"sha224,omitempty"`
	// The SHA-256 checksum if available.
	Sha256 *string `json:"sha256,omitempty"`
	// The SHA-384 checksum if available.
	Sha384 *string `json:"sha384,omitempty"`
	// The SHA-512 checksum if available.
	Sha512 *string `json:"sha512,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// Name of the package
	Name *string `json:"name,omitempty"`
	// The package's epoch
	Epoch *string `json:"epoch,omitempty"`
	// The version of the package. For example, '2.8.0'
	Version *string `json:"version,omitempty"`
	// The release of a particular version of the package. e.g. '1.el7' or '3.f24'
	Release *string `json:"release,omitempty"`
	// The target architecture for a package.For example, 'x86_64', 'i686', or 'noarch'
	Arch *string `json:"arch,omitempty"`
	// Checksum of the package file
	PkgId *string `json:"pkgId,omitempty"`
	// Type of checksum, e.g. 'sha256', 'md5'
	ChecksumType *string `json:"checksum_type,omitempty"`
	// Short description of the packaged software
	Summary *string `json:"summary,omitempty"`
	// In-depth description of the packaged software
	Description *string `json:"description,omitempty"`
	// URL with more information about the packaged software
	Url *string `json:"url,omitempty"`
	// Changelogs that package contains
	Changelogs map[string]interface{} `json:"changelogs,omitempty"`
	// Files that package contains
	Files map[string]interface{} `json:"files,omitempty"`
	// Capabilities the package requires
	Requires map[string]interface{} `json:"requires,omitempty"`
	// Capabilities the package provides
	Provides map[string]interface{} `json:"provides,omitempty"`
	// Capabilities the package conflicts
	Conflicts map[string]interface{} `json:"conflicts,omitempty"`
	// Capabilities the package obsoletes
	Obsoletes map[string]interface{} `json:"obsoletes,omitempty"`
	// Capabilities the package suggests
	Suggests map[string]interface{} `json:"suggests,omitempty"`
	// Capabilities the package enhances
	Enhances map[string]interface{} `json:"enhances,omitempty"`
	// Capabilities the package recommends
	Recommends map[string]interface{} `json:"recommends,omitempty"`
	// Capabilities the package supplements
	Supplements map[string]interface{} `json:"supplements,omitempty"`
	// Base location of this package
	LocationBase *string `json:"location_base,omitempty"`
	// Relative location of package to the repodata
	LocationHref *string `json:"location_href,omitempty"`
	// Hostname of the system that built the package
	RpmBuildhost *string `json:"rpm_buildhost,omitempty"`
	// RPM group (See: http://fedoraproject.org/wiki/RPMGroups)
	RpmGroup *string `json:"rpm_group,omitempty"`
	// License term applicable to the package software (GPLv2, etc.)
	RpmLicense *string `json:"rpm_license,omitempty"`
	// Person or persons responsible for creating the package
	RpmPackager *string `json:"rpm_packager,omitempty"`
	// Name of the source package (srpm) the package was built from
	RpmSourcerpm *string `json:"rpm_sourcerpm,omitempty"`
	// Name of the organization that produced the package
	RpmVendor *string `json:"rpm_vendor,omitempty"`
	// First byte of the header
	RpmHeaderStart *int64 `json:"rpm_header_start,omitempty"`
	// Last byte of the header
	RpmHeaderEnd *int64 `json:"rpm_header_end,omitempty"`
	// Flag to identify if the package is modular
	IsModular *bool `json:"is_modular,omitempty"`
	// Size, in bytes, of the archive portion of the original package file
	SizeArchive *int64 `json:"size_archive,omitempty"`
	// Total size, in bytes, of every file installed by this package
	SizeInstalled *int64 `json:"size_installed,omitempty"`
	// Size, in bytes, of the package
	SizePackage *int64 `json:"size_package,omitempty"`
	// Time the package was built in seconds since the epoch
	TimeBuild *int64 `json:"time_build,omitempty"`
	// The 'file' time attribute in the primary XML - file mtime in seconds since the epoch.
	TimeFile *int64 `json:"time_file,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _RpmPackageResponse RpmPackageResponse

// NewRpmPackageResponse instantiates a new RpmPackageResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmPackageResponse() *RpmPackageResponse {
	this := RpmPackageResponse{}
	return &this
}

// NewRpmPackageResponseWithDefaults instantiates a new RpmPackageResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmPackageResponseWithDefaults() *RpmPackageResponse {
	this := RpmPackageResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmPackageResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *RpmPackageResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetMd5 returns the Md5 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetMd5() string {
	if o == nil || IsNil(o.Md5) {
		var ret string
		return ret
	}
	return *o.Md5
}

// GetMd5Ok returns a tuple with the Md5 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetMd5Ok() (*string, bool) {
	if o == nil || IsNil(o.Md5) {
		return nil, false
	}
	return o.Md5, true
}

// HasMd5 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasMd5() bool {
	if o != nil && !IsNil(o.Md5) {
		return true
	}

	return false
}

// SetMd5 gets a reference to the given string and assigns it to the Md5 field.
func (o *RpmPackageResponse) SetMd5(v string) {
	o.Md5 = &v
}

// GetSha1 returns the Sha1 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSha1() string {
	if o == nil || IsNil(o.Sha1) {
		var ret string
		return ret
	}
	return *o.Sha1
}

// GetSha1Ok returns a tuple with the Sha1 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSha1Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha1) {
		return nil, false
	}
	return o.Sha1, true
}

// HasSha1 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSha1() bool {
	if o != nil && !IsNil(o.Sha1) {
		return true
	}

	return false
}

// SetSha1 gets a reference to the given string and assigns it to the Sha1 field.
func (o *RpmPackageResponse) SetSha1(v string) {
	o.Sha1 = &v
}

// GetSha224 returns the Sha224 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSha224() string {
	if o == nil || IsNil(o.Sha224) {
		var ret string
		return ret
	}
	return *o.Sha224
}

// GetSha224Ok returns a tuple with the Sha224 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSha224Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha224) {
		return nil, false
	}
	return o.Sha224, true
}

// HasSha224 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSha224() bool {
	if o != nil && !IsNil(o.Sha224) {
		return true
	}

	return false
}

// SetSha224 gets a reference to the given string and assigns it to the Sha224 field.
func (o *RpmPackageResponse) SetSha224(v string) {
	o.Sha224 = &v
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSha256() string {
	if o == nil || IsNil(o.Sha256) {
		var ret string
		return ret
	}
	return *o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSha256Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha256) {
		return nil, false
	}
	return o.Sha256, true
}

// HasSha256 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSha256() bool {
	if o != nil && !IsNil(o.Sha256) {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given string and assigns it to the Sha256 field.
func (o *RpmPackageResponse) SetSha256(v string) {
	o.Sha256 = &v
}

// GetSha384 returns the Sha384 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSha384() string {
	if o == nil || IsNil(o.Sha384) {
		var ret string
		return ret
	}
	return *o.Sha384
}

// GetSha384Ok returns a tuple with the Sha384 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSha384Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha384) {
		return nil, false
	}
	return o.Sha384, true
}

// HasSha384 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSha384() bool {
	if o != nil && !IsNil(o.Sha384) {
		return true
	}

	return false
}

// SetSha384 gets a reference to the given string and assigns it to the Sha384 field.
func (o *RpmPackageResponse) SetSha384(v string) {
	o.Sha384 = &v
}

// GetSha512 returns the Sha512 field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSha512() string {
	if o == nil || IsNil(o.Sha512) {
		var ret string
		return ret
	}
	return *o.Sha512
}

// GetSha512Ok returns a tuple with the Sha512 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSha512Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha512) {
		return nil, false
	}
	return o.Sha512, true
}

// HasSha512 returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSha512() bool {
	if o != nil && !IsNil(o.Sha512) {
		return true
	}

	return false
}

// SetSha512 gets a reference to the given string and assigns it to the Sha512 field.
func (o *RpmPackageResponse) SetSha512(v string) {
	o.Sha512 = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *RpmPackageResponse) SetArtifact(v string) {
	o.Artifact = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *RpmPackageResponse) SetName(v string) {
	o.Name = &v
}

// GetEpoch returns the Epoch field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetEpoch() string {
	if o == nil || IsNil(o.Epoch) {
		var ret string
		return ret
	}
	return *o.Epoch
}

// GetEpochOk returns a tuple with the Epoch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetEpochOk() (*string, bool) {
	if o == nil || IsNil(o.Epoch) {
		return nil, false
	}
	return o.Epoch, true
}

// HasEpoch returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasEpoch() bool {
	if o != nil && !IsNil(o.Epoch) {
		return true
	}

	return false
}

// SetEpoch gets a reference to the given string and assigns it to the Epoch field.
func (o *RpmPackageResponse) SetEpoch(v string) {
	o.Epoch = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetVersion() string {
	if o == nil || IsNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetVersionOk() (*string, bool) {
	if o == nil || IsNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasVersion() bool {
	if o != nil && !IsNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *RpmPackageResponse) SetVersion(v string) {
	o.Version = &v
}

// GetRelease returns the Release field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRelease() string {
	if o == nil || IsNil(o.Release) {
		var ret string
		return ret
	}
	return *o.Release
}

// GetReleaseOk returns a tuple with the Release field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetReleaseOk() (*string, bool) {
	if o == nil || IsNil(o.Release) {
		return nil, false
	}
	return o.Release, true
}

// HasRelease returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRelease() bool {
	if o != nil && !IsNil(o.Release) {
		return true
	}

	return false
}

// SetRelease gets a reference to the given string and assigns it to the Release field.
func (o *RpmPackageResponse) SetRelease(v string) {
	o.Release = &v
}

// GetArch returns the Arch field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetArch() string {
	if o == nil || IsNil(o.Arch) {
		var ret string
		return ret
	}
	return *o.Arch
}

// GetArchOk returns a tuple with the Arch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetArchOk() (*string, bool) {
	if o == nil || IsNil(o.Arch) {
		return nil, false
	}
	return o.Arch, true
}

// HasArch returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasArch() bool {
	if o != nil && !IsNil(o.Arch) {
		return true
	}

	return false
}

// SetArch gets a reference to the given string and assigns it to the Arch field.
func (o *RpmPackageResponse) SetArch(v string) {
	o.Arch = &v
}

// GetPkgId returns the PkgId field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetPkgId() string {
	if o == nil || IsNil(o.PkgId) {
		var ret string
		return ret
	}
	return *o.PkgId
}

// GetPkgIdOk returns a tuple with the PkgId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetPkgIdOk() (*string, bool) {
	if o == nil || IsNil(o.PkgId) {
		return nil, false
	}
	return o.PkgId, true
}

// HasPkgId returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasPkgId() bool {
	if o != nil && !IsNil(o.PkgId) {
		return true
	}

	return false
}

// SetPkgId gets a reference to the given string and assigns it to the PkgId field.
func (o *RpmPackageResponse) SetPkgId(v string) {
	o.PkgId = &v
}

// GetChecksumType returns the ChecksumType field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetChecksumType() string {
	if o == nil || IsNil(o.ChecksumType) {
		var ret string
		return ret
	}
	return *o.ChecksumType
}

// GetChecksumTypeOk returns a tuple with the ChecksumType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetChecksumTypeOk() (*string, bool) {
	if o == nil || IsNil(o.ChecksumType) {
		return nil, false
	}
	return o.ChecksumType, true
}

// HasChecksumType returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasChecksumType() bool {
	if o != nil && !IsNil(o.ChecksumType) {
		return true
	}

	return false
}

// SetChecksumType gets a reference to the given string and assigns it to the ChecksumType field.
func (o *RpmPackageResponse) SetChecksumType(v string) {
	o.ChecksumType = &v
}

// GetSummary returns the Summary field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSummary() string {
	if o == nil || IsNil(o.Summary) {
		var ret string
		return ret
	}
	return *o.Summary
}

// GetSummaryOk returns a tuple with the Summary field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSummaryOk() (*string, bool) {
	if o == nil || IsNil(o.Summary) {
		return nil, false
	}
	return o.Summary, true
}

// HasSummary returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSummary() bool {
	if o != nil && !IsNil(o.Summary) {
		return true
	}

	return false
}

// SetSummary gets a reference to the given string and assigns it to the Summary field.
func (o *RpmPackageResponse) SetSummary(v string) {
	o.Summary = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetDescription() string {
	if o == nil || IsNil(o.Description) {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.Description) {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasDescription() bool {
	if o != nil && !IsNil(o.Description) {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *RpmPackageResponse) SetDescription(v string) {
	o.Description = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *RpmPackageResponse) SetUrl(v string) {
	o.Url = &v
}

// GetChangelogs returns the Changelogs field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetChangelogs() map[string]interface{} {
	if o == nil || IsNil(o.Changelogs) {
		var ret map[string]interface{}
		return ret
	}
	return o.Changelogs
}

// GetChangelogsOk returns a tuple with the Changelogs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetChangelogsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Changelogs) {
		return map[string]interface{}{}, false
	}
	return o.Changelogs, true
}

// HasChangelogs returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasChangelogs() bool {
	if o != nil && !IsNil(o.Changelogs) {
		return true
	}

	return false
}

// SetChangelogs gets a reference to the given map[string]interface{} and assigns it to the Changelogs field.
func (o *RpmPackageResponse) SetChangelogs(v map[string]interface{}) {
	o.Changelogs = v
}

// GetFiles returns the Files field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetFiles() map[string]interface{} {
	if o == nil || IsNil(o.Files) {
		var ret map[string]interface{}
		return ret
	}
	return o.Files
}

// GetFilesOk returns a tuple with the Files field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetFilesOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Files) {
		return map[string]interface{}{}, false
	}
	return o.Files, true
}

// HasFiles returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasFiles() bool {
	if o != nil && !IsNil(o.Files) {
		return true
	}

	return false
}

// SetFiles gets a reference to the given map[string]interface{} and assigns it to the Files field.
func (o *RpmPackageResponse) SetFiles(v map[string]interface{}) {
	o.Files = v
}

// GetRequires returns the Requires field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRequires() map[string]interface{} {
	if o == nil || IsNil(o.Requires) {
		var ret map[string]interface{}
		return ret
	}
	return o.Requires
}

// GetRequiresOk returns a tuple with the Requires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRequiresOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Requires) {
		return map[string]interface{}{}, false
	}
	return o.Requires, true
}

// HasRequires returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRequires() bool {
	if o != nil && !IsNil(o.Requires) {
		return true
	}

	return false
}

// SetRequires gets a reference to the given map[string]interface{} and assigns it to the Requires field.
func (o *RpmPackageResponse) SetRequires(v map[string]interface{}) {
	o.Requires = v
}

// GetProvides returns the Provides field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetProvides() map[string]interface{} {
	if o == nil || IsNil(o.Provides) {
		var ret map[string]interface{}
		return ret
	}
	return o.Provides
}

// GetProvidesOk returns a tuple with the Provides field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetProvidesOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Provides) {
		return map[string]interface{}{}, false
	}
	return o.Provides, true
}

// HasProvides returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasProvides() bool {
	if o != nil && !IsNil(o.Provides) {
		return true
	}

	return false
}

// SetProvides gets a reference to the given map[string]interface{} and assigns it to the Provides field.
func (o *RpmPackageResponse) SetProvides(v map[string]interface{}) {
	o.Provides = v
}

// GetConflicts returns the Conflicts field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetConflicts() map[string]interface{} {
	if o == nil || IsNil(o.Conflicts) {
		var ret map[string]interface{}
		return ret
	}
	return o.Conflicts
}

// GetConflictsOk returns a tuple with the Conflicts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetConflictsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Conflicts) {
		return map[string]interface{}{}, false
	}
	return o.Conflicts, true
}

// HasConflicts returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasConflicts() bool {
	if o != nil && !IsNil(o.Conflicts) {
		return true
	}

	return false
}

// SetConflicts gets a reference to the given map[string]interface{} and assigns it to the Conflicts field.
func (o *RpmPackageResponse) SetConflicts(v map[string]interface{}) {
	o.Conflicts = v
}

// GetObsoletes returns the Obsoletes field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetObsoletes() map[string]interface{} {
	if o == nil || IsNil(o.Obsoletes) {
		var ret map[string]interface{}
		return ret
	}
	return o.Obsoletes
}

// GetObsoletesOk returns a tuple with the Obsoletes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetObsoletesOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Obsoletes) {
		return map[string]interface{}{}, false
	}
	return o.Obsoletes, true
}

// HasObsoletes returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasObsoletes() bool {
	if o != nil && !IsNil(o.Obsoletes) {
		return true
	}

	return false
}

// SetObsoletes gets a reference to the given map[string]interface{} and assigns it to the Obsoletes field.
func (o *RpmPackageResponse) SetObsoletes(v map[string]interface{}) {
	o.Obsoletes = v
}

// GetSuggests returns the Suggests field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSuggests() map[string]interface{} {
	if o == nil || IsNil(o.Suggests) {
		var ret map[string]interface{}
		return ret
	}
	return o.Suggests
}

// GetSuggestsOk returns a tuple with the Suggests field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSuggestsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Suggests) {
		return map[string]interface{}{}, false
	}
	return o.Suggests, true
}

// HasSuggests returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSuggests() bool {
	if o != nil && !IsNil(o.Suggests) {
		return true
	}

	return false
}

// SetSuggests gets a reference to the given map[string]interface{} and assigns it to the Suggests field.
func (o *RpmPackageResponse) SetSuggests(v map[string]interface{}) {
	o.Suggests = v
}

// GetEnhances returns the Enhances field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetEnhances() map[string]interface{} {
	if o == nil || IsNil(o.Enhances) {
		var ret map[string]interface{}
		return ret
	}
	return o.Enhances
}

// GetEnhancesOk returns a tuple with the Enhances field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetEnhancesOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Enhances) {
		return map[string]interface{}{}, false
	}
	return o.Enhances, true
}

// HasEnhances returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasEnhances() bool {
	if o != nil && !IsNil(o.Enhances) {
		return true
	}

	return false
}

// SetEnhances gets a reference to the given map[string]interface{} and assigns it to the Enhances field.
func (o *RpmPackageResponse) SetEnhances(v map[string]interface{}) {
	o.Enhances = v
}

// GetRecommends returns the Recommends field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRecommends() map[string]interface{} {
	if o == nil || IsNil(o.Recommends) {
		var ret map[string]interface{}
		return ret
	}
	return o.Recommends
}

// GetRecommendsOk returns a tuple with the Recommends field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRecommendsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Recommends) {
		return map[string]interface{}{}, false
	}
	return o.Recommends, true
}

// HasRecommends returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRecommends() bool {
	if o != nil && !IsNil(o.Recommends) {
		return true
	}

	return false
}

// SetRecommends gets a reference to the given map[string]interface{} and assigns it to the Recommends field.
func (o *RpmPackageResponse) SetRecommends(v map[string]interface{}) {
	o.Recommends = v
}

// GetSupplements returns the Supplements field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSupplements() map[string]interface{} {
	if o == nil || IsNil(o.Supplements) {
		var ret map[string]interface{}
		return ret
	}
	return o.Supplements
}

// GetSupplementsOk returns a tuple with the Supplements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSupplementsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Supplements) {
		return map[string]interface{}{}, false
	}
	return o.Supplements, true
}

// HasSupplements returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSupplements() bool {
	if o != nil && !IsNil(o.Supplements) {
		return true
	}

	return false
}

// SetSupplements gets a reference to the given map[string]interface{} and assigns it to the Supplements field.
func (o *RpmPackageResponse) SetSupplements(v map[string]interface{}) {
	o.Supplements = v
}

// GetLocationBase returns the LocationBase field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetLocationBase() string {
	if o == nil || IsNil(o.LocationBase) {
		var ret string
		return ret
	}
	return *o.LocationBase
}

// GetLocationBaseOk returns a tuple with the LocationBase field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetLocationBaseOk() (*string, bool) {
	if o == nil || IsNil(o.LocationBase) {
		return nil, false
	}
	return o.LocationBase, true
}

// HasLocationBase returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasLocationBase() bool {
	if o != nil && !IsNil(o.LocationBase) {
		return true
	}

	return false
}

// SetLocationBase gets a reference to the given string and assigns it to the LocationBase field.
func (o *RpmPackageResponse) SetLocationBase(v string) {
	o.LocationBase = &v
}

// GetLocationHref returns the LocationHref field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetLocationHref() string {
	if o == nil || IsNil(o.LocationHref) {
		var ret string
		return ret
	}
	return *o.LocationHref
}

// GetLocationHrefOk returns a tuple with the LocationHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetLocationHrefOk() (*string, bool) {
	if o == nil || IsNil(o.LocationHref) {
		return nil, false
	}
	return o.LocationHref, true
}

// HasLocationHref returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasLocationHref() bool {
	if o != nil && !IsNil(o.LocationHref) {
		return true
	}

	return false
}

// SetLocationHref gets a reference to the given string and assigns it to the LocationHref field.
func (o *RpmPackageResponse) SetLocationHref(v string) {
	o.LocationHref = &v
}

// GetRpmBuildhost returns the RpmBuildhost field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmBuildhost() string {
	if o == nil || IsNil(o.RpmBuildhost) {
		var ret string
		return ret
	}
	return *o.RpmBuildhost
}

// GetRpmBuildhostOk returns a tuple with the RpmBuildhost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmBuildhostOk() (*string, bool) {
	if o == nil || IsNil(o.RpmBuildhost) {
		return nil, false
	}
	return o.RpmBuildhost, true
}

// HasRpmBuildhost returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmBuildhost() bool {
	if o != nil && !IsNil(o.RpmBuildhost) {
		return true
	}

	return false
}

// SetRpmBuildhost gets a reference to the given string and assigns it to the RpmBuildhost field.
func (o *RpmPackageResponse) SetRpmBuildhost(v string) {
	o.RpmBuildhost = &v
}

// GetRpmGroup returns the RpmGroup field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmGroup() string {
	if o == nil || IsNil(o.RpmGroup) {
		var ret string
		return ret
	}
	return *o.RpmGroup
}

// GetRpmGroupOk returns a tuple with the RpmGroup field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmGroupOk() (*string, bool) {
	if o == nil || IsNil(o.RpmGroup) {
		return nil, false
	}
	return o.RpmGroup, true
}

// HasRpmGroup returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmGroup() bool {
	if o != nil && !IsNil(o.RpmGroup) {
		return true
	}

	return false
}

// SetRpmGroup gets a reference to the given string and assigns it to the RpmGroup field.
func (o *RpmPackageResponse) SetRpmGroup(v string) {
	o.RpmGroup = &v
}

// GetRpmLicense returns the RpmLicense field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmLicense() string {
	if o == nil || IsNil(o.RpmLicense) {
		var ret string
		return ret
	}
	return *o.RpmLicense
}

// GetRpmLicenseOk returns a tuple with the RpmLicense field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmLicenseOk() (*string, bool) {
	if o == nil || IsNil(o.RpmLicense) {
		return nil, false
	}
	return o.RpmLicense, true
}

// HasRpmLicense returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmLicense() bool {
	if o != nil && !IsNil(o.RpmLicense) {
		return true
	}

	return false
}

// SetRpmLicense gets a reference to the given string and assigns it to the RpmLicense field.
func (o *RpmPackageResponse) SetRpmLicense(v string) {
	o.RpmLicense = &v
}

// GetRpmPackager returns the RpmPackager field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmPackager() string {
	if o == nil || IsNil(o.RpmPackager) {
		var ret string
		return ret
	}
	return *o.RpmPackager
}

// GetRpmPackagerOk returns a tuple with the RpmPackager field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmPackagerOk() (*string, bool) {
	if o == nil || IsNil(o.RpmPackager) {
		return nil, false
	}
	return o.RpmPackager, true
}

// HasRpmPackager returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmPackager() bool {
	if o != nil && !IsNil(o.RpmPackager) {
		return true
	}

	return false
}

// SetRpmPackager gets a reference to the given string and assigns it to the RpmPackager field.
func (o *RpmPackageResponse) SetRpmPackager(v string) {
	o.RpmPackager = &v
}

// GetRpmSourcerpm returns the RpmSourcerpm field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmSourcerpm() string {
	if o == nil || IsNil(o.RpmSourcerpm) {
		var ret string
		return ret
	}
	return *o.RpmSourcerpm
}

// GetRpmSourcerpmOk returns a tuple with the RpmSourcerpm field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmSourcerpmOk() (*string, bool) {
	if o == nil || IsNil(o.RpmSourcerpm) {
		return nil, false
	}
	return o.RpmSourcerpm, true
}

// HasRpmSourcerpm returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmSourcerpm() bool {
	if o != nil && !IsNil(o.RpmSourcerpm) {
		return true
	}

	return false
}

// SetRpmSourcerpm gets a reference to the given string and assigns it to the RpmSourcerpm field.
func (o *RpmPackageResponse) SetRpmSourcerpm(v string) {
	o.RpmSourcerpm = &v
}

// GetRpmVendor returns the RpmVendor field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmVendor() string {
	if o == nil || IsNil(o.RpmVendor) {
		var ret string
		return ret
	}
	return *o.RpmVendor
}

// GetRpmVendorOk returns a tuple with the RpmVendor field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmVendorOk() (*string, bool) {
	if o == nil || IsNil(o.RpmVendor) {
		return nil, false
	}
	return o.RpmVendor, true
}

// HasRpmVendor returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmVendor() bool {
	if o != nil && !IsNil(o.RpmVendor) {
		return true
	}

	return false
}

// SetRpmVendor gets a reference to the given string and assigns it to the RpmVendor field.
func (o *RpmPackageResponse) SetRpmVendor(v string) {
	o.RpmVendor = &v
}

// GetRpmHeaderStart returns the RpmHeaderStart field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmHeaderStart() int64 {
	if o == nil || IsNil(o.RpmHeaderStart) {
		var ret int64
		return ret
	}
	return *o.RpmHeaderStart
}

// GetRpmHeaderStartOk returns a tuple with the RpmHeaderStart field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmHeaderStartOk() (*int64, bool) {
	if o == nil || IsNil(o.RpmHeaderStart) {
		return nil, false
	}
	return o.RpmHeaderStart, true
}

// HasRpmHeaderStart returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmHeaderStart() bool {
	if o != nil && !IsNil(o.RpmHeaderStart) {
		return true
	}

	return false
}

// SetRpmHeaderStart gets a reference to the given int64 and assigns it to the RpmHeaderStart field.
func (o *RpmPackageResponse) SetRpmHeaderStart(v int64) {
	o.RpmHeaderStart = &v
}

// GetRpmHeaderEnd returns the RpmHeaderEnd field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetRpmHeaderEnd() int64 {
	if o == nil || IsNil(o.RpmHeaderEnd) {
		var ret int64
		return ret
	}
	return *o.RpmHeaderEnd
}

// GetRpmHeaderEndOk returns a tuple with the RpmHeaderEnd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetRpmHeaderEndOk() (*int64, bool) {
	if o == nil || IsNil(o.RpmHeaderEnd) {
		return nil, false
	}
	return o.RpmHeaderEnd, true
}

// HasRpmHeaderEnd returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasRpmHeaderEnd() bool {
	if o != nil && !IsNil(o.RpmHeaderEnd) {
		return true
	}

	return false
}

// SetRpmHeaderEnd gets a reference to the given int64 and assigns it to the RpmHeaderEnd field.
func (o *RpmPackageResponse) SetRpmHeaderEnd(v int64) {
	o.RpmHeaderEnd = &v
}

// GetIsModular returns the IsModular field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetIsModular() bool {
	if o == nil || IsNil(o.IsModular) {
		var ret bool
		return ret
	}
	return *o.IsModular
}

// GetIsModularOk returns a tuple with the IsModular field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetIsModularOk() (*bool, bool) {
	if o == nil || IsNil(o.IsModular) {
		return nil, false
	}
	return o.IsModular, true
}

// HasIsModular returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasIsModular() bool {
	if o != nil && !IsNil(o.IsModular) {
		return true
	}

	return false
}

// SetIsModular gets a reference to the given bool and assigns it to the IsModular field.
func (o *RpmPackageResponse) SetIsModular(v bool) {
	o.IsModular = &v
}

// GetSizeArchive returns the SizeArchive field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSizeArchive() int64 {
	if o == nil || IsNil(o.SizeArchive) {
		var ret int64
		return ret
	}
	return *o.SizeArchive
}

// GetSizeArchiveOk returns a tuple with the SizeArchive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSizeArchiveOk() (*int64, bool) {
	if o == nil || IsNil(o.SizeArchive) {
		return nil, false
	}
	return o.SizeArchive, true
}

// HasSizeArchive returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSizeArchive() bool {
	if o != nil && !IsNil(o.SizeArchive) {
		return true
	}

	return false
}

// SetSizeArchive gets a reference to the given int64 and assigns it to the SizeArchive field.
func (o *RpmPackageResponse) SetSizeArchive(v int64) {
	o.SizeArchive = &v
}

// GetSizeInstalled returns the SizeInstalled field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSizeInstalled() int64 {
	if o == nil || IsNil(o.SizeInstalled) {
		var ret int64
		return ret
	}
	return *o.SizeInstalled
}

// GetSizeInstalledOk returns a tuple with the SizeInstalled field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSizeInstalledOk() (*int64, bool) {
	if o == nil || IsNil(o.SizeInstalled) {
		return nil, false
	}
	return o.SizeInstalled, true
}

// HasSizeInstalled returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSizeInstalled() bool {
	if o != nil && !IsNil(o.SizeInstalled) {
		return true
	}

	return false
}

// SetSizeInstalled gets a reference to the given int64 and assigns it to the SizeInstalled field.
func (o *RpmPackageResponse) SetSizeInstalled(v int64) {
	o.SizeInstalled = &v
}

// GetSizePackage returns the SizePackage field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetSizePackage() int64 {
	if o == nil || IsNil(o.SizePackage) {
		var ret int64
		return ret
	}
	return *o.SizePackage
}

// GetSizePackageOk returns a tuple with the SizePackage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetSizePackageOk() (*int64, bool) {
	if o == nil || IsNil(o.SizePackage) {
		return nil, false
	}
	return o.SizePackage, true
}

// HasSizePackage returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasSizePackage() bool {
	if o != nil && !IsNil(o.SizePackage) {
		return true
	}

	return false
}

// SetSizePackage gets a reference to the given int64 and assigns it to the SizePackage field.
func (o *RpmPackageResponse) SetSizePackage(v int64) {
	o.SizePackage = &v
}

// GetTimeBuild returns the TimeBuild field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetTimeBuild() int64 {
	if o == nil || IsNil(o.TimeBuild) {
		var ret int64
		return ret
	}
	return *o.TimeBuild
}

// GetTimeBuildOk returns a tuple with the TimeBuild field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetTimeBuildOk() (*int64, bool) {
	if o == nil || IsNil(o.TimeBuild) {
		return nil, false
	}
	return o.TimeBuild, true
}

// HasTimeBuild returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasTimeBuild() bool {
	if o != nil && !IsNil(o.TimeBuild) {
		return true
	}

	return false
}

// SetTimeBuild gets a reference to the given int64 and assigns it to the TimeBuild field.
func (o *RpmPackageResponse) SetTimeBuild(v int64) {
	o.TimeBuild = &v
}

// GetTimeFile returns the TimeFile field value if set, zero value otherwise.
func (o *RpmPackageResponse) GetTimeFile() int64 {
	if o == nil || IsNil(o.TimeFile) {
		var ret int64
		return ret
	}
	return *o.TimeFile
}

// GetTimeFileOk returns a tuple with the TimeFile field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmPackageResponse) GetTimeFileOk() (*int64, bool) {
	if o == nil || IsNil(o.TimeFile) {
		return nil, false
	}
	return o.TimeFile, true
}

// HasTimeFile returns a boolean if a field has been set.
func (o *RpmPackageResponse) HasTimeFile() bool {
	if o != nil && !IsNil(o.TimeFile) {
		return true
	}

	return false
}

// SetTimeFile gets a reference to the given int64 and assigns it to the TimeFile field.
func (o *RpmPackageResponse) SetTimeFile(v int64) {
	o.TimeFile = &v
}

func (o RpmPackageResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmPackageResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.Md5) {
		toSerialize["md5"] = o.Md5
	}
	if !IsNil(o.Sha1) {
		toSerialize["sha1"] = o.Sha1
	}
	if !IsNil(o.Sha224) {
		toSerialize["sha224"] = o.Sha224
	}
	if !IsNil(o.Sha256) {
		toSerialize["sha256"] = o.Sha256
	}
	if !IsNil(o.Sha384) {
		toSerialize["sha384"] = o.Sha384
	}
	if !IsNil(o.Sha512) {
		toSerialize["sha512"] = o.Sha512
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Epoch) {
		toSerialize["epoch"] = o.Epoch
	}
	if !IsNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !IsNil(o.Release) {
		toSerialize["release"] = o.Release
	}
	if !IsNil(o.Arch) {
		toSerialize["arch"] = o.Arch
	}
	if !IsNil(o.PkgId) {
		toSerialize["pkgId"] = o.PkgId
	}
	if !IsNil(o.ChecksumType) {
		toSerialize["checksum_type"] = o.ChecksumType
	}
	if !IsNil(o.Summary) {
		toSerialize["summary"] = o.Summary
	}
	if !IsNil(o.Description) {
		toSerialize["description"] = o.Description
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if !IsNil(o.Changelogs) {
		toSerialize["changelogs"] = o.Changelogs
	}
	if !IsNil(o.Files) {
		toSerialize["files"] = o.Files
	}
	if !IsNil(o.Requires) {
		toSerialize["requires"] = o.Requires
	}
	if !IsNil(o.Provides) {
		toSerialize["provides"] = o.Provides
	}
	if !IsNil(o.Conflicts) {
		toSerialize["conflicts"] = o.Conflicts
	}
	if !IsNil(o.Obsoletes) {
		toSerialize["obsoletes"] = o.Obsoletes
	}
	if !IsNil(o.Suggests) {
		toSerialize["suggests"] = o.Suggests
	}
	if !IsNil(o.Enhances) {
		toSerialize["enhances"] = o.Enhances
	}
	if !IsNil(o.Recommends) {
		toSerialize["recommends"] = o.Recommends
	}
	if !IsNil(o.Supplements) {
		toSerialize["supplements"] = o.Supplements
	}
	if !IsNil(o.LocationBase) {
		toSerialize["location_base"] = o.LocationBase
	}
	if !IsNil(o.LocationHref) {
		toSerialize["location_href"] = o.LocationHref
	}
	if !IsNil(o.RpmBuildhost) {
		toSerialize["rpm_buildhost"] = o.RpmBuildhost
	}
	if !IsNil(o.RpmGroup) {
		toSerialize["rpm_group"] = o.RpmGroup
	}
	if !IsNil(o.RpmLicense) {
		toSerialize["rpm_license"] = o.RpmLicense
	}
	if !IsNil(o.RpmPackager) {
		toSerialize["rpm_packager"] = o.RpmPackager
	}
	if !IsNil(o.RpmSourcerpm) {
		toSerialize["rpm_sourcerpm"] = o.RpmSourcerpm
	}
	if !IsNil(o.RpmVendor) {
		toSerialize["rpm_vendor"] = o.RpmVendor
	}
	if !IsNil(o.RpmHeaderStart) {
		toSerialize["rpm_header_start"] = o.RpmHeaderStart
	}
	if !IsNil(o.RpmHeaderEnd) {
		toSerialize["rpm_header_end"] = o.RpmHeaderEnd
	}
	if !IsNil(o.IsModular) {
		toSerialize["is_modular"] = o.IsModular
	}
	if !IsNil(o.SizeArchive) {
		toSerialize["size_archive"] = o.SizeArchive
	}
	if !IsNil(o.SizeInstalled) {
		toSerialize["size_installed"] = o.SizeInstalled
	}
	if !IsNil(o.SizePackage) {
		toSerialize["size_package"] = o.SizePackage
	}
	if !IsNil(o.TimeBuild) {
		toSerialize["time_build"] = o.TimeBuild
	}
	if !IsNil(o.TimeFile) {
		toSerialize["time_file"] = o.TimeFile
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmPackageResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmPackageResponse := _RpmPackageResponse{}

	if err = json.Unmarshal(bytes, &varRpmPackageResponse); err == nil {
		*o = RpmPackageResponse(varRpmPackageResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "md5")
		delete(additionalProperties, "sha1")
		delete(additionalProperties, "sha224")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "sha384")
		delete(additionalProperties, "sha512")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "name")
		delete(additionalProperties, "epoch")
		delete(additionalProperties, "version")
		delete(additionalProperties, "release")
		delete(additionalProperties, "arch")
		delete(additionalProperties, "pkgId")
		delete(additionalProperties, "checksum_type")
		delete(additionalProperties, "summary")
		delete(additionalProperties, "description")
		delete(additionalProperties, "url")
		delete(additionalProperties, "changelogs")
		delete(additionalProperties, "files")
		delete(additionalProperties, "requires")
		delete(additionalProperties, "provides")
		delete(additionalProperties, "conflicts")
		delete(additionalProperties, "obsoletes")
		delete(additionalProperties, "suggests")
		delete(additionalProperties, "enhances")
		delete(additionalProperties, "recommends")
		delete(additionalProperties, "supplements")
		delete(additionalProperties, "location_base")
		delete(additionalProperties, "location_href")
		delete(additionalProperties, "rpm_buildhost")
		delete(additionalProperties, "rpm_group")
		delete(additionalProperties, "rpm_license")
		delete(additionalProperties, "rpm_packager")
		delete(additionalProperties, "rpm_sourcerpm")
		delete(additionalProperties, "rpm_vendor")
		delete(additionalProperties, "rpm_header_start")
		delete(additionalProperties, "rpm_header_end")
		delete(additionalProperties, "is_modular")
		delete(additionalProperties, "size_archive")
		delete(additionalProperties, "size_installed")
		delete(additionalProperties, "size_package")
		delete(additionalProperties, "time_build")
		delete(additionalProperties, "time_file")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmPackageResponse struct {
	value *RpmPackageResponse
	isSet bool
}

func (v NullableRpmPackageResponse) Get() *RpmPackageResponse {
	return v.value
}

func (v *NullableRpmPackageResponse) Set(val *RpmPackageResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmPackageResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmPackageResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmPackageResponse(val *RpmPackageResponse) *NullableRpmPackageResponse {
	return &NullableRpmPackageResponse{value: val, isSet: true}
}

func (v NullableRpmPackageResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmPackageResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


