/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpAnsibleDefaultApiV3CollectionsAPIService PulpAnsibleDefaultApiV3CollectionsAPI service
type PulpAnsibleDefaultApiV3CollectionsAPIService service

type PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3CollectionsAPIService
	name string
	namespace string
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3CollectionsDeleteExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3CollectionsDelete Method for PulpAnsibleGalaxyDefaultApiV3CollectionsDelete

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param name
 @param namespace
 @return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest

Deprecated
*/
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsDelete(ctx context.Context, name string, namespace string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest {
	return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		name: name,
		namespace: namespace,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
// Deprecated
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsDeleteExecute(r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3CollectionsAPIService.PulpAnsibleGalaxyDefaultApiV3CollectionsDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3CollectionsAPIService
	deprecated *bool
	limit *int32
	name *string
	namespace *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Deprecated(deprecated bool) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.deprecated = &deprecated
	return r
}

// Number of results to return per page.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Limit(limit int32) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.limit = &limit
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Name(name string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.name = &name
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Namespace(namespace string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.namespace = &namespace
	return r
}

// The initial index from which to return the results.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Offset(offset int32) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;namespace&#x60; - Namespace * &#x60;-namespace&#x60; - Namespace (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Ordering(ordering []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Fields(fields []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) Execute() (*PaginatedCollectionResponseList, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3CollectionsListExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3CollectionsList Method for PulpAnsibleGalaxyDefaultApiV3CollectionsList

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest

Deprecated
*/
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsList(ctx context.Context) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest {
	return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedCollectionResponseList
// Deprecated
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsListExecute(r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsListRequest) (*PaginatedCollectionResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedCollectionResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3CollectionsAPIService.PulpAnsibleGalaxyDefaultApiV3CollectionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/collections/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "deprecated", r.deprecated, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.namespace != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3CollectionsAPIService
	name string
	namespace string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest) Fields(fields []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest) Execute() (*CollectionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3CollectionsReadExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3CollectionsRead Method for PulpAnsibleGalaxyDefaultApiV3CollectionsRead

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param name
 @param namespace
 @return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest

Deprecated
*/
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsRead(ctx context.Context, name string, namespace string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest {
	return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest{
		ApiService: a,
		ctx: ctx,
		name: name,
		namespace: namespace,
	}
}

// Execute executes the request
//  @return CollectionResponse
// Deprecated
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsReadExecute(r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsReadRequest) (*CollectionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *CollectionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3CollectionsAPIService.PulpAnsibleGalaxyDefaultApiV3CollectionsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3CollectionsAPIService
	name string
	namespace string
	patchedCollection *PatchedCollection
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest) PatchedCollection(patchedCollection PatchedCollection) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest {
	r.patchedCollection = &patchedCollection
	return r
}

func (r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3CollectionsUpdateExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3CollectionsUpdate Method for PulpAnsibleGalaxyDefaultApiV3CollectionsUpdate

Legacy v3 endpoint.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param name
 @param namespace
 @return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest

Deprecated
*/
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsUpdate(ctx context.Context, name string, namespace string) PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest {
	return PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest{
		ApiService: a,
		ctx: ctx,
		name: name,
		namespace: namespace,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
// Deprecated
func (a *PulpAnsibleDefaultApiV3CollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3CollectionsUpdateExecute(r PulpAnsibleDefaultApiV3CollectionsAPIPulpAnsibleGalaxyDefaultApiV3CollectionsUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3CollectionsAPIService.PulpAnsibleGalaxyDefaultApiV3CollectionsUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/collections/{namespace}/{name}/"
	localVarPath = strings.Replace(localVarPath, "{"+"name"+"}", parameterValueToString(r.name, "name"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters
	localVarPath = strings.Replace(localVarPath, "{"+"namespace"+"}", parameterValueToString(r.namespace, "namespace"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedCollection == nil {
		return localVarReturnValue, nil, reportError("patchedCollection is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedCollection
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
