/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
)


// PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPI service
type PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService service

type PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest) Execute() (*ClientConfigurationResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationRead Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationRead

Return configurations for the ansible-galaxy client.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationRead(ctx context.Context) PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return ClientConfigurationResponse
func (a *PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadExecute(r PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationReadRequest) (*ClientConfigurationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ClientConfigurationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleClientConfigurationAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleClientConfigurationRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/client-configuration/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
