/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the DebPackageResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DebPackageResponse{}

// DebPackageResponse A Serializer for Package.
type DebPackageResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// Path where the artifact is located relative to distributions base_path
	RelativePath *string `json:"relative_path,omitempty"`
	// Name of the distribution.
	Distribution *string `json:"distribution,omitempty"`
	// Name of the component.
	Component *string `json:"component,omitempty"`
	// The MD5 checksum if available.
	Md5 *string `json:"md5,omitempty"`
	// The SHA-1 checksum if available.
	Sha1 *string `json:"sha1,omitempty"`
	// The SHA-224 checksum if available.
	Sha224 *string `json:"sha224,omitempty"`
	// The SHA-256 checksum if available.
	Sha256 *string `json:"sha256,omitempty"`
	// The SHA-384 checksum if available.
	Sha384 *string `json:"sha384,omitempty"`
	// The SHA-512 checksum if available.
	Sha512 *string `json:"sha512,omitempty"`
	Package *string `json:"package,omitempty"`
	Source *string `json:"source,omitempty"`
	Version *string `json:"version,omitempty"`
	Architecture *string `json:"architecture,omitempty"`
	Section *string `json:"section,omitempty"`
	Priority *string `json:"priority,omitempty"`
	Origin *string `json:"origin,omitempty"`
	Tag *string `json:"tag,omitempty"`
	Bugs *string `json:"bugs,omitempty"`
	Essential *string `json:"essential,omitempty"`
	BuildEssential *string `json:"build_essential,omitempty"`
	InstalledSize *string `json:"installed_size,omitempty"`
	Maintainer *string `json:"maintainer,omitempty"`
	OriginalMaintainer *string `json:"original_maintainer,omitempty"`
	Description *string `json:"description,omitempty"`
	DescriptionMd5 *string `json:"description_md5,omitempty"`
	Homepage *string `json:"homepage,omitempty"`
	BuiltUsing *string `json:"built_using,omitempty"`
	AutoBuiltPackage *string `json:"auto_built_package,omitempty"`
	MultiArch *string `json:"multi_arch,omitempty"`
	Breaks *string `json:"breaks,omitempty"`
	Conflicts *string `json:"conflicts,omitempty"`
	Depends *string `json:"depends,omitempty"`
	Recommends *string `json:"recommends,omitempty"`
	Suggests *string `json:"suggests,omitempty"`
	Enhances *string `json:"enhances,omitempty"`
	PreDepends *string `json:"pre_depends,omitempty"`
	Provides *string `json:"provides,omitempty"`
	Replaces *string `json:"replaces,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _DebPackageResponse DebPackageResponse

// NewDebPackageResponse instantiates a new DebPackageResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDebPackageResponse() *DebPackageResponse {
	this := DebPackageResponse{}
	return &this
}

// NewDebPackageResponseWithDefaults instantiates a new DebPackageResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDebPackageResponseWithDefaults() *DebPackageResponse {
	this := DebPackageResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *DebPackageResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *DebPackageResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *DebPackageResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *DebPackageResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *DebPackageResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *DebPackageResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *DebPackageResponse) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *DebPackageResponse) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *DebPackageResponse) SetArtifact(v string) {
	o.Artifact = &v
}

// GetRelativePath returns the RelativePath field value if set, zero value otherwise.
func (o *DebPackageResponse) GetRelativePath() string {
	if o == nil || IsNil(o.RelativePath) {
		var ret string
		return ret
	}
	return *o.RelativePath
}

// GetRelativePathOk returns a tuple with the RelativePath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetRelativePathOk() (*string, bool) {
	if o == nil || IsNil(o.RelativePath) {
		return nil, false
	}
	return o.RelativePath, true
}

// HasRelativePath returns a boolean if a field has been set.
func (o *DebPackageResponse) HasRelativePath() bool {
	if o != nil && !IsNil(o.RelativePath) {
		return true
	}

	return false
}

// SetRelativePath gets a reference to the given string and assigns it to the RelativePath field.
func (o *DebPackageResponse) SetRelativePath(v string) {
	o.RelativePath = &v
}

// GetDistribution returns the Distribution field value if set, zero value otherwise.
func (o *DebPackageResponse) GetDistribution() string {
	if o == nil || IsNil(o.Distribution) {
		var ret string
		return ret
	}
	return *o.Distribution
}

// GetDistributionOk returns a tuple with the Distribution field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetDistributionOk() (*string, bool) {
	if o == nil || IsNil(o.Distribution) {
		return nil, false
	}
	return o.Distribution, true
}

// HasDistribution returns a boolean if a field has been set.
func (o *DebPackageResponse) HasDistribution() bool {
	if o != nil && !IsNil(o.Distribution) {
		return true
	}

	return false
}

// SetDistribution gets a reference to the given string and assigns it to the Distribution field.
func (o *DebPackageResponse) SetDistribution(v string) {
	o.Distribution = &v
}

// GetComponent returns the Component field value if set, zero value otherwise.
func (o *DebPackageResponse) GetComponent() string {
	if o == nil || IsNil(o.Component) {
		var ret string
		return ret
	}
	return *o.Component
}

// GetComponentOk returns a tuple with the Component field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetComponentOk() (*string, bool) {
	if o == nil || IsNil(o.Component) {
		return nil, false
	}
	return o.Component, true
}

// HasComponent returns a boolean if a field has been set.
func (o *DebPackageResponse) HasComponent() bool {
	if o != nil && !IsNil(o.Component) {
		return true
	}

	return false
}

// SetComponent gets a reference to the given string and assigns it to the Component field.
func (o *DebPackageResponse) SetComponent(v string) {
	o.Component = &v
}

// GetMd5 returns the Md5 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetMd5() string {
	if o == nil || IsNil(o.Md5) {
		var ret string
		return ret
	}
	return *o.Md5
}

// GetMd5Ok returns a tuple with the Md5 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetMd5Ok() (*string, bool) {
	if o == nil || IsNil(o.Md5) {
		return nil, false
	}
	return o.Md5, true
}

// HasMd5 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasMd5() bool {
	if o != nil && !IsNil(o.Md5) {
		return true
	}

	return false
}

// SetMd5 gets a reference to the given string and assigns it to the Md5 field.
func (o *DebPackageResponse) SetMd5(v string) {
	o.Md5 = &v
}

// GetSha1 returns the Sha1 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSha1() string {
	if o == nil || IsNil(o.Sha1) {
		var ret string
		return ret
	}
	return *o.Sha1
}

// GetSha1Ok returns a tuple with the Sha1 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSha1Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha1) {
		return nil, false
	}
	return o.Sha1, true
}

// HasSha1 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSha1() bool {
	if o != nil && !IsNil(o.Sha1) {
		return true
	}

	return false
}

// SetSha1 gets a reference to the given string and assigns it to the Sha1 field.
func (o *DebPackageResponse) SetSha1(v string) {
	o.Sha1 = &v
}

// GetSha224 returns the Sha224 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSha224() string {
	if o == nil || IsNil(o.Sha224) {
		var ret string
		return ret
	}
	return *o.Sha224
}

// GetSha224Ok returns a tuple with the Sha224 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSha224Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha224) {
		return nil, false
	}
	return o.Sha224, true
}

// HasSha224 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSha224() bool {
	if o != nil && !IsNil(o.Sha224) {
		return true
	}

	return false
}

// SetSha224 gets a reference to the given string and assigns it to the Sha224 field.
func (o *DebPackageResponse) SetSha224(v string) {
	o.Sha224 = &v
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSha256() string {
	if o == nil || IsNil(o.Sha256) {
		var ret string
		return ret
	}
	return *o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSha256Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha256) {
		return nil, false
	}
	return o.Sha256, true
}

// HasSha256 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSha256() bool {
	if o != nil && !IsNil(o.Sha256) {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given string and assigns it to the Sha256 field.
func (o *DebPackageResponse) SetSha256(v string) {
	o.Sha256 = &v
}

// GetSha384 returns the Sha384 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSha384() string {
	if o == nil || IsNil(o.Sha384) {
		var ret string
		return ret
	}
	return *o.Sha384
}

// GetSha384Ok returns a tuple with the Sha384 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSha384Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha384) {
		return nil, false
	}
	return o.Sha384, true
}

// HasSha384 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSha384() bool {
	if o != nil && !IsNil(o.Sha384) {
		return true
	}

	return false
}

// SetSha384 gets a reference to the given string and assigns it to the Sha384 field.
func (o *DebPackageResponse) SetSha384(v string) {
	o.Sha384 = &v
}

// GetSha512 returns the Sha512 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSha512() string {
	if o == nil || IsNil(o.Sha512) {
		var ret string
		return ret
	}
	return *o.Sha512
}

// GetSha512Ok returns a tuple with the Sha512 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSha512Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha512) {
		return nil, false
	}
	return o.Sha512, true
}

// HasSha512 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSha512() bool {
	if o != nil && !IsNil(o.Sha512) {
		return true
	}

	return false
}

// SetSha512 gets a reference to the given string and assigns it to the Sha512 field.
func (o *DebPackageResponse) SetSha512(v string) {
	o.Sha512 = &v
}

// GetPackage returns the Package field value if set, zero value otherwise.
func (o *DebPackageResponse) GetPackage() string {
	if o == nil || IsNil(o.Package) {
		var ret string
		return ret
	}
	return *o.Package
}

// GetPackageOk returns a tuple with the Package field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetPackageOk() (*string, bool) {
	if o == nil || IsNil(o.Package) {
		return nil, false
	}
	return o.Package, true
}

// HasPackage returns a boolean if a field has been set.
func (o *DebPackageResponse) HasPackage() bool {
	if o != nil && !IsNil(o.Package) {
		return true
	}

	return false
}

// SetPackage gets a reference to the given string and assigns it to the Package field.
func (o *DebPackageResponse) SetPackage(v string) {
	o.Package = &v
}

// GetSource returns the Source field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSource() string {
	if o == nil || IsNil(o.Source) {
		var ret string
		return ret
	}
	return *o.Source
}

// GetSourceOk returns a tuple with the Source field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSourceOk() (*string, bool) {
	if o == nil || IsNil(o.Source) {
		return nil, false
	}
	return o.Source, true
}

// HasSource returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSource() bool {
	if o != nil && !IsNil(o.Source) {
		return true
	}

	return false
}

// SetSource gets a reference to the given string and assigns it to the Source field.
func (o *DebPackageResponse) SetSource(v string) {
	o.Source = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *DebPackageResponse) GetVersion() string {
	if o == nil || IsNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetVersionOk() (*string, bool) {
	if o == nil || IsNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *DebPackageResponse) HasVersion() bool {
	if o != nil && !IsNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *DebPackageResponse) SetVersion(v string) {
	o.Version = &v
}

// GetArchitecture returns the Architecture field value if set, zero value otherwise.
func (o *DebPackageResponse) GetArchitecture() string {
	if o == nil || IsNil(o.Architecture) {
		var ret string
		return ret
	}
	return *o.Architecture
}

// GetArchitectureOk returns a tuple with the Architecture field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetArchitectureOk() (*string, bool) {
	if o == nil || IsNil(o.Architecture) {
		return nil, false
	}
	return o.Architecture, true
}

// HasArchitecture returns a boolean if a field has been set.
func (o *DebPackageResponse) HasArchitecture() bool {
	if o != nil && !IsNil(o.Architecture) {
		return true
	}

	return false
}

// SetArchitecture gets a reference to the given string and assigns it to the Architecture field.
func (o *DebPackageResponse) SetArchitecture(v string) {
	o.Architecture = &v
}

// GetSection returns the Section field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSection() string {
	if o == nil || IsNil(o.Section) {
		var ret string
		return ret
	}
	return *o.Section
}

// GetSectionOk returns a tuple with the Section field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSectionOk() (*string, bool) {
	if o == nil || IsNil(o.Section) {
		return nil, false
	}
	return o.Section, true
}

// HasSection returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSection() bool {
	if o != nil && !IsNil(o.Section) {
		return true
	}

	return false
}

// SetSection gets a reference to the given string and assigns it to the Section field.
func (o *DebPackageResponse) SetSection(v string) {
	o.Section = &v
}

// GetPriority returns the Priority field value if set, zero value otherwise.
func (o *DebPackageResponse) GetPriority() string {
	if o == nil || IsNil(o.Priority) {
		var ret string
		return ret
	}
	return *o.Priority
}

// GetPriorityOk returns a tuple with the Priority field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetPriorityOk() (*string, bool) {
	if o == nil || IsNil(o.Priority) {
		return nil, false
	}
	return o.Priority, true
}

// HasPriority returns a boolean if a field has been set.
func (o *DebPackageResponse) HasPriority() bool {
	if o != nil && !IsNil(o.Priority) {
		return true
	}

	return false
}

// SetPriority gets a reference to the given string and assigns it to the Priority field.
func (o *DebPackageResponse) SetPriority(v string) {
	o.Priority = &v
}

// GetOrigin returns the Origin field value if set, zero value otherwise.
func (o *DebPackageResponse) GetOrigin() string {
	if o == nil || IsNil(o.Origin) {
		var ret string
		return ret
	}
	return *o.Origin
}

// GetOriginOk returns a tuple with the Origin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetOriginOk() (*string, bool) {
	if o == nil || IsNil(o.Origin) {
		return nil, false
	}
	return o.Origin, true
}

// HasOrigin returns a boolean if a field has been set.
func (o *DebPackageResponse) HasOrigin() bool {
	if o != nil && !IsNil(o.Origin) {
		return true
	}

	return false
}

// SetOrigin gets a reference to the given string and assigns it to the Origin field.
func (o *DebPackageResponse) SetOrigin(v string) {
	o.Origin = &v
}

// GetTag returns the Tag field value if set, zero value otherwise.
func (o *DebPackageResponse) GetTag() string {
	if o == nil || IsNil(o.Tag) {
		var ret string
		return ret
	}
	return *o.Tag
}

// GetTagOk returns a tuple with the Tag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetTagOk() (*string, bool) {
	if o == nil || IsNil(o.Tag) {
		return nil, false
	}
	return o.Tag, true
}

// HasTag returns a boolean if a field has been set.
func (o *DebPackageResponse) HasTag() bool {
	if o != nil && !IsNil(o.Tag) {
		return true
	}

	return false
}

// SetTag gets a reference to the given string and assigns it to the Tag field.
func (o *DebPackageResponse) SetTag(v string) {
	o.Tag = &v
}

// GetBugs returns the Bugs field value if set, zero value otherwise.
func (o *DebPackageResponse) GetBugs() string {
	if o == nil || IsNil(o.Bugs) {
		var ret string
		return ret
	}
	return *o.Bugs
}

// GetBugsOk returns a tuple with the Bugs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetBugsOk() (*string, bool) {
	if o == nil || IsNil(o.Bugs) {
		return nil, false
	}
	return o.Bugs, true
}

// HasBugs returns a boolean if a field has been set.
func (o *DebPackageResponse) HasBugs() bool {
	if o != nil && !IsNil(o.Bugs) {
		return true
	}

	return false
}

// SetBugs gets a reference to the given string and assigns it to the Bugs field.
func (o *DebPackageResponse) SetBugs(v string) {
	o.Bugs = &v
}

// GetEssential returns the Essential field value if set, zero value otherwise.
func (o *DebPackageResponse) GetEssential() string {
	if o == nil || IsNil(o.Essential) {
		var ret string
		return ret
	}
	return *o.Essential
}

// GetEssentialOk returns a tuple with the Essential field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetEssentialOk() (*string, bool) {
	if o == nil || IsNil(o.Essential) {
		return nil, false
	}
	return o.Essential, true
}

// HasEssential returns a boolean if a field has been set.
func (o *DebPackageResponse) HasEssential() bool {
	if o != nil && !IsNil(o.Essential) {
		return true
	}

	return false
}

// SetEssential gets a reference to the given string and assigns it to the Essential field.
func (o *DebPackageResponse) SetEssential(v string) {
	o.Essential = &v
}

// GetBuildEssential returns the BuildEssential field value if set, zero value otherwise.
func (o *DebPackageResponse) GetBuildEssential() string {
	if o == nil || IsNil(o.BuildEssential) {
		var ret string
		return ret
	}
	return *o.BuildEssential
}

// GetBuildEssentialOk returns a tuple with the BuildEssential field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetBuildEssentialOk() (*string, bool) {
	if o == nil || IsNil(o.BuildEssential) {
		return nil, false
	}
	return o.BuildEssential, true
}

// HasBuildEssential returns a boolean if a field has been set.
func (o *DebPackageResponse) HasBuildEssential() bool {
	if o != nil && !IsNil(o.BuildEssential) {
		return true
	}

	return false
}

// SetBuildEssential gets a reference to the given string and assigns it to the BuildEssential field.
func (o *DebPackageResponse) SetBuildEssential(v string) {
	o.BuildEssential = &v
}

// GetInstalledSize returns the InstalledSize field value if set, zero value otherwise.
func (o *DebPackageResponse) GetInstalledSize() string {
	if o == nil || IsNil(o.InstalledSize) {
		var ret string
		return ret
	}
	return *o.InstalledSize
}

// GetInstalledSizeOk returns a tuple with the InstalledSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetInstalledSizeOk() (*string, bool) {
	if o == nil || IsNil(o.InstalledSize) {
		return nil, false
	}
	return o.InstalledSize, true
}

// HasInstalledSize returns a boolean if a field has been set.
func (o *DebPackageResponse) HasInstalledSize() bool {
	if o != nil && !IsNil(o.InstalledSize) {
		return true
	}

	return false
}

// SetInstalledSize gets a reference to the given string and assigns it to the InstalledSize field.
func (o *DebPackageResponse) SetInstalledSize(v string) {
	o.InstalledSize = &v
}

// GetMaintainer returns the Maintainer field value if set, zero value otherwise.
func (o *DebPackageResponse) GetMaintainer() string {
	if o == nil || IsNil(o.Maintainer) {
		var ret string
		return ret
	}
	return *o.Maintainer
}

// GetMaintainerOk returns a tuple with the Maintainer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetMaintainerOk() (*string, bool) {
	if o == nil || IsNil(o.Maintainer) {
		return nil, false
	}
	return o.Maintainer, true
}

// HasMaintainer returns a boolean if a field has been set.
func (o *DebPackageResponse) HasMaintainer() bool {
	if o != nil && !IsNil(o.Maintainer) {
		return true
	}

	return false
}

// SetMaintainer gets a reference to the given string and assigns it to the Maintainer field.
func (o *DebPackageResponse) SetMaintainer(v string) {
	o.Maintainer = &v
}

// GetOriginalMaintainer returns the OriginalMaintainer field value if set, zero value otherwise.
func (o *DebPackageResponse) GetOriginalMaintainer() string {
	if o == nil || IsNil(o.OriginalMaintainer) {
		var ret string
		return ret
	}
	return *o.OriginalMaintainer
}

// GetOriginalMaintainerOk returns a tuple with the OriginalMaintainer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetOriginalMaintainerOk() (*string, bool) {
	if o == nil || IsNil(o.OriginalMaintainer) {
		return nil, false
	}
	return o.OriginalMaintainer, true
}

// HasOriginalMaintainer returns a boolean if a field has been set.
func (o *DebPackageResponse) HasOriginalMaintainer() bool {
	if o != nil && !IsNil(o.OriginalMaintainer) {
		return true
	}

	return false
}

// SetOriginalMaintainer gets a reference to the given string and assigns it to the OriginalMaintainer field.
func (o *DebPackageResponse) SetOriginalMaintainer(v string) {
	o.OriginalMaintainer = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DebPackageResponse) GetDescription() string {
	if o == nil || IsNil(o.Description) {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.Description) {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DebPackageResponse) HasDescription() bool {
	if o != nil && !IsNil(o.Description) {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DebPackageResponse) SetDescription(v string) {
	o.Description = &v
}

// GetDescriptionMd5 returns the DescriptionMd5 field value if set, zero value otherwise.
func (o *DebPackageResponse) GetDescriptionMd5() string {
	if o == nil || IsNil(o.DescriptionMd5) {
		var ret string
		return ret
	}
	return *o.DescriptionMd5
}

// GetDescriptionMd5Ok returns a tuple with the DescriptionMd5 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetDescriptionMd5Ok() (*string, bool) {
	if o == nil || IsNil(o.DescriptionMd5) {
		return nil, false
	}
	return o.DescriptionMd5, true
}

// HasDescriptionMd5 returns a boolean if a field has been set.
func (o *DebPackageResponse) HasDescriptionMd5() bool {
	if o != nil && !IsNil(o.DescriptionMd5) {
		return true
	}

	return false
}

// SetDescriptionMd5 gets a reference to the given string and assigns it to the DescriptionMd5 field.
func (o *DebPackageResponse) SetDescriptionMd5(v string) {
	o.DescriptionMd5 = &v
}

// GetHomepage returns the Homepage field value if set, zero value otherwise.
func (o *DebPackageResponse) GetHomepage() string {
	if o == nil || IsNil(o.Homepage) {
		var ret string
		return ret
	}
	return *o.Homepage
}

// GetHomepageOk returns a tuple with the Homepage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetHomepageOk() (*string, bool) {
	if o == nil || IsNil(o.Homepage) {
		return nil, false
	}
	return o.Homepage, true
}

// HasHomepage returns a boolean if a field has been set.
func (o *DebPackageResponse) HasHomepage() bool {
	if o != nil && !IsNil(o.Homepage) {
		return true
	}

	return false
}

// SetHomepage gets a reference to the given string and assigns it to the Homepage field.
func (o *DebPackageResponse) SetHomepage(v string) {
	o.Homepage = &v
}

// GetBuiltUsing returns the BuiltUsing field value if set, zero value otherwise.
func (o *DebPackageResponse) GetBuiltUsing() string {
	if o == nil || IsNil(o.BuiltUsing) {
		var ret string
		return ret
	}
	return *o.BuiltUsing
}

// GetBuiltUsingOk returns a tuple with the BuiltUsing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetBuiltUsingOk() (*string, bool) {
	if o == nil || IsNil(o.BuiltUsing) {
		return nil, false
	}
	return o.BuiltUsing, true
}

// HasBuiltUsing returns a boolean if a field has been set.
func (o *DebPackageResponse) HasBuiltUsing() bool {
	if o != nil && !IsNil(o.BuiltUsing) {
		return true
	}

	return false
}

// SetBuiltUsing gets a reference to the given string and assigns it to the BuiltUsing field.
func (o *DebPackageResponse) SetBuiltUsing(v string) {
	o.BuiltUsing = &v
}

// GetAutoBuiltPackage returns the AutoBuiltPackage field value if set, zero value otherwise.
func (o *DebPackageResponse) GetAutoBuiltPackage() string {
	if o == nil || IsNil(o.AutoBuiltPackage) {
		var ret string
		return ret
	}
	return *o.AutoBuiltPackage
}

// GetAutoBuiltPackageOk returns a tuple with the AutoBuiltPackage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetAutoBuiltPackageOk() (*string, bool) {
	if o == nil || IsNil(o.AutoBuiltPackage) {
		return nil, false
	}
	return o.AutoBuiltPackage, true
}

// HasAutoBuiltPackage returns a boolean if a field has been set.
func (o *DebPackageResponse) HasAutoBuiltPackage() bool {
	if o != nil && !IsNil(o.AutoBuiltPackage) {
		return true
	}

	return false
}

// SetAutoBuiltPackage gets a reference to the given string and assigns it to the AutoBuiltPackage field.
func (o *DebPackageResponse) SetAutoBuiltPackage(v string) {
	o.AutoBuiltPackage = &v
}

// GetMultiArch returns the MultiArch field value if set, zero value otherwise.
func (o *DebPackageResponse) GetMultiArch() string {
	if o == nil || IsNil(o.MultiArch) {
		var ret string
		return ret
	}
	return *o.MultiArch
}

// GetMultiArchOk returns a tuple with the MultiArch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetMultiArchOk() (*string, bool) {
	if o == nil || IsNil(o.MultiArch) {
		return nil, false
	}
	return o.MultiArch, true
}

// HasMultiArch returns a boolean if a field has been set.
func (o *DebPackageResponse) HasMultiArch() bool {
	if o != nil && !IsNil(o.MultiArch) {
		return true
	}

	return false
}

// SetMultiArch gets a reference to the given string and assigns it to the MultiArch field.
func (o *DebPackageResponse) SetMultiArch(v string) {
	o.MultiArch = &v
}

// GetBreaks returns the Breaks field value if set, zero value otherwise.
func (o *DebPackageResponse) GetBreaks() string {
	if o == nil || IsNil(o.Breaks) {
		var ret string
		return ret
	}
	return *o.Breaks
}

// GetBreaksOk returns a tuple with the Breaks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetBreaksOk() (*string, bool) {
	if o == nil || IsNil(o.Breaks) {
		return nil, false
	}
	return o.Breaks, true
}

// HasBreaks returns a boolean if a field has been set.
func (o *DebPackageResponse) HasBreaks() bool {
	if o != nil && !IsNil(o.Breaks) {
		return true
	}

	return false
}

// SetBreaks gets a reference to the given string and assigns it to the Breaks field.
func (o *DebPackageResponse) SetBreaks(v string) {
	o.Breaks = &v
}

// GetConflicts returns the Conflicts field value if set, zero value otherwise.
func (o *DebPackageResponse) GetConflicts() string {
	if o == nil || IsNil(o.Conflicts) {
		var ret string
		return ret
	}
	return *o.Conflicts
}

// GetConflictsOk returns a tuple with the Conflicts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetConflictsOk() (*string, bool) {
	if o == nil || IsNil(o.Conflicts) {
		return nil, false
	}
	return o.Conflicts, true
}

// HasConflicts returns a boolean if a field has been set.
func (o *DebPackageResponse) HasConflicts() bool {
	if o != nil && !IsNil(o.Conflicts) {
		return true
	}

	return false
}

// SetConflicts gets a reference to the given string and assigns it to the Conflicts field.
func (o *DebPackageResponse) SetConflicts(v string) {
	o.Conflicts = &v
}

// GetDepends returns the Depends field value if set, zero value otherwise.
func (o *DebPackageResponse) GetDepends() string {
	if o == nil || IsNil(o.Depends) {
		var ret string
		return ret
	}
	return *o.Depends
}

// GetDependsOk returns a tuple with the Depends field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetDependsOk() (*string, bool) {
	if o == nil || IsNil(o.Depends) {
		return nil, false
	}
	return o.Depends, true
}

// HasDepends returns a boolean if a field has been set.
func (o *DebPackageResponse) HasDepends() bool {
	if o != nil && !IsNil(o.Depends) {
		return true
	}

	return false
}

// SetDepends gets a reference to the given string and assigns it to the Depends field.
func (o *DebPackageResponse) SetDepends(v string) {
	o.Depends = &v
}

// GetRecommends returns the Recommends field value if set, zero value otherwise.
func (o *DebPackageResponse) GetRecommends() string {
	if o == nil || IsNil(o.Recommends) {
		var ret string
		return ret
	}
	return *o.Recommends
}

// GetRecommendsOk returns a tuple with the Recommends field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetRecommendsOk() (*string, bool) {
	if o == nil || IsNil(o.Recommends) {
		return nil, false
	}
	return o.Recommends, true
}

// HasRecommends returns a boolean if a field has been set.
func (o *DebPackageResponse) HasRecommends() bool {
	if o != nil && !IsNil(o.Recommends) {
		return true
	}

	return false
}

// SetRecommends gets a reference to the given string and assigns it to the Recommends field.
func (o *DebPackageResponse) SetRecommends(v string) {
	o.Recommends = &v
}

// GetSuggests returns the Suggests field value if set, zero value otherwise.
func (o *DebPackageResponse) GetSuggests() string {
	if o == nil || IsNil(o.Suggests) {
		var ret string
		return ret
	}
	return *o.Suggests
}

// GetSuggestsOk returns a tuple with the Suggests field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetSuggestsOk() (*string, bool) {
	if o == nil || IsNil(o.Suggests) {
		return nil, false
	}
	return o.Suggests, true
}

// HasSuggests returns a boolean if a field has been set.
func (o *DebPackageResponse) HasSuggests() bool {
	if o != nil && !IsNil(o.Suggests) {
		return true
	}

	return false
}

// SetSuggests gets a reference to the given string and assigns it to the Suggests field.
func (o *DebPackageResponse) SetSuggests(v string) {
	o.Suggests = &v
}

// GetEnhances returns the Enhances field value if set, zero value otherwise.
func (o *DebPackageResponse) GetEnhances() string {
	if o == nil || IsNil(o.Enhances) {
		var ret string
		return ret
	}
	return *o.Enhances
}

// GetEnhancesOk returns a tuple with the Enhances field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetEnhancesOk() (*string, bool) {
	if o == nil || IsNil(o.Enhances) {
		return nil, false
	}
	return o.Enhances, true
}

// HasEnhances returns a boolean if a field has been set.
func (o *DebPackageResponse) HasEnhances() bool {
	if o != nil && !IsNil(o.Enhances) {
		return true
	}

	return false
}

// SetEnhances gets a reference to the given string and assigns it to the Enhances field.
func (o *DebPackageResponse) SetEnhances(v string) {
	o.Enhances = &v
}

// GetPreDepends returns the PreDepends field value if set, zero value otherwise.
func (o *DebPackageResponse) GetPreDepends() string {
	if o == nil || IsNil(o.PreDepends) {
		var ret string
		return ret
	}
	return *o.PreDepends
}

// GetPreDependsOk returns a tuple with the PreDepends field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetPreDependsOk() (*string, bool) {
	if o == nil || IsNil(o.PreDepends) {
		return nil, false
	}
	return o.PreDepends, true
}

// HasPreDepends returns a boolean if a field has been set.
func (o *DebPackageResponse) HasPreDepends() bool {
	if o != nil && !IsNil(o.PreDepends) {
		return true
	}

	return false
}

// SetPreDepends gets a reference to the given string and assigns it to the PreDepends field.
func (o *DebPackageResponse) SetPreDepends(v string) {
	o.PreDepends = &v
}

// GetProvides returns the Provides field value if set, zero value otherwise.
func (o *DebPackageResponse) GetProvides() string {
	if o == nil || IsNil(o.Provides) {
		var ret string
		return ret
	}
	return *o.Provides
}

// GetProvidesOk returns a tuple with the Provides field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetProvidesOk() (*string, bool) {
	if o == nil || IsNil(o.Provides) {
		return nil, false
	}
	return o.Provides, true
}

// HasProvides returns a boolean if a field has been set.
func (o *DebPackageResponse) HasProvides() bool {
	if o != nil && !IsNil(o.Provides) {
		return true
	}

	return false
}

// SetProvides gets a reference to the given string and assigns it to the Provides field.
func (o *DebPackageResponse) SetProvides(v string) {
	o.Provides = &v
}

// GetReplaces returns the Replaces field value if set, zero value otherwise.
func (o *DebPackageResponse) GetReplaces() string {
	if o == nil || IsNil(o.Replaces) {
		var ret string
		return ret
	}
	return *o.Replaces
}

// GetReplacesOk returns a tuple with the Replaces field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DebPackageResponse) GetReplacesOk() (*string, bool) {
	if o == nil || IsNil(o.Replaces) {
		return nil, false
	}
	return o.Replaces, true
}

// HasReplaces returns a boolean if a field has been set.
func (o *DebPackageResponse) HasReplaces() bool {
	if o != nil && !IsNil(o.Replaces) {
		return true
	}

	return false
}

// SetReplaces gets a reference to the given string and assigns it to the Replaces field.
func (o *DebPackageResponse) SetReplaces(v string) {
	o.Replaces = &v
}

func (o DebPackageResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DebPackageResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.RelativePath) {
		toSerialize["relative_path"] = o.RelativePath
	}
	if !IsNil(o.Distribution) {
		toSerialize["distribution"] = o.Distribution
	}
	if !IsNil(o.Component) {
		toSerialize["component"] = o.Component
	}
	if !IsNil(o.Md5) {
		toSerialize["md5"] = o.Md5
	}
	if !IsNil(o.Sha1) {
		toSerialize["sha1"] = o.Sha1
	}
	if !IsNil(o.Sha224) {
		toSerialize["sha224"] = o.Sha224
	}
	if !IsNil(o.Sha256) {
		toSerialize["sha256"] = o.Sha256
	}
	if !IsNil(o.Sha384) {
		toSerialize["sha384"] = o.Sha384
	}
	if !IsNil(o.Sha512) {
		toSerialize["sha512"] = o.Sha512
	}
	if !IsNil(o.Package) {
		toSerialize["package"] = o.Package
	}
	if !IsNil(o.Source) {
		toSerialize["source"] = o.Source
	}
	if !IsNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !IsNil(o.Architecture) {
		toSerialize["architecture"] = o.Architecture
	}
	if !IsNil(o.Section) {
		toSerialize["section"] = o.Section
	}
	if !IsNil(o.Priority) {
		toSerialize["priority"] = o.Priority
	}
	if !IsNil(o.Origin) {
		toSerialize["origin"] = o.Origin
	}
	if !IsNil(o.Tag) {
		toSerialize["tag"] = o.Tag
	}
	if !IsNil(o.Bugs) {
		toSerialize["bugs"] = o.Bugs
	}
	if !IsNil(o.Essential) {
		toSerialize["essential"] = o.Essential
	}
	if !IsNil(o.BuildEssential) {
		toSerialize["build_essential"] = o.BuildEssential
	}
	if !IsNil(o.InstalledSize) {
		toSerialize["installed_size"] = o.InstalledSize
	}
	if !IsNil(o.Maintainer) {
		toSerialize["maintainer"] = o.Maintainer
	}
	if !IsNil(o.OriginalMaintainer) {
		toSerialize["original_maintainer"] = o.OriginalMaintainer
	}
	if !IsNil(o.Description) {
		toSerialize["description"] = o.Description
	}
	if !IsNil(o.DescriptionMd5) {
		toSerialize["description_md5"] = o.DescriptionMd5
	}
	if !IsNil(o.Homepage) {
		toSerialize["homepage"] = o.Homepage
	}
	if !IsNil(o.BuiltUsing) {
		toSerialize["built_using"] = o.BuiltUsing
	}
	if !IsNil(o.AutoBuiltPackage) {
		toSerialize["auto_built_package"] = o.AutoBuiltPackage
	}
	if !IsNil(o.MultiArch) {
		toSerialize["multi_arch"] = o.MultiArch
	}
	if !IsNil(o.Breaks) {
		toSerialize["breaks"] = o.Breaks
	}
	if !IsNil(o.Conflicts) {
		toSerialize["conflicts"] = o.Conflicts
	}
	if !IsNil(o.Depends) {
		toSerialize["depends"] = o.Depends
	}
	if !IsNil(o.Recommends) {
		toSerialize["recommends"] = o.Recommends
	}
	if !IsNil(o.Suggests) {
		toSerialize["suggests"] = o.Suggests
	}
	if !IsNil(o.Enhances) {
		toSerialize["enhances"] = o.Enhances
	}
	if !IsNil(o.PreDepends) {
		toSerialize["pre_depends"] = o.PreDepends
	}
	if !IsNil(o.Provides) {
		toSerialize["provides"] = o.Provides
	}
	if !IsNil(o.Replaces) {
		toSerialize["replaces"] = o.Replaces
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *DebPackageResponse) UnmarshalJSON(bytes []byte) (err error) {
	varDebPackageResponse := _DebPackageResponse{}

	if err = json.Unmarshal(bytes, &varDebPackageResponse); err == nil {
		*o = DebPackageResponse(varDebPackageResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "relative_path")
		delete(additionalProperties, "distribution")
		delete(additionalProperties, "component")
		delete(additionalProperties, "md5")
		delete(additionalProperties, "sha1")
		delete(additionalProperties, "sha224")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "sha384")
		delete(additionalProperties, "sha512")
		delete(additionalProperties, "package")
		delete(additionalProperties, "source")
		delete(additionalProperties, "version")
		delete(additionalProperties, "architecture")
		delete(additionalProperties, "section")
		delete(additionalProperties, "priority")
		delete(additionalProperties, "origin")
		delete(additionalProperties, "tag")
		delete(additionalProperties, "bugs")
		delete(additionalProperties, "essential")
		delete(additionalProperties, "build_essential")
		delete(additionalProperties, "installed_size")
		delete(additionalProperties, "maintainer")
		delete(additionalProperties, "original_maintainer")
		delete(additionalProperties, "description")
		delete(additionalProperties, "description_md5")
		delete(additionalProperties, "homepage")
		delete(additionalProperties, "built_using")
		delete(additionalProperties, "auto_built_package")
		delete(additionalProperties, "multi_arch")
		delete(additionalProperties, "breaks")
		delete(additionalProperties, "conflicts")
		delete(additionalProperties, "depends")
		delete(additionalProperties, "recommends")
		delete(additionalProperties, "suggests")
		delete(additionalProperties, "enhances")
		delete(additionalProperties, "pre_depends")
		delete(additionalProperties, "provides")
		delete(additionalProperties, "replaces")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableDebPackageResponse struct {
	value *DebPackageResponse
	isSet bool
}

func (v NullableDebPackageResponse) Get() *DebPackageResponse {
	return v.value
}

func (v *NullableDebPackageResponse) Set(val *DebPackageResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDebPackageResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDebPackageResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDebPackageResponse(val *DebPackageResponse) *NullableDebPackageResponse {
	return &NullableDebPackageResponse{value: val, isSet: true}
}

func (v NullableDebPackageResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDebPackageResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


