/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.security.SigningUnit;
import com.netscape.cms.servlet.admin.CMSAdminServlet;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.ocsp.OCSPAuthority;
import org.dogtagpki.server.ocsp.OCSPEngine;

public class OCSPCMSAdminServlet
extends CMSAdminServlet {
    public boolean isSubsystemInstalled(String subsystem) {
        return subsystem.equals("ocsp");
    }

    void readSubsystem(NameValuePairs params) {
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem("ocsp");
        params.put((Object)ocsp.getId(), (Object)"ocsp");
    }

    String getOCSPNickname() {
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem("ocsp");
        SigningUnit signingUnit = ocsp.getSigningUnit();
        return signingUnit.getNickname();
    }

    String getOCSPNewnickname() throws EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem("ocsp");
        SigningUnit signingUnit = ocsp.getSigningUnit();
        return signingUnit.getNewNickName();
    }

    void setOCSPNewnickname(String tokenName, String nickname) throws EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem("ocsp");
        SigningUnit signingUnit = ocsp.getSigningUnit();
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            signingUnit.setNewNickName(nickname);
        } else if (tokenName.equals("") && nickname.equals("")) {
            signingUnit.setNewNickName("");
        } else {
            signingUnit.setNewNickName(tokenName + ":" + nickname);
        }
    }

    public void installOCSPSigningCert(String fullName, String nickname, String tokenName) throws EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        OCSPAuthority ocsp = (OCSPAuthority)engine.getSubsystem("ocsp");
        this.setOCSPNewnickname("", "");
        SigningUnit signingUnit = ocsp.getSigningUnit();
        if (fullName.equals(nickname)) {
            signingUnit.updateConfig(fullName, "internal");
        } else {
            signingUnit.updateConfig(fullName, tokenName);
        }
    }
}

