/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools;

import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.security.KeyPair;
import org.dogtag.util.cert.CertUtil;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class PKCS10Client {
    private static void printUsage() {
        System.out.println("\nUsage: PKCS10Client -d <location of certdb> -h <token name> -P <token password file> -a <algorithm: 'rsa' or 'ec'> -l <rsa key length> -c <ec curve name> -o <output file which saves the base64 PKCS10> -n <subjectDN>\n");
        System.out.println("    Optionally, for ECC key generation per definition in JSS pkcs11.PK11KeyPairGenerator:\n");
        System.out.println("    -k <true for enabling encoding of attribute values; false for default encoding of attribute values; default is false>\n");
        System.out.println("    -t <true for temporary(session); false for permanent(token); default is false>\n");
        System.out.println("    -s <1 for sensitive; 0 for non-sensitive; -1 temporaryPairMode dependent; default is -1>\n");
        System.out.println("    -e <1 for extractable; 0 for non-extractable; -1 token dependent; default is -1>\n");
        System.out.println("    Also optional for ECC key generation:\n");
        System.out.println("    -x <true for SSL cert that does ECDH ECDSA; false otherwise; default false>\n");
        System.out.println("   available ECC curve names (if provided by the crypto module): nistp256 (secp256r1),nistp384 (secp384r1),nistp521 (secp521r1),nistk163 (sect163k1),sect163r1,nistb163 (sect163r2),sect193r1,sect193r2,nistk233 (sect233k1),nistb233 (sect233r1),sect239k1,nistk283 (sect283k1),nistb283 (sect283r1),nistk409 (sect409k1),nistb409 (sect409r1),nistk571 (sect571k1),nistb571 (sect571r1),secp160k1,secp160r1,secp160r2,secp192k1,nistp192 (secp192r1, prime192v1),secp224k1,nistp224 (secp224r1),secp256k1,prime192v2,prime192v3,prime239v1,prime239v2,prime239v3,c2pnb163v1,c2pnb163v2,c2pnb163v3,c2pnb176v1,c2tnb191v1,c2tnb191v2,c2tnb191v3,c2pnb208w1,c2tnb239v1,c2tnb239v2,c2tnb239v3,c2pnb272w1,c2pnb304w1,c2tnb359w1,c2pnb368w1,c2tnb431r1,secp112r1,secp112r2,secp128r1,secp128r2,sect113r1,sect113r2,sect131r1,sect131r2\n");
        System.out.println("    -v Verbose mode\n");
        System.out.println("    -w geneate RSA keypair with keyOpFlags for doing wrap/unwrap\n");
        System.out.println("In addition: -y <true for adding SubjectKeyIdentifier extensionfor CMC SharedSecret requests; false otherwise; default false> To be used with 'request.useSharedSecret=true' when running CMCRequest.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        dbdir = null;
        ofilename = null;
        kid_ofilename = null;
        password = null;
        subjectName = null;
        tokenName = null;
        passwordFile = null;
        alg = "rsa";
        ecc_curve = "nistp256";
        ec_temporary = false;
        enable_encoding = false;
        verbose = false;
        ec_sensitive = -1;
        ec_extractable = -1;
        ec_ssl_ecdh = false;
        rsa_keygen_wrap_unwrap_ops = false;
        rsa_keylen = 2048;
        use_shared_secret = false;
        if (args.length < 4) {
            PKCS10Client.printUsage();
            System.exit(1);
        }
        for (i = 0; i < args.length; i += 2) {
            name = args[i];
            if (name.equals("-p")) {
                password = args[i + 1];
                continue;
            }
            if (name.equals("-P")) {
                passwordFile = args[i + 1];
                continue;
            }
            if (name.equals("-d")) {
                dbdir = args[i + 1];
                continue;
            }
            if (name.equals("-a")) {
                alg = args[i + 1];
                if (alg.equals("rsa") || alg.equals("ec")) continue;
                System.out.println("PKCS10Client: ERROR: invalid algorithm: " + alg);
                System.exit(1);
                continue;
            }
            if (name.equals("-x")) {
                temp = args[i + 1];
                if (temp.equals("true")) {
                    ec_ssl_ecdh = true;
                    continue;
                }
                ec_ssl_ecdh = false;
                continue;
            }
            if (name.equals("-w")) {
                rsa_keygen_wrap_unwrap_ops = true;
                --i;
                continue;
            }
            if (name.equals("-t")) {
                temp = args[i + 1];
                if (temp.equals("true")) {
                    ec_temporary = true;
                    continue;
                }
                ec_temporary = false;
                continue;
            }
            if (name.equals("-k")) {
                temp = args[i + 1];
                enable_encoding = temp.equals("true") != false;
                System.out.println("PKCS10Client: enable_encoding =" + enable_encoding);
                continue;
            }
            if (name.equals("-s")) {
                ec_sensitive_s = args[i + 1];
                ec_sensitive = Integer.parseInt(ec_sensitive_s);
                if (ec_sensitive == 0 || ec_sensitive == 1 || ec_sensitive == -1) continue;
                System.out.println("PKCS10Client: Illegal input parameters for -s.");
                PKCS10Client.printUsage();
                System.exit(1);
                continue;
            }
            if (name.equals("-e")) {
                ec_extractable_s = args[i + 1];
                ec_extractable = Integer.parseInt(ec_extractable_s);
                if (ec_extractable == 0 || ec_extractable == 1 || ec_extractable == -1) continue;
                System.out.println("PKCS10Client: Illegal input parameters for -e.");
                PKCS10Client.printUsage();
                System.exit(1);
                continue;
            }
            if (name.equals("-c")) {
                ecc_curve = args[i + 1];
                continue;
            }
            if (name.equals("-l")) {
                rsa_keylen = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (name.equals("-o")) {
                ofilename = args[i + 1];
                kid_ofilename = ofilename + ".keyId";
                continue;
            }
            if (name.equals("-n")) {
                subjectName = args[i + 1];
                continue;
            }
            if (name.equals("-h")) {
                tokenName = args[i + 1];
                continue;
            }
            if (name.equals("-y")) {
                temp = args[i + 1];
                if (temp.equals("true")) {
                    use_shared_secret = true;
                    continue;
                }
                use_shared_secret = false;
                continue;
            }
            if (name.equals("-v")) {
                verbose = true;
                --i;
                continue;
            }
            System.out.println("Unrecognized argument(" + i + "): " + name);
            PKCS10Client.printUsage();
            System.exit(1);
        }
        if (ofilename == null || subjectName == null) {
            System.out.println("PKCS10Client: Illegal input parameters.");
            PKCS10Client.printUsage();
            System.exit(1);
        }
        if (password != null && passwordFile != null) {
            System.out.println("PKCS10Client: '-p' and '-P' cannot be both specified.");
            PKCS10Client.printUsage();
            System.exit(1);
        }
        if (dbdir == null) {
            dbdir = ".";
        }
        try {
            mPrefix = "";
            vals = new InitializationValues(dbdir, mPrefix, mPrefix, "secmod.db");
            CryptoManager.initialize((InitializationValues)vals);
            cm = CryptoManager.getInstance();
            token = CryptoUtil.getKeyStorageToken(tokenName);
            tokenName = token.getName();
            if (verbose) {
                System.out.println("PKCS10Client: Debug: got token.");
            }
            cm.setThreadToken(token);
            if (verbose) {
                System.out.println("PKCS10Client: Debug: thread token set.");
            }
            if (passwordFile != null) {
                in = new BufferedReader(new FileReader(passwordFile));
                try {
                    line = in.readLine();
                    if (line == null) {
                        line = "";
                    }
                }
                finally {
                    in.close();
                }
                pass = new Password(line.toCharArray());
                try {
                    token.login((PasswordCallback)pass);
                    if (!verbose) ** GOTO lbl161
                    System.out.println("PKCS10Client: token " + tokenName + " logged in...");
                }
                finally {
                    pass.clear();
                }
            } else if (password != null) {
                pass = new Password(password.toCharArray());
                try {
                    token.login((PasswordCallback)pass);
                    if (verbose) {
                        System.out.println("PKCS10Client: token " + tokenName + " logged in...");
                    }
                }
                finally {
                    pass.clear();
                }
            }
            pair = null;
            if (alg.equals("rsa")) {
                if (verbose) {
                    System.out.println("PKCS10Client: rsa_keygen_wrap_unwrap_ops: " + rsa_keygen_wrap_unwrap_ops);
                }
                usages = rsa_keygen_wrap_unwrap_ops != false ? CryptoUtil.RSA_KEYPAIR_USAGES : null;
                usagesMask = rsa_keygen_wrap_unwrap_ops != false ? CryptoUtil.RSA_KEYPAIR_USAGES_MASK : null;
                pair = CryptoUtil.generateRSAKeyPair((CryptoToken)token, (int)rsa_keylen, (KeyPairGeneratorSpi.Usage[])usages, (KeyPairGeneratorSpi.Usage[])usagesMask);
            } else if (alg.equals("ec") && (pair = CryptoUtil.generateECCKeyPair((CryptoToken)token, (String)ecc_curve, (boolean)ec_temporary, (int)ec_sensitive, (int)ec_extractable, (KeyPairGeneratorSpi.Usage[])(usages = null), (KeyPairGeneratorSpi.Usage[])(usagesMask = ec_ssl_ecdh != false ? CryptoUtil.ECDH_USAGES_MASK : CryptoUtil.ECDHE_USAGES_MASK))) == null) {
                System.out.println("PKCS10Client: pair null.");
                System.exit(1);
            }
            if (verbose) {
                System.out.println("PKCS10Client: key pair generated.");
            }
            extns = new Extensions();
            if (use_shared_secret) {
                if (verbose) {
                    System.out.println("PKCS10Client: use_shared_secret true. Generating SubjectKeyIdentifier extension.");
                }
                subjKeyId = CryptoUtil.createKeyIdentifier((KeyPair)pair);
                extn = new SubjectKeyIdentifierExtension(false, subjKeyId.getIdentifier());
                extns.add((Object)extn);
            }
            certReq = CryptoUtil.createCertificationRequest(subjectName, (boolean)enable_encoding, (KeyPair)pair, (Extensions)extns);
            if (verbose) {
                System.out.println("PKCS10Client: Certificate request created");
            }
            privateKey = (PrivateKey)pair.getPrivate();
            id = privateKey.getUniqueID();
            kid = CryptoUtil.encodeKeyID((byte[])id);
            if (verbose) {
                System.out.println("Keypair private key id: " + kid);
                System.out.println("");
            }
            pem = CertUtil.toPEM((PKCS10)certReq);
            fos = new FileOutputStream(ofilename);
            try {
                ps = new PrintStream(fos);
                try {
                    ps.print(pem);
                }
                finally {
                    ps.close();
                }
            }
            finally {
                fos.close();
            }
            System.out.println("PKCS10Client: Certificate request written into " + ofilename);
            out_kid = new FileWriter(kid_ofilename);
            try {
                out_kid.write(kid);
            }
            finally {
                out_kid.close();
            }
            System.out.println("PKCS10Client: PKCS#10 request key id written into " + kid_ofilename);
        }
        catch (Exception e) {
            System.out.println("PKCS10Client: Exception caught: " + e);
            System.exit(1);
        }
    }
}

