/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.cli;

import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.acme.ACMECLI;
import com.netscape.cmstools.ca.CACLI;
import com.netscape.cmstools.cli.HelpCLI;
import com.netscape.cmstools.cli.InfoCLI;
import com.netscape.cmstools.cli.ProxyCLI;
import com.netscape.cmstools.client.ClientCLI;
import com.netscape.cmstools.kra.KRACLI;
import com.netscape.cmstools.nss.NSSCLI;
import com.netscape.cmstools.ocsp.OCSPCLI;
import com.netscape.cmstools.pkcs11.PKCS11CLI;
import com.netscape.cmstools.pkcs12.PKCS12CLI;
import com.netscape.cmstools.pkcs7.PKCS7CLI;
import com.netscape.cmstools.system.SecurityDomainCLI;
import com.netscape.cmstools.tks.TKSCLI;
import com.netscape.cmstools.tps.TPSCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PlainPasswordFile;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.common.Info;
import org.dogtagpki.nss.NSSDatabase;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class MainCLI
extends CLI {
    public ClientConfig config = new ClientConfig();
    NSSDatabase nssdb;
    public Collection<Integer> rejectedCertStatuses = new HashSet<Integer>();
    public Collection<Integer> ignoredCertStatuses = new HashSet<Integer>();
    public boolean ignoreBanner;
    String output;
    boolean initialized;
    boolean optionsParsed;

    public MainCLI() throws Exception {
        super("pki", "PKI command-line interface");
        this.addModule((CLI)new HelpCLI(this));
        this.addModule(new ClientCLI(this));
        this.addModule(new NSSCLI(this));
        this.addModule((CLI)new InfoCLI(this));
        this.addModule(new ProxyCLI(new SecurityDomainCLI(this), "ca"));
        this.addModule(new ACMECLI(this));
        this.addModule(new CACLI(this));
        this.addModule(new KRACLI(this));
        this.addModule(new OCSPCLI(this));
        this.addModule(new TKSCLI(this));
        this.addModule(new TPSCLI(this));
        this.addModule(new PKCS7CLI(this));
        this.addModule(new PKCS11CLI(this));
        this.addModule(new PKCS12CLI(this));
        this.createOptions();
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public NSSDatabase getNSSDatabase() {
        return this.nssdb;
    }

    public String getFullModuleName(String moduleName) {
        return moduleName;
    }

    public String getManPage() {
        return "pki";
    }

    public void printVersion() {
        Package pkg = MainCLI.class.getPackage();
        System.out.println("PKI Command-Line Interface " + pkg.getImplementationVersion());
    }

    public void printHelp() throws Exception {
        formatter.printHelp(this.name + " [OPTIONS..] <command> [ARGS..]", this.options);
        System.out.println();
        super.printHelp();
    }

    public void createOptions() throws UnknownHostException {
        Option option = new Option("U", true, "Server URL");
        option.setArgName("uri");
        this.options.addOption(option);
        option = new Option("P", true, "Protocol (default: https)");
        option.setArgName("protocol");
        this.options.addOption(option);
        option = new Option("h", true, "Hostname (default: " + InetAddress.getLocalHost().getCanonicalHostName() + ")");
        option.setArgName("hostname");
        this.options.addOption(option);
        option = new Option("p", true, "Port (default: 8443)");
        option.setArgName("port");
        this.options.addOption(option);
        option = new Option("t", true, "Subsystem type (deprecated)");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option("d", true, "NSS database location (default: ~/.dogtag/nssdb)");
        option.setArgName("database");
        this.options.addOption(option);
        option = new Option("c", true, "NSS database password (mutually exclusive to -C and -f options)");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option("C", true, "NSS database password file (mutually exclusive to -c and -f options)");
        option.setArgName("password file");
        this.options.addOption(option);
        option = new Option("f", true, "NSS database password configuration (mutually exclusive to -c and -C options)");
        option.setArgName("password config");
        this.options.addOption(option);
        option = new Option("n", true, "Nickname for client certificate authentication (mutually exclusive to -u option)");
        option.setArgName("nickname");
        this.options.addOption(option);
        option = new Option("u", true, "Username for basic authentication (mutually exclusive to -n option)");
        option.setArgName("username");
        this.options.addOption(option);
        option = new Option("w", true, "Password for basic authentication (mutually exclusive to -W option)");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option("W", true, "Password file for basic authentication (mutually exclusive to -w option)");
        option.setArgName("passwordfile");
        this.options.addOption(option);
        option = new Option(null, "token", true, "Security token name");
        option.setArgName("token");
        this.options.addOption(option);
        option = new Option(null, "output", true, "Folder to store HTTP messages");
        option.setArgName("folder");
        this.options.addOption(option);
        option = new Option(null, "reject-cert-status", true, "Comma-separated list of rejected certificate validity statuses");
        option.setArgName("list");
        this.options.addOption(option);
        option = new Option(null, "ignore-cert-status", true, "Comma-separated list of ignored certificate validity statuses");
        option.setArgName("list");
        this.options.addOption(option);
        option = new Option(null, "ignore-banner", false, "Ignore access banner");
        this.options.addOption(option);
        option = new Option(null, "message-format", true, "Message format: xml (default), json");
        option.setArgName("format");
        this.options.addOption(option);
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
        this.options.addOption(null, "version", false, "Show version number.");
    }

    public String loadPassword(String path) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String string = br.readLine();
            return string;
        }
    }

    public Map<String, String> loadPasswordConfig(String filename) throws Exception {
        LinkedHashMap<String, String> passwords = new LinkedHashMap<String, String>();
        List<String> list = Files.readAllLines(Paths.get(filename, new String[0]));
        String[] lines = list.toArray(new String[list.size()]);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            int p = line.indexOf("=");
            if (p < 0) {
                throw new Exception("Missing delimiter in " + filename + ":" + (i + 1));
            }
            String name = line.substring(0, p).trim();
            String password = line.substring(p + 1).trim();
            if (name.equals("internal")) {
                logger.info("- internal: ********");
                passwords.put(name, password);
                continue;
            }
            if (name.startsWith("hardware-")) {
                name = name.substring(9);
                logger.info("- " + name + ": ********");
                passwords.put(name, password);
                continue;
            }
            logger.debug("- " + name + ": ******** (not token)");
        }
        return passwords;
    }

    public String promptForPassword(String prompt) throws IOException {
        char[] password = null;
        Console console = System.console();
        System.out.print(prompt);
        password = console.readPassword();
        return new String(password);
    }

    public String promptForPassword() throws IOException {
        return this.promptForPassword("Enter Password: ");
    }

    public static CAClient createCAClient(PKIClient client) throws Exception {
        ClientConfig config = client.getConfig();
        CAClient caClient = new CAClient(client);
        while (!caClient.exists()) {
            System.err.println("Error: CA subsystem not available");
            URL serverURI = config.getServerURL();
            Object uri = serverURI.getProtocol() + "://" + serverURI.getHost() + ":" + serverURI.getPort();
            System.out.print("CA server URL [" + (String)uri + "]: ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine().trim();
            if (!line.equals("")) {
                uri = line;
            }
            config = new ClientConfig(client.getConfig());
            config.setServerURL((String)uri);
            client = new PKIClient(config);
            caClient = new CAClient(client);
        }
        return caClient;
    }

    public void parseOptions(CommandLine cmd) throws Exception {
        if (cmd.hasOption("debug")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
        } else if (cmd.hasOption("verbose")) {
            PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
        }
        this.output = cmd.getOptionValue("output");
        Object url = cmd.getOptionValue("U");
        String protocol = cmd.getOptionValue("P", "https");
        String hostname = cmd.getOptionValue("h", InetAddress.getLocalHost().getCanonicalHostName());
        String port = cmd.getOptionValue("p", "8443");
        String subsystem = cmd.getOptionValue("t");
        if (url == null) {
            url = protocol + "://" + hostname + ":" + port;
        }
        if (subsystem != null) {
            logger.warn("The -t option has been deprecated. Use pki " + subsystem + " command instead.");
            url = (String)url + "/" + subsystem;
        }
        this.config.setServerURL((String)url);
        logger.info("Server URL: " + (String)url);
        String nssDatabase = cmd.getOptionValue("d");
        String nssPassword = cmd.getOptionValue("c");
        String nssPasswordFile = cmd.getOptionValue("C");
        String nssPasswordConfig = cmd.getOptionValue("f");
        String tokenName = cmd.getOptionValue("token");
        String certNickname = cmd.getOptionValue("n");
        String username = cmd.getOptionValue("u");
        String password = cmd.getOptionValue("w");
        String passwordFile = cmd.getOptionValue("W");
        int nssPasswordCounter = 0;
        if (nssPassword != null) {
            ++nssPasswordCounter;
        }
        if (nssPasswordFile != null) {
            ++nssPasswordCounter;
        }
        if (nssPasswordConfig != null) {
            ++nssPasswordCounter;
        }
        if (nssPasswordCounter > 1) {
            throw new Exception("The -c, -C, -f options are mutually exclusive.");
        }
        if (certNickname != null && username != null) {
            throw new Exception("The -n and -u options are mutually exclusive.");
        }
        if (username != null && password != null && passwordFile != null) {
            throw new Exception("The -w and -W options are mutually exclusive.");
        }
        if (nssDatabase != null) {
            this.config.setNSSDatabase(new File(nssDatabase).getAbsolutePath());
        } else {
            this.config.setNSSDatabase(System.getProperty("user.home") + File.separator + ".dogtag" + File.separator + "nssdb");
        }
        this.config.setTokenName(tokenName);
        this.config.setCertNickname(certNickname);
        if (nssPassword != null) {
            this.config.setNSSPassword(nssPassword);
        } else if (nssPasswordFile != null) {
            logger.info("Loading NSS password from " + nssPasswordFile);
            nssPassword = this.loadPassword(nssPasswordFile);
            this.config.setNSSPassword(nssPassword);
        } else if (nssPasswordConfig != null) {
            logger.info("Loading NSS password configuration from " + nssPasswordConfig);
            Map<String, String> nssPasswords = this.loadPasswordConfig(nssPasswordConfig);
            this.config.setNSSPasswords(nssPasswords);
        }
        PlainPasswordFile passwordStore = new PlainPasswordFile();
        if (nssPassword != null) {
            String token = tokenName;
            if (token == null) {
                token = "internal";
            }
            passwordStore.putPassword(token, nssPassword);
        } else if (nssPasswordConfig != null) {
            passwordStore.init(nssPasswordConfig);
        }
        logger.info("NSS database: " + this.config.getNSSDatabase());
        this.nssdb = new NSSDatabase(this.config.getNSSDatabase());
        this.nssdb.setPasswordStore((PasswordStore)passwordStore);
        this.config.setUsername(username);
        if (passwordFile != null) {
            logger.info("Loading user password from " + passwordFile);
            password = this.loadPassword(passwordFile);
        } else if (username != null && password == null) {
            password = this.promptForPassword();
        }
        this.config.setPassword(password);
        String list = cmd.getOptionValue("reject-cert-status");
        this.convertCertStatusList(list, this.rejectedCertStatuses);
        list = cmd.getOptionValue("ignore-cert-status");
        this.convertCertStatusList(list, this.ignoredCertStatuses);
        this.ignoreBanner = cmd.hasOption("ignore-banner");
        String messageFormat = cmd.getOptionValue("message-format");
        this.config.setMessageFormat(messageFormat);
        logger.info("Message format: " + messageFormat);
        this.optionsParsed = true;
    }

    public void convertCertStatusList(String list, Collection<Integer> statuses) throws Exception {
        if (list == null) {
            return;
        }
        Class<SSLCertificateApprovalCallback.ValidityStatus> clazz = SSLCertificateApprovalCallback.ValidityStatus.class;
        for (String status : list.split(",")) {
            try {
                Field field = clazz.getField(status);
                statuses.add(field.getInt(null));
            }
            catch (NoSuchFieldException e) {
                throw new Exception("Invalid cert status \"" + status + "\".", e);
            }
        }
    }

    public void init() throws Exception {
        CryptoToken token;
        String tokenName;
        CryptoManager manager;
        if (this.initialized) {
            return;
        }
        if (!this.optionsParsed) {
            throw new Exception("Unable to call MainCLI.init() without first calling MainCLI.parseOptions()");
        }
        if (!this.nssdb.exists()) {
            if (this.config.getNSSPassword() != null) {
                this.nssdb.create(this.config.getNSSPassword());
            } else {
                this.nssdb.create();
            }
        }
        logger.info("Initializing NSS");
        CryptoManager.initialize((String)this.nssdb.getPath().toString());
        try {
            manager = CryptoManager.getInstance();
        }
        catch (NotInitializedException e) {
            throw new Exception("NSS has not been initialized", e);
        }
        if (this.config.getNSSPassword() != null) {
            tokenName = this.config.getTokenName();
            tokenName = tokenName == null ? "internal" : tokenName;
            logger.info("Logging into " + tokenName + " token");
            token = CryptoUtil.getKeyStorageToken((String)tokenName);
            Password password = new Password(this.config.getNSSPassword().toCharArray());
            try {
                token.login((PasswordCallback)password);
            }
            catch (IncorrectPasswordException e) {
                throw new Exception("Incorrect password for " + tokenName + " token", e);
            }
            finally {
                password.clear();
            }
        } else {
            Map passwords = this.config.getNSSPasswords();
            for (String tokenName2 : passwords.keySet()) {
                logger.info("Logging into " + tokenName2 + " token");
                CryptoToken token2 = CryptoUtil.getKeyStorageToken((String)tokenName2);
                Password password = new Password(((String)passwords.get(tokenName2)).toCharArray());
                try {
                    token2.login((PasswordCallback)password);
                }
                catch (IncorrectPasswordException e) {
                    throw new Exception("Incorrect password for " + tokenName2 + " token", e);
                }
                finally {
                    password.clear();
                }
            }
        }
        tokenName = (tokenName = this.config.getTokenName()) == null ? "internal" : tokenName;
        logger.info("Using " + tokenName + " token");
        token = CryptoUtil.getKeyStorageToken((String)tokenName);
        manager.setThreadToken(token);
        SSLSocket.enablePostHandshakeAuthDefault((boolean)true);
        this.initialized = true;
    }

    public PKIClient getClient() throws Exception {
        if (this.client != null) {
            return this.client;
        }
        logger.info("Connecting to " + this.config.getServerURL());
        this.client = new PKIClient(this.config);
        this.client.setRejectedCertStatuses(this.rejectedCertStatuses);
        this.client.setIgnoredCertStatuses(this.ignoredCertStatuses);
        if (this.output != null) {
            File file = new File(this.output);
            file.mkdirs();
            this.client.setOutput(file);
        }
        try {
            Info info = this.client.getInfo();
            logger.info("Server Name: " + info.getName());
            logger.info("Server Version: " + info.getVersion());
            String banner = info.getBanner();
            if (banner != null && !this.ignoreBanner) {
                System.err.print("%s\n\nDo you want to proceed (y/N)? ".formatted(banner));
                System.err.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String line = reader.readLine().trim();
                if (!line.equalsIgnoreCase("Y")) {
                    throw new CLIException();
                }
            }
        }
        catch (PKIException e) {
            if (e.getCode() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw e;
            }
            logger.warn("Unable to get server info: " + e.getMessage());
        }
        return this.client;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(String[] args) throws Exception {
        CommandLine cmd = parser.parse(this.options, args, true);
        String[] cmdArgs = cmd.getArgs();
        if (cmd.hasOption("version")) {
            this.printVersion();
            return;
        }
        if (cmdArgs.length == 0 || cmd.hasOption("help")) {
            this.printHelp();
            return;
        }
        this.parseOptions(cmd);
        if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Command:");
            for (String string : cmdArgs) {
                void var8_8;
                if (string.contains(" ")) {
                    String string2 = "\"" + string + "\"";
                }
                sb.append(" ");
                sb.append((String)var8_8);
            }
            logger.info(sb.toString());
        }
        super.execute(cmdArgs);
    }

    public static void printMessage(String message) {
        System.out.println(StringUtils.repeat((String)"-", (int)message.length()));
        System.out.println(message);
        System.out.println(StringUtils.repeat((String)"-", (int)message.length()));
    }

    public static void handleException(Throwable t) {
        if (logger.isInfoEnabled()) {
            t.printStackTrace(System.err);
        } else if (t.getClass() == Exception.class) {
            System.err.println("ERROR: " + t.getMessage());
        } else if (t instanceof UnrecognizedOptionException || t instanceof MissingArgumentException) {
            System.err.println(t.getMessage());
        } else if (t instanceof ProcessingException) {
            Throwable e = t.getCause();
            if (e == null) {
                e = t;
            }
            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
        } else if (t instanceof PKIException) {
            System.err.println(t.getClass().getSimpleName() + ": " + t.getMessage());
        } else {
            t.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        try {
            MainCLI cli = new MainCLI();
            cli.execute(args);
        }
        catch (CLIException e) {
            String message = e.getMessage();
            if (message != null) {
                System.err.println("ERROR: " + message);
            }
            System.exit(e.getCode());
        }
        catch (Throwable t) {
            MainCLI.handleException(t);
            System.exit(-1);
        }
    }
}

