/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.logging.AuditClient;
import com.netscape.certsrv.logging.AuditConfig;
import com.netscape.certsrv.logging.AuditFile;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.logging.AuditFileFindCLI;
import com.netscape.cmstools.logging.AuditFileRetrieveCLI;
import com.netscape.cmstools.logging.AuditModifyCLI;
import com.netscape.cmstools.logging.AuditShowCLI;
import java.io.IOException;
import java.util.Map;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(AuditCLI.class);
    public SubsystemCLI subsystemCLI;
    public AuditClient auditClient;

    public AuditCLI(SubsystemCLI subsystemCLI) {
        super("audit", "Audit management commands", (CLI)subsystemCLI);
        this.subsystemCLI = subsystemCLI;
        this.addModule((CLI)new AuditModifyCLI(this));
        this.addModule((CLI)new AuditShowCLI(this));
        this.addModule((CLI)new AuditFileFindCLI(this));
        this.addModule((CLI)new AuditFileRetrieveCLI(this));
    }

    public String getManPage() {
        return "pki-audit";
    }

    public AuditClient getAuditClient() throws Exception {
        if (this.auditClient != null) {
            return this.auditClient;
        }
        PKIClient client = this.getClient();
        this.auditClient = new AuditClient(client, this.subsystemCLI.getName());
        return this.auditClient;
    }

    public static void printAuditConfig(AuditConfig auditConfig) throws IOException {
        if (auditConfig.getStatus() != null) {
            System.out.println("  Status: " + auditConfig.getStatus());
        }
        if (auditConfig.getSigned() != null) {
            System.out.println("  Signed: " + auditConfig.getSigned());
        }
        if (auditConfig.getInterval() != null) {
            System.out.println("  Interval (seconds): " + auditConfig.getInterval());
        }
        if (auditConfig.getBufferSize() != null) {
            System.out.println("  Buffer size (bytes): " + auditConfig.getBufferSize());
        }
        System.out.println("  Events:");
        Map eventConfigs = auditConfig.getEventConfigs();
        if (eventConfigs != null) {
            for (Map.Entry entry : eventConfigs.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println("    " + name + ": " + value);
            }
        }
    }

    public static void printAuditFile(AuditFile auditFile) {
        System.out.println("  File name: " + auditFile.getName());
        System.out.println("  Size: " + auditFile.getSize());
    }
}

