/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.common.CMSFileLoader;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.base.ConfigStore;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSGateway {
    public static Logger logger = LoggerFactory.getLogger(CMSGateway.class);
    public static final String PROP_CMSGATEWAY = "cmsgateway";
    private static final String PROP_ENABLE_ADMIN_ENROLL = "enableAdminEnroll";
    public static final String CERT_ATTR = "javax.servlet.request.X509Certificate";
    protected CMSEngine engine;
    protected CMSFileLoader mFileLoader = new CMSFileLoader();
    protected boolean mEnableFileServing;
    protected boolean mEnableAdminEnroll = true;
    protected ConfigStore mConfig;
    protected static final String AUTHMGR_PARAM = "authenticator";

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void init() throws Exception {
        EngineConfig cs = this.engine.getConfig();
        this.mConfig = cs.getSubStore(PROP_CMSGATEWAY, ConfigStore.class);
        this.mEnableAdminEnroll = this.mConfig.getBoolean(PROP_ENABLE_ADMIN_ENROLL, false);
        this.mEnableFileServing = true;
    }

    public Hashtable<String, String> toHashtable(HttpServletRequest req) {
        Hashtable<String, String> httpReqHash = new Hashtable<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            httpReqHash.put(name, req.getParameter(name));
        }
        String ip = req.getRemoteAddr();
        if (ip != null) {
            httpReqHash.put("clientHost", ip);
        }
        return httpReqHash;
    }

    public boolean getEnableAdminEnroll() {
        return this.mEnableAdminEnroll;
    }

    public void setEnableAdminEnroll(boolean enableAdminEnroll) throws EBaseException {
        EngineConfig engineConfig = this.engine.getConfig();
        this.mEnableAdminEnroll = enableAdminEnroll;
        this.mConfig.putBoolean(PROP_ENABLE_ADMIN_ENROLL, enableAdminEnroll);
        engineConfig.commit(true);
    }

    public void disableAdminEnroll() throws EBaseException {
        this.setEnableAdminEnroll(false);
    }

    public AuthCredentials getAuthCreds(AuthManager authMgr, ArgBlock argBlock, X509Certificate clientCert) throws EBaseException {
        if (authMgr == null) {
            return null;
        }
        String[] reqCreds = authMgr.getRequiredCreds();
        AuthCredentials creds = new AuthCredentials();
        try {
            if (clientCert != null) {
                clientCert = new X509CertImpl(clientCert.getEncoded());
            }
        }
        catch (CertificateException e) {
            throw new EBaseException("Unable to parse client certificate: " + e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < reqCreds.length; ++i) {
            String reqCred = reqCreds[i];
            if (reqCred.equals("sslClientCert")) {
                creds.set(reqCred, new X509Certificate[]{clientCert});
                continue;
            }
            String value = argBlock.getValueAsString(reqCred);
            creds.set(reqCred, value);
        }
        creds.set("clientHost", argBlock.getValueAsString("clientHost"));
        creds.setArgBlock(argBlock);
        return creds;
    }

    public AuthToken checkAuthManager(HttpServletRequest httpReq, ArgBlock httpParams, X509Certificate cert, String authMgrName) throws EBaseException {
        ArgBlock httpArgs = httpParams;
        if (httpArgs == null) {
            httpArgs = new ArgBlock(this.toHashtable(httpReq));
        }
        AuthSubsystem authSub = this.engine.getAuthSubsystem();
        String authMgr_http = httpArgs.getValueAsString(AUTHMGR_PARAM, null);
        if (authMgr_http != null) {
            authMgrName = authMgr_http;
        }
        if (authMgrName == null || authMgrName.length() == 0) {
            throw new EBaseException(CMS.getLogMessage("BASE_INTERNAL_ERROR_1", CMS.getLogMessage("CMSGW_AUTH_MAN_EXPECTED", new Object[0])));
        }
        AuthManager authMgr = authSub.getAuthManager("certUserDBAuthMgr");
        authMgr = authSub.getAuthManager(authMgrName);
        if (authMgr == null) {
            return null;
        }
        AuthCredentials creds = this.getAuthCreds(authMgr, new ArgBlock(this.toHashtable(httpReq)), cert);
        AuthToken authToken = null;
        try {
            authToken = authMgr.authenticate(creds);
        }
        catch (EBaseException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("CMSGateway: " + e.getMessage(), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_AUTH_ERROR_2", e.toString(), e.getMessage()));
        }
        return authToken;
    }

    public void renderTemplate(String templateName, HttpServletRequest req, HttpServletResponse resp, ServletConfig servletConfig, CMSFileLoader fileLoader) throws EBaseException, IOException {
        CMSTemplate template = this.getTemplate(templateName, req, servletConfig, fileLoader, new Locale[1]);
        ServletOutputStream out = resp.getOutputStream();
        template.renderOutput((OutputStream)out, new CMSTemplateParams(null, null));
    }

    public Locale getLocale(String lang) {
        int dash = lang.indexOf(45);
        return dash == -1 ? new Locale(lang, "") : new Locale(lang.substring(0, dash), lang.substring(dash + 1));
    }

    public File getLangFile(HttpServletRequest req, File realpathFile, Locale[] locale) throws IOException {
        File file = null;
        String acceptLang = req.getHeader("accept-language");
        if (acceptLang != null && !acceptLang.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(acceptLang, ",");
            int numLangs = tokenizer.countTokens();
            if (numLangs > 0) {
                int i;
                String name;
                Object parent = realpathFile.getParent();
                if (parent == null) {
                    parent = "." + File.separatorChar;
                }
                if ((name = realpathFile.getName()) == null) {
                    throw new IOException("file has no name");
                }
                for (i = 0; i < numLangs; ++i) {
                    String lang = null;
                    String token = tokenizer.nextToken();
                    int semicolon = token.indexOf(59);
                    if (semicolon == -1) {
                        lang = token.trim();
                    } else {
                        if (semicolon < 2) continue;
                        lang = token.substring(0, semicolon).trim();
                    }
                    Locale l = this.getLocale(lang);
                    if (Locale.getDefault().equals(l)) {
                        locale[0] = l;
                        file = realpathFile;
                        break;
                    }
                    String langfilepath = (String)parent + File.separatorChar + lang + File.separatorChar + name;
                    file = new File(langfilepath);
                    if (!file.exists()) continue;
                    locale[0] = this.getLocale(lang);
                    break;
                }
                if (i == numLangs) {
                    file = realpathFile;
                    locale[0] = Locale.getDefault();
                }
            }
        } else {
            file = realpathFile;
            locale[0] = Locale.getDefault();
        }
        return file;
    }

    protected CMSTemplate getTemplate(String templateName, HttpServletRequest httpReq, ServletConfig servletConfig, CMSFileLoader fileLoader, Locale[] locale) throws EBaseException, IOException {
        if (servletConfig == null) {
            logger.warn("CMSGateway:getTemplate() - servletConfig is null!");
            return null;
        }
        if (servletConfig.getServletContext() == null) {
            // empty if block
        }
        if (templateName == null) {
            // empty if block
        }
        String realpath = servletConfig.getServletContext().getRealPath("/" + templateName);
        File realpathFile = new File(realpath);
        File templateFile = this.getLangFile(httpReq, realpathFile, locale);
        CMSTemplate template = (CMSTemplate)fileLoader.getCMSFile(templateFile, httpReq.getCharacterEncoding());
        return template;
    }

    public boolean modifiedSince(HttpServletRequest req, long lastModified) {
        long ifModSinceStr;
        try {
            ifModSinceStr = req.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        if (ifModSinceStr < 0L) {
            return true;
        }
        return ifModSinceStr < lastModified;
    }
}

