/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCertApprovalCallback
implements SSLCertificateApprovalCallback {
    public static Logger logger = LoggerFactory.getLogger(ConfigCertApprovalCallback.class);
    public Set<Integer> ignoredErrors = new HashSet<Integer>();

    public void ignoreError(int error) {
        this.ignoredErrors.add(error);
    }

    public String getErrorDescription(int reason) {
        for (Field f : SSLCertificateApprovalCallback.ValidityStatus.class.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod)) continue;
            try {
                int value = f.getInt(null);
                if (value != reason) continue;
                return f.getName();
            }
            catch (IllegalAccessException e) {
                return "ERROR #" + reason;
            }
        }
        return "UNKNOWN_ERROR";
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        logger.debug("Server certificate:");
        logger.debug("- subject: " + cert.getSubjectDN());
        logger.debug("- issuer: " + cert.getIssuerDN());
        Enumeration errors = status.getReasons();
        boolean result = true;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            String description = this.getErrorDescription(reason);
            if (this.ignoredErrors.contains(reason)) {
                logger.warn("WARNING: " + description);
                continue;
            }
            logger.error("ERROR: " + description);
            result = false;
        }
        return result;
    }
}

