/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ocsp.IOCSPService;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;

public class GetOCSPInfo
extends CMSServlet {
    private static final long serialVersionUID = -3633557968127876119L;
    private static final String TPL_FILE = "getOCSPInfo.template";
    private String mFormPath = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/" + this.mAuthority.getId() + "/getOCSPInfo.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage("ADMIN_SRVLT_AUTH_FAILURE", e.toString()), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        if (!(this.mAuthority instanceof IOCSPService)) {
            logger.warn(CMS.getLogMessage("CMSGW_CA_FROM_RA_NOT_IMP", new Object[0]));
            cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_NOT_YET_IMPLEMENTED", new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, httpReq, locale);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_GET_TEMPLATE", this.mFormPath, e.toString()), (Throwable)e);
            cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
            return;
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        IOCSPService ca = (IOCSPService)((Object)this.mAuthority);
        header.addLongValue("numReq", ca.getNumOCSPRequest());
        header.addLongValue("totalSec", ca.getOCSPRequestTotalTime());
        header.addLongValue("totalSignSec", ca.getOCSPTotalSignTime());
        header.addLongValue("totalLookupSec", ca.getOCSPTotalLookupTime());
        header.addLongValue("totalData", ca.getOCSPTotalData());
        long secs = 0L;
        if (ca.getOCSPRequestTotalTime() != 0L) {
            secs = ca.getNumOCSPRequest() * 1000L / ca.getOCSPRequestTotalTime();
        }
        header.addLongValue("ReqSec", secs);
        try {
            ServletOutputStream out = httpResp.getOutputStream();
            httpResp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
            cmsReq.setStatus(CMSRequest.SUCCESS);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage("CMSGW_ERR_STREAM_TEMPLATE", e.toString()), (Throwable)e);
            cmsReq.setError(new ECMSGWException(CMS.getUserMessage("CMS_GW_DISPLAY_TEMPLATE_ERROR", new String[0])));
            cmsReq.setStatus(CMSRequest.ERROR);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }
}

