/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import netscape.ldap.LDAPAttribute;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemUserAddCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemUserAddCLI.class);

    public SubsystemUserAddCLI(CLI parent) {
        super("add", "Add " + parent.getParent().getName().toUpperCase() + " user", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "full-name", true, "Full name");
        option.setArgName("full name");
        this.options.addOption(option);
        option = new Option(null, "email", true, "Email");
        option.setArgName("email");
        this.options.addOption(option);
        option = new Option(null, "password", true, "Password");
        option.setArgName("password");
        this.options.addOption(option);
        option = new Option(null, "password-file", true, "Password file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "phone", true, "Phone");
        option.setArgName("phone");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Type: userType, agentType, adminType, subsystemType");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "state", true, "State");
        option.setArgName("state");
        this.options.addOption(option);
        option = new Option(null, "tps-profiles", true, "Comma-separated TPS profiles");
        option.setArgName("profiles");
        this.options.addOption(option);
        option = new Option(null, "attributes", true, "Attributes");
        option.setArgName("attributes");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing user ID");
        }
        String userID = cmdArgs[0];
        String fullName = cmd.getOptionValue("full-name");
        if (fullName == null) {
            throw new Exception("Missing full name");
        }
        String email = cmd.getOptionValue("email");
        String password = cmd.getOptionValue("password");
        String passwordFile = cmd.getOptionValue("password-file");
        String phone = cmd.getOptionValue("phone");
        String type = cmd.getOptionValue("type");
        String state = cmd.getOptionValue("state");
        String tpsProfiles = cmd.getOptionValue("tps-profiles");
        String attributes = cmd.getOptionValue("attributes");
        if (passwordFile != null) {
            password = new String(Files.readAllBytes(Paths.get(passwordFile, new String[0])), "UTF-8").trim();
        }
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        UGSubsystemConfig ugConfig = cs.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        UGSubsystem ugSubsystem = new UGSubsystem();
        try {
            ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
            User user = new User();
            user.setUserID(userID);
            user.setFullName(fullName);
            user.setEmail(email);
            user.setPassword(password);
            user.setPhone(phone);
            user.setUserType(type);
            user.setState(state);
            if (tpsProfiles != null) {
                List<String> list = Arrays.asList(tpsProfiles.split(","));
                user.setTpsProfiles(list);
            }
            if (attributes != null) {
                String[] attrs = attributes.split(",");
                ArrayList<LDAPAttribute> ldapAttrList = new ArrayList<LDAPAttribute>();
                for (String s : attrs) {
                    String[] split = s.split(":");
                    ldapAttrList.add(new LDAPAttribute(split[0], split[1]));
                }
                user.setAttributes(ldapAttrList);
            }
            ugSubsystem.addUser(user);
        }
        finally {
            ugSubsystem.shutdown();
        }
    }
}

