/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.kra.KeyRecoveryAuthority;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.dogtagpki.common.KRAInfo;
import org.dogtagpki.common.KRAInfoResource;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.netscape.security.util.WrappingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAInfoService
extends PKIService
implements KRAInfoResource {
    private static Logger logger = LoggerFactory.getLogger(KRAInfoService.class);
    private KeyRecoveryAuthority kra;
    private IStorageKeyUnit storageUnit;

    public KRAInfoService() {
        KRAEngine engine = KRAEngine.getInstance();
        this.kra = (KeyRecoveryAuthority)engine.getSubsystem("kra");
        this.storageUnit = this.kra.getStorageKeyUnit();
    }

    public Response getInfo() throws Exception {
        HttpSession session = this.servletRequest.getSession();
        logger.debug("KRAInfoService.getInfo(): session: " + session.getId());
        KRAInfo info = new KRAInfo();
        info.setArchivalMechanism(this.getArchivalMechanism());
        info.setRecoveryMechanism(this.getRecoveryMechanism());
        info.setEncryptAlgorithm(this.getEncryptAlgorithm());
        info.setWrapAlgorithm(this.getWrapAlgorithm());
        info.setRsaPublicKeyWrapAlgorithm(this.getRsaPublicKeyWrapAlgorithm());
        return this.createOKResponse(info);
    }

    String getArchivalMechanism() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean encrypt_archival = cs.getBoolean("kra.allowEncDecrypt.archival", false);
        return encrypt_archival ? "encrypt" : "keywrap";
    }

    String getRecoveryMechanism() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean encrypt_recovery = cs.getBoolean("kra.allowEncDecrypt.recovery", false);
        return encrypt_recovery ? "encrypt" : "keywrap";
    }

    String getWrapAlgorithm() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean encrypt_archival = cs.getBoolean("kra.allowEncDecrypt.archival", false);
        WrappingParams params = null;
        try {
            params = this.storageUnit.getWrappingParams(encrypt_archival);
        }
        catch (Exception e) {
            return "AES/CBC/Padding";
        }
        return params.getPayloadWrapAlgorithm().toString();
    }

    String getEncryptAlgorithm() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean encrypt_archival = cs.getBoolean("kra.allowEncDecrypt.archival", false);
        WrappingParams params = null;
        try {
            params = this.storageUnit.getWrappingParams(encrypt_archival);
        }
        catch (Exception e) {
            return "AES/CBC/Padding";
        }
        return params.getPayloadEncryptionAlgorithm().toString();
    }

    String getRsaPublicKeyWrapAlgorithm() throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        boolean useOAEP = cs.getUseOAEPKeyWrap();
        return useOAEP ? "RSA_OAEP" : "RSA";
    }
}

