/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.CertificateAuthority;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetCertStatus
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(GetCertStatus.class);
    private CertificateAuthority mCA;
    private CAService mService;

    public GetCertStatus(CAService service) {
        this.mService = service;
        this.mCA = this.mService.getCA();
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        BigInteger serialno = request.getExtDataInBigInteger("serialNumber");
        String issuerDN = request.getExtDataInString("issuerDN");
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certDB = engine.getCertificateRepository();
        String status = null;
        if (serialno != null) {
            X509CertImpl cacert;
            X500Name p;
            CertRecord record = null;
            try {
                record = certDB.readCertificateRecord(serialno);
            }
            catch (EBaseException ee) {
                logger.warn(ee.toString());
            }
            if (record != null && (status = record.getStatus()).equals("VALID") && !(p = (cacert = this.mCA.getCACert()).getSubjectName()).toString().equals(issuerDN)) {
                status = "INVALIDCERTROOT";
            }
        }
        request.setExtData("certStatus", status);
        return true;
    }
}

