/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSAuthInfoAccessExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(CMSAuthInfoAccessExtension.class);
    public static final String PROP_NUM_ADS = "numberOfAccessDescriptions";
    public static final String PROP_ACCESS_METHOD = "accessMethod";
    public static final String PROP_ACCESS_LOCATION_TYPE = "accessLocationType";
    public static final String PROP_ACCESS_LOCATION = "accessLocation";
    private static final String PROP_ACCESS_METHOD_OCSP = "ocsp";
    private static final String PROP_ACCESS_METHOD_CAISSUERS = "caIssuers";
    private static final String PROP_DIRNAME = "DirectoryName";
    private static final String PROP_URINAME = "URI";

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        AuthInfoAccessExtension authInfoAccessExt = (AuthInfoAccessExtension)ext;
        authInfoAccessExt.setCritical(critical);
        return authInfoAccessExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        AuthInfoAccessExtension authInfoAccessExt = new AuthInfoAccessExtension(critical);
        int numberOfAccessDescriptions = 0;
        try {
            numberOfAccessDescriptions = config.getInteger(PROP_NUM_ADS, 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_INVALID_NUM_ADS", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (numberOfAccessDescriptions > 0) {
            for (int i = 0; i < numberOfAccessDescriptions; ++i) {
                String accessMethod = null;
                String accessLocationType = null;
                Object accessLocation = null;
                ObjectIdentifier method = AuthInfoAccessExtension.METHOD_CA_ISSUERS;
                try {
                    accessMethod = config.getString(PROP_ACCESS_METHOD + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AM_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AM_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (accessMethod != null && accessMethod.equals(PROP_ACCESS_METHOD_OCSP)) {
                    method = AuthInfoAccessExtension.METHOD_OCSP;
                }
                try {
                    accessLocationType = config.getString(PROP_ACCESS_LOCATION_TYPE + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_ALT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_ALT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                try {
                    accessLocation = config.getString(PROP_ACCESS_LOCATION + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_DIST_POINT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                if (accessLocationType != null && accessLocation != null && ((String)accessLocation).length() > 0) {
                    if (accessLocationType.equalsIgnoreCase(PROP_DIRNAME)) {
                        try {
                            X500Name dirName = new X500Name((String)accessLocation);
                            authInfoAccessExt.addAccessDescription(method, new GeneralName((GeneralNameInterface)dirName));
                        }
                        catch (IOException e) {
                            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_500NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        }
                        continue;
                    }
                    if (accessLocationType.equalsIgnoreCase(PROP_URINAME)) {
                        URIName uriName = new URIName((String)accessLocation);
                        authInfoAccessExt.addAccessDescription(method, new GeneralName((GeneralNameInterface)uriName));
                        continue;
                    }
                    logger.warn(CMS.getLogMessage((String)"CRL_INVALID_POTINT_TYPE", (Object[])new Object[]{accessLocation}));
                    continue;
                }
                accessLocationType = PROP_URINAME;
                CAEngine engine = CAEngine.getInstance();
                CAEngineConfig cs = engine.getConfig();
                String hostname = cs.getHostname();
                String port = engine.getEENonSSLPort();
                if (hostname != null && port != null) {
                    accessLocation = "http://" + hostname + ":" + port + "/ca/ee/ca/getCAChain?op=downloadBIN";
                }
                URIName uriName = new URIName((String)accessLocation);
                authInfoAccessExt.addAccessDescription(AuthInfoAccessExtension.METHOD_CA_ISSUERS, new GeneralName((GeneralNameInterface)uriName));
            }
        }
        return authInfoAccessExt;
    }

    @Override
    public String getCRLExtOID() {
        return AuthInfoAccessExtension.ID.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        int numberOfAccessDescriptions = 0;
        try {
            numberOfAccessDescriptions = config.getInteger(PROP_NUM_ADS, 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_INVALID_NUM_ADS", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        nvp.put((Object)PROP_NUM_ADS, (Object)String.valueOf(numberOfAccessDescriptions));
        for (int i = 0; i < numberOfAccessDescriptions; ++i) {
            String accessMethod = null;
            String accessLocationType = null;
            Object accessLocation = null;
            try {
                accessMethod = config.getString(PROP_ACCESS_METHOD + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AM_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AM_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (accessMethod != null && accessMethod.length() > 0) {
                nvp.put((Object)(PROP_ACCESS_METHOD + i), (Object)accessMethod);
            } else {
                nvp.put((Object)(PROP_ACCESS_METHOD + i), (Object)PROP_ACCESS_METHOD_CAISSUERS);
            }
            try {
                accessLocationType = config.getString(PROP_ACCESS_LOCATION_TYPE + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_ALT_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_ALT_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (accessLocationType != null && accessLocationType.length() > 0) {
                nvp.put((Object)(PROP_ACCESS_LOCATION_TYPE + i), (Object)accessLocationType);
            } else {
                nvp.put((Object)(PROP_ACCESS_LOCATION_TYPE + i), (Object)PROP_URINAME);
            }
            try {
                accessLocation = config.getString(PROP_ACCESS_LOCATION + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AL_UNDEFINED", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_AIA_AD_AL_INVALID", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (accessLocation != null && ((String)accessLocation).length() > 0) {
                nvp.put((Object)(PROP_ACCESS_LOCATION + i), accessLocation);
                continue;
            }
            CAEngine engine = CAEngine.getInstance();
            CAEngineConfig cs = engine.getConfig();
            String hostname = cs.getHostname();
            String port = engine.getEENonSSLPort();
            if (hostname != null && port != null) {
                accessLocation = "http://" + hostname + ":" + port + "/ca/ee/ca/getCAChain?op=downloadBIN";
            }
            nvp.put((Object)(PROP_ACCESS_LOCATION + i), accessLocation);
        }
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Authority Information Access extension.", "critical;boolean;Set criticality for Authority Information Access extension.", "numberOfAccessDescriptions;number;Set number of Access Descriptions.", "accessMethod0;choice(caIssuers,ocsp);Select access description method.", "accessLocationType0;choice(URI,DirectoryName);Select access location type.", "accessLocation0;string;Enter access location corresponding to the selected access location type.", "HELP_TOKEN;configuration-ca-edit-crlextension-authorityinformationaccess", "accessMethod1;choice(caIssuers,ocsp);Select access description method.", "accessLocationType1;choice(URI,DirectoryName);Select access location type.", "accessLocation1;string;Enter access location corresponding to the selected access location type.", "HELP_TOKEN;configuration-ca-edit-crlextension-authorityinformationaccess", "accessMethod2;choice(caIssuers,ocsp);Select access description method.", "accessLocationType2;choice(URI,DirectoryName);Select access location type.", "accessLocation2;string;Enter access location corresponding to the selected access location type.", "HELP_TOKEN;configuration-ca-edit-crlextension-authorityinformationaccess", "HELP_TEXT;The Freshest CRL is a non critical CRL extension that identifies the delta CRL distribution points for a particular CRL."};
        return params;
    }
}

