/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.NSCCommentExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSCCommentExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(NSCCommentExtDefault.class);
    public static final String CONFIG_CRITICAL = "nscCommentCritical";
    public static final String CONFIG_COMMENT = "nscCommentContent";
    public static final String VAL_CRITICAL = "nscCommentCritical";
    public static final String VAL_COMMENT = "nscCommentContent";

    public NSCCommentExtDefault() {
        this.addValueName("nscCommentCritical");
        this.addValueName("nscCommentContent");
        this.addConfigName("nscCommentCritical");
        this.addConfigName("nscCommentContent");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("nscCommentCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("nscCommentContent")) {
            return new Descriptor("string", null, "Comment Here...", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_COMMENT", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("nscCommentCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("nscCommentContent")) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_COMMENT", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            NSCCommentExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ObjectIdentifier oid = NSCCommentExtension.OID;
            ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("nscCommentCritical")) {
                ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals("nscCommentContent")) {
                ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
                if (ext == null) {
                    return;
                }
                boolean critical = ext.isCritical();
                ext = value == null || value.equals("") ? new NSCCommentExtension(critical, "") : new NSCCommentExtension(critical, value);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(ext.getExtensionId().toString(), (Extension)ext, info);
        }
        catch (IOException e) {
            logger.warn("NSCCommentExtDefault: setValue " + e.getMessage(), (Throwable)e);
        }
        catch (EProfileException e) {
            logger.warn("NSCCommentExtDefault: setValue " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        NSCCommentExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ObjectIdentifier oid = NSCCommentExtension.OID;
        ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("nscCommentCritical")) {
            ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals("nscCommentContent")) {
            ext = (NSCCommentExtension)this.getExtension(oid.toString(), info);
            if (ext == null) {
                return "";
            }
            String comment = ext.getComment();
            if (comment == null) {
                comment = "";
            }
            return comment;
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("nscCommentCritical"), this.getConfig("nscCommentContent")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_NS_COMMENT_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        NSCCommentExtension ext = this.createExtension();
        this.addExtension(ext.getExtensionId().toString(), (Extension)ext, info);
    }

    public NSCCommentExtension createExtension() {
        NSCCommentExtension ext = null;
        try {
            boolean critical = this.getConfigBoolean("nscCommentCritical");
            String comment = this.getConfig("nscCommentContent");
            ext = comment == null || comment.equals("") ? new NSCCommentExtension(critical, "") : new NSCCommentExtension(critical, comment);
        }
        catch (Exception e) {
            logger.warn("NSCCommentExtension: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

