/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.security.cert.CertificateException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSCertTypeExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(NSCertTypeExtDefault.class);
    public static final String CONFIG_CRITICAL = "nsCertCritical";
    public static final String CONFIG_SSL_CLIENT = "nsCertSSLClient";
    public static final String CONFIG_SSL_SERVER = "nsCertSSLServer";
    public static final String CONFIG_EMAIL = "nsCertEmail";
    public static final String CONFIG_OBJECT_SIGNING = "nsCertObjectSigning";
    public static final String CONFIG_SSL_CA = "nsCertSSLCA";
    public static final String CONFIG_EMAIL_CA = "nsCertEmailCA";
    public static final String CONFIG_OBJECT_SIGNING_CA = "nsCertObjectSigningCA";
    public static final String VAL_CRITICAL = "nsCertCritical";
    public static final String VAL_SSL_CLIENT = "nsCertSSLClient";
    public static final String VAL_SSL_SERVER = "nsCertSSLServer";
    public static final String VAL_EMAIL = "nsCertEmail";
    public static final String VAL_OBJECT_SIGNING = "nsCertObjectSigning";
    public static final String VAL_SSL_CA = "nsCertSSLCA";
    public static final String VAL_EMAIL_CA = "nsCertEmailCA";
    public static final String VAL_OBJECT_SIGNING_CA = "nsCertObjectSigningCA";

    public NSCertTypeExtDefault() {
        this.addValueName("nsCertCritical");
        this.addValueName("nsCertSSLClient");
        this.addValueName("nsCertSSLServer");
        this.addValueName("nsCertEmail");
        this.addValueName("nsCertObjectSigning");
        this.addValueName("nsCertSSLCA");
        this.addValueName("nsCertEmailCA");
        this.addValueName("nsCertObjectSigningCA");
        this.addConfigName("nsCertCritical");
        this.addConfigName("nsCertSSLClient");
        this.addConfigName("nsCertSSLServer");
        this.addConfigName("nsCertEmail");
        this.addConfigName("nsCertObjectSigning");
        this.addConfigName("nsCertSSLCA");
        this.addConfigName("nsCertEmailCA");
        this.addConfigName("nsCertObjectSigningCA");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("nsCertCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLClient")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CLIENT", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLServer")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_SERVER", (String[])new String[0]));
        }
        if (name.equals("nsCertEmail")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL", (String[])new String[0]));
        }
        if (name.equals("nsCertObjectSigning")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CA", (String[])new String[0]));
        }
        if (name.equals("nsCertEmailCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL_CA", (String[])new String[0]));
        }
        if (name.equals("nsCertObjectSigningCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING_CA", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("nsCertCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLClient")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CLIENT", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLServer")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_SERVER", (String[])new String[0]));
        }
        if (name.equals("nsCertEmail")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL", (String[])new String[0]));
        }
        if (name.equals("nsCertObjectSigning")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING", (String[])new String[0]));
        }
        if (name.equals("nsCertSSLCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CA", (String[])new String[0]));
        }
        if (name.equals("nsCertEmailCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL_CA", (String[])new String[0]));
        }
        if (name.equals("nsCertObjectSigningCA")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING_CA", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            NSCertTypeExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("nsCertCritical")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals("nsCertSSLClient")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("ssl_client", (Object)val);
            } else if (name.equals("nsCertSSLServer")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("ssl_server", (Object)val);
            } else if (name.equals("nsCertEmail")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("email", (Object)val);
            } else if (name.equals("nsCertObjectSigning")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("object_signing", (Object)val);
            } else if (name.equals("nsCertSSLCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("ssl_ca", (Object)val);
            } else if (name.equals("nsCertEmailCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("email_ca", (Object)val);
            } else if (name.equals("nsCertObjectSigningCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                Boolean val = Boolean.valueOf(value);
                ext.set("object_signing_ca", (Object)val);
            } else {
                throw new EPropertyException("Invalid name " + name);
            }
            this.replaceExtension(NSCertTypeExtension.CertType_Id.toString(), (Extension)ext, info);
        }
        catch (CertificateException e) {
            logger.warn("NSCertTypeExtDefault: setValue " + e.getMessage(), (Throwable)e);
        }
        catch (EProfileException e) {
            logger.warn("NSCertTypeExtDefault: setValue " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        try {
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            NSCertTypeExtension ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
            if (ext == null) {
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("nsCertCritical")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                return ext.isCritical() ? "true" : "false";
            }
            if (name.equals("nsCertSSLClient")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("ssl_client");
                return val.toString();
            }
            if (name.equals("nsCertSSLServer")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("ssl_server");
                return val.toString();
            }
            if (name.equals("nsCertEmail")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("email");
                return val.toString();
            }
            if (name.equals("nsCertObjectSigning")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("object_signing");
                return val.toString();
            }
            if (name.equals("nsCertSSLCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("ssl_ca");
                return val.toString();
            }
            if (name.equals("nsCertEmailCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("email_ca");
                return val.toString();
            }
            if (name.equals("nsCertObjectSigningCA")) {
                ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                Boolean val = (Boolean)ext.get("object_signing_ca");
                return val.toString();
            }
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (CertificateException e) {
            logger.warn("NSCertTypeExtDefault: setValue " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("nsCertCritical"), this.getConfig("nsCertSSLClient"), this.getConfig("nsCertSSLServer"), this.getConfig("nsCertEmail"), this.getConfig("nsCertObjectSigning"), this.getConfig("nsCertSSLCA"), this.getConfig("nsCertEmailCA"), this.getConfig("nsCertObjectSigningCA")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_NS_CERT_TYPE_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        NSCertTypeExtension ext = this.createExtension();
        this.addExtension(NSCertTypeExtension.CertType_Id.toString(), (Extension)ext, info);
    }

    public NSCertTypeExtension createExtension() {
        NSCertTypeExtension ext = null;
        boolean[] bits = new boolean[8];
        boolean critical = this.getConfigBoolean("nsCertCritical");
        bits[0] = this.getConfigBoolean("nsCertSSLClient");
        bits[1] = this.getConfigBoolean("nsCertSSLServer");
        bits[2] = this.getConfigBoolean("nsCertEmail");
        bits[3] = this.getConfigBoolean("nsCertObjectSigning");
        bits[4] = false;
        bits[5] = this.getConfigBoolean("nsCertSSLCA");
        bits[6] = this.getConfigBoolean("nsCertEmailCA");
        bits[7] = this.getConfigBoolean("nsCertObjectSigningCA");
        try {
            ext = new NSCertTypeExtension(critical, bits);
        }
        catch (Exception e) {
            logger.warn("NSCertTypeExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }
}

