/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralSubtree;
import org.mozilla.jss.netscape.security.x509.GeneralSubtrees;
import org.mozilla.jss.netscape.security.x509.NameConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameConstraintsExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(NameConstraintsExtDefault.class);
    public static final String CONFIG_CRITICAL = "nameConstraintsCritical";
    public static final String CONFIG_NUM_PERMITTED_SUBTREES = "nameConstraintsNumPermittedSubtrees";
    public static final String CONFIG_PERMITTED_MIN_VAL = "nameConstraintsPermittedSubtreeMinValue_";
    public static final String CONFIG_PERMITTED_MAX_VAL = "nameConstraintsPermittedSubtreeMaxValue_";
    public static final String CONFIG_PERMITTED_NAME_CHOICE = "nameConstraintsPermittedSubtreeNameChoice_";
    public static final String CONFIG_PERMITTED_NAME_VAL = "nameConstraintsPermittedSubtreeNameValue_";
    public static final String CONFIG_PERMITTED_ENABLE = "nameConstraintsPermittedSubtreeEnable_";
    public static final String CONFIG_NUM_EXCLUDED_SUBTREES = "nameConstraintsNumExcludedSubtrees";
    public static final String CONFIG_EXCLUDED_MIN_VAL = "nameConstraintsExcludedSubtreeMinValue_";
    public static final String CONFIG_EXCLUDED_MAX_VAL = "nameConstraintsExcludedSubtreeMaxValue_";
    public static final String CONFIG_EXCLUDED_NAME_CHOICE = "nameConstraintsExcludedSubtreeNameChoice_";
    public static final String CONFIG_EXCLUDED_NAME_VAL = "nameConstraintsExcludedSubtreeNameValue_";
    public static final String CONFIG_EXCLUDED_ENABLE = "nameConstraintsExcludedSubtreeEnable_";
    public static final String VAL_CRITICAL = "nameConstraintsCritical";
    public static final String VAL_PERMITTED_SUBTREES = "nameConstraintsPermittedSubtreesValue";
    public static final String VAL_EXCLUDED_SUBTREES = "nameConstraintsExcludedSubtreesValue";
    private static final String GENERAL_NAME_CHOICE = "GeneralNameChoice";
    private static final String GENERAL_NAME_VALUE = "GeneralNameValue";
    private static final String MIN_VALUE = "Min Value";
    private static final String MAX_VALUE = "Max Value";
    private static final String ENABLE = "Enable";
    protected static final int DEF_NUM_PERMITTED_SUBTREES = 1;
    protected static final int DEF_NUM_EXCLUDED_SUBTREES = 1;
    protected static final int MAX_NUM_EXCLUDED_SUBTREES = 100;
    protected static final int MAX_NUM_PERMITTED_SUBTREES = 100;

    @Override
    public void init(CAEngineConfig engineConfig, ConfigStore config) throws EProfileException {
        super.init(engineConfig, config);
        this.refreshConfigAndValueNames();
    }

    protected int getNumPermitted() {
        int num = 1;
        String val = this.getConfig(CONFIG_NUM_PERMITTED_SUBTREES);
        if (val != null) {
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    protected int getNumExcluded() {
        int num = 1;
        String val = this.getConfig(CONFIG_NUM_EXCLUDED_SUBTREES);
        if (val != null) {
            try {
                num = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (num >= 100) {
            num = 1;
        }
        return num;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        block8: {
            int num = 0;
            if (name.equals(CONFIG_NUM_PERMITTED_SUBTREES)) {
                try {
                    num = Integer.parseInt(value);
                    if (num >= 100 || num < 0) {
                        throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_PERMITTED_SUBTREES}));
                    }
                    break block8;
                }
                catch (Exception e) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_PERMITTED_SUBTREES}));
                }
            }
            if (name.equals(CONFIG_NUM_EXCLUDED_SUBTREES)) {
                try {
                    num = Integer.parseInt(value);
                    if (num >= 100 || num < 0) {
                        throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_EXCLUDED_SUBTREES}));
                    }
                }
                catch (Exception e) {
                    throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NUM_EXCLUDED_SUBTREES}));
                }
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public Enumeration<String> getConfigNames() {
        this.refreshConfigAndValueNames();
        return super.getConfigNames();
    }

    @Override
    protected void refreshConfigAndValueNames() {
        int i;
        super.refreshConfigAndValueNames();
        this.addValueName("nameConstraintsCritical");
        this.addValueName(VAL_PERMITTED_SUBTREES);
        this.addValueName(VAL_EXCLUDED_SUBTREES);
        this.addConfigName("nameConstraintsCritical");
        int num = this.getNumPermitted();
        this.addConfigName(CONFIG_NUM_PERMITTED_SUBTREES);
        for (i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_PERMITTED_MIN_VAL + i);
            this.addConfigName(CONFIG_PERMITTED_MAX_VAL + i);
            this.addConfigName(CONFIG_PERMITTED_NAME_CHOICE + i);
            this.addConfigName(CONFIG_PERMITTED_NAME_VAL + i);
            this.addConfigName(CONFIG_PERMITTED_ENABLE + i);
        }
        num = this.getNumExcluded();
        this.addConfigName(CONFIG_NUM_EXCLUDED_SUBTREES);
        for (i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_EXCLUDED_MIN_VAL + i);
            this.addConfigName(CONFIG_EXCLUDED_MAX_VAL + i);
            this.addConfigName(CONFIG_EXCLUDED_NAME_CHOICE + i);
            this.addConfigName(CONFIG_EXCLUDED_NAME_VAL + i);
            this.addConfigName(CONFIG_EXCLUDED_ENABLE + i);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("nameConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PERMITTED_MIN_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PERMITTED_MIN_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PERMITTED_MAX_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PERMITTED_MAX_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PERMITTED_NAME_CHOICE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PERMITTED_NAME_CHOICE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PERMITTED_NAME_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PERMITTED_NAME_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_PERMITTED_ENABLE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_EXCLUDED_MIN_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXCLUDED_MIN_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_EXCLUDED_MAX_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXCLUDED_MAX_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_EXCLUDED_NAME_CHOICE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXCLUDED_NAME_CHOICE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_EXCLUDED_NAME_VAL)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXCLUDED_NAME_VAL", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_EXCLUDED_ENABLE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ENABLE", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_EXCLUDED_SUBTREES)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_EXCLUDED_SUBTREES", (String[])new String[0]));
        }
        if (name.startsWith(CONFIG_NUM_PERMITTED_SUBTREES)) {
            return new Descriptor("integer", null, "1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NUM_PERMITTED_SUBTREES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("nameConstraintsCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_PERMITTED_SUBTREES)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_PERMITTED_SUBTREES", (String[])new String[0]));
        }
        if (name.equals(VAL_EXCLUDED_SUBTREES)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EXCLUDED_SUBTREES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            NameConstraintsExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("nameConstraintsCritical")) {
                ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
                boolean val = Boolean.valueOf(value);
                if (ext == null) {
                    return;
                }
                ext.setCritical(val);
            } else if (name.equals(VAL_PERMITTED_SUBTREES)) {
                ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                if (value == null || value.equals("null") || value.equals("")) {
                    logger.debug("NameConstraintsExtDefault:setValue : blank value for permitted subtrees ... returning");
                    return;
                }
                Vector<NameValuePairs> v = this.parseRecords(value);
                Vector<GeneralSubtree> permittedSubtrees = this.createSubtrees(locale, v);
                ext.set("permitted_subtrees", (Object)new GeneralSubtrees(permittedSubtrees));
            } else if (name.equals(VAL_EXCLUDED_SUBTREES)) {
                ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                if (value == null || value.equals("null") || value.equals("")) {
                    logger.debug("NameConstraintsExtDefault:setValue : blank value for excluded subtrees ... returning");
                    return;
                }
                Vector<NameValuePairs> v = this.parseRecords(value);
                Vector<GeneralSubtree> excludedSubtrees = this.createSubtrees(locale, v);
                ext.set("excluded_subtrees", (Object)new GeneralSubtrees(excludedSubtrees));
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.NameConstraints_Id.toString(), (Extension)ext, info);
        }
        catch (IOException e) {
            logger.error("NameConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (EProfileException e) {
            logger.error("NameConstraintsExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    private Vector<GeneralSubtree> createSubtrees(Locale locale, Vector<NameValuePairs> v) throws EPropertyException {
        int size = v.size();
        String choice = null;
        String val = "";
        String minS = null;
        String maxS = null;
        Vector<GeneralSubtree> subtrees = new Vector<GeneralSubtree>();
        for (int i = 0; i < size; ++i) {
            NameValuePairs nvps = v.elementAt(i);
            for (String name1 : nvps.keySet()) {
                if (name1.equals(GENERAL_NAME_CHOICE)) {
                    choice = (String)nvps.get((Object)name1);
                    continue;
                }
                if (name1.equals(GENERAL_NAME_VALUE)) {
                    val = (String)nvps.get((Object)name1);
                    continue;
                }
                if (name1.equals(MIN_VALUE)) {
                    minS = (String)nvps.get((Object)name1);
                    continue;
                }
                if (!name1.equals(MAX_VALUE)) continue;
                maxS = (String)nvps.get((Object)name1);
            }
            if (choice == null || choice.length() == 0) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GENERAL_NAME_NOT_FOUND", (String[])new String[0]));
            }
            if (val == null) {
                val = "";
            }
            int min = 0;
            int max = -1;
            if (minS != null && minS.length() > 0) {
                min = Integer.parseInt(minS);
            }
            if (maxS != null && maxS.length() > 0) {
                max = Integer.parseInt(maxS);
            }
            GeneralName gn = null;
            GeneralNameInterface gnI = null;
            try {
                gnI = this.parseGeneralName(choice + ":" + val);
            }
            catch (IOException e) {
                logger.warn("NameConstraintsExtDefault: createSubtress " + e.getMessage(), (Throwable)e);
            }
            if (gnI != null) {
                if (!gnI.validSubtree()) {
                    throw new EPropertyException("Not valid for Name Constraints: " + val);
                }
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GENERAL_NAME_NOT_FOUND", (String[])new String[0]));
            }
            gn = new GeneralName(gnI);
            GeneralSubtree subtree = new GeneralSubtree(gn, min, max);
            subtrees.addElement(subtree);
        }
        return subtrees;
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        NameConstraintsExtension ext = null;
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("nameConstraintsCritical")) {
            ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_PERMITTED_SUBTREES)) {
            ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            GeneralSubtrees subtrees = null;
            try {
                subtrees = (GeneralSubtrees)ext.get("permitted_subtrees");
            }
            catch (IOException e) {
                logger.warn("NameConstraintExtDefault: getValue " + e.getMessage(), (Throwable)e);
            }
            return NameConstraintsExtDefault.getSubtreesInfo(subtrees);
        }
        if (name.equals(VAL_EXCLUDED_SUBTREES)) {
            ext = (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id.toString(), info);
            if (ext == null) {
                return "";
            }
            GeneralSubtrees subtrees = null;
            try {
                subtrees = (GeneralSubtrees)ext.get("excluded_subtrees");
            }
            catch (IOException e) {
                logger.warn("NameConstraintExtDefault: getValue " + e.getMessage(), (Throwable)e);
            }
            return NameConstraintsExtDefault.getSubtreesInfo(subtrees);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    private static String getSubtreesInfo(GeneralSubtrees subtrees) throws EPropertyException {
        if (subtrees == null) {
            return "";
        }
        Vector trees = subtrees.getSubtrees();
        Vector<NameValuePairs> recs = new Vector<NameValuePairs>();
        for (GeneralSubtree tree : trees) {
            GeneralName gn = tree.getGeneralName();
            String type = NameConstraintsExtDefault.getGeneralNameType(gn);
            int max = tree.getMaxValue();
            int min = tree.getMinValue();
            NameValuePairs pairs = new NameValuePairs();
            pairs.put((Object)GENERAL_NAME_CHOICE, (Object)type);
            pairs.put((Object)GENERAL_NAME_VALUE, (Object)NameConstraintsExtDefault.getGeneralNameValue(gn));
            pairs.put((Object)MIN_VALUE, (Object)Integer.toString(min));
            pairs.put((Object)MAX_VALUE, (Object)Integer.toString(max));
            pairs.put((Object)ENABLE, (Object)"true");
            recs.addElement(pairs);
        }
        return NameConstraintsExtDefault.buildRecords(recs);
    }

    @Override
    public String getText(Locale locale) {
        int i;
        StringBuffer sb = new StringBuffer();
        int num = this.getNumPermitted();
        for (i = 0; i < num; ++i) {
            sb.append("Permitted #");
            sb.append(i);
            sb.append("{");
            sb.append("GeneralNameChoice:");
            sb.append(this.getConfig(CONFIG_PERMITTED_NAME_CHOICE + i));
            sb.append(",");
            sb.append("GeneralNameValue:");
            sb.append(this.getConfig(CONFIG_PERMITTED_NAME_VAL + i));
            sb.append(",");
            sb.append("Min Value:");
            sb.append(this.getConfig(CONFIG_PERMITTED_MIN_VAL + i));
            sb.append(",");
            sb.append("Max Value:");
            sb.append(this.getConfig(CONFIG_PERMITTED_MAX_VAL + i));
            sb.append("}");
        }
        num = this.getNumExcluded();
        for (i = 0; i < num; ++i) {
            sb.append("Exluded #");
            sb.append(i);
            sb.append("{");
            sb.append("GeneralNameChoice:");
            sb.append(this.getConfig(CONFIG_EXCLUDED_NAME_CHOICE + i));
            sb.append(",");
            sb.append("GeneralNameValue:");
            sb.append(this.getConfig(CONFIG_EXCLUDED_NAME_VAL + i));
            sb.append(",");
            sb.append("Min Value:");
            sb.append(this.getConfig(CONFIG_EXCLUDED_MIN_VAL + i));
            sb.append(",");
            sb.append("Max Value:");
            sb.append(this.getConfig(CONFIG_EXCLUDED_MAX_VAL + i));
            sb.append("}");
        }
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_NAME_CONSTRAINTS_EXT", (String[])new String[]{this.getConfig("nameConstraintsCritical"), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        NameConstraintsExtension ext = this.createExtension();
        this.addExtension(PKIXExtensions.NameConstraints_Id.toString(), (Extension)ext, info);
    }

    public NameConstraintsExtension createExtension() throws EProfileException {
        NameConstraintsExtension ext = null;
        try {
            int num = this.getNumPermitted();
            boolean critical = this.getConfigBoolean("nameConstraintsCritical");
            Vector<GeneralSubtree> v = new Vector<GeneralSubtree>();
            for (int i = 0; i < num; ++i) {
                String enable = this.getConfig(CONFIG_PERMITTED_ENABLE + i);
                if (enable == null || !enable.equals("true")) continue;
                String choice = this.getConfig(CONFIG_PERMITTED_NAME_CHOICE + i);
                String value = this.getConfig(CONFIG_PERMITTED_NAME_VAL + i);
                String minS = this.getConfig(CONFIG_PERMITTED_MIN_VAL + i);
                String maxS = this.getConfig(CONFIG_PERMITTED_MAX_VAL + i);
                v.addElement(this.createSubtree(choice, value, minS, maxS));
            }
            Vector<GeneralSubtree> v1 = new Vector<GeneralSubtree>();
            num = this.getNumExcluded();
            for (int i = 0; i < num; ++i) {
                String enable = this.getConfig(CONFIG_EXCLUDED_ENABLE + i);
                if (enable == null || !enable.equals("true")) continue;
                String choice = this.getConfig(CONFIG_EXCLUDED_NAME_CHOICE + i);
                String value = this.getConfig(CONFIG_EXCLUDED_NAME_VAL + i);
                String minS = this.getConfig(CONFIG_EXCLUDED_MIN_VAL + i);
                String maxS = this.getConfig(CONFIG_EXCLUDED_MAX_VAL + i);
                v1.addElement(this.createSubtree(choice, value, minS, maxS));
            }
            ext = new NameConstraintsExtension(critical, new GeneralSubtrees(v), new GeneralSubtrees(v1));
        }
        catch (EProfileException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("NameConstraintsExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }

    private GeneralSubtree createSubtree(String choice, String value, String minS, String maxS) throws EProfileException {
        GeneralName gn = null;
        GeneralNameInterface gnI = null;
        try {
            gnI = this.parseGeneralName(choice + ":" + value);
        }
        catch (IOException e) {
            logger.warn("NameConstraintsExtDefault: " + e.getMessage(), (Throwable)e);
        }
        if (gnI != null) {
            if (!gnI.validSubtree()) {
                throw new EProfileException("Not valid for Name Constraints: " + value);
            }
        } else {
            return null;
        }
        gn = new GeneralName(gnI);
        int min = 0;
        if (minS != null && minS.length() > 0) {
            min = Integer.parseInt(minS);
        }
        int max = -1;
        if (maxS != null && maxS.length() > 0) {
            max = Integer.parseInt(maxS);
        }
        return new GeneralSubtree(gn, min, max);
    }
}

