/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.RevocationInfo;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caDisplayBySerial", urlPatterns={"/ee/ca/displayBySerial"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/ee/ca/displayBySerial.template"), @WebInitParam(name="ID", value="caDisplayBySerial"), @WebInitParam(name="resourceID", value="certServer.ee.certificate"), @WebInitParam(name="interface", value="ee")})
public class CADisplayBySerial
extends CMSServlet {
    public static final Logger logger = LoggerFactory.getLogger(CADisplayBySerial.class);
    private static final long serialVersionUID = -4143700762995036597L;
    private static final String TPL_FILE1 = "displayBySerial.template";
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private CertificateRepository mCertDB;
    private String mForm1Path = null;
    private X509Certificate[] mCACerts = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        CertificateAuthority ca = engine.getCA();
        this.mCertDB = engine.getCertificateRepository();
        try {
            this.mCACerts = ca.getCACertChain().getChain();
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_CA_CHAIN_NOT_AVAILABLE", (Object[])new Object[0]), (Throwable)e);
        }
        this.mForm1Path = "/ca/displayBySerial.template";
        if (this.mOutputTemplatePath != null) {
            this.mForm1Path = this.mOutputTemplatePath;
        }
        this.mTemplates.remove(CMSRequest.SUCCESS);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        BigInteger serialNumber = MINUS_ONE;
        Object error = null;
        String[] certType = new String[1];
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            serialNumber = this.getSerialNumber(req);
            this.getCertRecord(serialNumber, certType);
            if (certType[0].equalsIgnoreCase("x509")) {
                form = this.getTemplate(this.mForm1Path, req, locale);
            }
        }
        catch (NumberFormatException e) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT_1", (Object[])new Object[]{String.valueOf(serialNumber)}), (Throwable)e);
            error = new ECMSGWException(CMS.getLogMessage((String)"BASE_INVALID_NUMBER_FORMAT", (Object[])new Object[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mForm1Path, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
        catch (EDBRecordNotFoundException e) {
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_CERT_SERIAL_NOT_FOUND_1", (Object[])new Object[]{"0x" + serialNumber.toString(16)}), (Exception)((Object)e));
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        try {
            if (serialNumber.compareTo(MINUS_ONE) > 0) {
                this.process(header, serialNumber, req, locale[0]);
            } else {
                error = new ECMSGWException(CMS.getLogMessage((String)"CMSGW_INVALID_SERIAL_NUMBER", (Object[])new Object[0]));
            }
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError((EBaseException)((Object)error));
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_BAD_SERV_OUT_STREAM", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_DISPLAY_TEMPLATE", (Object[])new Object[0]), (Exception)e);
        }
    }

    private void process(ArgBlock header, BigInteger seq, HttpServletRequest req, Locale locale) throws EBaseException {
        String[] certType = new String[1];
        try {
            this.getCertRecord(seq, certType);
            if (certType[0].equalsIgnoreCase("x509")) {
                this.processX509(header, seq, req, locale);
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_DISP_BY_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw e;
        }
    }

    private void processX509(ArgBlock header, BigInteger seq, HttpServletRequest req, Locale locale) throws EBaseException {
        block30: {
            boolean b64CertOnly = false;
            String isB64CertOnly = req.getParameter("b64CertOnly");
            if (isB64CertOnly != null && isB64CertOnly.equals("true")) {
                b64CertOnly = true;
            }
            try {
                CRLExtensions crlExts;
                CertRecord rec = this.mCertDB.readCertificateRecord(seq);
                if (rec == null) {
                    logger.error("DisplayBySerial: failed to read record");
                    throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_ISSUED_CERT", (Object[])new Object[0]));
                }
                X509CertImpl cert = rec.getCertificate();
                if (cert == null) {
                    logger.error("DisplayBySerial: no certificate in record");
                    throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_ISSUED_CERT", (Object[])new Object[0]));
                }
                try {
                    String rid;
                    X509CertInfo info = (X509CertInfo)cert.get("x509.info");
                    if (info == null) {
                        logger.error("DisplayBySerial: no info found");
                        throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_ISSUED_CERT", (Object[])new Object[0]));
                    }
                    CertificateExtensions extensions = (CertificateExtensions)info.get("extensions");
                    boolean emailCert = false;
                    if (extensions != null) {
                        for (int i = 0; i < extensions.size(); ++i) {
                            NSCertTypeExtension type;
                            Extension ext = (Extension)extensions.elementAt(i);
                            if (ext instanceof NSCertTypeExtension && ((Boolean)(type = (NSCertTypeExtension)ext).get("email")).booleanValue()) {
                                emailCert = true;
                            }
                            if (!(ext instanceof KeyUsageExtension)) continue;
                            KeyUsageExtension usage = (KeyUsageExtension)ext;
                            try {
                                if (!((Boolean)usage.get("digital_signature")).booleanValue() && !((Boolean)usage.get("data_encipherment")).booleanValue()) continue;
                                emailCert = true;
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }
                    header.addBooleanValue("emailCert", emailCert);
                    boolean noCertImport = true;
                    MetaInfo metaInfo = (MetaInfo)rec.get("certMetaInfo");
                    if (metaInfo != null && (rid = (String)metaInfo.get("requestId")) != null) {
                        Request r = this.requestRepository.readRequest(new RequestId(rid));
                        String certType = r.getExtDataInString("HTTP_PARAMS", "certType");
                        if (certType != null && certType.equals("client")) {
                            noCertImport = false;
                        }
                        header.addStringValue("reqId", rid);
                    }
                    header.addBooleanValue("noCertImport", noCertImport);
                }
                catch (Exception e) {
                    logger.warn(CMS.getLogMessage((String)"CMSGW_ERROR_PARSING_EXTENS", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
                byte[] ba = cert.getEncoded();
                header.addStringValue("certChainBase64", Utils.base64encode((byte[])ba, (boolean)true));
                RevocationInfo revocationInfo = rec.getRevocationInfo();
                if (revocationInfo != null && (crlExts = revocationInfo.getCRLEntryExtensions()) != null) {
                    Enumeration enumx = crlExts.getElements();
                    int reason = 0;
                    while (enumx.hasMoreElements()) {
                        Extension ext = (Extension)enumx.nextElement();
                        if (!(ext instanceof CRLReasonExtension)) continue;
                        CRLReasonExtension crlReasonExtension = (CRLReasonExtension)ext;
                        reason = crlReasonExtension.getReason().getCode();
                    }
                    header.addIntegerValue("revocationReason", reason);
                }
                if (!b64CertOnly) {
                    CertPrettyPrint certDetails = new CertPrettyPrint((Certificate)cert);
                    header.addStringValue("certPrettyPrint", certDetails.toString(locale));
                }
                header.addStringValue("authorityid", "ca");
                if (!b64CertOnly) {
                    String certFingerprints = "";
                    try {
                        certFingerprints = CertUtils.getFingerPrints((Certificate)cert);
                    }
                    catch (Exception e) {
                        logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_DIGESTING_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    if (certFingerprints.length() > 0) {
                        header.addStringValue("certFingerprint", certFingerprints);
                    }
                }
                header.addStringValue("serialNumber", seq.toString(16));
                X509CertImpl[] certsInChain = new X509CertImpl[1];
                if (this.mCACerts != null) {
                    for (int i = 0; i < this.mCACerts.length; ++i) {
                        if (cert.equals((Object)this.mCACerts[i])) {
                            certsInChain = new X509CertImpl[this.mCACerts.length];
                            break;
                        }
                        certsInChain = new X509CertImpl[this.mCACerts.length + 1];
                    }
                }
                certsInChain[0] = cert;
                if (this.mCACerts != null) {
                    for (int i = 0; i < this.mCACerts.length; ++i) {
                        if (cert.equals((Object)this.mCACerts[i])) continue;
                        certsInChain[i + 1] = (X509CertImpl)this.mCACerts[i];
                    }
                }
                if (b64CertOnly) break block30;
                try {
                    PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])certsInChain, new SignerInfo[0]);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    p7.encodeSignedData((OutputStream)bos, false);
                    byte[] p7Bytes = bos.toByteArray();
                    String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
                    header.addStringValue("pkcs7ChainBase64", p7Str);
                }
                catch (Exception e) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_FORMING_PKCS7_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_FORMING_PKCS7", (Object[])new Object[0]), e);
                }
            }
            catch (EBaseException e) {
                logger.error(CMS.getLogMessage((String)"MSGW_ERR_DISP_BY_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw e;
            }
            catch (CertificateEncodingException e) {
                logger.error(CMS.getLogMessage((String)"CMSGW_ERR_ENCODE_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new ECMSGWException(CMS.getLogMessage((String)"CMSGW_ERROR_ENCODING_ISSUED_CERT", (Object[])new Object[0]), (Exception)e);
            }
        }
    }

    private CertRecord getCertRecord(BigInteger seq, String[] certtype) throws EBaseException {
        CertRecord rec = null;
        try {
            rec = this.mCertDB.readCertificateRecord(seq);
            X509CertImpl x509cert = rec.getCertificate();
            if (x509cert != null) {
                certtype[0] = "x509";
                return rec;
            }
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_DISP_BY_SERIAL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw e;
        }
        return rec;
    }

    private BigInteger getSerialNumber(HttpServletRequest req) throws NumberFormatException {
        String serialNumString = req.getParameter("serialNumber");
        if (serialNumString == null) {
            throw new NumberFormatException();
        }
        boolean isHex = (serialNumString = serialNumString.trim()).startsWith("0x") || serialNumString.startsWith("0X");
        return isHex ? new BigInteger(serialNumString.substring(2), 16) : new BigInteger(serialNumString);
    }
}

