/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.cert.ImportCertsTemplateFiller;
import com.netscape.cms.servlet.common.CAServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caRenewal", urlPatterns={"/renewal"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="successTemplate", value="/ca/RenewalSuccess.template"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caRenewal"), @WebInitParam(name="resourceID", value="certServer.ee.certificate"), @WebInitParam(name="AuthMgr", value="sslClientCertAuthMgr")})
public class RenewalServlet
extends CAServlet {
    public static Logger logger = LoggerFactory.getLogger(RenewalServlet.class);
    private static final long serialVersionUID = -3094124661102395244L;
    public static final String RENEWAL_SUCCESS_TEMPLATE = "RenewalSuccess.template";
    public static final String CERT_TYPE = "certType";
    public static final String SERIAL_NO = "serialNo";
    public static final String IMPORT_CERT = "importCert";
    private String mRenewalSuccessTemplate = "RenewalSuccess.template";
    private ICMSTemplateFiller mRenewalSuccessFiller = new ImportCertsTemplateFiller();

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mTemplates.remove(CMSRequest.SUCCESS);
        try {
            ICMSTemplateFiller filler;
            String fillername;
            this.mRenewalSuccessTemplate = sc.getInitParameter("successTemplate");
            if (this.mRenewalSuccessTemplate == null) {
                this.mRenewalSuccessTemplate = RENEWAL_SUCCESS_TEMPLATE;
            }
            if ((fillername = sc.getInitParameter("successTemplateFiller")) != null && (filler = this.newFillerObject(fillername)) != null) {
                this.mRenewalSuccessFiller = filler;
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_IMP_INIT_SERV_ERR", (Object[])new Object[]{e.toString(), this.mId}), (Throwable)e);
        }
    }

    protected void process(CMSRequest cmsReq) throws EBaseException {
        long startTime = new Date().getTime();
        ArgBlock httpParams = cmsReq.getHttpParams();
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        BigInteger old_serial_no = null;
        X509CertImpl old_cert = null;
        X509CertImpl renewed_cert = null;
        Date notBefore = null;
        Date notAfter = null;
        boolean doSaveAuthToken = false;
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "renew");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String authMgr = "noAuthManager";
        if (authToken != null && !this.mAuthMgr.equals("sslClientCertAuthMgr")) {
            authMgr = authToken.getInString("authMgrInstName");
        }
        if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
            cert = new X509Certificate[1];
            old_serial_no = this.getCertFromAgent(httpParams, (X509Certificate[])cert);
            old_cert = cert[0];
            int beginYear = httpParams.getValueAsInt("beginYear", -1);
            int beginMonth = httpParams.getValueAsInt("beginMonth", -1);
            int beginDate = httpParams.getValueAsInt("beginDate", -1);
            int endYear = httpParams.getValueAsInt("endYear", -1);
            int endMonth = httpParams.getValueAsInt("endMonth", -1);
            int endDate = httpParams.getValueAsInt("endDate", -1);
            if (beginYear != -1 && beginMonth != -1 && beginDate != -1 && endYear != -1 && endMonth != -1 && endDate != -1) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(beginYear, beginMonth, beginDate);
                notBefore = calendar.getTime();
                calendar.set(endYear, endMonth, endDate);
                notAfter = calendar.getTime();
            }
        } else {
            cert = new X509CertImpl[1];
            old_serial_no = this.getCertFromAuthMgr(authToken, (X509Certificate[])cert);
            old_cert = cert[0];
        }
        Request req = null;
        try {
            CertInfo new_certInfo = null;
            CAEngine engine = CAEngine.getInstance();
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            req = requestRepository.createRequest("renewal");
            req.setExtData("OLD_SERIALS", new BigInteger[]{old_serial_no});
            if (old_cert != null) {
                req.setExtData("OLD_CERTS", new X509CertImpl[]{old_cert});
                X509CertInfo old_certInfo = (X509CertInfo)old_cert.get("x509.info");
                new_certInfo = new X509CertInfo(old_certInfo.getEncodedInfo());
            } else {
                new_certInfo = new CertInfo();
                new_certInfo.set("serialNumber", (Object)new CertificateSerialNumber(old_serial_no));
            }
            if (notBefore == null || notAfter == null) {
                notBefore = new Date(0L);
                notAfter = new Date(0L);
            }
            new_certInfo.set("validity", (Object)new CertificateValidity(notBefore, notAfter));
            req.setExtData("CERT_INFO", new X509CertInfo[]{new_certInfo});
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SETTING_RENEWAL_VALIDITY_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SETTING_RENEWAL_VALIDITY_ERROR", (String[])new String[0]), (Exception)e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERROR_SETTING_RENEWAL_VALIDITY_1", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_SETTING_RENEWAL_VALIDITY_ERROR", (String[])new String[0]), (Exception)e);
        }
        this.saveHttpHeaders(httpReq, req);
        this.saveHttpParams(httpParams, req);
        if (doSaveAuthToken) {
            RenewalServlet.saveAuthToken((AuthToken)authToken, (Request)req);
        }
        cmsReq.setRequest(req);
        this.mRequestQueue.processRequest(req);
        Object initiative = null;
        String agentID = null;
        if (this.mAuthMgr != null && this.mAuthMgr.equals("certUserDBAuthMgr")) {
            agentID = authToken.getInString("userid");
            initiative = "fromAgent agentID: " + agentID;
        } else {
            initiative = "fromUser";
        }
        RequestStatus status = req.getRequestStatus();
        if (status != RequestStatus.COMPLETE) {
            cmsReq.setIRequestStatus();
            if (status == RequestStatus.REJECTED) {
                Vector messages = req.getExtDataInStringVector("errors");
                if (messages != null) {
                    Enumeration msgs = messages.elements();
                    StringBuffer wholeMsg = new StringBuffer();
                    while (msgs.hasMoreElements()) {
                        wholeMsg.append("\n");
                        wholeMsg.append((String)msgs.nextElement());
                    }
                    logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), "violation: " + wholeMsg});
                } else {
                    logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), ""});
                }
            } else {
                logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{req.getRequestId(), initiative, authMgr, status, old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), ""});
            }
            return;
        }
        Integer result = req.getExtDataInInteger("Result");
        logger.debug("RenewalServlet: Result for request " + req.getRequestId() + " is " + result);
        if (result.equals(Request.RES_ERROR)) {
            logger.debug("RenewalServlet: Result for request " + req.getRequestId() + " is error.");
            cmsReq.setStatus(CMSRequest.ERROR);
            cmsReq.setError(req.getExtDataInString("Error"));
            String[] svcErrors = req.getExtDataInStringArray("serviceErrors");
            if (svcErrors != null && svcErrors.length > 0) {
                for (int i = 0; i < svcErrors.length; ++i) {
                    String err = svcErrors[i];
                    if (err == null) continue;
                    cmsReq.setErrorDescription(err);
                    logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{req.getRequestId(), initiative, authMgr, "completed with error: " + err, old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), ""});
                }
            }
            return;
        }
        X509CertImpl[] certs = req.getExtDataInCertArray("issuedCerts");
        renewed_cert = certs[0];
        this.respondSuccess(cmsReq, renewed_cert);
        long endTime = new Date().getTime();
        logger.info("Renewal request reqID {} {} authenticated by {} is {}. DN requested: {} old serial number: 0x{} {}", new Object[]{req.getRequestId(), initiative, authMgr, "completed", old_cert.getSubjectName(), old_cert.getSerialNumber().toString(16), "new serial number: 0x" + renewed_cert.getSerialNumber().toString(16) + " time: " + (endTime - startTime)});
    }

    private void respondSuccess(CMSRequest cmsReq, X509CertImpl renewed_cert) throws EBaseException {
        cmsReq.setResult((Object)new X509CertImpl[]{renewed_cert});
        cmsReq.setStatus(CMSRequest.SUCCESS);
        ArgBlock httpParams = cmsReq.getHttpParams();
        if (this.checkImportCertToNav(cmsReq.getHttpResp(), httpParams, renewed_cert)) {
            return;
        }
        try {
            this.renderTemplate(cmsReq, this.mRenewalSuccessTemplate, this.mRenewalSuccessFiller);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGE_ERROR_DISPLAY_TEMPLATE_1", (Object[])new Object[]{this.mRenewalSuccessTemplate, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    protected BigInteger getRenewedCert(CertRecord certRec) throws EBaseException {
        BigInteger renewedCert = null;
        String serial = null;
        MetaInfo meta = certRec.getMetaInfo();
        if (meta == null) {
            logger.warn("RenewalServlet: no meta info in cert serial 0x" + certRec.getSerialNumber().toString(16));
            return null;
        }
        serial = (String)meta.get("renewedCertSerialNo");
        if (serial == null) {
            logger.warn("RenewalServlet: no renewed cert in cert 0x" + certRec.getSerialNumber().toString(16));
            return null;
        }
        renewedCert = new BigInteger(serial);
        logger.info("RenewalServlet: renewed cert serial 0x" + renewedCert.toString(16) + "found for 0x" + certRec.getSerialNumber().toString(16));
        return renewedCert;
    }

    private BigInteger getCertFromAgent(ArgBlock httpParams, X509Certificate[] certContainer) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certRepository = engine.getCertificateRepository();
        BigInteger serialno = null;
        X509CertImpl cert = null;
        serialno = httpParams.getValueAsBigInteger(SERIAL_NO, null);
        if (serialno == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SERIALNO_FOR_RENEW", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_SERIALNO_FOR_RENEW", (String[])new String[0]));
        }
        cert = certRepository.getX509Certificate(serialno);
        if (cert == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_SERIALNO_FOR_RENEW_1", (Object[])new Object[]{serialno.toString(16)}));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_FOR_RENEWAL", (String[])new String[0]));
        }
        certContainer[0] = cert;
        return serialno;
    }

    private BigInteger getCertFromAuthMgr(AuthToken authToken, X509Certificate[] certContainer) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certRepository = engine.getCertificateRepository();
        X509CertImpl cert = authToken.getInCert("tokenCert");
        if (cert == null) {
            logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CERTS_RENEW_FROM_AUTHMGR", (Object[])new Object[0]));
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CERTS_RENEW_FROM_AUTHMGR", (String[])new String[0]));
        }
        X509CertImpl certInDB = certRepository.getX509Certificate(cert.getSerialNumber());
        if (certInDB == null || !certInDB.equals((Object)cert)) {
            logger.error("RenewalServlet: certficate from auth manager for renewal is not from this ca");
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_CERT_FOR_RENEWAL", (String[])new String[0]));
        }
        certContainer[0] = cert;
        BigInteger serialno = cert.getSerialNumber();
        return serialno;
    }
}

