/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.KeyUsageExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueSubjectNameConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(UniqueSubjectNameConstraints.class);
    protected static final String PROP_PRE_AGENT_APPROVAL_CHECKING = "enablePreAgentApprovalChecking";
    protected static final String PROP_KEY_USAGE_EXTENSION_CHECKING = "enableKeyUsageExtensionChecking";
    public CertificateAuthority mCA;
    public boolean mPreAgentApprovalChecking = false;
    public boolean mKeyUsageExtensionChecking = true;

    public UniqueSubjectNameConstraints() {
        this.NAME = "UniqueSubjectName";
        this.DESC = "Ensure the uniqueness of the subject name.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enablePreAgentApprovalChecking;boolean;If checked, check subject name uniqueness BEFORE agent approves, (else checks AFTER approval)", "enableKeyUsageExtensionChecking;boolean;If checked, allow non-unique subject names if Key Usage Extension differs", "HELP_TOKEN;configuration-policyrules-uniquesubjectname", "HELP_TEXT;Rejects a request if there exists an unrevoked, unexpired certificate with the same subject name"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        if (certAuthority == null) {
            logger.error(CMS.getLogMessage((String)"CA_CANT_FIND_MANAGER", (Object[])new Object[0]));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Cannot find the Certificate Manager or Registration Manager"}));
        }
        this.mCA = certAuthority;
        try {
            this.mPreAgentApprovalChecking = config.getBoolean(PROP_PRE_AGENT_APPROVAL_CHECKING, false);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        try {
            this.mKeyUsageExtensionChecking = config.getBoolean(PROP_KEY_USAGE_EXTENSION_CHECKING, true);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
    }

    public PolicyResult apply(Request req) {
        CAEngine engine = CAEngine.getInstance();
        if (!this.mPreAgentApprovalChecking && !this.agentApproved(req)) {
            return PolicyResult.ACCEPTED;
        }
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfos = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfos == null) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfos.length; ++i) {
                CertificateSubjectName subName = (CertificateSubjectName)certInfos[i].get("subject");
                if (subName == null) {
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_SUBJECT_NAME", (String[])new String[]{this.getInstanceName()}), "");
                    return PolicyResult.REJECTED;
                }
                String certSubjectName = subName.toString();
                String filter = "x509Cert.subject=" + certSubjectName;
                Enumeration<CertRecord> matched = engine.getCertificateRepository().findCertRecords(filter);
                while (matched.hasMoreElements()) {
                    CertRecord rec = matched.nextElement();
                    String status = rec.getStatus();
                    if (status.equals("REVOKED") || status.equals("EXPIRED") || status.equals("REVOKED_EXPIRED") || this.mKeyUsageExtensionChecking && this.agentApproved(req) && !this.sameKeyUsageExtension(rec, certInfos[i])) continue;
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_NAME_EXIST", (String[])new String[]{this.getInstanceName() + " " + certSubjectName}), "");
                    return PolicyResult.REJECTED;
                }
            }
        }
        catch (Exception e) {
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    private boolean sameKeyUsageExtension(CertRecord rec, X509CertInfo certInfo) {
        X509CertImpl impl = rec.getCertificate();
        boolean[] bits = impl.getKeyUsage();
        CertificateExtensions extensions = null;
        try {
            extensions = (CertificateExtensions)certInfo.get("extensions");
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        KeyUsageExtension ext = null;
        if (extensions == null) {
            if (bits != null) {
                return false;
            }
        } else {
            try {
                ext = (KeyUsageExtension)extensions.get("KeyUsage");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ext == null) {
                if (bits != null) {
                    return false;
                }
            } else {
                boolean[] InfoBits = ext.getBits();
                if (InfoBits == null) {
                    if (bits != null) {
                        return false;
                    }
                } else {
                    if (bits == null) {
                        return false;
                    }
                    if (InfoBits.length != bits.length) {
                        return false;
                    }
                    for (int i = 0; i < InfoBits.length; ++i) {
                        if (InfoBits[i] == bits[i]) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> confParams = new Vector<String>();
        confParams.addElement("enablePreAgentApprovalChecking=" + this.mPreAgentApprovalChecking);
        confParams.addElement("enableKeyUsageExtensionChecking=" + this.mKeyUsageExtensionChecking);
        return confParams;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> defParams = new Vector<String>();
        defParams.addElement("enablePreAgentApprovalChecking=");
        defParams.addElement("enableKeyUsageExtensionChecking=");
        return defParams;
    }
}

