/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.main;

import java.util.ArrayList;
import org.dogtagpki.server.tps.main.AttributeSpec;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.TPSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSpec {
    public static Logger logger = LoggerFactory.getLogger(ObjectSpec.class);
    static final int DATATYPE_STRING = 0;
    static final int DATATYPE_INTEGER = 1;
    static final int DATATYPE_BOOL_FALSE = 2;
    static final int DATATYPE_BOOL_TRUE = 3;
    private long objectID;
    private long fixedAttributes;
    private ArrayList<AttributeSpec> attributeSpecs = new ArrayList();
    private int parseRead;

    public int getParseReadSize() {
        return this.parseRead;
    }

    public static void parseAttributes(String objectID, ObjectSpec objectSpec, TPSBuffer b) {
        int attribute_size;
        long fixedAttrs = 0L;
        int xclass = 0;
        int id = 0;
        for (int curpos = 7; curpos < b.size(); curpos += 6 + attribute_size) {
            long attribute_id = b.getLongFrom4Bytes(curpos);
            attribute_size = b.getIntFrom2Bytes(curpos + 4);
            byte type = 0;
            TPSBuffer data = new TPSBuffer();
            boolean found = false;
            switch ((int)attribute_id) {
                case 1: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x80L;
                    break;
                }
                case 2: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x100L;
                    break;
                }
                case 368: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x200L;
                    break;
                }
                case 268: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x400L;
                    break;
                }
                case 355: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x800L;
                    break;
                }
                case 260: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x1000L;
                    break;
                }
                case 261: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x2000L;
                    break;
                }
                case 262: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x4000L;
                    break;
                }
                case 263: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x8000L;
                    break;
                }
                case 264: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x10000L;
                    break;
                }
                case 265: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x20000L;
                    break;
                }
                case 266: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x40000L;
                    break;
                }
                case 267: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x80000L;
                    break;
                }
                case 259: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x100000L;
                    break;
                }
                case 357: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x200000L;
                    break;
                }
                case 354: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x400000L;
                    break;
                }
                case 356: {
                    if (b.at(curpos + 6) == 0) break;
                    fixedAttrs |= 0x800000L;
                    break;
                }
                case 257: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    break;
                }
                case 3: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    found = true;
                    break;
                }
                case 288: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    break;
                }
                case 258: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    break;
                }
                case 256: {
                    type = 1;
                    data = b.substr(curpos + 6, 4);
                    found = true;
                    break;
                }
                case 0: {
                    type = 1;
                    data = b.substr(curpos + 6, 4);
                    xclass = data.at(0);
                    break;
                }
                case 290: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    break;
                }
                case 128: {
                    type = 1;
                    data = b.substr(curpos + 6, 4);
                    break;
                }
                case 384: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    found = true;
                    break;
                }
                case 385: {
                    type = 0;
                    data = b.substr(curpos + 6, attribute_size);
                    found = true;
                    break;
                }
                default: {
                    logger.debug("ObjectSpec.parseKeyBlob skipped attribute_id = " + attribute_id);
                }
            }
            if (!found) continue;
            AttributeSpec attrSpec = new AttributeSpec();
            attrSpec.setAttributeID(attribute_id);
            attrSpec.setType(type);
            switch (type) {
                case 0: {
                    attrSpec.setData(data);
                    break;
                }
                case 1: {
                    attrSpec.setData(data);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
            objectSpec.addAttributeSpec(attrSpec);
        }
        int val = objectSpec.getObjectIndex();
        switch (objectID.charAt(0)) {
            case 'c': {
                id = val;
                break;
            }
            case 'k': {
                id = val % 2 != 0 ? (val - 1) / 2 : val / 2;
            }
        }
        objectSpec.setFixedAttributes(fixedAttrs | (long)(xclass << 4) | (long)id);
    }

    public static void parseCertificateAttributes(String objectID, ObjectSpec objectSpec, TPSBuffer b) {
        ObjectSpec.parseAttributes(objectID, objectSpec, b);
    }

    public static void parseKeyAttributes(String objectID, ObjectSpec objectSpec, TPSBuffer b) {
        ObjectSpec.parseAttributes(objectID, objectSpec, b);
    }

    public static void parseCertificateBlob(String objectID, ObjectSpec objectSpec, TPSBuffer b) {
        long fixedAttrs = 0L;
        int xclass = 0;
        int id = 0;
        AttributeSpec value = new AttributeSpec();
        value.setAttributeID(17L);
        value.setType((byte)0);
        value.setData(b);
        objectSpec.addAttributeSpec(value);
        fixedAttrs = 128L;
        xclass = 1;
        id = objectSpec.getObjectIndex();
        objectSpec.setFixedAttributes(fixedAttrs | (long)(xclass << 4) | (long)id);
    }

    public static ObjectSpec parseFromTokenData(long objid, TPSBuffer b) throws TPSException {
        String objectID = null;
        StringBuilder idBuilder = new StringBuilder();
        ObjectSpec o = new ObjectSpec();
        o.setObjectID(objid);
        char[] b1 = new char[]{(char)(objid >> 24 & 0xFFL), (char)(objid >> 16 & 0xFFL), (char)(objid >> 8 & 0xFFL), (char)(objid & 0xFFL)};
        idBuilder.append(b1[0]);
        idBuilder.append(b1[1]);
        idBuilder.append(b1[2]);
        idBuilder.append(b1[3]);
        objectID = idBuilder.toString();
        switch (b1[0]) {
            case 'c': {
                ObjectSpec.parseCertificateAttributes(objectID, o, b);
                break;
            }
            case 'k': {
                ObjectSpec.parseKeyAttributes(objectID, o, b);
                break;
            }
            case 'C': {
                ObjectSpec.parseCertificateBlob(objectID, o, b);
                break;
            }
            default: {
                logger.error("ObjectSpec::ParseKeyBlob unknown objectID = " + objectID.charAt(0));
                throw new TPSException("ObjectSpec parseFromToken data: Invalid object type, aborting..");
            }
        }
        return o;
    }

    public static ObjectSpec parse(TPSBuffer b, int offset) throws TPSException {
        int sum = 0;
        if (b.size() - offset < 10) {
            return null;
        }
        ObjectSpec o = new ObjectSpec();
        long id = b.getLongFrom4Bytes(offset);
        o.setObjectID(id);
        long attribute = b.getLongFrom4Bytes(offset + 4);
        o.setFixedAttributes(attribute);
        int count = b.getIntFrom2Bytes(offset + 8);
        sum += 10;
        int curpos = offset + 10;
        for (int i = 0; i < count; ++i) {
            int len = 0;
            switch (b.at(curpos + 4)) {
                case 0: {
                    len = 7 + b.getIntFrom2Bytes(curpos + 5);
                    break;
                }
                case 1: {
                    len = 9;
                    break;
                }
                case 2: {
                    len = 5;
                    break;
                }
                case 3: {
                    len = 5;
                    break;
                }
                default: {
                    logger.error("ObjectSpec::parse unknown DataType = " + b.at(curpos + 4));
                    throw new TPSException("ObjectSpec parse: Invalid data type, aborting..");
                }
            }
            TPSBuffer attr = b.substr(curpos, len);
            AttributeSpec attrSpec = AttributeSpec.parse(attr, 0);
            o.addAttributeSpec(attrSpec);
            curpos += len;
            sum += len;
        }
        o.setParseRead(sum);
        return o;
    }

    private void setParseRead(int nread) {
        this.parseRead = nread;
    }

    void setObjectID(long v) {
        this.objectID = v;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public void setFixedAttributes(long v) {
        this.fixedAttributes = v;
    }

    public long getFixedAttributes() {
        return this.fixedAttributes;
    }

    public int getAttributeSpecCount() {
        return this.attributeSpecs.size();
    }

    public AttributeSpec getAttributeSpec(int p) {
        return this.attributeSpecs.get(p);
    }

    public void addAttributeSpec(AttributeSpec p) {
        this.attributeSpecs.add(p);
    }

    public void removeAttributeSpec(int p) {
        this.attributeSpecs.remove(p);
    }

    TPSBuffer getData() {
        TPSBuffer data = new TPSBuffer();
        data.addLong4Bytes(this.objectID);
        data.addLong4Bytes(this.fixedAttributes);
        int attributeCount = this.getAttributeSpecCount();
        data.addInt2Bytes(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            AttributeSpec spec = this.getAttributeSpec(i);
            data.add(spec.getData());
        }
        return data;
    }

    public int getObjectIndex() {
        return ObjectSpec.getObjectIndex(this.objectID);
    }

    public static int getObjectIndex(long objectID) {
        char char_index = (char)(objectID >> 16 & 0xFFL);
        int index = -1;
        if (char_index >= '0' && char_index <= '9') {
            index = char_index - 48;
        }
        if (char_index >= 'A' && char_index <= 'Z') {
            index = char_index - 65 + 10;
        }
        if (char_index >= 'a' && char_index <= 'z') {
            index = char_index - 97 + 26;
        }
        if (index == -1) {
            index = 256 + char_index;
        }
        return index;
    }

    public char getObjectType() {
        return ObjectSpec.getObjectType(this.objectID);
    }

    public static char getObjectType(long objectID) {
        char type = '0';
        type = (char)(objectID >> 24 & 0xFFL);
        return type;
    }

    public static char getObjectIndexChar(long objectID) {
        char char_index = (char)(objectID >> 16 & 0xFFL);
        return char_index;
    }

    public static long createObjectID(char type, int index) {
        long id = 0L;
        if (type != 'c' && type != 'C' && type != 'k') {
            return 0L;
        }
        if (index > 61 || index < 0) {
            return 0L;
        }
        int indexChar = 48;
        long l1 = (type & 0xFF) << 24;
        if (index >= 0 && index <= 9) {
            indexChar = (char)(index + 48);
        }
        if (index >= 10 && index <= 35) {
            indexChar = (char)(index - 10 + 65);
        }
        if (index >= 36 && index <= 61) {
            indexChar = (char)(index - 26 + 97);
        }
        long l2 = (indexChar & 0xFF) << 16;
        id = l1 + l2;
        return id;
    }

    public String getAttrId() {
        return ObjectSpec.getAttrId(this.objectID);
    }

    public static String getAttrId(long objectID) {
        Object attrId = "";
        attrId = ObjectSpec.getObjectType(objectID) + String.valueOf(ObjectSpec.getObjectIndex(objectID));
        return attrId;
    }

    public static char getObjectType(String attrId) {
        long obj = ObjectSpec.createObjectID(attrId);
        return ObjectSpec.getObjectType(obj);
    }

    public static int getObjectIndex(String attrId) {
        long obj = ObjectSpec.createObjectID(attrId);
        return ObjectSpec.getObjectIndex(obj);
    }

    public static long createObjectID(String attrId) {
        long id = 0L;
        if (attrId == null) {
            return 0L;
        }
        int len = attrId.length();
        if (len < 2 || len > 3) {
            return 0L;
        }
        String indexStr = attrId.substring(1);
        char typeCh = attrId.charAt(0);
        int index = 0;
        try {
            index = Integer.parseInt(indexStr.trim());
        }
        catch (NumberFormatException nfe) {
            logger.warn("ObjectSpec.createObjectID(Str) bad object index string: " + nfe.getMessage(), (Throwable)nfe);
            return 0L;
        }
        id = ObjectSpec.createObjectID(typeCh, index);
        return id;
    }

    public static void main(String[] args) {
        String attr1 = "k0";
        String attr2 = "k10";
        String attr3 = "c27";
        String attr4 = "C37";
        long objectID1 = ObjectSpec.createObjectID(attr1);
        long objectID2 = ObjectSpec.createObjectID(attr2);
        long objectID3 = ObjectSpec.createObjectID(attr3);
        long objectID4 = ObjectSpec.createObjectID(attr4);
        System.out.println("objectID1: " + objectID1);
        System.out.println("objectID2: " + objectID2);
        System.out.println("objectID3: " + objectID3);
        System.out.println("objectID4: " + objectID4);
        System.out.println("\n");
        System.out.println("attr1 values: " + attr1 + "\n");
        char type1 = ObjectSpec.getObjectType(objectID1);
        System.out.println("type1: " + type1);
        int index1 = ObjectSpec.getObjectIndex(objectID1);
        System.out.println("index1: " + index1);
        System.out.println("index1 getAttrId: " + ObjectSpec.getAttrId(objectID1));
        System.out.println("\n");
        System.out.println("attr2 values: " + attr2 + "\n");
        char type2 = ObjectSpec.getObjectType(objectID2);
        System.out.println("type2: " + type2);
        int index2 = ObjectSpec.getObjectIndex(objectID2);
        System.out.println("index2: " + index2);
        System.out.println("index2 getAttrId: " + ObjectSpec.getAttrId(objectID2));
        System.out.println("\n");
        System.out.println("attr3 values: " + attr3 + "\n");
        char type3 = ObjectSpec.getObjectType(objectID3);
        System.out.println("type3: " + type3);
        int index3 = ObjectSpec.getObjectIndex(objectID3);
        System.out.println("index3: " + index3);
        System.out.println("index3 getAttrId: " + ObjectSpec.getAttrId(objectID3));
        System.out.println("\n");
        System.out.println("attr4 values: " + attr4 + "\n");
        char type4 = ObjectSpec.getObjectType(objectID4);
        System.out.println("type4: " + type4);
        int index4 = ObjectSpec.getObjectIndex(objectID4);
        System.out.println("index4: " + index4);
        System.out.println("index4 getAttrId: " + ObjectSpec.getAttrId(objectID4));
        System.out.println("\n");
        long test_id = 1798307840L;
        char testType = ObjectSpec.getObjectType(test_id);
        int testIndex = ObjectSpec.getObjectIndex(test_id);
        System.out.println("test_id: " + test_id + " testType: " + testType + " testIndex: " + testIndex);
        System.out.println("\n");
    }
}

