/* ====================================================================
 *
 *
 *   BSD LICENSE
 *
 *   Copyright(c) 2021 Intel Corporation.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 * ====================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <openssl/evp.h>
#include <openssl/err.h>
#include <openssl/async.h>
#include <openssl/objects.h>
#include <openssl/rsa.h>
#include <openssl/engine.h>
#include <openssl/bn.h>

#include "tests.h"
#include "../qat_utils.h"

/* Maximum RSA size supported */
#define RSA_SIZE 1024

#define RSA_PKCS1_OAEP_PADDING_SIZE  62
/* RSA data sizes in bytes */
/* RSA 1024 bit */
#define RSA_SIZE_1024                  128
#define HASH_DATA_SIZE_1024             25
#define HASH_DATA_SIZE_NO_PADDING_1024 128
/* RSA 2048 bit */
#define RSA_SIZE_2048                  256
#define HASH_DATA_SIZE_2048             50
#define HASH_DATA_SIZE_NO_PADDING_2048 256
/* RSA 4096 bit */
#define RSA_SIZE_4096                  512
#define HASH_DATA_SIZE_4096            100
#define HASH_DATA_SIZE_NO_PADDING_4096 512
/* RSA 8192 bit */
#define RSA_SIZE_8192                  1024
#define HASH_DATA_SIZE_8192            200
#define HASH_DATA_SIZE_NO_PADDING_8192 1024

static int padding[] = {
    RSA_NO_PADDING,
    RSA_PKCS1_PADDING,
    RSA_X931_PADDING,
    RSA_PKCS1_OAEP_PADDING
};

static const unsigned char rsaCrtCoefQInv_1024_KeyPair[] = {
    0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0,
    0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d,
    0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9,
    0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11,
    0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73,
    0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81,
    0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd,
    0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1
};

static const unsigned char rsaCrtCoefQInv_2048_KeyPair[] = {
    0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55,
    0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde,
    0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec,
    0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68,
    0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4,
    0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea,
    0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d,
    0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce,
    0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee,
    0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93,
    0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82,
    0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3,
    0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f,
    0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e,
    0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20,
    0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8
};

static const unsigned char rsaCrtCoefQInv_4096_KeyPair[] = {
    0x94, 0x13, 0xB8, 0x44, 0x05, 0x22, 0xCD, 0xC8,
    0x71, 0xFB, 0x20, 0xC0, 0x39, 0x90, 0xD6, 0xA7,
    0x82, 0x7F, 0x93, 0xE2, 0x5A, 0x8C, 0x96, 0x7D,
    0x4D, 0xDC, 0xFE, 0xDD, 0x89, 0x5B, 0x95, 0x3D,
    0xF9, 0xF3, 0xE6, 0xE4, 0x50, 0xE4, 0xF0, 0xE6,
    0xD3, 0xDB, 0x1E, 0x85, 0xC7, 0xCA, 0xCE, 0x6B,
    0xC6, 0x6E, 0x21, 0x3B, 0x61, 0x83, 0xC9, 0x31,
    0x8A, 0xB9, 0x9C, 0x0F, 0x87, 0x1A, 0xD7, 0x78,
    0xC8, 0xCD, 0x53, 0xCA, 0x0F, 0xA4, 0x2B, 0xFE,
    0x35, 0x44, 0x8B, 0x59, 0x1E, 0xE7, 0x5A, 0x04,
    0xCB, 0xFD, 0xC2, 0xD0, 0x95, 0x4F, 0x43, 0x58,
    0x7F, 0x00, 0x06, 0x20, 0x54, 0xD9, 0x9D, 0x49,
    0x4D, 0xDA, 0x19, 0xEE, 0xD5, 0x49, 0xA4, 0xAA,
    0xD1, 0xE1, 0xBA, 0xCF, 0x18, 0x58, 0x21, 0xB5,
    0x96, 0x06, 0x5E, 0x27, 0x82, 0x79, 0x0E, 0x6D,
    0x33, 0xD4, 0xE3, 0x58, 0xB9, 0xD5, 0x73, 0x20,
    0x7E, 0x21, 0x23, 0x97, 0x12, 0x84, 0x54, 0xBB,
    0x9B, 0xBB, 0xC1, 0xBE, 0x6F, 0xF1, 0xF3, 0x12,
    0xBA, 0x20, 0xD7, 0x51, 0xAA, 0x46, 0x96, 0x87,
    0x85, 0xAA, 0x50, 0xDB, 0x3C, 0x4D, 0xA1, 0x6E,
    0xAD, 0xF6, 0xB6, 0xB6, 0x73, 0xD2, 0xAE, 0x5C,
    0x96, 0x83, 0x25, 0x4E, 0x32, 0x9F, 0x3A, 0x89,
    0xB6, 0x1A, 0x28, 0x4C, 0xFE, 0x9E, 0x89, 0x4B,
    0x64, 0xB7, 0x89, 0xE2, 0xEE, 0xF9, 0x38, 0x5D,
    0x65, 0x9C, 0x66, 0x15, 0x74, 0x00, 0xA8, 0xBE,
    0xD2, 0x30, 0xA2, 0x25, 0xB4, 0x33, 0xDA, 0xD2,
    0xBD, 0x6C, 0xB3, 0xE0, 0x2C, 0x54, 0xE6, 0xF6,
    0x90, 0xA9, 0x0C, 0x44, 0xCC, 0xE9, 0x2A, 0x50,
    0xC7, 0x80, 0x5D, 0x40, 0xF3, 0x2D, 0x83, 0x60,
    0x27, 0x95, 0x57, 0x79, 0xBF, 0x0E, 0xC0, 0x23,
    0x75, 0x21, 0xA5, 0x78, 0xBC, 0xA2, 0x5E, 0x63,
    0xAF, 0x9D, 0xBC, 0x29, 0x10, 0x81, 0x4D, 0xFD
};

static const unsigned char rsaCrtCoefQInv_8192_KeyPair[] = {
    0x18, 0x2c, 0xbc, 0x37, 0x37, 0x3c, 0xa2, 0x29,
    0xce, 0x4d, 0x97, 0xd7, 0x33, 0x1c, 0x51, 0x38,
    0x03, 0xab, 0xb5, 0x0c, 0x08, 0x7a, 0xf2, 0x18,
    0x4d, 0xdd, 0x65, 0xf4, 0x36, 0x25, 0x7c, 0xe8,
    0xd8, 0xb5, 0xda, 0x18, 0xbc, 0x9c, 0x82, 0x40,
    0x0c, 0xb0, 0xcc, 0x90, 0xbe, 0xbb, 0x4a, 0x26,
    0x21, 0x89, 0x9d, 0xb8, 0x18, 0x0c, 0xc7, 0x42,
    0x67, 0xcb, 0xc6, 0x1c, 0x9d, 0x64, 0xf3, 0x15,
    0x03, 0x6c, 0xf3, 0xbd, 0x65, 0xbb, 0x32, 0x94,
    0x52, 0x6f, 0x44, 0x53, 0x0c, 0x37, 0xc7, 0x7d,
    0xe4, 0x8a, 0xd0, 0x37, 0xca, 0xcd, 0x76, 0x49,
    0xb2, 0xac, 0x64, 0xcc, 0xa2, 0xff, 0x3e, 0x08,
    0x93, 0xa7, 0xf5, 0x9e, 0xd2, 0x72, 0x28, 0xeb,
    0xb0, 0x1f, 0xf3, 0x63, 0x9e, 0xe8, 0x80, 0x7c,
    0xe6, 0x10, 0x83, 0x71, 0xf6, 0xa4, 0x95, 0xbd,
    0x8e, 0xf1, 0xdb, 0xdb, 0x33, 0x74, 0x45, 0x3a,
    0x6f, 0xfa, 0x14, 0xc1, 0x8a, 0xb5, 0xa7, 0xa5,
    0x45, 0x10, 0xcd, 0x0b, 0xca, 0x52, 0xa8, 0xa9,
    0xcd, 0x92, 0xf0, 0x17, 0x83, 0xca, 0x0c, 0x68,
    0xf5, 0x30, 0xd8, 0xd1, 0x70, 0x2b, 0x73, 0xdb,
    0xfa, 0xf2, 0x85, 0xeb, 0xa5, 0x04, 0x97, 0x7d,
    0x33, 0xcf, 0xd3, 0x40, 0x4d, 0x69, 0xd5, 0x83,
    0x9a, 0x08, 0x44, 0xcc, 0x40, 0xa7, 0x07, 0x89,
    0x93, 0x7d, 0xa8, 0x39, 0x8e, 0x75, 0x01, 0xf0,
    0xb6, 0x7c, 0x24, 0x55, 0x17, 0x74, 0x00, 0xa5,
    0xe9, 0x79, 0xf8, 0x0a, 0x62, 0xba, 0xa5, 0xce,
    0x80, 0xaf, 0xb2, 0xd3, 0x7d, 0x46, 0x21, 0x31,
    0xc3, 0xe2, 0x75, 0x77, 0xdd, 0xd5, 0xb1, 0xe5,
    0x58, 0xec, 0x42, 0x6d, 0xe6, 0x48, 0xdb, 0x9c,
    0xe6, 0x9b, 0x58, 0xcd, 0x2e, 0xf0, 0xc9, 0x1d,
    0x8c, 0x63, 0x80, 0xd2, 0x5f, 0x25, 0x86, 0x11,
    0x88, 0x36, 0x65, 0x7a, 0x89, 0x8e, 0x7b, 0xb0,
    0x6b, 0xcf, 0x02, 0xa7, 0x41, 0xf1, 0xa9, 0xac,
    0x4c, 0x74, 0x66, 0xb2, 0x4d, 0x20, 0x48, 0x07,
    0xbe, 0x06, 0x05, 0xf0, 0x0e, 0x46, 0xa8, 0xf5,
    0xb8, 0xae, 0xe9, 0x7d, 0xf3, 0x31, 0x34, 0xf7,
    0x61, 0xc7, 0x6c, 0x59, 0x1b, 0x96, 0xeb, 0x68,
    0xff, 0x4c, 0x39, 0xac, 0xb1, 0x91, 0xa6, 0x94,
    0x9a, 0x7c, 0x21, 0x80, 0xb2, 0x23, 0x1a, 0x46,
    0x5c, 0x4b, 0x37, 0x54, 0x53, 0x11, 0xf8, 0xf5,
    0x7f, 0xc1, 0x85, 0x55, 0xaa, 0x7e, 0x99, 0x22,
    0x5e, 0xaa, 0x38, 0x22, 0x15, 0xa5, 0x7c, 0x72,
    0x46, 0xcf, 0xe3, 0xb9, 0x85, 0x22, 0x74, 0x72,
    0x2f, 0x47, 0xcc, 0x03, 0xfe, 0xd7, 0xfe, 0xac,
    0x6c, 0x8c, 0xdd, 0xf7, 0xd8, 0x2e, 0x70, 0x72,
    0x02, 0x1f, 0xdb, 0x89, 0x73, 0x23, 0xf8, 0x38,
    0xe4, 0xde, 0x30, 0xe0, 0x8c, 0x0f, 0x06, 0xb2,
    0x51, 0xb6, 0xc1, 0x9f, 0xd3, 0x13, 0x0c, 0xaa,
    0x36, 0xd3, 0x7a, 0x84, 0x84, 0x8e, 0xe1, 0x1a,
    0xd1, 0x0a, 0x32, 0x2d, 0xf7, 0x77, 0xa5, 0x63,
    0xc8, 0xe3, 0xc1, 0x76, 0xbb, 0x64, 0x6b, 0xcb,
    0x1c, 0x12, 0x84, 0x45, 0x63, 0x10, 0xc5, 0x03,
    0x48, 0x92, 0xfc, 0x01, 0xaf, 0x8e, 0xe4, 0x13,
    0x57, 0xa6, 0x95, 0x03, 0x49, 0xf3, 0xa8, 0x42,
    0x42, 0x95, 0x8b, 0xd4, 0xba, 0x73, 0xaf, 0x21,
    0x86, 0xfd, 0xef, 0x02, 0x44, 0x28, 0x65, 0x88,
    0xbd, 0x1b, 0xdb, 0x0f, 0xdf, 0x31, 0xd2, 0xa6,
    0x87, 0x7f, 0xd8, 0x50, 0x08, 0x6a, 0xd1, 0x89,
    0x11, 0x43, 0x40, 0x76, 0x8f, 0x54, 0xe7, 0xfd,
    0x8a, 0x95, 0x2b, 0x20, 0xa2, 0x9c, 0xba, 0x13,
    0xfd, 0xe1, 0xd9, 0xe5, 0x36, 0x7b, 0x7d, 0x97,
    0x0b, 0xd8, 0xce, 0xb4, 0x1e, 0x54, 0xaa, 0x02,
    0x17, 0x34, 0xab, 0x58, 0x42, 0x73, 0x1e, 0xa8,
    0x39, 0x6d, 0x2b, 0x4b, 0xf5, 0x6c, 0xd0, 0x37};


static const unsigned char rsaCrtExpDq_1024_KeyPair[] = {
    0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67,
    0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc,
    0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e,
    0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73,
    0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda,
    0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a,
    0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99,
    0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83
};

static const unsigned char rsaCrtExpDq_2048_KeyPair[] = {
    0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03,
    0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8,
    0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d,
    0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6,
    0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac,
    0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8,
    0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4,
    0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92,
    0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28,
    0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60,
    0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f,
    0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c,
    0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21,
    0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b,
    0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba,
    0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49
};

static const unsigned char rsaCrtExpDq_4096_KeyPair[] = {
    0x2A, 0x38, 0xD4, 0x7A, 0x18, 0x8D, 0xCE, 0xFA,
    0x18, 0xD4, 0x6D, 0x2A, 0x8A, 0xD7, 0xD7, 0xA7,
    0x94, 0x54, 0x4C, 0x09, 0x2E, 0x57, 0xD0, 0x01,
    0x7E, 0x59, 0xE2, 0x18, 0xD7, 0xAE, 0xB5, 0x14,
    0x00, 0xAA, 0x6E, 0xDA, 0x3A, 0x35, 0x39, 0x05,
    0xC7, 0x31, 0xA0, 0xCA, 0xBB, 0x05, 0x34, 0x48,
    0x18, 0xCF, 0x3A, 0xDC, 0x66, 0xA4, 0xBE, 0xB0,
    0x6B, 0x13, 0x0E, 0x7F, 0x26, 0x60, 0xF8, 0xC3,
    0x5A, 0x6A, 0x20, 0xB4, 0x45, 0x47, 0xCC, 0x10,
    0x8A, 0x2C, 0xFD, 0x23, 0xC2, 0x77, 0x1E, 0x78,
    0xCC, 0xAF, 0x46, 0x89, 0x7E, 0xFE, 0xE7, 0x4F,
    0x6F, 0x3C, 0xA4, 0xE9, 0xE0, 0xBA, 0xBA, 0x88,
    0xE1, 0x81, 0x59, 0x60, 0xE8, 0xDE, 0x0A, 0xE7,
    0xB7, 0xB3, 0x4C, 0xCD, 0x7A, 0x35, 0x54, 0x8A,
    0x23, 0x70, 0x8F, 0x0A, 0xED, 0x46, 0x3A, 0x83,
    0x3C, 0x33, 0x98, 0xDA, 0x80, 0x71, 0x21, 0x6F,
    0xE4, 0x8D, 0x6C, 0x60, 0x50, 0x7B, 0x97, 0xF7,
    0x7C, 0x8E, 0x18, 0x24, 0x69, 0xB2, 0x2B, 0x76,
    0x95, 0x89, 0xD1, 0xD3, 0x93, 0x5E, 0x78, 0xB0,
    0xA0, 0x1C, 0x9D, 0x64, 0xD4, 0xEE, 0xD4, 0xF6,
    0x17, 0x3A, 0x84, 0x0F, 0x87, 0xEA, 0x85, 0x2A,
    0xDC, 0x77, 0x24, 0x53, 0x13, 0xAC, 0x97, 0xCD,
    0xC3, 0x2D, 0xDF, 0x1A, 0x1E, 0x3D, 0xC3, 0x3D,
    0x75, 0xDF, 0x08, 0xA8, 0xD4, 0x91, 0xF2, 0x8C,
    0x09, 0x4C, 0x43, 0xF7, 0xC1, 0xB3, 0xAE, 0xC4,
    0xC8, 0x6F, 0x80, 0x0C, 0x60, 0xB6, 0x3D, 0xFF,
    0x84, 0xAA, 0xDA, 0x33, 0x2C, 0x59, 0x54, 0xE7,
    0x07, 0x1B, 0x72, 0x74, 0x73, 0x13, 0x5E, 0x2D,
    0x6B, 0x35, 0xCB, 0x56, 0xE0, 0x03, 0xA6, 0xBF,
    0xA5, 0xB0, 0xC6, 0x53, 0x0E, 0x27, 0x12, 0x6D,
    0xED, 0x24, 0x17, 0x9F, 0x11, 0x18, 0x1C, 0xB8,
    0xE2, 0x73, 0x20, 0xEE, 0x63, 0x4D, 0x68, 0x4F
};

static const unsigned char rsaCrtExpDq_8192_KeyPair[] = {
    0x5a, 0xda, 0xbc, 0x9d, 0x7f, 0x7c, 0x15, 0x44,
    0xf4, 0x99, 0xf2, 0x6b, 0x22, 0xf0, 0x10, 0x4f,
    0xc4, 0x77, 0x36, 0x97, 0xef, 0xfe, 0x09, 0x7e,
    0x83, 0x47, 0xaf, 0xc5, 0xbf, 0xbb, 0x35, 0x25,
    0x46, 0x91, 0xf7, 0x2c, 0x87, 0x76, 0xc3, 0x68,
    0x91, 0x69, 0x88, 0x5b, 0xeb, 0xcc, 0x8e, 0x72,
    0xcf, 0x47, 0x79, 0x52, 0x01, 0x76, 0x5c, 0xab,
    0x18, 0xce, 0x7f, 0x6e, 0xd2, 0x5a, 0x04, 0x94,
    0x67, 0xe4, 0xbf, 0xfe, 0x1f, 0x2e, 0x55, 0x7e,
    0xd2, 0x98, 0x2d, 0x7e, 0xc5, 0x96, 0xab, 0x10,
    0xc6, 0x67, 0xfe, 0xf9, 0xa0, 0xa1, 0xb7, 0xf2,
    0x3a, 0x5e, 0xd0, 0x7b, 0x17, 0xcc, 0x52, 0xcd,
    0x18, 0xa2, 0x1c, 0x42, 0x3a, 0xfa, 0x70, 0x8c,
    0x8d, 0x15, 0x7a, 0x26, 0x38, 0xba, 0xcf, 0x7a,
    0x8e, 0x49, 0xb0, 0xb1, 0x36, 0xa8, 0x06, 0x13,
    0xd8, 0x7a, 0x3b, 0x39, 0x9b, 0xc3, 0xc1, 0x9e,
    0x60, 0xef, 0x55, 0xa2, 0x8d, 0xc8, 0x02, 0xaa,
    0xcd, 0xc0, 0xef, 0x9d, 0xc8, 0x5d, 0x34, 0x04,
    0x35, 0x59, 0x27, 0x40, 0xa6, 0x1b, 0xdc, 0xc9,
    0xdd, 0x68, 0x17, 0x71, 0xe7, 0xd1, 0x1c, 0x83,
    0x76, 0x70, 0x06, 0x95, 0xd5, 0xbb, 0x7c, 0xf6,
    0x19, 0x5e, 0xe9, 0x7a, 0x72, 0x1e, 0xca, 0x8f,
    0x14, 0x8a, 0x8c, 0x21, 0xc1, 0xa0, 0x75, 0xd1,
    0xf2, 0xda, 0x72, 0xfb, 0xba, 0x53, 0x8a, 0xaa,
    0x24, 0xa2, 0xfb, 0x72, 0x18, 0xe4, 0xe2, 0xe6,
    0xbb, 0x6e, 0x50, 0x25, 0x84, 0x08, 0x61, 0x1f,
    0x5c, 0x6d, 0x83, 0xf2, 0x41, 0x92, 0xd1, 0x86,
    0xdc, 0xb7, 0x38, 0x94, 0xc0, 0xf8, 0x57, 0x7a,
    0xf7, 0x03, 0x51, 0x1d, 0x73, 0x5d, 0x72, 0x74,
    0x2d, 0x75, 0x6f, 0xee, 0x30, 0xd9, 0x9b, 0xc3,
    0x3e, 0x75, 0xeb, 0xe7, 0xc1, 0x85, 0xbb, 0x0d,
    0xfa, 0x3a, 0x62, 0xe8, 0x89, 0x2c, 0x91, 0xa5,
    0xce, 0xd5, 0x77, 0x78, 0x87, 0x32, 0xdf, 0xe3,
    0xa1, 0x38, 0xde, 0x71, 0x21, 0x90, 0x41, 0xf4,
    0xca, 0xa1, 0x7f, 0xbe, 0x19, 0x86, 0x56, 0x21,
    0xe3, 0x31, 0xc8, 0xe3, 0x58, 0x41, 0x3d, 0x57,
    0x24, 0x67, 0x56, 0x3a, 0x0e, 0x91, 0xee, 0xba,
    0xf3, 0x26, 0x11, 0xd9, 0xef, 0xeb, 0xad, 0xdd,
    0x9b, 0xc8, 0x15, 0xa4, 0x1c, 0x9b, 0x0b, 0x9f,
    0x89, 0x9f, 0xa4, 0xcc, 0xb7, 0x85, 0x34, 0x27,
    0x47, 0x11, 0x2b, 0x89, 0x66, 0x41, 0x3a, 0x99,
    0xae, 0x01, 0x0c, 0x97, 0xe9, 0xa8, 0x49, 0xef,
    0x33, 0x9a, 0x70, 0x48, 0xeb, 0x03, 0xc2, 0x03,
    0xad, 0x97, 0xde, 0x7a, 0x4d, 0x44, 0xf9, 0xfb,
    0x3b, 0x38, 0x5a, 0x23, 0xef, 0x31, 0x6f, 0xc2,
    0xb3, 0xeb, 0x3d, 0xa7, 0xca, 0x99, 0x75, 0x75,
    0xd2, 0x99, 0x80, 0x60, 0x24, 0x14, 0x02, 0xcf,
    0x39, 0xbc, 0xb6, 0x3d, 0x54, 0x89, 0x5a, 0x2b,
    0x0d, 0x99, 0x3c, 0xa6, 0x1f, 0x16, 0x54, 0xda,
    0x53, 0xb3, 0x24, 0xa8, 0xcc, 0x0c, 0xe9, 0x0e,
    0xfa, 0xe0, 0xeb, 0x17, 0x7d, 0x58, 0x8e, 0xe3,
    0x23, 0xc6, 0x9f, 0x2e, 0x7c, 0x4c, 0xdd, 0xe7,
    0x5e, 0xd1, 0x13, 0x5f, 0x66, 0x8c, 0x2a, 0xce,
    0x1f, 0x19, 0x55, 0x1a, 0x20, 0x6d, 0x15, 0xcd,
    0x62, 0xac, 0xab, 0xe6, 0xb1, 0x4c, 0xe8, 0xce,
    0x2d, 0x79, 0xb7, 0xa1, 0xb4, 0x77, 0xa4, 0x40,
    0x5d, 0x86, 0x7a, 0x56, 0x0e, 0x0e, 0x1c, 0xe4,
    0x09, 0x53, 0x7b, 0x5a, 0x50, 0x43, 0xc4, 0x9e,
    0x00, 0xa6, 0x1e, 0x1b, 0x09, 0x75, 0xa7, 0x04,
    0x49, 0xce, 0xad, 0x87, 0xf8, 0xab, 0x17, 0x7c,
    0x95, 0xd9, 0x50, 0x1d, 0x40, 0xc8, 0x6a, 0x3a,
    0xa0, 0x39, 0x85, 0xfb, 0x24, 0xf2, 0x1d, 0xb5,
    0x4d, 0x75, 0x7c, 0x5d, 0x37, 0x82, 0x4d, 0xb9,
    0x5a, 0x74, 0x2b, 0x50, 0x97, 0xb0, 0x5d, 0x49
};

static const unsigned char rsaCrtExpDp_1024_KeyPair[] = {
    0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5,
    0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04,
    0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c,
    0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3,
    0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f,
    0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d,
    0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37,
    0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1
};


static const unsigned char rsaCrtExpDp_2048_KeyPair[] = {
    0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15,
    0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91,
    0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4,
    0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff,
    0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61,
    0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b,
    0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18,
    0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63,
    0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27,
    0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78,
    0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c,
    0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6,
    0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0,
    0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef,
    0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84,
    0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1
};

static const unsigned char rsaCrtExpDp_4096_KeyPair[] = {
    0x64, 0x73, 0xFE, 0xD9, 0x52, 0xBA, 0x7B, 0xA6,
    0xF6, 0xB9, 0xAA, 0xB0, 0x74, 0xDA, 0x36, 0x78,
    0x76, 0x47, 0xE9, 0xC5, 0x12, 0xBD, 0xEF, 0xA9,
    0x29, 0xF0, 0x2B, 0x70, 0xDA, 0xA8, 0x23, 0x18,
    0x92, 0x18, 0x98, 0x9B, 0xE6, 0x2E, 0x14, 0x03,
    0x77, 0x0E, 0x61, 0x8F, 0x1E, 0x9B, 0x7B, 0xCB,
    0x23, 0xE8, 0xF4, 0x5D, 0xCB, 0x42, 0xD6, 0x2A,
    0x58, 0x37, 0xFA, 0x58, 0x46, 0x5A, 0x07, 0xF3,
    0x26, 0x29, 0x3C, 0xFE, 0x73, 0xD2, 0x0B, 0x66,
    0x3D, 0x66, 0x56, 0x1B, 0xEC, 0x8D, 0xD0, 0xED,
    0xE2, 0x38, 0x49, 0x3C, 0x4A, 0x62, 0xC2, 0xFC,
    0xCE, 0xDB, 0xAC, 0xAA, 0xC2, 0xB8, 0xCC, 0x2D,
    0x99, 0xC3, 0xCC, 0x00, 0x42, 0x31, 0x87, 0xB9,
    0xB1, 0x3A, 0xA3, 0x78, 0x04, 0x38, 0xF0, 0x16,
    0x01, 0xFC, 0x23, 0x05, 0x1E, 0x1F, 0xC3, 0xC1,
    0xAF, 0x5A, 0x19, 0x13, 0x8B, 0xB9, 0x64, 0x48,
    0x04, 0x6A, 0xA0, 0x25, 0xA6, 0xE5, 0xE8, 0x29,
    0x20, 0xA0, 0xFF, 0x0F, 0xAE, 0x06, 0xF7, 0x4C,
    0xAC, 0x64, 0x09, 0x24, 0x47, 0xA7, 0x00, 0x46,
    0x6E, 0xA9, 0x70, 0xBD, 0x6B, 0xAF, 0x70, 0xD7,
    0x63, 0xC2, 0x57, 0xFA, 0x68, 0xE0, 0x75, 0x66,
    0x43, 0x03, 0x2C, 0x61, 0xF5, 0x61, 0xC3, 0x92,
    0x04, 0x13, 0xD2, 0xC4, 0x9F, 0xF4, 0xA4, 0xA0,
    0x3D, 0xF6, 0x25, 0xB8, 0xDE, 0xCE, 0x5C, 0x53,
    0x91, 0x61, 0xDB, 0x60, 0x34, 0xE0, 0x5E, 0x3E,
    0xF4, 0x73, 0xB2, 0x45, 0xE5, 0xE3, 0x71, 0xFF,
    0x1C, 0xA9, 0xE6, 0x9F, 0xE4, 0xB9, 0xB4, 0xD7,
    0xE5, 0x60, 0xD7, 0xAC, 0x31, 0xFB, 0x19, 0xD6,
    0x2D, 0x11, 0x29, 0x55, 0x79, 0x8A, 0xF4, 0x99,
    0x0E, 0x69, 0x2A, 0xED, 0x5F, 0xC1, 0x59, 0xAE,
    0xAE, 0xC6, 0x66, 0x40, 0x23, 0xED, 0xED, 0x94,
    0x62, 0x78, 0x9C, 0xEB, 0x48, 0x04, 0x17, 0x85
};

static const unsigned char rsaCrtExpDp_8192_KeyPair[] = {
    0x26, 0x0f, 0x8f, 0x37, 0x1b, 0x58, 0x6e, 0xc1,
    0xd5, 0xbc, 0x10, 0x14, 0x1a, 0x64, 0xbf, 0xfb,
    0x92, 0xdc, 0x70, 0xde, 0x33, 0x20, 0xe6, 0xb6,
    0xb2, 0x58, 0x46, 0x73, 0xcf, 0x6f, 0x4b, 0xe7,
    0x1d, 0xb4, 0x7f, 0x54, 0x6d, 0x25, 0x65, 0x52,
    0x4d, 0xd1, 0x99, 0x33, 0x41, 0xac, 0x4b, 0x71,
    0xea, 0x89, 0xe4, 0x8d, 0xb2, 0x02, 0x9f, 0xbd,
    0x02, 0xd2, 0x03, 0x9b, 0x67, 0x23, 0x35, 0x20,
    0x6a, 0xd1, 0x0a, 0xf8, 0x7b, 0xe8, 0x20, 0x3d,
    0xb0, 0x5e, 0xfc, 0x4c, 0x2e, 0xaa, 0x04, 0xac,
    0x77, 0xd1, 0xb1, 0x73, 0x67, 0xf3, 0xab, 0x0b,
    0x46, 0x20, 0xf2, 0xbd, 0x88, 0xb0, 0x6f, 0x75,
    0xf4, 0xd4, 0xaf, 0x25, 0xea, 0xda, 0x9f, 0x6e,
    0xd6, 0xb2, 0xe0, 0x81, 0x72, 0xe1, 0xc8, 0xac,
    0xa4, 0xc7, 0xf3, 0x61, 0x7f, 0x11, 0x9f, 0x2a,
    0x5a, 0x52, 0x3d, 0x62, 0x0e, 0x3e, 0x85, 0x25,
    0x5f, 0x15, 0x51, 0x84, 0xde, 0x47, 0x3b, 0x21,
    0x83, 0x2f, 0x59, 0xf8, 0x62, 0xad, 0x0c, 0x81,
    0xef, 0x38, 0x03, 0x25, 0x4e, 0xad, 0xd8, 0x1c,
    0x7e, 0xa0, 0x5b, 0xdf, 0x8d, 0xd8, 0x5a, 0x62,
    0x43, 0xc9, 0x74, 0x6f, 0x24, 0x3c, 0x5d, 0x8d,
    0x4b, 0x3c, 0xd7, 0x88, 0x0a, 0xd0, 0x5b, 0x67,
    0x89, 0x44, 0xbc, 0x50, 0x34, 0x43, 0x46, 0x77,
    0xfd, 0x4c, 0x9b, 0x8b, 0xb1, 0x20, 0xc5, 0x9b,
    0xc4, 0x58, 0xb1, 0x23, 0xd4, 0xe9, 0xc9, 0x8c,
    0x35, 0x9f, 0xf5, 0x21, 0x59, 0x43, 0x74, 0x87,
    0x09, 0x38, 0x81, 0xeb, 0xea, 0xf6, 0x10, 0x53,
    0x93, 0x2a, 0xbd, 0x6a, 0x77, 0x83, 0xd4, 0x9c,
    0x8e, 0x9c, 0x1a, 0xbe, 0xe3, 0x65, 0x3d, 0x00,
    0x83, 0xa2, 0x1e, 0xff, 0x60, 0x0c, 0x6e, 0x3a,
    0xbd, 0xcf, 0x1a, 0xf4, 0x5c, 0x07, 0x63, 0xd6,
    0x20, 0xf6, 0x92, 0x02, 0x4e, 0x30, 0xfe, 0xe2,
    0x4d, 0x2c, 0x94, 0xee, 0x1f, 0x8f, 0x9f, 0x35,
    0x70, 0x4c, 0x09, 0x5c, 0x44, 0x37, 0xa3, 0xbe,
    0xd5, 0x85, 0x89, 0x91, 0x8e, 0x04, 0x80, 0xb6,
    0x8c, 0xb9, 0x45, 0xc0, 0xc9, 0xb8, 0x43, 0x3b,
    0xf3, 0x95, 0x37, 0x2a, 0x85, 0xdf, 0xae, 0x85,
    0x0f, 0x30, 0x9d, 0xb7, 0x51, 0x86, 0x17, 0xa3,
    0x84, 0x07, 0xea, 0xad, 0xcc, 0x23, 0xa2, 0xc3,
    0xa0, 0x4c, 0x21, 0x6c, 0x2a, 0x7b, 0x12, 0xed,
    0x11, 0xcc, 0xa7, 0x08, 0x29, 0x23, 0x39, 0x73,
    0x15, 0x78, 0xfd, 0x65, 0xa1, 0xcf, 0xb3, 0xbb,
    0x05, 0x66, 0x21, 0x83, 0xc3, 0x24, 0xf3, 0x6b,
    0x5e, 0x95, 0xa3, 0x5f, 0x3b, 0x93, 0xd2, 0xf8,
    0xec, 0x64, 0x78, 0xcd, 0x05, 0x40, 0x72, 0x7c,
    0xd9, 0xca, 0x1c, 0x3a, 0xea, 0x07, 0x9b, 0xe6,
    0xa5, 0x8c, 0xfb, 0xfd, 0x4c, 0xe5, 0x45, 0xf2,
    0xcd, 0xeb, 0xd9, 0x41, 0x42, 0x98, 0xbd, 0xe5,
    0x87, 0xb7, 0xec, 0xf9, 0x73, 0x3e, 0x8b, 0x75,
    0x2e, 0x33, 0xd7, 0xc9, 0xdb, 0x2a, 0x2a, 0xfb,
    0x90, 0x8e, 0x9f, 0xb6, 0x1e, 0x07, 0xc1, 0xf6,
    0xfe, 0x5c, 0x8c, 0x59, 0xd8, 0x82, 0xd8, 0x6c,
    0xdd, 0x78, 0x6a, 0xbf, 0x84, 0x92, 0x03, 0x6f,
    0x13, 0xa2, 0xc8, 0xde, 0x31, 0xe1, 0xfe, 0x30,
    0x01, 0x80, 0x66, 0x7e, 0x1c, 0x18, 0x5a, 0xeb,
    0xca, 0xbb, 0x3a, 0xee, 0x65, 0xfb, 0x12, 0xdf,
    0x26, 0xc3, 0x2d, 0x88, 0xf4, 0xb4, 0x28, 0xb2,
    0xf7, 0x72, 0x67, 0xde, 0x2e, 0x83, 0xa4, 0x51,
    0x76, 0x7d, 0xcf, 0xee, 0x70, 0xc1, 0xd4, 0x55,
    0x75, 0x20, 0x14, 0x79, 0x11, 0xdd, 0x72, 0x7b,
    0x89, 0xb6, 0xcd, 0x54, 0x2a, 0x12, 0x99, 0x23,
    0x11, 0x20, 0xdd, 0x8d, 0xdf, 0x47, 0x93, 0xb6,
    0x7a, 0xab, 0xa3, 0xa2, 0x16, 0x2b, 0x43, 0x70,
    0x5d, 0xf5, 0x77, 0x13, 0xf2, 0x51, 0xc0, 0x01
};

static const unsigned char rsaPrimeQ_1024_KeyPair[] = {
    0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30,
    0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7,
    0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed,
    0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c,
    0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64,
    0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe,
    0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0,
    0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77
};

static const unsigned char rsaPrimeQ_2048_KeyPair[] = {
    0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca,
    0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b,
    0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd,
    0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e,
    0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99,
    0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59,
    0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07,
    0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7,
    0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83,
    0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b,
    0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47,
    0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c,
    0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b,
    0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7,
    0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c,
    0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83
};

static const unsigned char rsaPrimeQ_4096_KeyPair[] = {
    0xD0, 0xB2, 0x39, 0x17, 0x5C, 0xE3, 0x20, 0x42,
    0xE0, 0xC0, 0x43, 0xF1, 0x67, 0x52, 0x96, 0xA0,
    0x85, 0xFE, 0x1D, 0x6A, 0x2E, 0x16, 0x53, 0x8C,
    0xD1, 0x48, 0x64, 0x9B, 0x58, 0x52, 0xE2, 0x11,
    0x4B, 0x71, 0x80, 0x14, 0x90, 0x55, 0x53, 0x2D,
    0x65, 0x7D, 0x21, 0xEE, 0x31, 0xD9, 0xDF, 0x8C,
    0xB7, 0x41, 0x4F, 0xB6, 0xD0, 0x81, 0x8A, 0x97,
    0xE8, 0x6F, 0x3E, 0x0A, 0x18, 0x72, 0x21, 0x54,
    0xCD, 0x76, 0x3E, 0x06, 0x19, 0xD5, 0xBE, 0x03,
    0x53, 0x57, 0x8C, 0x03, 0x9F, 0x49, 0x22, 0xD9,
    0x45, 0x9B, 0x01, 0x8A, 0x4A, 0xA6, 0xAB, 0x61,
    0x92, 0x73, 0x31, 0x39, 0xAA, 0x3F, 0x46, 0xB7,
    0x62, 0x7E, 0x22, 0x73, 0x27, 0xCF, 0xB9, 0xFC,
    0x61, 0xC1, 0x42, 0x87, 0xA2, 0xEA, 0x05, 0xE5,
    0xDB, 0x67, 0xFB, 0x1F, 0xE2, 0x0E, 0x8D, 0xC8,
    0xF2, 0xCA, 0x53, 0x69, 0x31, 0x98, 0x1F, 0x60,
    0x18, 0x0B, 0x4B, 0x28, 0xDA, 0x2C, 0xAF, 0xC2,
    0x4D, 0x88, 0x09, 0x29, 0x5F, 0x86, 0xB1, 0x73,
    0xA7, 0x1D, 0x8C, 0x38, 0x3F, 0x36, 0xD0, 0xC6,
    0x7F, 0x7E, 0x34, 0x5A, 0x04, 0xBE, 0x41, 0x64,
    0xBB, 0x4B, 0xBA, 0xEB, 0x0C, 0xFE, 0xBA, 0x30,
    0xE1, 0x3E, 0x34, 0x85, 0x60, 0x8D, 0x17, 0x14,
    0x59, 0x94, 0x93, 0xE5, 0x75, 0x68, 0x4F, 0x25,
    0x75, 0x7F, 0x1C, 0xC8, 0xFA, 0x47, 0xD8, 0x92,
    0xCF, 0xF2, 0xF8, 0xF4, 0x00, 0xEA, 0x7B, 0x27,
    0x32, 0xCD, 0xCA, 0x48, 0xA6, 0x67, 0xBB, 0xFE,
    0x6D, 0xFB, 0xC4, 0xE1, 0x68, 0x71, 0xDC, 0xAC,
    0x88, 0x83, 0xA1, 0x8B, 0x86, 0xF9, 0xE7, 0x57,
    0x0B, 0xDB, 0xE7, 0xC3, 0x35, 0x02, 0x77, 0x80,
    0x31, 0x20, 0x74, 0xD8, 0xB7, 0xD9, 0x8C, 0xE8,
    0x39, 0x58, 0x13, 0xAD, 0x74, 0x50, 0x0B, 0xC2,
    0x1F, 0x51, 0x37, 0x1D, 0x2D, 0xA8, 0x9B, 0x2B
};

static const unsigned char rsaPrimeQ_8192_KeyPair[] = {
    0xd2, 0xe0, 0x8d, 0x82, 0xd9, 0x07, 0x55, 0x20,
    0x0a, 0x24, 0xfb, 0x70, 0xb9, 0xed, 0x63, 0x8c,
    0x48, 0x73, 0x22, 0xa0, 0x48, 0x26, 0x87, 0x18,
    0x4e, 0x19, 0xa1, 0x9c, 0xfd, 0x6f, 0x0d, 0xbf,
    0xc5, 0x50, 0xab, 0xbd, 0xb1, 0x9f, 0x8f, 0x22,
    0x88, 0x4e, 0x47, 0x0e, 0xcc, 0x40, 0xca, 0x80,
    0x93, 0xe9, 0x97, 0xdb, 0xaf, 0xdb, 0x23, 0x15,
    0x0c, 0x29, 0xda, 0x54, 0xf3, 0x59, 0xd2, 0x12,
    0xc0, 0xf1, 0xbf, 0x1c, 0x3e, 0x58, 0x50, 0x31,
    0xaf, 0x55, 0xfc, 0xa7, 0x6e, 0x42, 0xce, 0xb5,
    0xb4, 0x6d, 0xdc, 0x8b, 0xfb, 0x75, 0xfa, 0x4e,
    0x48, 0x52, 0xc8, 0xc8, 0xd7, 0xa1, 0x83, 0xd6,
    0xc2, 0xbd, 0x6c, 0x95, 0x30, 0xbf, 0x4c, 0x2f,
    0x6a, 0x05, 0xf0, 0xcd, 0x4a, 0x51, 0x61, 0xdb,
    0x7f, 0x13, 0xd3, 0xff, 0xeb, 0xeb, 0x84, 0x39,
    0x49, 0x6b, 0xb4, 0xe4, 0x64, 0x81, 0x3a, 0x39,
    0xd4, 0xad, 0x8e, 0x11, 0xf2, 0x3e, 0x04, 0xbd,
    0x74, 0xc5, 0xfc, 0xb9, 0x76, 0x81, 0xdf, 0x02,
    0xce, 0x09, 0xc2, 0xcc, 0xbb, 0x88, 0xed, 0xf4,
    0x8f, 0x57, 0x0b, 0xa8, 0xcf, 0x77, 0xae, 0x14,
    0xb2, 0xbf, 0xd1, 0xa2, 0x09, 0xcd, 0xc2, 0x94,
    0x87, 0x88, 0xc8, 0xb4, 0xff, 0xaf, 0x50, 0x99,
    0x77, 0xf2, 0x14, 0x7e, 0x2f, 0x3c, 0xf5, 0x2d,
    0xaa, 0x29, 0x9d, 0x0c, 0xec, 0x27, 0xf0, 0x05,
    0xa6, 0xb0, 0x08, 0xe5, 0x18, 0x08, 0xf4, 0xae,
    0x7e, 0xe7, 0x43, 0x4e, 0xc5, 0x56, 0xd4, 0xa8,
    0xf9, 0xea, 0x51, 0x04, 0x00, 0xc5, 0x75, 0x7a,
    0xe3, 0x83, 0x95, 0x7c, 0xbb, 0x65, 0x26, 0x37,
    0xc3, 0x59, 0x1b, 0x2b, 0x85, 0xf4, 0xaa, 0x51,
    0x98, 0xdf, 0xf4, 0x23, 0x41, 0xe4, 0x9f, 0xf9,
    0xda, 0xdf, 0xda, 0x8d, 0x7c, 0x55, 0x1e, 0xf7,
    0xe3, 0x5a, 0x75, 0x05, 0x13, 0xf4, 0xc8, 0x7f,
    0xa8, 0xeb, 0x59, 0x73, 0x0f, 0x27, 0x57, 0x0f,
    0x7e, 0xdc, 0xb5, 0xda, 0xca, 0x97, 0xd7, 0x23,
    0x54, 0x03, 0x23, 0xef, 0x8b, 0xfd, 0x62, 0xc0,
    0xf2, 0x24, 0xbc, 0xeb, 0x28, 0x55, 0x33, 0xe6,
    0x56, 0xf3, 0x95, 0xae, 0x72, 0x0e, 0x43, 0xa4,
    0xc5, 0xba, 0xec, 0x3c, 0x37, 0x9c, 0x2d, 0x32,
    0xe5, 0x52, 0xe1, 0x52, 0x29, 0x8d, 0x8c, 0x1e,
    0x38, 0x7e, 0xa0, 0x30, 0x6a, 0xed, 0xca, 0xa8,
    0x4d, 0x65, 0x2b, 0x37, 0x3f, 0xbe, 0x26, 0x2d,
    0x8e, 0x26, 0x77, 0x1b, 0x00, 0x8b, 0xba, 0x70,
    0x09, 0xf3, 0xa1, 0xe2, 0x6f, 0xe2, 0xd0, 0xbd,
    0x98, 0x05, 0x9f, 0x30, 0xaa, 0x96, 0x6c, 0x6f,
    0xbe, 0xe6, 0x30, 0xec, 0xd3, 0xd7, 0x3a, 0x51,
    0x0d, 0x12, 0xc3, 0x7f, 0xfb, 0xf3, 0x17, 0x05,
    0xb1, 0xbb, 0x7c, 0x14, 0x7e, 0x88, 0x59, 0x63,
    0x5f, 0x86, 0x00, 0x74, 0x25, 0xec, 0x0a, 0xc6,
    0x4c, 0x8f, 0x45, 0x27, 0x2a, 0x25, 0x19, 0x6d,
    0xa2, 0xeb, 0x4b, 0xa6, 0x5b, 0x83, 0x95, 0x0d,
    0x20, 0xac, 0xad, 0xdc, 0x9b, 0xcc, 0x52, 0xca,
    0xbf, 0xef, 0x33, 0x12, 0x7d, 0xa7, 0xad, 0x35,
    0x19, 0x7f, 0xb6, 0x2a, 0xcf, 0x9e, 0x18, 0x3f,
    0x0c, 0x12, 0x50, 0xe7, 0x6c, 0xf8, 0xb1, 0xcc,
    0x12, 0x5e, 0x7e, 0xe3, 0x5c, 0x66, 0xcb, 0xd7,
    0x70, 0x75, 0x8c, 0x20, 0x2b, 0x2b, 0x20, 0x62,
    0xa8, 0xb2, 0xa4, 0xd5, 0x2c, 0x76, 0x9d, 0xa1,
    0x67, 0x19, 0x64, 0x66, 0x5f, 0xf1, 0x1a, 0x4f,
    0x08, 0xd9, 0x95, 0x51, 0x0c, 0xce, 0xdd, 0x3d,
    0x1d, 0x82, 0xcd, 0xfa, 0x2e, 0x60, 0x1b, 0x0d,
    0x23, 0xeb, 0x99, 0xa5, 0x20, 0x4a, 0xa9, 0x88,
    0xa2, 0xa7, 0x3d, 0xcd, 0x8b, 0x6a, 0xc1, 0x12,
    0xd9, 0xc3, 0xd0, 0xbb, 0xe4, 0x49, 0xe2, 0x70,
    0xb7, 0x31, 0x31, 0x41, 0x7c, 0xa7, 0x72, 0xa7
};

static const unsigned char rsaPrimeP_1024_KeyPair[] = {
    0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13,
    0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b,
    0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d,
    0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a,
    0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a,
    0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1,
    0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71,
    0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d
};


static const unsigned char rsaPrimeP_2048_KeyPair[] = {
    0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff,
    0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb,
    0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1,
    0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09,
    0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34,
    0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16,
    0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad,
    0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7,
    0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95,
    0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e,
    0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f,
    0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98,
    0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46,
    0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17,
    0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80,
    0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69
};

static const unsigned char rsaPrimeP_4096_KeyPair[] = {
    0xD9, 0x33, 0xBC, 0x12, 0x30, 0x71, 0xE8, 0x20,
    0x73, 0xF3, 0xEA, 0xCD, 0x2A, 0xF2, 0x06, 0x45,
    0xCD, 0xF7, 0xFE, 0x5A, 0x57, 0xE5, 0xF0, 0x59,
    0xAD, 0x46, 0x10, 0x30, 0xF8, 0x97, 0xBD, 0x62,
    0x2B, 0x8E, 0xC7, 0x32, 0x2D, 0x1E, 0x5F, 0xA7,
    0xFB, 0xF6, 0x23, 0xE4, 0x3B, 0x13, 0xAA, 0x72,
    0x5B, 0x6B, 0xC1, 0xD3, 0x92, 0x12, 0x4A, 0x10,
    0xA4, 0x58, 0x9A, 0x99, 0x48, 0xF1, 0x57, 0x16,
    0xBC, 0xDB, 0x6B, 0xE3, 0x27, 0xB7, 0xB1, 0xF5,
    0xF9, 0x0B, 0x99, 0xC9, 0xBB, 0x32, 0x3B, 0x97,
    0xC4, 0xBA, 0x1C, 0xDB, 0x4A, 0x4C, 0xE7, 0x8D,
    0xB0, 0x93, 0xCD, 0x4F, 0x78, 0xE4, 0xA4, 0x72,
    0xB6, 0xC0, 0x2D, 0xFB, 0x16, 0x06, 0x89, 0x5C,
    0x30, 0x36, 0x7F, 0xF6, 0x9A, 0xF9, 0xF0, 0x36,
    0xBF, 0x79, 0x2C, 0xF5, 0xE4, 0x2B, 0x53, 0xC7,
    0xBD, 0xE1, 0xE6, 0xE0, 0xDF, 0xE5, 0x60, 0xC9,
    0x6D, 0x6E, 0xBB, 0x89, 0xE1, 0xDC, 0x59, 0x85,
    0x22, 0x28, 0x2A, 0xB5, 0x7F, 0x81, 0xD3, 0xBD,
    0x57, 0x52, 0x42, 0xB9, 0xFD, 0x27, 0xF3, 0x01,
    0x53, 0x53, 0xE5, 0xE8, 0xB1, 0x45, 0xEB, 0xC0,
    0xDC, 0xC2, 0xC3, 0x8C, 0xAA, 0xF8, 0xF1, 0x01,
    0x81, 0xC2, 0xAD, 0x30, 0x01, 0x61, 0xFF, 0xCB,
    0xA1, 0xA7, 0xFB, 0x7A, 0x08, 0xE5, 0x5D, 0xB5,
    0x41, 0xE1, 0xED, 0xEA, 0xC9, 0xB8, 0x19, 0x8E,
    0xA2, 0x72, 0x55, 0x0D, 0x65, 0xC7, 0xA3, 0xF7,
    0x4E, 0x73, 0xD5, 0xD9, 0xCA, 0x99, 0x35, 0xE3,
    0xFB, 0x47, 0x5C, 0xF8, 0xF3, 0x53, 0xD9, 0x4B,
    0xFB, 0x8B, 0xF5, 0xC5, 0xAB, 0x29, 0x6F, 0x50,
    0x1C, 0x2B, 0xA2, 0xBE, 0x77, 0x4B, 0xB6, 0x2E,
    0x7A, 0x8D, 0xDF, 0x0C, 0x4D, 0xA0, 0x19, 0x45,
    0x58, 0x93, 0x12, 0x48, 0x25, 0xD2, 0x70, 0x14,
    0xF2, 0x57, 0xBB, 0x84, 0xBA, 0xAF, 0xB5, 0x37
};

static const unsigned char rsaPrimeP_8192_KeyPair[] = {
   0xd3, 0xd1, 0xda, 0x94, 0x67, 0x4b, 0x59, 0x9d,
   0x50, 0xa6, 0x63, 0x22, 0x50, 0x8a ,0x50, 0x01,
   0xcd, 0x0b, 0x36, 0x24, 0xf4, 0xd9, 0x9a, 0xf2,
   0xa1, 0xb7, 0x7e, 0xdf, 0x15, 0xa1, 0xfc, 0x50,
   0x35, 0x78, 0x48, 0x8a, 0xb4, 0xbc, 0x3a, 0x41,
   0x1c, 0x9b, 0x48, 0x74, 0x0f, 0xfd, 0x80, 0xa8,
   0x21, 0x4c, 0xd9, 0x8e, 0x67, 0x4f, 0xb0, 0xb0,
   0x0e, 0x3d, 0x5b, 0x6c, 0x0f, 0x46, 0x2d, 0xfd,
   0xe9, 0x6c, 0x4c, 0xba, 0x95, 0x94, 0x17, 0x15,
   0x3b, 0x0e, 0xe2, 0x54, 0x69, 0x86, 0xae, 0x66,
   0xe1, 0x59, 0xf0, 0xce, 0x77, 0x1c, 0x3d, 0x31,
   0xc3, 0xbe, 0x74, 0x24, 0x13, 0x16, 0x17, 0x18,
   0x70, 0xed, 0x4d, 0xcb, 0xb2, 0x19, 0x44, 0x61,
   0x2d, 0x41, 0x33, 0x39, 0x77, 0x06, 0xdc, 0x23,
   0xc5, 0x51, 0x38, 0x8d, 0x9e, 0x54, 0x22, 0xb1,
   0xf2, 0x03, 0x4c, 0x44, 0x6d, 0x3a, 0xdb, 0x37,
   0x0c, 0x68, 0x03, 0x5a, 0x15, 0x21, 0xf1, 0x94,
   0xd5, 0x3c, 0x75, 0xbb, 0xc0, 0xd0, 0x54, 0x7f,
   0xe8, 0x37, 0x5b, 0x12, 0x79, 0x75, 0xb6, 0x7c,
   0x52, 0x04, 0xbf, 0xff, 0x83, 0xff, 0x7b, 0xb5,
   0x86, 0x84, 0x01, 0x3a, 0xf8, 0x99, 0x15, 0x14,
   0x5d, 0x70, 0x0f, 0x69, 0x18, 0x2e, 0xbe, 0x6e,
   0xb5, 0xd4, 0xfd, 0xac, 0x2f, 0xba, 0x51, 0xfb,
   0xe8, 0x72, 0xa0, 0x87, 0x3b, 0x66, 0xc1, 0x50,
   0xe9, 0x7c, 0xfd, 0x24, 0x4e, 0x35, 0x88, 0x21,
   0x5f, 0x91, 0xa0, 0x07, 0x44, 0xf9, 0x57, 0xe1,
   0x57, 0xa4, 0x6a, 0x87, 0xee, 0xa6, 0xda, 0xa4,
   0xf2, 0x0c, 0xe1, 0xda, 0x31, 0xb3, 0xbd, 0xeb,
   0xe5, 0x67, 0xdb, 0x05, 0x86, 0x59, 0xbf, 0x6d,
   0xed, 0x46, 0x51, 0x6c, 0x80, 0x41, 0xb3, 0xa2,
   0x59, 0x41, 0xed, 0xfd, 0x05, 0x79, 0x0a, 0x61,
   0x7e, 0xe2, 0x7f, 0xd8, 0x5a, 0x28, 0xa1, 0xcf,
   0x91, 0x04, 0xea, 0x51, 0xd6, 0x36, 0x3b, 0xef,
   0xa4, 0x34, 0xbb, 0x4f, 0x99, 0x79, 0xe9, 0x88,
   0x33, 0x92, 0xc3, 0x48, 0xdc, 0x4e, 0x3b, 0xb7,
   0xf1, 0xbc, 0x3a, 0x4e, 0x3f, 0xd9, 0x53, 0x38,
   0xd8, 0x06, 0x7e, 0x9a, 0x5e, 0xd4, 0x9e, 0x04,
   0x1f, 0xc6, 0x8a, 0x9b, 0x76, 0x34, 0x5f, 0x83,
   0x62, 0x55, 0xe2, 0x8f, 0x1a, 0xd0, 0x52, 0xf0,
   0xc3, 0x20, 0x09, 0x92, 0x58, 0x81, 0x55, 0xbe,
   0x04, 0x09, 0x95, 0x52, 0x70, 0x3f, 0x5c, 0x4f,
   0xa0, 0xf5, 0x47, 0x9f, 0x49, 0x81, 0xdc, 0x0f,
   0x27, 0xad, 0x5e, 0x20, 0xcc, 0x03, 0xf8, 0x01,
   0xc8, 0x5e, 0xa6, 0xb6, 0xef, 0x05, 0xe1, 0xab,
   0x1d, 0xdb, 0x3e, 0x4b, 0x16, 0x8d, 0xbb, 0xc4,
   0x70, 0xd8, 0xd3, 0x96, 0x65, 0x9e, 0xbc, 0xd4,
   0xe6, 0xb0, 0x08, 0x92, 0x47, 0xb5, 0x47, 0x7a,
   0xdd, 0xe2, 0x3e, 0x32, 0xb1, 0x42, 0xcb, 0x17,
   0xc6, 0x34, 0x9f, 0xae, 0x9d, 0x0b, 0x1a, 0x2a,
   0xfe, 0x1b, 0xf4, 0xd1, 0xcd, 0xa7, 0x17, 0x14,
   0xc5, 0xc9, 0x65, 0xab, 0x14, 0xd2, 0xc8, 0x52,
   0x18, 0x13, 0xb6, 0x0d, 0x52, 0xb5, 0xee, 0xf3,
   0x42, 0x33, 0xa8, 0x2c, 0x28, 0xba, 0x9b, 0xd9,
   0x8b, 0x84, 0xcb, 0x26, 0xd7, 0xa8, 0x00, 0x64,
   0x2a, 0xca, 0x9b, 0xcb, 0x2f, 0xca, 0xef, 0x64,
   0xfe, 0x10, 0xd1, 0x99, 0xc2, 0x4a, 0xf9, 0x9d,
   0x14, 0x39, 0x7c, 0x17, 0x01, 0x54, 0x1e, 0x11,
   0x64, 0xfc, 0x81, 0xc0, 0x7c, 0x8f, 0xb6, 0xb8,
   0x3c, 0x28, 0x7c, 0xc9, 0xc1, 0x0c, 0xa1, 0xe5,
   0xc5, 0x56, 0x78, 0x32, 0xeb, 0x9e, 0xb4, 0x05,
   0x7b, 0x87, 0x75, 0x1b, 0xa3, 0xa0, 0x11, 0xdc,
   0xbe, 0xb1, 0xb5, 0xe2, 0xb6, 0xba, 0x26, 0xea,
   0x0d, 0x43, 0x70, 0xfe, 0x79, 0x55, 0x6d, 0x1f,
   0x55, 0xb1, 0x27, 0x29, 0x3f, 0x6d, 0x9d, 0xa1
};

static const unsigned char rsaPrivateExponentD_1024[] = {
    0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46,
    0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c,
    0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf,
    0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd,
    0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f,
    0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b,
    0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81,
    0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55,
    0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26,
    0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73,
    0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d,
    0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf,
    0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb,
    0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde,
    0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd,
    0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1
};

static const unsigned char rsaPrivateExponentD_2048[] = {
    0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54,
    0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85,
    0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5,
    0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59,
    0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd,
    0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0,
    0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9,
    0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d,
    0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b,
    0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80,
    0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2,
    0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe,
    0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58,
    0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19,
    0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb,
    0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10,
    0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8,
    0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2,
    0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a,
    0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64,
    0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0,
    0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1,
    0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49,
    0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43,
    0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e,
    0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87,
    0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5,
    0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01,
    0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3,
    0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e,
    0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09,
    0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79
};

static const unsigned char rsaPrivateExponentD_4096[] = {
    0x9D, 0x0E, 0xD2, 0x47, 0x6D, 0x75, 0x03, 0x44,
    0x57, 0xC1, 0x31, 0x0A, 0x81, 0xC4, 0xBA, 0xB9,
    0xF5, 0x22, 0x96, 0xAD, 0xF8, 0x64, 0x88, 0xB2,
    0x89, 0x82, 0x93, 0x34, 0xB5, 0x70, 0x03, 0x06,
    0x21, 0x99, 0xAD, 0xAF, 0x16, 0x24, 0x84, 0x3A,
    0x43, 0x1E, 0x18, 0x8F, 0x31, 0x24, 0x39, 0xC8,
    0x93, 0x4C, 0x40, 0x29, 0x14, 0xB5, 0xD3, 0xB8,
    0x94, 0x42, 0x10, 0x5C, 0x80, 0x81, 0xDE, 0xAE,
    0x90, 0x95, 0x33, 0xF9, 0x79, 0x62, 0x40, 0x64,
    0x7B, 0x1F, 0x5C, 0xA4, 0xF9, 0x44, 0x29, 0x75,
    0xC4, 0xF6, 0xDC, 0x4E, 0x91, 0xC2, 0x38, 0x62,
    0x40, 0x73, 0x99, 0x17, 0x54, 0x0C, 0x4E, 0xC2,
    0x13, 0x15, 0xA0, 0x06, 0x79, 0x04, 0x9C, 0x12,
    0xD9, 0x60, 0xA3, 0x88, 0x52, 0xA4, 0x41, 0x61,
    0xC3, 0xA3, 0x0E, 0x84, 0x8F, 0x7D, 0x2E, 0xD9,
    0x5D, 0xB4, 0xDF, 0x35, 0x06, 0xC1, 0x11, 0x0C,
    0x64, 0xBC, 0x40, 0xA2, 0xC8, 0x4A, 0x61, 0xC3,
    0xAF, 0x1E, 0x20, 0x81, 0xC9, 0x1D, 0xD2, 0xD9,
    0x0D, 0x8B, 0xA4, 0xA0, 0xA8, 0x35, 0xB1, 0x15,
    0x5F, 0xAD, 0x71, 0x91, 0x0A, 0x9F, 0xE4, 0x77,
    0x13, 0x35, 0x6D, 0xFB, 0x83, 0xF3, 0x4C, 0xA5,
    0xB2, 0xC2, 0x54, 0x82, 0xAA, 0x79, 0x1A, 0x11,
    0xA1, 0x7D, 0xE1, 0x8E, 0x84, 0xD6, 0x4E, 0xD8,
    0x50, 0x35, 0x72, 0x84, 0x57, 0x26, 0xC6, 0xA9,
    0xEB, 0xDE, 0x00, 0x71, 0x09, 0x21, 0xD9, 0x90,
    0x77, 0x44, 0xF3, 0x7A, 0x92, 0xCD, 0x06, 0xE0,
    0xC7, 0xE4, 0x50, 0x6D, 0x69, 0xB5, 0xBE, 0x63,
    0xC8, 0x80, 0x7A, 0x2A, 0xD4, 0x4D, 0x1D, 0x9A,
    0x30, 0xB4, 0xA7, 0xFC, 0x32, 0x6E, 0x94, 0xCA,
    0x72, 0x0B, 0x66, 0x5F, 0xAA, 0x1B, 0xE4, 0x1F,
    0x9F, 0xB6, 0xA5, 0x00, 0x97, 0x60, 0x7C, 0xCB,
    0x6D, 0xD1, 0x9D, 0x40, 0x0C, 0x7B, 0x5B, 0xF7,
    0xF1, 0xE0, 0x12, 0x21, 0x2F, 0x7D, 0x9A, 0x04,
    0x9A, 0x8B, 0x7E, 0x5E, 0x25, 0x5B, 0xB6, 0xE8,
    0x9C, 0x45, 0x49, 0x17, 0x94, 0x1D, 0x73, 0x30,
    0x0D, 0xF0, 0xED, 0x80, 0xCD, 0x7A, 0xEE, 0x7E,
    0x48, 0xD8, 0x89, 0x6A, 0xCB, 0x8D, 0xAE, 0xE1,
    0x0A, 0x80, 0xED, 0x90, 0x9B, 0x47, 0xAE, 0xF9,
    0x4C, 0xC5, 0x7E, 0x1B, 0xC7, 0xF3, 0x8B, 0x76,
    0xAF, 0xF4, 0xA6, 0x7C, 0x8B, 0x5D, 0xE5, 0xCF,
    0xA4, 0x5E, 0x76, 0x98, 0x1C, 0x41, 0xC6, 0x00,
    0x28, 0x72, 0x53, 0xBA, 0x7A, 0x29, 0x84, 0xB6,
    0xCA, 0x36, 0xA5, 0xFB, 0xE1, 0x8A, 0xDB, 0xC8,
    0x3B, 0xD6, 0xDF, 0x1B, 0x32, 0x3D, 0x5F, 0xAE,
    0x78, 0xD8, 0xE1, 0x72, 0x92, 0x26, 0xA4, 0x09,
    0xDF, 0x3C, 0x34, 0x01, 0x4A, 0x3A, 0x9E, 0x69,
    0xEF, 0x7C, 0x57, 0x18, 0x97, 0xDC, 0xBF, 0x5E,
    0xF3, 0xDC, 0xBA, 0x54, 0x73, 0x4D, 0x33, 0xD0,
    0xBD, 0xD4, 0x9E, 0xAA, 0x49, 0x29, 0x54, 0xF0,
    0x99, 0xB9, 0x89, 0x85, 0x71, 0x04, 0xEF, 0xF2,
    0x09, 0xCF, 0xAD, 0xB6, 0x74, 0x81, 0xB7, 0x76,
    0x29, 0x20, 0x90, 0x59, 0x7C, 0x54, 0xF6, 0xA4,
    0xAC, 0x37, 0x16, 0xF4, 0x58, 0xE0, 0x21, 0x00,
    0xDD, 0x77, 0xAD, 0x5D, 0xAC, 0x96, 0xD0, 0x66,
    0xC0, 0xE0, 0xE4, 0x6F, 0x12, 0x7A, 0x46, 0xE4,
    0xE2, 0x74, 0x35, 0x76, 0xD6, 0x41, 0xB1, 0xEB,
    0x3F, 0x07, 0xA6, 0x0F, 0x7B, 0xB2, 0x71, 0x76,
    0xE9, 0x00, 0x22, 0xDF, 0xA4, 0xE8, 0xB0, 0x4C,
    0x86, 0xC8, 0x80, 0x64, 0x53, 0xD6, 0x41, 0x8D,
    0x03, 0x75, 0xB7, 0x91, 0x53, 0x55, 0x78, 0xA9,
    0x39, 0xE6, 0x19, 0x81, 0xC0, 0x56, 0xF6, 0xA8,
    0x38, 0x9D, 0x0B, 0x17, 0x80, 0x9A, 0xD6, 0x4A,
    0x34, 0x89, 0x2A, 0x0E, 0x83, 0x3A, 0xCD, 0x25,
    0x94, 0x45, 0x7C, 0x71, 0xDF, 0xDB, 0x28, 0x55
};

static const unsigned char rsaPrivateExponentD_8192[] = {
    0x49, 0x7c, 0xa6, 0x57, 0x7c, 0x24, 0x49, 0x79,
    0x72, 0x3b, 0xf6, 0xf3, 0xe6, 0xf8, 0x97, 0x12,
    0xe1, 0xfe, 0xb7, 0x29, 0xfa, 0x1e, 0x85, 0x38,
    0x1d, 0x6c, 0xc9, 0x2c, 0x87, 0x68, 0xd4, 0x5f,
    0x3b, 0x3d, 0x26, 0x25, 0x97, 0x32, 0xda, 0xdf,
    0x0a, 0xa6, 0xb6, 0xf9, 0x9e, 0xa0, 0xb8, 0xc9,
    0x58, 0x03, 0xc6, 0xec, 0xf3, 0x7c, 0x16, 0x68,
    0x55, 0xa5, 0x27, 0x3b, 0x75, 0x90, 0xc3, 0x80,
    0xfa, 0x82, 0x4d, 0x5a, 0x74, 0xce, 0x18, 0xfa,
    0xe8, 0x2f, 0x24, 0xf6, 0xe8, 0xf9, 0x43, 0x5b,
    0x79, 0x28, 0x49, 0xd0, 0xfc, 0x7b, 0x04, 0x2f,
    0xff, 0x92, 0x39, 0xae, 0xeb, 0x99, 0x0d, 0xde,
    0xb9, 0xe5, 0xa7, 0x2b, 0x61, 0x9d, 0xcc, 0x29,
    0x54, 0x71, 0xfb, 0x30, 0x51, 0x99, 0x7c, 0x0d,
    0x5c, 0x62, 0x41, 0x32, 0x58, 0x2f, 0xf0, 0xec,
    0xb8, 0x56, 0xae, 0x55, 0x1c, 0x21, 0xef, 0x10,
    0x59, 0x0a, 0x9b, 0xfc, 0xec, 0x8d, 0xd5, 0xb3,
    0xf2, 0x16, 0x5a, 0x01, 0x8c, 0x40, 0x31, 0xc6,
    0xa7, 0x44, 0x5a, 0xca, 0xf1, 0x34, 0x93, 0xf8,
    0x73, 0x2d, 0x44, 0xd5, 0x90, 0xf5, 0x8e, 0x2e,
    0xf4, 0x34, 0x5b, 0x63, 0x63, 0xc6, 0x84, 0xae,
    0x53, 0x62, 0x37, 0x70, 0xad, 0x29, 0x2d, 0xc4,
    0xcf, 0xe6, 0xc9, 0xba, 0x7f, 0x68, 0x77, 0x43,
    0x1f, 0xfe, 0x59, 0x46, 0x78, 0xbd, 0x36, 0x79,
    0xa8, 0xb9, 0xd4, 0xb9, 0x5b, 0x62, 0xca, 0x46,
    0x25, 0xbf, 0x2f, 0xe0, 0x70, 0x44, 0x9f, 0x6c,
    0xf7, 0xcf, 0xbe, 0x3b, 0x6a, 0x96, 0x51, 0x25,
    0x32, 0x44, 0x99, 0xfc, 0x9b, 0xbd, 0x07, 0x72,
    0x6e, 0x87, 0x09, 0x98, 0x02, 0x7a, 0xda, 0xd0,
    0xe8, 0xf7, 0x49, 0xeb, 0xae, 0x2f, 0x70, 0xb0,
    0x5b, 0x58, 0x60, 0x17, 0x41, 0xd0, 0x0c, 0xc8,
    0x42, 0xab, 0x60, 0x50, 0xeb, 0x26, 0x68, 0xa3,
    0xb4, 0x8e, 0x42, 0xb8, 0x9c, 0x54, 0x4f, 0xa9,
    0x2c, 0xdb, 0x8b, 0xc9, 0x14, 0x6e, 0xb3, 0x3e,
    0xe6, 0xc6, 0x99, 0x14, 0x82, 0x14, 0x30, 0x86,
    0x57, 0xa5, 0x42, 0x23, 0x02, 0x5c, 0xcc, 0xa7,
    0x86, 0x27, 0x98, 0x40, 0x1c, 0x36, 0xc4, 0xb9,
    0xd4, 0xaf, 0xa6, 0x88, 0x29, 0xce, 0x66, 0xdd,
    0x01, 0x4a, 0x69, 0x25, 0x49, 0x87, 0x5b, 0xa7,
    0xe1, 0x23, 0x9f, 0x67, 0x9b, 0x88, 0x01, 0x0d,
    0x4b, 0xea, 0x74, 0x99, 0xd9, 0x3d, 0x7c, 0x9a,
    0xee, 0x55, 0xf3, 0x1e, 0x78, 0xe0, 0x48, 0xe0,
    0x0a, 0xbb, 0x2e, 0xc3, 0xe0, 0xdd, 0xe6, 0x7f,
    0x88, 0xc5, 0xef, 0xbd, 0x94, 0xd0, 0xbd, 0x63,
    0x90, 0x14, 0x75, 0x3f, 0xb6, 0x5c, 0x29, 0x00,
    0x79, 0x5e, 0x54, 0xf5, 0x91, 0xcf, 0x73, 0x7e,
    0x8e, 0x2e, 0xfd, 0x91, 0x59, 0x37, 0x78, 0xc2,
    0x8f, 0x63, 0x57, 0x4b, 0x46, 0xe3, 0x0e, 0x68,
    0xd4, 0x8b, 0xb4, 0x04, 0x92, 0x06, 0x2d, 0x80,
    0x8b, 0x5a, 0x93, 0xaf, 0x1b, 0x48, 0x25, 0x63,
    0x2b, 0xfe, 0x04, 0x2c, 0xdd, 0xed, 0x9b, 0x4b,
    0x92, 0x33, 0xa6, 0x7a, 0xc6, 0xfd, 0x8f, 0x56,
    0x52, 0xac, 0x06, 0x89, 0x3f, 0xad, 0xea, 0x12,
    0x0f, 0x13, 0x9d, 0xde, 0xcd, 0x71, 0x55, 0x0d,
    0xa7, 0x4e, 0x71, 0x30, 0x5d, 0x7a, 0xaa, 0x20,
    0x6c, 0x1c, 0xa8, 0x26, 0xf3, 0x9d, 0x09, 0xdc,
    0xd3, 0xe4, 0xaa, 0xc5, 0xf7, 0xe5, 0xba, 0xc8,
    0xb7, 0x53, 0x2d, 0xe7, 0xc2, 0xf5, 0x32, 0x3c,
    0xb6, 0x11, 0xda, 0x94, 0x5e, 0x25, 0x66, 0x49,
    0xb7, 0x64, 0xec, 0x21, 0xac, 0x98, 0x7d, 0x71,
    0xf0, 0x61, 0xe1, 0x42, 0x15, 0xf3, 0xfa, 0x19,
    0x76, 0x5a, 0xf8, 0x6b, 0x2a, 0xeb, 0x13, 0xa9,
    0x81, 0x4e, 0x2e, 0x58, 0x3e, 0x53, 0x36, 0xdb,
    0x2f, 0x97, 0x0c, 0x8b, 0x82, 0x71, 0x86, 0x9a,
    0x8f, 0xf4, 0x0b, 0xb2, 0x58, 0x51, 0x98, 0x3c,
    0x3a, 0x5d, 0x80, 0x4b, 0x50, 0xc5, 0xaa, 0xdc,
    0x7f, 0xbe, 0x21, 0x4c, 0x76, 0xe3, 0xb5, 0x6b,
    0x33, 0xa0, 0x6b, 0x6c, 0xfe, 0x53, 0x96, 0x26,
    0x08, 0xc3, 0x98, 0x90, 0x39, 0x05, 0x5a, 0xdd,
    0x18, 0x45, 0xf7, 0xef, 0xde, 0xc2, 0xe9, 0xce,
    0x34, 0x41, 0x52, 0x1d, 0x73, 0x6f, 0x6b, 0x71,
    0x4e, 0x18, 0x97, 0x2f, 0x8f, 0xe3, 0xd6, 0xaf,
    0x6b, 0xc6, 0xfe, 0xec, 0xd8, 0x48, 0xca, 0x6f,
    0xd9, 0x48, 0x34, 0x1e, 0x02, 0x5b, 0xf5, 0xda,
    0x3c, 0x3c, 0x8c, 0xce, 0xd6, 0xe3, 0x9f, 0x90,
    0x1c, 0x2e, 0x1a, 0xcf, 0xe3, 0x42, 0x5e, 0x7a,
    0x1d, 0x42, 0x9b, 0xf3, 0xda, 0x64, 0xf5, 0x8d,
    0x14, 0xd3, 0x0b, 0x63, 0x75, 0xfb, 0xf3, 0xe1,
    0x99, 0xb8, 0x77, 0x64, 0xf9, 0x82, 0x10, 0x4d,
    0x2e, 0x8b, 0x72, 0xb6, 0x48, 0x6a, 0x53, 0x1c,
    0x30, 0x8f, 0x5d, 0x3d, 0x63, 0x4c, 0x6e, 0x47,
    0xb0, 0x92, 0xc4, 0x2f, 0x07, 0x7f, 0x19, 0xdd,
    0x6f, 0xde, 0xa2, 0x47, 0x14, 0x6a, 0xd0, 0xf1,
    0xfc, 0x87, 0x91, 0x16, 0x19, 0x7b, 0x7a, 0x80,
    0x52, 0xdc, 0xf2, 0x89, 0xe2, 0x15, 0xa1, 0xda,
    0x4a, 0xdf, 0x30, 0x40, 0x1f, 0x34, 0xb8, 0xd9,
    0xa5, 0x78, 0x23, 0x0e, 0x77, 0x62, 0xc2, 0x60,
    0x2a, 0x2d, 0x4e, 0x09, 0x88, 0x07, 0x56, 0x14,
    0x65, 0x26, 0x1d, 0xe7, 0x23, 0xfb, 0x27, 0x3a,
    0x69, 0xc7, 0x30, 0x92, 0x33, 0xed, 0x68, 0x21,
    0xbd, 0x3e, 0x88, 0x95, 0xc1, 0xdc, 0x41, 0x79,
    0xbd, 0x90, 0xd7, 0xdd, 0xe3, 0x94, 0xb3, 0x88,
    0x3c, 0xa5, 0x6a, 0x34, 0x7d, 0x9e, 0x93, 0x33,
    0x30, 0xcd, 0x87, 0xb5, 0x9e, 0x2c, 0x90, 0x74,
    0x4f, 0xca, 0xfe, 0xb2, 0x36, 0x95, 0x71, 0x11,
    0xf9, 0xc8, 0x11, 0xf9, 0xb5, 0xd6, 0x25, 0xac,
    0x2d, 0x25, 0xf4, 0x6f, 0xa4, 0x2c, 0x63, 0x90,
    0xf7, 0x5f, 0x28, 0x39, 0x24, 0x5c, 0x46, 0x7c,
    0x52, 0x45, 0xdb, 0x7c, 0x9c, 0x54, 0x06, 0xe7,
    0x33, 0x80, 0xa5, 0x36, 0x54, 0x82, 0xc3, 0x9f,
    0xfc, 0xe9, 0x5f, 0x33, 0xe6, 0x15, 0x98, 0x2e,
    0xe8, 0x6e, 0x74, 0x0d, 0x98, 0x61, 0xcd, 0x27,
    0x72, 0x95, 0x08, 0x7e, 0x9b, 0xb2, 0xda, 0x01,
    0x66, 0xfe, 0x93, 0x20, 0x30, 0x5d, 0x46, 0x22,
    0x9a, 0x99, 0xd0, 0xe0, 0x9e, 0x45, 0xfc, 0xd4,
    0x8a, 0xa0, 0x63, 0x50, 0x6e, 0xf6, 0x98, 0x76,
    0x3c, 0x7f, 0x01, 0x61, 0xaf, 0x97, 0xc2, 0x14,
    0x33, 0x72, 0xb4, 0x3d, 0x8d, 0x0c, 0xa6, 0xa5,
    0x9e, 0x0d, 0x55, 0x69, 0x53, 0x36, 0x3e, 0x0f,
    0xec, 0x88, 0xac, 0x59, 0x7b, 0xf1, 0x91, 0x7b,
    0xae, 0x39, 0xbe, 0x6a, 0x0a, 0x39, 0x8c, 0xe6,
    0x09, 0xd9, 0xf2, 0x92, 0x06, 0x81, 0x5c, 0xef,
    0x25, 0xd0, 0xa4, 0xc7, 0xd2, 0xe9, 0xa1, 0xe7,
    0xf9, 0x2b, 0x6c, 0x77, 0x49, 0xd7, 0x78, 0xe6,
    0xc1, 0xf5, 0x01, 0x7d, 0xcd, 0x59, 0x67, 0x4c,
    0x3e, 0xc0, 0x0b, 0xff, 0x57, 0xd3, 0x63, 0x6b,
    0xb5, 0x03, 0x0b, 0x4c, 0x42, 0x98, 0x17, 0x57,
    0x27, 0xd0, 0xda, 0x3f, 0x4c, 0x5c, 0x2c, 0x2b,
    0x2f, 0x56, 0x5a, 0x23, 0x49, 0xa6, 0xfe, 0x44,
    0x58, 0x9d, 0x1e, 0x53, 0xf0, 0x29, 0xae, 0x7c,
    0x43, 0xae, 0x05, 0x88, 0xe6, 0xfd, 0x56, 0x98,
    0x1b, 0xac, 0x61, 0x1b, 0x13, 0x73, 0x00, 0xe3,
    0x69, 0x52, 0xf0, 0xf4, 0xe6, 0xe4, 0x96, 0x04,
    0xf3, 0x33, 0xce, 0x2c, 0x60, 0xf8, 0xcc, 0xb1,
    0x9d, 0x6a, 0x91, 0xa2, 0xfd, 0x72, 0xd2, 0xd5,
    0x0f, 0x2f, 0xe7, 0x23, 0x2b, 0xb5, 0x00, 0x9c,
    0x81, 0xe5, 0x32, 0x82, 0xa6, 0x50, 0xa0, 0xd3,
    0x64, 0x2e, 0x04, 0xba, 0xa0, 0x70, 0xd7, 0x81
};

static const unsigned char rsaPublicExponentE_1024[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01
};

static const unsigned char rsaPublicExponentE_2048[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01};

static const unsigned char rsaPublicExponentE_4096[] = {
    0x01, 0x00, 0x01
};

static const unsigned char rsaPublicExponentE_8192[] = {
    0x01, 0x00, 0x01
};

static const unsigned char rsaModulusN_1024[] = {
    0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b,
    0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4,
    0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55,
    0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab,
    0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5,
    0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85,
    0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42,
    0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72,
    0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58,
    0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97,
    0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5,
    0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14,
    0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93,
    0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24,
    0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf,
    0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb
};

static const unsigned char rsaModulusN_2048[] = {
    0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8,
    0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d,
    0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79,
    0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8,
    0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba,
    0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4,
    0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e,
    0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5,
    0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf,
    0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d,
    0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a,
    0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f,
    0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71,
    0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1,
    0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41,
    0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0,
    0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88,
    0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a,
    0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb,
    0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00,
    0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf,
    0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8,
    0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30,
    0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef,
    0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6,
    0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76,
    0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01,
    0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88,
    0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f,
    0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc,
    0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d,
    0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb
};

static const unsigned char rsaModulusN_4096[] = {
    0xB1, 0x11, 0x3F, 0x37, 0xE3, 0x57, 0x7A, 0x0E,
    0xFE, 0xC4, 0xEF, 0x49, 0x3C, 0x31, 0x5C, 0x49,
    0x1E, 0xF0, 0x7E, 0x45, 0x01, 0x12, 0x85, 0xE1,
    0xB3, 0xD3, 0xC0, 0xD8, 0x7E, 0xF5, 0x0E, 0xF8,
    0x24, 0x52, 0x74, 0x58, 0x1C, 0x84, 0x7E, 0xE9,
    0xD9, 0xA4, 0xE2, 0x0B, 0xDA, 0x95, 0x15, 0x45,
    0x0B, 0x3A, 0xA2, 0x84, 0x40, 0x58, 0x1D, 0x33,
    0x04, 0xBA, 0x68, 0xA3, 0x4C, 0x67, 0x6A, 0x96,
    0x94, 0xF6, 0xA7, 0x30, 0xCB, 0xD3, 0x90, 0x6F,
    0xA9, 0x6B, 0x70, 0x8A, 0xB1, 0xC0, 0xC8, 0x15,
    0x84, 0xE1, 0x49, 0xEC, 0xC3, 0xA8, 0x56, 0x70,
    0xD6, 0xCA, 0xE4, 0x5A, 0x32, 0x1F, 0x7B, 0x74,
    0x67, 0xFB, 0x78, 0x0B, 0x7D, 0x65, 0x3E, 0xAD,
    0x74, 0xCF, 0x4D, 0x47, 0x4D, 0xAE, 0x97, 0x31,
    0x64, 0xC4, 0x9D, 0x64, 0x4C, 0x31, 0xB8, 0x8D,
    0xED, 0xFB, 0x02, 0x93, 0x67, 0xC6, 0xEC, 0xDF,
    0x28, 0xD9, 0x38, 0xAB, 0x39, 0xC2, 0xF6, 0x82,
    0x8F, 0x70, 0xF6, 0x1F, 0x2D, 0x75, 0x8D, 0x3D,
    0x57, 0xC8, 0xF1, 0xA1, 0xAE, 0x9E, 0x52, 0xF0,
    0x1C, 0x20, 0x66, 0x71, 0xC5, 0x12, 0x64, 0x0F,
    0x45, 0x67, 0x06, 0x40, 0xD3, 0x06, 0xF0, 0x4D,
    0xFF, 0x91, 0x8C, 0x5E, 0x41, 0x65, 0x66, 0xA4,
    0xC7, 0xFC, 0x3E, 0x65, 0x3C, 0xC3, 0x75, 0x7B,
    0xF1, 0x2C, 0xF4, 0x08, 0xA8, 0x10, 0x83, 0x7B,
    0xFB, 0xDC, 0x2B, 0xF2, 0x36, 0xCE, 0x2C, 0x6D,
    0x69, 0xAF, 0x72, 0xB8, 0xF6, 0x79, 0x04, 0x2B,
    0x6A, 0xA0, 0x58, 0x6F, 0xD4, 0xF6, 0x3E, 0xF4,
    0x8E, 0xEE, 0xB1, 0x01, 0x51, 0x9D, 0xC2, 0x31,
    0x80, 0x26, 0xB8, 0xBE, 0xC0, 0x02, 0xD9, 0xAB,
    0x46, 0x0F, 0x63, 0x8D, 0xBB, 0x2A, 0x79, 0xE3,
    0x34, 0xF9, 0x9C, 0xF8, 0xC4, 0x22, 0x6B, 0xD5,
    0x0C, 0x2E, 0x65, 0x13, 0x5A, 0x8D, 0xBE, 0x84,
    0xAB, 0x29, 0x88, 0xE2, 0xD5, 0x5C, 0x4C, 0x04,
    0xCF, 0x27, 0x39, 0x51, 0x04, 0x02, 0x8C, 0x2C,
    0xE3, 0x1F, 0x03, 0x53, 0x62, 0x94, 0x1F, 0xD9,
    0x2A, 0x1B, 0xB5, 0x09, 0x2C, 0x3A, 0x14, 0xD2,
    0xC3, 0xFD, 0x04, 0x2E, 0x47, 0xEC, 0x98, 0x49,
    0x31, 0xD8, 0x35, 0x8E, 0x78, 0x14, 0x67, 0x73,
    0xD9, 0x3F, 0xBC, 0xF3, 0xE3, 0x66, 0x74, 0x8D,
    0xE5, 0x31, 0x9A, 0x27, 0x23, 0x72, 0x2C, 0xF5,
    0x48, 0xDC, 0x56, 0x16, 0x22, 0x8F, 0xE6, 0x78,
    0xE3, 0x7B, 0x22, 0xDD, 0x2A, 0xCC, 0x0A, 0xDC,
    0xC0, 0xF4, 0x00, 0x67, 0x8F, 0xBD, 0x95, 0x90,
    0x6A, 0x1D, 0xC7, 0x90, 0x12, 0x08, 0xAB, 0xF2,
    0x51, 0x41, 0xEA, 0xF6, 0xAE, 0x04, 0x5F, 0x47,
    0x05, 0xA5, 0xFC, 0x5B, 0x81, 0x58, 0x02, 0x8C,
    0xF6, 0xDC, 0x06, 0x35, 0xDB, 0x2D, 0x3B, 0xFA,
    0xAF, 0xF5, 0x3B, 0x29, 0x7D, 0xCF, 0x64, 0x03,
    0x37, 0x15, 0xDB, 0xC3, 0xC1, 0x2E, 0x84, 0x90,
    0x7E, 0x9F, 0x51, 0xC1, 0x47, 0x9E, 0x14, 0x43,
    0x70, 0xC6, 0xE7, 0xD2, 0xFB, 0x91, 0x7E, 0x16,
    0xD2, 0x82, 0xE0, 0x05, 0x1A, 0xAC, 0x2F, 0xF8,
    0xF6, 0xFB, 0x00, 0xDA, 0xB0, 0x9E, 0x99, 0xB4,
    0x68, 0x70, 0xAF, 0x90, 0x3F, 0xC6, 0x84, 0x44,
    0xDB, 0x6D, 0x0F, 0x9C, 0xE5, 0x54, 0x1B, 0x41,
    0x4E, 0x32, 0xB0, 0xE2, 0xCE, 0x68, 0x8E, 0x39,
    0x88, 0x01, 0x43, 0x4F, 0x21, 0xE3, 0xC7, 0xB0,
    0xEF, 0x52, 0x67, 0x54, 0x0F, 0x00, 0x80, 0x40,
    0xBF, 0x0F, 0xFF, 0xFC, 0x93, 0xCF, 0x36, 0x2D,
    0x3E, 0x3F, 0xFC, 0x2D, 0xBC, 0x53, 0x50, 0x60,
    0x4A, 0xC9, 0x3A, 0x78, 0x6A, 0x5E, 0xA7, 0x39,
    0x91, 0xB3, 0x0E, 0x5F, 0x9D, 0x44, 0xBA, 0x47,
    0x00, 0x5E, 0x5F, 0x85, 0x48, 0x82, 0xC3, 0x26,
    0x1C, 0x6E, 0x9A, 0xB8, 0x55, 0x53, 0xBD, 0x3D
};

static const unsigned char rsaModulusN_8192[] = {
    0xae, 0x7b, 0xf2, 0x03, 0xd8, 0x1d, 0xe1, 0x26,
    0x60, 0x3f, 0x4d, 0x2e, 0xc7, 0xe4, 0x87, 0x5e,
    0x55, 0x61, 0x0a, 0xe5, 0x18, 0xc4, 0x9e, 0x07,
    0x2f, 0x40, 0xed, 0xaa, 0xb7, 0x21, 0xd0, 0x41,
    0x24, 0x4d, 0xfe, 0x94, 0x1c, 0x58, 0xfb, 0x66,
    0x17, 0x63, 0x75, 0x53, 0xf3, 0x68, 0x7b, 0xb4,
    0xd8, 0x68, 0x4f, 0xd7, 0xe1, 0xa9, 0xb0, 0x50,
    0xd6, 0xb4, 0x4e, 0xe0, 0xad, 0x70, 0x53, 0x90,
    0x04, 0x7b, 0x76, 0xa1, 0x5c, 0xce, 0xc4, 0x98,
    0x7c, 0x98, 0xbf, 0x0a, 0x63, 0x17, 0xa7, 0x4d,
    0xbe, 0xc7, 0x35, 0xf8, 0xd2, 0xfb, 0x0d, 0xb2,
    0xe8, 0x12, 0xc8, 0x9a, 0x87, 0x39, 0x89, 0x05,
    0xb1, 0x47, 0xaa, 0x88, 0xb7, 0x5a, 0x5e, 0xda,
    0x7a, 0xf0, 0x5c, 0x06, 0xb8, 0xe1, 0x3d, 0xec,
    0xf8, 0xed, 0xda, 0xd5, 0x25, 0x2c, 0xf4, 0x99,
    0x27, 0xc8, 0x69, 0xea, 0x3e, 0xf2, 0x9e, 0x52,
    0x52, 0xb8, 0x76, 0xef, 0x2e, 0x44, 0xe9, 0xd0,
    0x1a, 0x82, 0x83, 0xa9, 0x9e, 0x2f, 0xcd, 0x4f,
    0xf9, 0xde, 0x97, 0xd6, 0xb5, 0x85, 0x10, 0xcb,
    0xf6, 0x09, 0x4f, 0xd8, 0x22, 0xad, 0xdf, 0xba,
    0x92, 0xc1, 0x9d, 0x5a, 0x1f, 0xa9, 0xb6, 0x67,
    0x65, 0x14, 0xa2, 0x71, 0xf9, 0x14, 0x69, 0xb6,
    0x7c, 0x59, 0xf1, 0x48, 0xa1, 0xa1, 0x33, 0x49,
    0x05, 0xa2, 0x56, 0x5f, 0x9f, 0x47, 0xd5, 0x9f,
    0x6c, 0xad, 0x14, 0x44, 0x56, 0x41, 0x88, 0x24,
    0x81, 0x60, 0x31, 0x8f, 0x7b, 0x15, 0xc1, 0x6d,
    0xdc, 0x64, 0x4c, 0x01, 0xef, 0xcd, 0xcd, 0x8a,
    0x8a, 0x35, 0xa5, 0xac, 0xfd, 0x2d, 0x58, 0x7e,
    0x7c, 0xec, 0xd6, 0xf0, 0xfe, 0x86, 0x29, 0x40,
    0x6b, 0x83, 0x98, 0xf7, 0x99, 0x1d, 0xf2, 0x62,
    0x03, 0xe6, 0xf3, 0xfe, 0xc1, 0x9c, 0xac, 0x70,
    0x1b, 0x7c, 0x9f, 0xb6, 0x80, 0x9d, 0x7b, 0x77,
    0x3a, 0x5b, 0x25, 0x1b, 0x59, 0xfd, 0xd9, 0x22,
    0x60, 0x76, 0xa5, 0xd6, 0x57, 0x11, 0x99, 0xb2,
    0x4b, 0xfd, 0xfe, 0xcd, 0xf6, 0xea, 0xd2, 0x7c,
    0x18, 0xd0, 0xbb, 0xf1, 0xde, 0xb8, 0x7b, 0xa7,
    0x36, 0x2c, 0xb0, 0x70, 0x60, 0x5f, 0x47, 0x40,
    0xf4, 0x58, 0x9f, 0x26, 0xe6, 0xb4, 0x31, 0xe4,
    0x6f, 0xe2, 0x6a, 0xf3, 0xf2, 0xfb, 0xfc, 0x5b,
    0x74, 0xb0, 0x85, 0x5c, 0xe7, 0x6b, 0x20, 0xc9,
    0xf0, 0x02, 0x15, 0x13, 0x2d, 0xb7, 0xd2, 0xab,
    0x4f, 0xef, 0xfc, 0xa0, 0xbf, 0xb7, 0x01, 0x81,
    0x6a, 0x56, 0x1e, 0xbf, 0x04, 0xa2, 0xa2, 0x94,
    0x7f, 0xe4, 0xa0, 0x39, 0x9e, 0x99, 0xa5, 0x7b,
    0x59, 0x34, 0x44, 0x13, 0xeb, 0x1c, 0xba, 0x21,
    0x5f, 0xaf, 0x67, 0xee, 0x67, 0x5d, 0xda, 0x79,
    0x83, 0x95, 0xc8, 0xb0, 0x5b, 0x32, 0x44, 0xc3,
    0x4a, 0x0c, 0x57, 0x77, 0x4f, 0xb0, 0xf4, 0x5e,
    0x55, 0x1c, 0x08, 0x89, 0x06, 0x50, 0x50, 0x7e,
    0x11, 0xcc, 0x9b, 0xfa, 0x92, 0xf0, 0xf6, 0x70,
    0xd4, 0x83, 0x41, 0xc8, 0xc7, 0x8a, 0x42, 0x87,
    0x6c, 0xa2, 0xf1, 0xaf, 0x10, 0x6b, 0x59, 0x2a,
    0x70, 0xe9, 0xce, 0xbe, 0xa2, 0x4c, 0xa0, 0x0b,
    0x36, 0xe7, 0x35, 0x50, 0x97, 0x37, 0x3e, 0xa1,
    0xc1, 0x01, 0xd7, 0x4a, 0xa6, 0x1e, 0x87, 0x53,
    0xeb, 0x6b, 0x91, 0xff, 0xa0, 0x78, 0x79, 0x2e,
    0x8e, 0x82, 0x9c, 0xc4, 0x46, 0xf7, 0x95, 0xbc,
    0x17, 0x7b, 0x88, 0x1f, 0xc3, 0xb9, 0x30, 0x86,
    0x39, 0xe5, 0xd9, 0xf5, 0x10, 0x06, 0x46, 0x12,
    0x44, 0xa8, 0x3d, 0x0d, 0x32, 0x02, 0xba, 0x25,
    0xa2, 0x95, 0x69, 0x73, 0xf1, 0xe2, 0x6e, 0xca,
    0x4d, 0xc3, 0x55, 0x08, 0x19, 0x94, 0xf4, 0xf7,
    0xf0, 0xa3, 0x61, 0x33, 0xe3, 0x8a, 0x4b, 0xed,
    0x23, 0xb0, 0xf1, 0x9c, 0x61, 0x64, 0xd3, 0x5b,
    0xe1, 0x69, 0x4c, 0xdd, 0x2c, 0x5d, 0x00, 0x4c,
    0xb5, 0xb8, 0x91, 0x04, 0x89, 0x30, 0x01, 0x2f,
    0x8b, 0x1a, 0x3a, 0x13, 0xa5, 0xf4, 0x5b, 0x63,
    0x26, 0x16, 0xc0, 0xa2, 0x73, 0x6a, 0xdc, 0x1c,
    0xb1, 0xc5, 0x6c, 0x71, 0xab, 0x19, 0x3f, 0xbd,
    0x0b, 0x50, 0x95, 0xf7, 0x01, 0x25, 0x33, 0x97,
    0xd6, 0x77, 0xa1, 0x04, 0xef, 0xc2, 0x08, 0x07,
    0xbf, 0x2d, 0x24, 0xcd, 0x1d, 0x4b, 0x1f, 0xa5,
    0xd8, 0x0a, 0x30, 0xe6, 0x3c, 0x2a, 0xe7, 0x29,
    0x91, 0x60, 0x43, 0xe4, 0xf5, 0x18, 0x45, 0x18,
    0x27, 0x11, 0x06, 0xb8, 0x8b, 0xb5, 0xb9, 0x79,
    0x24, 0xf6, 0x6c, 0xbe, 0xe5, 0x81, 0xd8, 0xbe,
    0xd2, 0x96, 0x0e, 0x85, 0xd2, 0x36, 0xf6, 0x45,
    0x7c, 0xeb, 0x9e, 0xbc, 0x37, 0xd0, 0x6c, 0x20,
    0x13, 0xcb, 0xc4, 0x6d, 0x7e, 0xbd, 0x36, 0x05,
    0x35, 0x8a, 0x6e, 0xa2, 0xa9, 0x7c, 0xf9, 0x6f,
    0xa6, 0xe4, 0x05, 0x53, 0x53, 0x76, 0x75, 0x6c,
    0x44, 0x22, 0x35, 0xed, 0xe9, 0xf8, 0xad, 0x0d,
    0x16, 0x7d, 0x3c, 0x91, 0x87, 0x55, 0x9d, 0x4e,
    0x8f, 0x20, 0x01, 0xdf, 0xd0, 0x00, 0x8a, 0x30,
    0x71, 0x84, 0xb8, 0xf0, 0x61, 0x76, 0x7a, 0x9d,
    0x87, 0xc6, 0x6f, 0xf9, 0x95, 0x40, 0x21, 0x3b,
    0x78, 0x87, 0x94, 0xd0, 0x7c, 0x19, 0x8e, 0x15,
    0xd2, 0x9e, 0x8a, 0xeb, 0x39, 0xd6, 0x2a, 0x1c,
    0x54, 0x5b, 0xde, 0xda, 0x81, 0x67, 0x32, 0x33,
    0xcd, 0xca, 0xea, 0xa8, 0x4f, 0xb8, 0xa9, 0xc7,
    0x1e, 0x1f, 0x65, 0xcb, 0xa8, 0x10, 0x52, 0x08,
    0xef, 0x76, 0xf4, 0x9c, 0x3d, 0x75, 0x68, 0x41,
    0xb5, 0xf9, 0xea, 0x8a, 0xad, 0x53, 0x26, 0x98,
    0xe2, 0xbc, 0x73, 0xc7, 0x59, 0x8d, 0x2b, 0x91,
    0xf7, 0x78, 0x14, 0x61, 0xd2, 0x53, 0x31, 0xc8,
    0xa1, 0xdc, 0xe7, 0xd2, 0x9d, 0x35, 0xe0, 0x9a,
    0x14, 0xa7, 0xce, 0x96, 0xc4, 0xf1, 0x05, 0x54,
    0x3b, 0x50, 0x35, 0x9b, 0x36, 0xb1, 0x31, 0x40,
    0x73, 0x7a, 0xcc, 0xe2, 0x72, 0xa6, 0xdf, 0xf6,
    0x82, 0xa4, 0x39, 0x1e, 0xe5, 0xb7, 0x2e, 0xaf,
    0x72, 0x6f, 0x5e, 0x37, 0x2b, 0x3c, 0x4f, 0x7e,
    0xcb, 0x8c, 0x99, 0x2d, 0x87, 0x8f, 0x6b, 0x21,
    0x74, 0xae, 0xdb, 0xfd, 0xa6, 0x3f, 0x2b, 0x5a,
    0xbf, 0x72, 0x04, 0x10, 0xf6, 0x7e, 0xdc, 0x6f,
    0x01, 0x8b, 0x59, 0xb4, 0x40, 0x1b, 0x24, 0xb0,
    0x8f, 0x8e, 0x23, 0x75, 0x5c, 0xc2, 0xa9, 0x5e,
    0x89, 0x8b, 0xc2, 0x87, 0x21, 0x0e, 0x2e, 0x15,
    0x1b, 0x7d, 0x38, 0x16, 0x77, 0xbd, 0xc3, 0xee,
    0xde, 0xa3, 0x4e, 0x26, 0xa6, 0xe3, 0xa0, 0xd5,
    0x21, 0x8c, 0xc6, 0x21, 0x4f, 0x37, 0x2b, 0xe1,
    0xdd, 0x32, 0x1d, 0x20, 0x17, 0xdf, 0x6d, 0x2f,
    0x8c, 0x7b, 0xab, 0x7b, 0x0e, 0x31, 0xda, 0x90,
    0xb1, 0x36, 0x4b, 0x1e, 0xe5, 0x9a, 0xae, 0xbd,
    0xec, 0x5a, 0x0d, 0x8a, 0x15, 0x15, 0xb3, 0x2e,
    0xee, 0x0b, 0xb5, 0x82, 0xbe, 0xba, 0xef, 0x9c,
    0x72, 0x07, 0x92, 0xce, 0xef, 0xde, 0x8a, 0x2c,
    0xc6, 0xe7, 0x8d, 0x00, 0xe6, 0x64, 0xda, 0x4d,
    0x01, 0x3f, 0x63, 0xe1, 0x5d, 0x9b, 0xdc, 0x0c,
    0x65, 0x9c, 0xca, 0xb6, 0x4c, 0xa0, 0xcd, 0xe8,
    0xbe, 0xbe, 0xf8, 0x11, 0x21, 0xfd, 0x59, 0xe1,
    0xee, 0x3f, 0x71, 0xf4, 0x70, 0x2e, 0xb1, 0x23,
    0x81, 0x77, 0x45, 0x9e, 0xd3, 0x48, 0xee, 0x2c,
    0x5e, 0xcb, 0x85, 0x04, 0x43, 0xe6, 0xa2, 0x7c,
    0xb1, 0xec, 0x26, 0xcf, 0x96, 0x10, 0x85, 0x3b,
    0x43, 0xfb, 0xf1, 0x7a, 0x5c, 0xa6, 0x9a, 0x4d,
    0x86, 0xa4, 0x01, 0x76, 0x4c, 0xa5, 0x0c, 0x5b,
    0xd3, 0x07, 0x85, 0x2c, 0x10, 0x01, 0x47, 0xd8,
    0xa9, 0x74, 0x39, 0xe4, 0x00, 0xba, 0x86, 0x07
};

static unsigned char expectedPtexttt_1024[] = {
    0x5d, 0xec, 0x98, 0xeb, 0x0e, 0x5a, 0xa5, 0xc0,
    0xd4, 0xb2, 0xae, 0xa1, 0x00, 0xc7, 0x20, 0xb0,
    0x3f, 0xfd, 0x79, 0x43, 0x78, 0xbf, 0xe7, 0x1c,
    0x71, 0x9a, 0x7c, 0x14, 0x6d, 0x32, 0xe9, 0x0a,
    0xd5, 0xa4, 0x2e, 0x25, 0x6d, 0x05, 0x65, 0x50,
    0xcb, 0x6a, 0x21, 0x43, 0xe7, 0x55, 0x6c, 0x6b,
    0x81, 0x85, 0x32, 0x23, 0x7c, 0x17, 0x99, 0x06,
    0x65, 0xbc, 0xe0, 0x3d, 0x4b, 0x9d, 0xb7, 0xc3,
    0x48, 0xd6, 0x2f, 0x4d, 0xae, 0x44, 0x3a, 0xfa,
    0x6a, 0xb7, 0x79, 0x9f, 0xe5, 0xf9, 0x4b, 0x14,
    0x07, 0xda, 0x97, 0x64, 0x9d, 0xd7, 0xd1, 0xf1,
    0x1a, 0x2f, 0xdd, 0x6a, 0xa9, 0xbc, 0xb2, 0x1e,
    0x75, 0x37, 0x2f, 0xff, 0xb7, 0x8e, 0xc2, 0x77,
    0x4d, 0xc0, 0x4d, 0xb6, 0xb3, 0xc5, 0xda, 0xdd,
    0xaf, 0x67, 0x18, 0x6b, 0x79, 0x5e, 0x83, 0xe1,
    0xaf, 0x49, 0xc6, 0xd8, 0xa3, 0x48, 0x2d, 0x5b,
};

static unsigned char expectedPtexttt_2048[] = {
    0x5d, 0xec, 0x98, 0xeb, 0x0e, 0x5a, 0xa5, 0xc0,
    0xd4, 0xb2, 0xae, 0xa1, 0x00, 0xc7, 0x20, 0xb0,
    0x3f, 0xfd, 0x79, 0x43, 0x78, 0xbf, 0xe7, 0x1c,
    0x71, 0x9a, 0x7c, 0x14, 0x6d, 0x32, 0xe9, 0x0a,
    0xd5, 0xa4, 0x2e, 0x25, 0x6d, 0x05, 0x65, 0x50,
    0xcb, 0x6a, 0x21, 0x43, 0xe7, 0x55, 0x6c, 0x6b,
    0x81, 0x85, 0x32, 0x23, 0x7c, 0x17, 0x99, 0x06,
    0x65, 0xbc, 0xe0, 0x3d, 0x4b, 0x9d, 0xb7, 0xc3,
    0x48, 0xd6, 0x2f, 0x4d, 0xae, 0x44, 0x3a, 0xfa,
    0x6a, 0xb7, 0x79, 0x9f, 0xe5, 0xf9, 0x4b, 0x14,
    0x07, 0xda, 0x97, 0x64, 0x9d, 0xd7, 0xd1, 0xf1,
    0x1a, 0x2f, 0xdd, 0x6a, 0xa9, 0xbc, 0xb2, 0x1e,
    0x75, 0x37, 0x2f, 0xff, 0xb7, 0x8e, 0xc2, 0x77,
    0x4d, 0xc0, 0x4d, 0xb6, 0xb3, 0xc5, 0xda, 0xdd,
    0xaf, 0x67, 0x18, 0x6b, 0x79, 0x5e, 0x83, 0xe1,
    0xaf, 0x49, 0xc6, 0xd8, 0xa3, 0x48, 0x2d, 0x5b,
    0xbc, 0xac, 0x67, 0x97, 0xf4, 0xde, 0x6a, 0x33,
    0x93, 0xed, 0x77, 0xc2, 0xcc, 0xa4, 0xcf, 0xcb,
    0x3e, 0xe8, 0x02, 0x3d, 0x7d, 0x73, 0xe3, 0xc3,
    0x4c, 0xc4, 0x98, 0x17, 0x55, 0x56, 0x2b, 0xa3,
    0x2e, 0xe2, 0xbe, 0x2a, 0x21, 0x03, 0xda, 0xe8,
    0x44, 0xd2, 0x45, 0x1b, 0xfc, 0x4f, 0xb3, 0x14,
    0x9c, 0xf4, 0xcb, 0x37, 0x23, 0x5f, 0x6a, 0x1e,
    0x50, 0x7e, 0xa1, 0x72, 0x25, 0x73, 0xa4, 0x64,
    0xe4, 0x9b, 0xe5, 0xe0, 0x75, 0x0f, 0x31, 0x01,
    0x82, 0x0a, 0xdf, 0x5d, 0x22, 0xd1, 0x9f, 0x03,
    0x95, 0x3c, 0x8b, 0x96, 0xb6, 0xe8, 0x95, 0x37,
    0x7a, 0x9c, 0x53, 0x3d, 0xc1, 0xc7, 0xc0, 0xd2,
    0x5f, 0x3c, 0x87, 0xce, 0xf4, 0x35, 0xff, 0x6e,
    0x7d, 0x01, 0x83, 0x0c, 0x18, 0x06, 0xbb, 0x2a,
    0x20, 0x29, 0xad, 0xfb, 0xd9, 0x62, 0xae, 0x49,
    0x6c, 0xfa, 0x4c, 0xef, 0x6c, 0x56, 0xba, 0x9a
};

static unsigned char expectedPtexttt_4096[] = {
    0x5d, 0xec, 0x98, 0xeb, 0x0e, 0x5a, 0xa5, 0xc0, 0xd4, 0xb2, 0xae, 0xa1,
    0x00, 0xc7, 0x20, 0xb0, 0x3f, 0xfd, 0x79, 0x43, 0x78, 0xbf, 0xe7, 0x1c,
    0x71, 0x9a, 0x7c, 0x14, 0x6d, 0x32, 0xe9, 0x0a, 0xd5, 0xa4, 0x2e, 0x25,
    0x6d, 0x05, 0x65, 0x50, 0xcb, 0x6a, 0x21, 0x43, 0xe7, 0x55, 0x6c, 0x6b,
    0x81, 0x85, 0x32, 0x23, 0x7c, 0x17, 0x99, 0x06, 0x65, 0xbc, 0xe0, 0x3d,
    0x4b, 0x9d, 0xb7, 0xc3, 0x48, 0xd6, 0x2f, 0x4d, 0xae, 0x44, 0x3a, 0xfa,
    0x6a, 0xb7, 0x79, 0x9f, 0xe5, 0xf9, 0x4b, 0x14, 0x07, 0xda, 0x97, 0x64,
    0x9d, 0xd7, 0xd1, 0xf1, 0x1a, 0x2f, 0xdd, 0x6a, 0xa9, 0xbc, 0xb2, 0x1e,
    0x75, 0x37, 0x2f, 0xff, 0xb7, 0x8e, 0xc2, 0x77, 0x4d, 0xc0, 0x4d, 0xb6,
    0xb3, 0xc5, 0xda, 0xdd, 0xaf, 0x67, 0x18, 0x6b, 0x79, 0x5e, 0x83, 0xe1,
    0xaf, 0x49, 0xc6, 0xd8, 0xa3, 0x48, 0x2d, 0x5b, 0xbc, 0xac, 0x67, 0x97,
    0xf4, 0xde, 0x6a, 0x33, 0x93, 0xed, 0x77, 0xc2, 0xcc, 0xa4, 0xcf, 0xcb,
    0x3e, 0xe8, 0x02, 0x3d, 0x7d, 0x73, 0xe3, 0xc3, 0x4c, 0xc4, 0x98, 0x17,
    0x55, 0x56, 0x2b, 0xa3, 0x2e, 0xe2, 0xbe, 0x2a, 0x21, 0x03, 0xda, 0xe8,
    0x44, 0xd2, 0x45, 0x1b, 0xfc, 0x4f, 0xb3, 0x14, 0x9c, 0xf4, 0xcb, 0x37,
    0x23, 0x5f, 0x6a, 0x1e, 0x50, 0x7e, 0xa1, 0x72, 0x25, 0x73, 0xa4, 0x64,
    0xe4, 0x9b, 0xe5, 0xe0, 0x75, 0x0f, 0x31, 0x01, 0x82, 0x0a, 0xdf, 0x5d,
    0x22, 0xd1, 0x9f, 0x03, 0x95, 0x3c, 0x8b, 0x96, 0xb6, 0xe8, 0x95, 0x37,
    0x7a, 0x9c, 0x53, 0x3d, 0xc1, 0xc7, 0xc0, 0xd2, 0x5f, 0x3c, 0x87, 0xce,
    0xf4, 0x35, 0xff, 0x6e, 0x7d, 0x01, 0x83, 0x0c, 0x18, 0x06, 0xbb, 0x2a,
    0x20, 0x29, 0xad, 0xfb, 0xd9, 0x62, 0xae, 0x49, 0x6c, 0xfa, 0x4c, 0xef,
    0x6c, 0x56, 0xba, 0x9a, 0x77, 0x92, 0x45, 0xbf, 0x27, 0x73, 0x5f, 0x1f,
    0x9d, 0x41, 0xa1, 0x7c, 0x1c, 0x7b, 0xff, 0x26, 0xe5, 0xda, 0x43, 0x08,
    0x99, 0x7b, 0xb6, 0x30, 0xf5, 0x0f, 0xeb, 0x50, 0x46, 0xee, 0x92, 0x21,
    0x86, 0xbd, 0xab, 0x78, 0xcf, 0xd4, 0xee, 0xb4, 0x09, 0x0d, 0x5a, 0x89,
    0x8d, 0xe8, 0x4c, 0x23, 0xde, 0x67, 0x7f, 0xec, 0x12, 0xc5, 0xa5, 0xfb,
    0xaa, 0xa7, 0x57, 0x49, 0xb5, 0x4b, 0xc0, 0x82, 0x63, 0x05, 0xab, 0x71,
    0xec, 0x56, 0xaa, 0x7c, 0x43, 0xe8, 0xcb, 0xf1, 0x9c, 0xef, 0x13, 0xad,
    0x29, 0x9c, 0x8c, 0xf9, 0x5d, 0x2b, 0xe8, 0x5a, 0x73, 0x44, 0x6e, 0x11,
    0x9d, 0x6a, 0x51, 0xc2, 0xeb, 0x56, 0x67, 0xe2, 0xf1, 0xc7, 0xb7, 0x74,
    0x7c, 0xc5, 0x37, 0x68, 0xbe, 0xb1, 0xd4, 0xea, 0x43, 0x5b, 0xfe, 0x6a,
    0xea, 0xb8, 0xbf, 0xa8, 0xa7, 0xa9, 0x20, 0x3d, 0xcc, 0xfa, 0xb6, 0xb8,
    0x63, 0x79, 0xf0, 0x10, 0x25, 0xfe, 0xae, 0xf1, 0xf2, 0xb1, 0x96, 0xf5,
    0x53, 0x8b, 0x7e, 0x6d, 0x4e, 0x68, 0x67, 0xf1, 0x57, 0x81, 0x63, 0xde,
    0x3c, 0xb0, 0xdd, 0xa1, 0x8e, 0xc1, 0xa9, 0x37, 0xfa, 0xfd, 0xaa, 0xdb,
    0x49, 0x3a, 0xd1, 0x19, 0x92, 0xda, 0x60, 0x00, 0xf7, 0x04, 0x50, 0x83,
    0x5a, 0xdf, 0xf3, 0xdb, 0xda, 0x4c, 0x38, 0xe4, 0x46, 0xf0, 0xe6, 0x5f,
    0x9e, 0x50, 0x0f, 0x38, 0x7a, 0xd1, 0x28, 0x52, 0xdd, 0x5f, 0xfd, 0xe4,
    0xab, 0xa3, 0x9b, 0x15, 0x7b, 0x92, 0xfe, 0x73, 0x3c, 0x45, 0x1a, 0x73,
    0x4d, 0xa8, 0xf5, 0x74, 0x26, 0x81, 0xa5, 0x96, 0x7f, 0x65, 0x85, 0xe6,
    0x1f, 0x47, 0xd4, 0x17, 0x20, 0xa0, 0x8b, 0x61, 0xfb, 0x3e, 0xa2, 0x86,
    0x26, 0x27, 0x8a, 0x4b, 0xaf, 0x41, 0x67, 0x54, 0xd9, 0x80, 0xfc, 0xbd,
    0xc3, 0x7b, 0x81, 0x7c, 0x33, 0x2f, 0x5d, 0x82
};

static unsigned char expectedPtexttt_8192[] = {
    0x5d, 0xec, 0x98, 0xeb, 0x0e, 0x5a, 0xa5, 0xc0, 0xd4, 0xb2, 0xae, 0xa1,
    0x00, 0xc7, 0x20, 0xb0, 0x3f, 0xfd, 0x79, 0x43, 0x78, 0xbf, 0xe7, 0x1c,
    0x71, 0x9a, 0x7c, 0x14, 0x6d, 0x32, 0xe9, 0x0a, 0xd5, 0xa4, 0x2e, 0x25,
    0x6d, 0x05, 0x65, 0x50, 0xcb, 0x6a, 0x21, 0x43, 0xe7, 0x55, 0x6c, 0x6b,
    0x81, 0x85, 0x32, 0x23, 0x7c, 0x17, 0x99, 0x06, 0x65, 0xbc, 0xe0, 0x3d,
    0x4b, 0x9d, 0xb7, 0xc3, 0x48, 0xd6, 0x2f, 0x4d, 0xae, 0x44, 0x3a, 0xfa,
    0x6a, 0xb7, 0x79, 0x9f, 0xe5, 0xf9, 0x4b, 0x14, 0x07, 0xda, 0x97, 0x64,
    0x9d, 0xd7, 0xd1, 0xf1, 0x1a, 0x2f, 0xdd, 0x6a, 0xa9, 0xbc, 0xb2, 0x1e,
    0x75, 0x37, 0x2f, 0xff, 0xb7, 0x8e, 0xc2, 0x77, 0x4d, 0xc0, 0x4d, 0xb6,
    0xb3, 0xc5, 0xda, 0xdd, 0xaf, 0x67, 0x18, 0x6b, 0x79, 0x5e, 0x83, 0xe1,
    0xaf, 0x49, 0xc6, 0xd8, 0xa3, 0x48, 0x2d, 0x5b, 0xbc, 0xac, 0x67, 0x97,
    0xf4, 0xde, 0x6a, 0x33, 0x93, 0xed, 0x77, 0xc2, 0xcc, 0xa4, 0xcf, 0xcb,
    0x3e, 0xe8, 0x02, 0x3d, 0x7d, 0x73, 0xe3, 0xc3, 0x4c, 0xc4, 0x98, 0x17,
    0x55, 0x56, 0x2b, 0xa3, 0x2e, 0xe2, 0xbe, 0x2a, 0x21, 0x03, 0xda, 0xe8,
    0x44, 0xd2, 0x45, 0x1b, 0xfc, 0x4f, 0xb3, 0x14, 0x9c, 0xf4, 0xcb, 0x37,
    0x23, 0x5f, 0x6a, 0x1e, 0x50, 0x7e, 0xa1, 0x72, 0x25, 0x73, 0xa4, 0x64,
    0xe4, 0x9b, 0xe5, 0xe0, 0x75, 0x0f, 0x31, 0x01, 0x82, 0x0a, 0xdf, 0x5d,
    0x22, 0xd1, 0x9f, 0x03, 0x95, 0x3c, 0x8b, 0x96, 0xb6, 0xe8, 0x95, 0x37,
    0x7a, 0x9c, 0x53, 0x3d, 0xc1, 0xc7, 0xc0, 0xd2, 0x5f, 0x3c, 0x87, 0xce,
    0xf4, 0x35, 0xff, 0x6e, 0x7d, 0x01, 0x83, 0x0c, 0x18, 0x06, 0xbb, 0x2a,
    0x20, 0x29, 0xad, 0xfb, 0xd9, 0x62, 0xae, 0x49, 0x6c, 0xfa, 0x4c, 0xef,
    0x6c, 0x56, 0xba, 0x9a, 0x77, 0x92, 0x45, 0xbf, 0x27, 0x73, 0x5f, 0x1f,
    0x9d, 0x41, 0xa1, 0x7c, 0x1c, 0x7b, 0xff, 0x26, 0xe5, 0xda, 0x43, 0x08,
    0x99, 0x7b, 0xb6, 0x30, 0xf5, 0x0f, 0xeb, 0x50, 0x46, 0xee, 0x92, 0x21,
    0x86, 0xbd, 0xab, 0x78, 0xcf, 0xd4, 0xee, 0xb4, 0x09, 0x0d, 0x5a, 0x89,
    0x8d, 0xe8, 0x4c, 0x23, 0xde, 0x67, 0x7f, 0xec, 0x12, 0xc5, 0xa5, 0xfb,
    0xaa, 0xa7, 0x57, 0x49, 0xb5, 0x4b, 0xc0, 0x82, 0x63, 0x05, 0xab, 0x71,
    0xec, 0x56, 0xaa, 0x7c, 0x43, 0xe8, 0xcb, 0xf1, 0x9c, 0xef, 0x13, 0xad,
    0x29, 0x9c, 0x8c, 0xf9, 0x5d, 0x2b, 0xe8, 0x5a, 0x73, 0x44, 0x6e, 0x11,
    0x9d, 0x6a, 0x51, 0xc2, 0xeb, 0x56, 0x67, 0xe2, 0xf1, 0xc7, 0xb7, 0x74,
    0x7c, 0xc5, 0x37, 0x68, 0xbe, 0xb1, 0xd4, 0xea, 0x43, 0x5b, 0xfe, 0x6a,
    0xea, 0xb8, 0xbf, 0xa8, 0xa7, 0xa9, 0x20, 0x3d, 0xcc, 0xfa, 0xb6, 0xb8,
    0x63, 0x79, 0xf0, 0x10, 0x25, 0xfe, 0xae, 0xf1, 0xf2, 0xb1, 0x96, 0xf5,
    0x53, 0x8b, 0x7e, 0x6d, 0x4e, 0x68, 0x67, 0xf1, 0x57, 0x81, 0x63, 0xde,
    0x3c, 0xb0, 0xdd, 0xa1, 0x8e, 0xc1, 0xa9, 0x37, 0xfa, 0xfd, 0xaa, 0xdb,
    0x49, 0x3a, 0xd1, 0x19, 0x92, 0xda, 0x60, 0x00, 0xf7, 0x04, 0x50, 0x83,
    0x5a, 0xdf, 0xf3, 0xdb, 0xda, 0x4c, 0x38, 0xe4, 0x46, 0xf0, 0xe6, 0x5f,
    0x9e, 0x50, 0x0f, 0x38, 0x7a, 0xd1, 0x28, 0x52, 0xdd, 0x5f, 0xfd, 0xe4,
    0xab, 0xa3, 0x9b, 0x15, 0x7b, 0x92, 0xfe, 0x73, 0x3c, 0x45, 0x1a, 0x73,
    0x4d, 0xa8, 0xf5, 0x74, 0x26, 0x81, 0xa5, 0x96, 0x7f, 0x65, 0x85, 0xe6,
    0x1f, 0x47, 0xd4, 0x17, 0x20, 0xa0, 0x8b, 0x61, 0xfb, 0x3e, 0xa2, 0x86,
    0x26, 0x27, 0x8a, 0x4b, 0xaf, 0x41, 0x67, 0x54, 0xd9, 0x80, 0xfc, 0xbd,
    0xc3, 0x7b, 0x81, 0x7c, 0x33, 0x2f, 0x5d, 0x82, 0x77, 0xc2, 0xcc, 0xa4,
    0xcf, 0xcb, 0x3e, 0xe8, 0x02, 0x3d, 0x7d, 0x73, 0xe3, 0xc3, 0x4c, 0xc4,
    0x98, 0x17, 0x55, 0x56, 0x2b, 0xa3, 0x2e, 0xe2, 0xbe, 0x2a, 0x21, 0x03,
    0xda, 0xe8, 0x44, 0xd2, 0x45, 0x1b, 0xfc, 0x4f, 0xb3, 0x14, 0x9c, 0xf4,
    0xcb, 0x37, 0x23, 0x5f, 0x6a, 0x1e, 0x50, 0x7e, 0xa1, 0x72, 0x25, 0x73,
    0x29, 0x9c, 0x8c, 0xf9, 0x5d, 0x2b, 0xe8, 0x5a, 0x73, 0x44, 0x6e, 0x11,
    0x9d, 0x6a, 0x51, 0xc2, 0xeb, 0x56, 0x67, 0xe2, 0xf1, 0xc7, 0xb7, 0x74,
    0x7c, 0xc5, 0x37, 0x68, 0xbe, 0xb1, 0xd4, 0xea, 0x43, 0x5b, 0xfe, 0x6a,
    0xea, 0xb8, 0xbf, 0xa8, 0xa7, 0xa9, 0x20, 0x3d, 0xcc, 0xfa, 0xb6, 0xb8,
    0x63, 0x79, 0xf0, 0x10, 0x25, 0xfe, 0xae, 0xf1, 0xf2, 0xb1, 0x96, 0xf5,
    0x53, 0x8b, 0x7e, 0x6d, 0x4e, 0x68, 0x67, 0xf1, 0x57, 0x81, 0x63, 0xde,
    0x3c, 0xb0, 0xdd, 0xa1, 0x8e, 0xc1, 0xa9, 0x37, 0xfa, 0xfd, 0xaa, 0xdb,
    0x49, 0x3a, 0xd1, 0x19, 0x92, 0xda, 0x60, 0x00, 0xf7, 0x04, 0x50, 0x83,
    0xea, 0xb8, 0xbf, 0xa8, 0xa7, 0xa9, 0x20, 0x3d, 0xcc, 0xfa, 0xb6, 0xb8,
    0x63, 0x79, 0xf0, 0x10, 0x25, 0xfe, 0xae, 0xf1, 0xf2, 0xb1, 0x96, 0xf5,
    0x53, 0x8b, 0x7e, 0x6d, 0x4e, 0x68, 0x67, 0xf1, 0x57, 0x81, 0x63, 0xde,
    0x3c, 0xb0, 0xdd, 0xa1, 0x8e, 0xc1, 0xa9, 0x37, 0xfa, 0xfd, 0xaa, 0xdb,
    0x49, 0x3a, 0xd1, 0x19, 0x92, 0xda, 0x60, 0x00, 0xf7, 0x04, 0x50, 0x83,
    0x44, 0xd2, 0x45, 0x1b, 0xfc, 0x4f, 0xb3, 0x14, 0x9c, 0xf4, 0xcb, 0x37,
    0x23, 0x5f, 0x6a, 0x1e, 0x50, 0x7e, 0xa1, 0x72, 0x25, 0x73, 0xa4, 0x64,
    0xe4, 0x9b, 0xe5, 0xe0, 0x75, 0x0f, 0x31, 0x01, 0x82, 0x0a, 0xdf, 0x5d,
    0x22, 0xd1, 0x9f, 0x03, 0x95, 0x3c, 0x8b, 0x96, 0xb6, 0xe8, 0x95, 0x37,
    0x1f, 0x47, 0xd4, 0x17, 0x20, 0xa0, 0x8b, 0x61, 0xfb, 0x3e, 0xa2, 0x86,
    0x26, 0x27, 0x8a, 0x4b, 0xaf, 0x41, 0x67, 0x54, 0xd9, 0x80, 0xfc, 0xbd,
    0xc3, 0x7b, 0x81, 0x7c, 0x33, 0x2f, 0x5d, 0x82, 0x77, 0xc2, 0xcc, 0xa4,
    0x9d, 0x41, 0xa1, 0x7c, 0x1c, 0x7b, 0xff, 0x26, 0xe5, 0xda, 0x43, 0x08,
    0x99, 0x7b, 0xb6, 0x30, 0xf5, 0x0f, 0xeb, 0x50, 0x46, 0xee, 0x92, 0x21,
    0x86, 0xbd, 0xab, 0x78, 0xcf, 0xd4, 0xee, 0xb4, 0x09, 0x0d, 0x5a, 0x89,
    0x8d, 0xe8, 0x4c, 0x23, 0xde, 0x67, 0x7f, 0xec, 0x12, 0xc5, 0xa5, 0xfb,
    0x7c, 0xc5, 0x37, 0x68, 0xbe, 0xb1, 0xd4, 0xea, 0x43, 0x5b, 0xfe, 0x6a,
    0xea, 0xb8, 0xbf, 0xa8, 0xa7, 0xa9, 0x20, 0x3d, 0xcc, 0xfa, 0xb6, 0xb8,
    0x63, 0x79, 0xf0, 0x10, 0x25, 0xfe, 0xae, 0xf1, 0xf2, 0xb1, 0x96, 0xf5,
    0x53, 0x8b, 0x7e, 0x6d, 0x4e, 0x68, 0x67, 0xf1, 0x57, 0x81, 0x63, 0xde,
    0x5a, 0xdf, 0xf3, 0xdb, 0xda, 0x4c, 0x38, 0xe4, 0x46, 0xf0, 0xe6, 0x5f,
    0x9e, 0x50, 0x0f, 0x38, 0x7a, 0xd1, 0x28, 0x52, 0xdd, 0x5f, 0xfd, 0xe4,
    0xab, 0xa3, 0x9b, 0x15, 0x7b, 0x92, 0xfe, 0x73, 0x3c, 0x45, 0x1a, 0x73,
    0x4d, 0xa8, 0xf5, 0x74, 0x26, 0x81, 0xa5, 0x96, 0x7f, 0x65, 0x85, 0xe6,
    0x1f, 0x47, 0xd4, 0x17, 0x20, 0xa0, 0x8b, 0x61, 0xfb, 0x3e, 0xa2, 0x86,
    0x9d, 0x41, 0xa1, 0x7c, 0x1c, 0x7b, 0xff, 0x26, 0xe5, 0xda, 0x43, 0x08,
    0x99, 0x7b, 0xb6, 0x30, 0xf5, 0x0f, 0xeb, 0x50, 0x46, 0xee, 0x92, 0x21,
    0x86, 0xbd, 0xab, 0x78, 0xcf, 0xd4, 0xee, 0xb4, 0x09, 0x0d, 0x5a, 0x89,
    0x8d, 0xe8, 0x4c, 0x23, 0xde, 0x67, 0x7f, 0xec, 0x12, 0xc5, 0xa5, 0xfb,
    0x22, 0xd1, 0x9f, 0x03, 0x95, 0x3c, 0x8b, 0x96, 0xb6, 0xe8, 0x95, 0x37,
    0x1f, 0x47, 0xd4, 0x17
};

static const char* get_padding_str(int padding)
{
    char *pad_str;
    switch (padding) {
    case RSA_NO_PADDING:
        pad_str = "RSA_NO_PADDING";
        break;
    case RSA_PKCS1_PADDING:
        pad_str = "RSA_PKCS1_PADDING";
        break;
    case RSA_X931_PADDING:
        pad_str = "RSA_X931_PADDING";
        break;
    case RSA_PKCS1_OAEP_PADDING:
        pad_str = "RSA_PKCS1_OAEP_PADDING";
        break;
    default:
        pad_str = "UNKNOWN PADDING";
   }
   return pad_str;
}

/******************************************************************************
* function:
*   run_rsa (void *args)
*
* @param args [IN] - the test parameters
*
* description:
*   the test application for RSA sign and verify using QAT engine.
*   The OpenSSL corresponding RSA_private_encrypt() and RSA_public_decrypt()
*   functions are used in this application.
*   The values of RSA key structures are passed from Intel API RSA test vector.
******************************************************************************/
static int run_rsa(void *args)
{
    int i = 0;
    int sigLen = 0;
    int verLen = 0;
    int ret = 1;

    TEST_PARAMS *temp_args = (TEST_PARAMS *)args;
    struct async_additional_args_rsa *extra_args =
        (struct async_additional_args_rsa *)temp_args->additional_args;
    int count = *(temp_args->count);
    int size = temp_args->size;
    int print_output = temp_args->print_output;
    int verify = temp_args->verify;
    int sign_only = extra_args->sign_only;
    int verify_only = extra_args->verify_only;
    int encrypt_only = extra_args->encrypt_only;
    int decrypt_only = extra_args->decrypt_only;
    int pad = extra_args->padding;

    RSA *key = NULL;
    BIGNUM *n = NULL;
    BIGNUM *e = NULL;
    BIGNUM *d = NULL;
    BIGNUM *p = NULL;
    BIGNUM *q = NULL;
    BIGNUM *dmp1 = NULL;
    BIGNUM *dmq1 = NULL;
    BIGNUM *iqmp = NULL;

    unsigned char *sig = OPENSSL_malloc(RSA_SIZE);
    unsigned char *verMsg = OPENSSL_malloc(RSA_SIZE);
    int hash_length = 0;
    unsigned char *HashData = OPENSSL_malloc(HASH_DATA_SIZE_NO_PADDING_8192);
    unsigned char *ctext = NULL;
    unsigned char *ptext = NULL;
    int plen = 0;
    int expectedPlen = 0;
    int clen = 0;
    unsigned char * expectedPtext = NULL;
    const char* pad_str;

    if (sig == NULL || verMsg == NULL || HashData == NULL) {
        WARN("# FAIL RSA Initial mallocs failed\n");
        ret = 0;
        goto err;
    }
    pad_str = get_padding_str(pad);
    pad_str = pad_str; /* only used in DEBUG mode */

    DEBUG("[%s] Input:\n sign_only = %d \n verify_only = %d \n"
          "encrypt_only = %d \n decrypt_only = %d\n padding = %s\n --- \n",
          __func__, sign_only, verify_only, encrypt_only, decrypt_only,
          pad_str);


    /* setup input hash message */
    for (i = 0; i < HASH_DATA_SIZE_NO_PADDING_8192; i++)
        HashData[i] = i % 16;

    /* setup new RSA key */
    key = RSA_new();

    /*
     * initialise RSA key components by copying intel testing vector to RSA key
     * structure
     * pass input size to support RSA module size
     */
    if (size <= 1024) {
        /* bignumber format needed for RSA sturcture */
        DEBUG("\n RSA module size 1024 \n");

        if (pad == RSA_NO_PADDING)
           hash_length = HASH_DATA_SIZE_NO_PADDING_1024;
        else
           hash_length = HASH_DATA_SIZE_1024;

        expectedPtext = OPENSSL_malloc(sizeof(expectedPtexttt_1024));
        if (expectedPtext == NULL) {
            WARN("# FAIL RSA expectedPtext malloc failed\n");
            ret = 0;
            goto err;
        }
        memcpy(expectedPtext, expectedPtexttt_1024,
               sizeof(expectedPtexttt_1024));
        if (pad == RSA_PKCS1_OAEP_PADDING)
            expectedPlen =
                sizeof(expectedPtexttt_1024) - RSA_PKCS1_OAEP_PADDING_SIZE;
        else if (pad == RSA_PKCS1_PADDING)
            expectedPlen =
                sizeof(expectedPtexttt_1024) - RSA_PKCS1_PADDING_SIZE;
        else
            expectedPlen = sizeof(expectedPtexttt_1024);

        if (((n = BN_bin2bn(rsaModulusN_1024,
                            sizeof(rsaModulusN_1024), NULL)) == NULL) ||
            ((e = BN_bin2bn(rsaPublicExponentE_1024,
                            sizeof(rsaPublicExponentE_1024), NULL)) == NULL) ||
            ((d = BN_bin2bn(rsaPrivateExponentD_1024,
                            sizeof(rsaPrivateExponentD_1024), NULL)) == NULL) ||
            ((p = BN_bin2bn(rsaPrimeP_1024_KeyPair,
                            sizeof(rsaPrimeP_1024_KeyPair), NULL)) == NULL) ||
            ((q = BN_bin2bn(rsaPrimeQ_1024_KeyPair,
                            sizeof(rsaPrimeQ_1024_KeyPair), NULL)) == NULL) ||
            ((dmp1 = BN_bin2bn(rsaCrtExpDp_1024_KeyPair,
                           sizeof(rsaCrtExpDp_1024_KeyPair), NULL)) == NULL) ||
            ((dmq1 = BN_bin2bn(rsaCrtExpDq_1024_KeyPair,
                           sizeof(rsaCrtExpDq_1024_KeyPair), NULL)) == NULL) ||
            ((iqmp = BN_bin2bn(rsaCrtCoefQInv_1024_KeyPair,
                        sizeof(rsaCrtCoefQInv_1024_KeyPair), NULL)) == NULL)) {
            WARN("# FAIL RSA - Failed setting 1024 bit parameters\n");
            ret = 0;
            if (n) BN_free(n);
            if (e) BN_free(e);
            if (d) BN_free(d);
            if (p) BN_free(p);
            if (q) BN_free(q);
            if (dmp1) BN_free(dmp1);
            if (dmq1) BN_free(dmq1);
            if (iqmp) BN_free(iqmp);
            goto err;
        }
    }

    if (size > 1024 && size <= 2048) {
        /* bignumber format needed for RSA sturcture */
        DEBUG("\n RSA module size 2048 \n");

        if (pad == RSA_NO_PADDING)
           hash_length = HASH_DATA_SIZE_NO_PADDING_2048;
        else
           hash_length = HASH_DATA_SIZE_2048;

        expectedPtext = OPENSSL_malloc(sizeof(expectedPtexttt_2048));
        if (expectedPtext == NULL) {
            WARN("# FAIL RSA expectedPtext malloc failed\n");
            ret = 0;
            goto err;
        }
        memcpy(expectedPtext, expectedPtexttt_2048,
               sizeof(expectedPtexttt_2048));
        if (pad == RSA_PKCS1_OAEP_PADDING)
            expectedPlen = sizeof(expectedPtexttt_2048) -
                RSA_PKCS1_OAEP_PADDING_SIZE;
        else if (pad == RSA_PKCS1_PADDING)
            expectedPlen = sizeof(expectedPtexttt_2048) -
                RSA_PKCS1_PADDING_SIZE;
        else
            expectedPlen = sizeof(expectedPtexttt_2048);

        if (((n = BN_bin2bn(rsaModulusN_2048,
                            sizeof(rsaModulusN_2048), NULL)) == NULL) ||
            ((e = BN_bin2bn(rsaPublicExponentE_2048,
                            sizeof(rsaPublicExponentE_2048), NULL)) == NULL) ||
            ((d = BN_bin2bn(rsaPrivateExponentD_2048,
                           sizeof(rsaPrivateExponentD_2048), NULL)) == NULL) ||
            ((p = BN_bin2bn(rsaPrimeP_2048_KeyPair,
                            sizeof(rsaPrimeP_2048_KeyPair), NULL)) == NULL) ||
            ((q = BN_bin2bn(rsaPrimeQ_2048_KeyPair,
                            sizeof(rsaPrimeQ_2048_KeyPair), NULL)) == NULL) ||
            ((dmp1 = BN_bin2bn(rsaCrtExpDp_2048_KeyPair,
                        sizeof(rsaCrtExpDp_2048_KeyPair), NULL)) == NULL) ||
            ((dmq1 = BN_bin2bn(rsaCrtExpDq_2048_KeyPair,
                        sizeof(rsaCrtExpDq_2048_KeyPair), NULL)) == NULL) ||
            ((iqmp = BN_bin2bn(rsaCrtCoefQInv_2048_KeyPair,
                         sizeof(rsaCrtCoefQInv_2048_KeyPair), NULL)) == NULL)) {
            WARN("# FAIL RSA - Failed setting 2048 bit parameters\n");
            ret = 0;
            if (n) BN_free(n);
            if (e) BN_free(e);
            if (d) BN_free(d);
            if (p) BN_free(p);
            if (q) BN_free(q);
            if (dmp1) BN_free(dmp1);
            if (dmq1) BN_free(dmq1);
            if (iqmp) BN_free(iqmp);
            goto err;
        }
    }

    if (size > 2048 && size <= 4096) {
        /* bignumber format needed for RSA sturcture */
        DEBUG("\n RSA module size 4096 \n");

        if (pad == RSA_NO_PADDING)
           hash_length = HASH_DATA_SIZE_NO_PADDING_4096;
        else
           hash_length = HASH_DATA_SIZE_4096;

        expectedPtext = OPENSSL_malloc(sizeof(expectedPtexttt_4096));
        if (expectedPtext == NULL) {
            WARN("# FAIL RSA expectedPtext malloc failed\n");
            ret = 0;
            goto err;
        }
        memcpy(expectedPtext, expectedPtexttt_4096,
               sizeof(expectedPtexttt_4096));
        if (pad == RSA_PKCS1_OAEP_PADDING)
            expectedPlen = sizeof(expectedPtexttt_4096) -
                RSA_PKCS1_OAEP_PADDING_SIZE;
        else if (pad == RSA_PKCS1_PADDING)
            expectedPlen = sizeof(expectedPtexttt_4096) -
                RSA_PKCS1_PADDING_SIZE;
        else
            expectedPlen = sizeof(expectedPtexttt_4096);

        if (((n = BN_bin2bn(rsaModulusN_4096,
                            sizeof(rsaModulusN_4096), NULL)) == NULL) ||
            ((e = BN_bin2bn(rsaPublicExponentE_4096,
                            sizeof(rsaPublicExponentE_4096), NULL)) == NULL) ||
            ((d = BN_bin2bn(rsaPrivateExponentD_4096,
                           sizeof(rsaPrivateExponentD_4096), NULL)) == NULL) ||
            ((p = BN_bin2bn(rsaPrimeP_4096_KeyPair,
                           sizeof(rsaPrimeP_4096_KeyPair), NULL)) == NULL) ||
            ((q = BN_bin2bn(rsaPrimeQ_4096_KeyPair,
                           sizeof(rsaPrimeQ_4096_KeyPair), NULL)) == NULL) ||
            ((dmp1 = BN_bin2bn(rsaCrtExpDp_4096_KeyPair,
                        sizeof(rsaCrtExpDp_4096_KeyPair), NULL)) == NULL) ||
            ((dmq1 = BN_bin2bn(rsaCrtExpDq_4096_KeyPair,
                         sizeof(rsaCrtExpDq_4096_KeyPair), NULL)) == NULL) ||
            ((iqmp = BN_bin2bn(rsaCrtCoefQInv_4096_KeyPair,
                         sizeof(rsaCrtCoefQInv_4096_KeyPair), NULL)) == NULL)) {
            WARN("# FAIL RSA - Failed setting 4096 bit parameters\n");
            ret = 0;
            if (n) BN_free(n);
            if (e) BN_free(e);
            if (d) BN_free(d);
            if (p) BN_free(p);
            if (q) BN_free(q);
            if (dmp1) BN_free(dmp1);
            if (dmq1) BN_free(dmq1);
            if (iqmp) BN_free(iqmp);
            goto err;
        }
    }

     if (size >4096) {
        /* bignumber format needed for RSA sturcture */
        DEBUG("\n RSA module size 8192 \n");

        if (pad == RSA_NO_PADDING)
           hash_length = HASH_DATA_SIZE_NO_PADDING_8192;
        else
           hash_length = HASH_DATA_SIZE_8192;

        expectedPtext = OPENSSL_malloc(sizeof(expectedPtexttt_8192));
        if (expectedPtext == NULL) {
            WARN("# FAIL RSA expectedPtext malloc failed\n");
            ret = 0;
            goto err;
        }
        memcpy(expectedPtext, expectedPtexttt_8192, sizeof(expectedPtexttt_8192));
        if (pad == RSA_PKCS1_OAEP_PADDING)
            expectedPlen = sizeof(expectedPtexttt_8192) - RSA_PKCS1_OAEP_PADDING_SIZE;
        else if (pad == RSA_PKCS1_PADDING)
            expectedPlen = sizeof(expectedPtexttt_8192) - RSA_PKCS1_PADDING_SIZE;
        else
            expectedPlen = sizeof(expectedPtexttt_8192);

        if (((n = BN_bin2bn(rsaModulusN_8192,
                            sizeof(rsaModulusN_8192), NULL)) == NULL) ||
            ((e = BN_bin2bn(rsaPublicExponentE_8192,
                           sizeof(rsaPublicExponentE_8192), NULL)) == NULL) ||
            ((d = BN_bin2bn(rsaPrivateExponentD_8192,
                           sizeof(rsaPrivateExponentD_8192), NULL)) == NULL) ||
            ((p = BN_bin2bn(rsaPrimeP_8192_KeyPair,
                           sizeof(rsaPrimeP_8192_KeyPair), NULL)) == NULL) ||
            ((q = BN_bin2bn(rsaPrimeQ_8192_KeyPair,
                           sizeof(rsaPrimeQ_8192_KeyPair), NULL)) == NULL) ||
            ((dmp1 = BN_bin2bn(rsaCrtExpDp_8192_KeyPair,
                              sizeof(rsaCrtExpDp_8192_KeyPair), NULL)) == NULL) ||
            ((dmq1 = BN_bin2bn(rsaCrtExpDq_8192_KeyPair,
                              sizeof(rsaCrtExpDq_8192_KeyPair), NULL)) == NULL) ||
            ((iqmp = BN_bin2bn(rsaCrtCoefQInv_8192_KeyPair,
                   sizeof(rsaCrtCoefQInv_8192_KeyPair), NULL)) == NULL)) {
            WARN("# FAIL RSA - Failed setting 8192 bit parameters\n");
            ret = 0;
            if (n) BN_free(n);
            if (e) BN_free(e);
            if (d) BN_free(d);
            if (p) BN_free(p);
            if (q) BN_free(q);
            if (dmp1) BN_free(dmp1);
            if (dmq1) BN_free(dmq1);
            if (iqmp) BN_free(iqmp);
            goto err;
        }
    }

    RSA_set0_key(key, n, e, d);
    RSA_set0_factors(key, p, q);
    RSA_set0_crt_params(key, dmp1, dmq1, iqmp);

    /* the op buffer for pub enc needs to be the pub key size*/
    ctext = OPENSSL_malloc(RSA_size(key));
    ptext = OPENSSL_malloc(RSA_size(key));

    for (i = 0; i < count; i++) {
        /*
         * For functional tests we need to run verify anyway,
         *  i.e., even if sign only
         */
        if ((!i || sign_only) && (!encrypt_only && !decrypt_only)) {
            DEBUG("\n----- RSA Sign   ----- \n\n");
            if (print_output)
                tests_hexdump("Hashdata:", HashData, hash_length);

            /*
             * the RSA_private_encrypt() function returns the length of
             * signature
             * a signature file contains all 0xFF will be returned if
             * RSA_private_encrypt() fails
             */
            sigLen = RSA_private_encrypt(hash_length, /* length in bytes of input file */
                                         HashData,  /* input data pointer */
                                         sig,   /* output signature pointer */
                                         key,   /* RSA key structure */
                                         pad);  /* padding format */
            if (sigLen <= 0) {
                WARN("# FAIL RSA - Sign Failed\n");
                ret = 0;
                goto err;
            }
            else
                DEBUG("----- RSA Sign completed  ----- \n");

            if (print_output)
                tests_hexdump("Signature:", sig, sigLen);
        } /* (!i || sign_only) */

        /*Sign*/
        if ((!i || verify_only) && (!encrypt_only && !decrypt_only)) {
            DEBUG("\n----- RSA Verify   ----- \n\n");

            if (print_output)
                tests_hexdump("Signature:", sig, sigLen);

            /*
             * RSA_public_decrypt() returns the length of the verified message
             * A verified file containing all 0xFF will be returned if
             * RSA_private_encrypt() fails
             */
            verLen = RSA_public_decrypt(sigLen, /* length in bytes of input signature */
                                        sig,    /* input signature */
                                        verMsg, /* output verify message pointer */
                                        key,    /* RSA key structure */
                                        pad);   /* padding format */
            if (verLen <= 0) {
                WARN("# FAIL RSA - Verify Failed\n");
                ret = 0;
                goto err;
            }
            else
                DEBUG("----- RSA Verify completed  ----- \n");

            if (print_output)
                tests_hexdump("Verify:", verMsg, verLen);
        }

        /*For functional tests we need to run encrypt anyway*/
        if ((!i || encrypt_only) && (!sign_only && !verify_only)) {
            DEBUG("\n----- RSA Encrypt   ----- \n\n");

            if (print_output)
                tests_hexdump("Plain text:", expectedPtext, expectedPlen);

            clen = RSA_public_encrypt(expectedPlen,   /* length in bytes of input file */
                                      expectedPtext,  /* input data pointer */
                                      ctext,   /* output ciphertext pointer */
                                      key,   /* RSA key structure */
                                      pad);  /* padding format */
            if (clen <= 0) {
                WARN("# FAIL RSA - Encrypt Failed\n");
                ret = 0;
                goto err;
            }
            else
                DEBUG("----- RSA Encrypt completed  ----- \n");

            if (print_output)
                tests_hexdump("Cipher text:", ctext, clen);
        }

        if ((!i || decrypt_only)  && (!sign_only && !verify_only)) {
            DEBUG("\n----- RSA Decrypt   ----- \n\n");

            if (print_output)
                tests_hexdump("Cipher text:", ctext, clen);

            plen = RSA_private_decrypt(clen,   /* length in bytes of input file */
                                       ctext,  /* input data pointer */
                                       ptext,   /* output ciphertext pointer */
                                       key,   /* RSA key structure */
                                       pad);  /* padding format */
            if (plen <= 0) {
                WARN("# FAIL RSA - Decrypt Failed\n");
                ret = 0;
                goto err;
            }
            else
                DEBUG("----- RSA Decrypt completed  ----- \n");

            if (print_output)
                tests_hexdump("Plain text:", ptext, plen);
        }
    } /* count for-loop */

    if (encrypt_only || decrypt_only) {
        /* Compare and verify the encrypted and decrypted message */
        if (verify) {
            if (memcmp(ptext, expectedPtext, plen))
            {
                INFO("# FAIL %s for RSA with %s\n",
                     encrypt_only ? "encrypt" : "decrypt",
                     pad_str);
                ret = 0;

                tests_hexdump("Actual plain text:", expectedPtext,
                              expectedPlen);
                tests_hexdump("Decrypted plain text:", ptext, plen);
            }
            else
                INFO("# PASS %s for RSA with %s\n",
                     encrypt_only ? "encrypt" : "decrypt",
                     pad_str);
         }
    }

    if (sign_only || verify_only) {
        /* Compare and verify the signed and verified message */
        if (verify) {
            if (memcmp(verMsg, HashData, verLen)) {
                INFO("# FAIL %s for RSA with %s\n",
                     sign_only ? "sign" : "verify", pad_str);
                ret = 0;

                tests_hexdump("Verified actual:", verMsg, verLen);
                tests_hexdump("Signed expected:", HashData, hash_length);
            } else
                INFO("# PASS %s for RSA with %s\n",
                     sign_only ? "sign" : "verify", pad_str);
        }
    }

err:
    if (sig)
        OPENSSL_free(sig);
    if (verMsg)
        OPENSSL_free(verMsg);
    if (HashData)
        OPENSSL_free(HashData);
    if (expectedPtext)
        OPENSSL_free(expectedPtext);
    RSA_free(key);
    return ret;
}


static void rsa_tests_triage(TEST_PARAMS *args, int sign_only,
                             int verify_only, int encrypt_only,
                             int decrypt_only)
{
    int i;
    struct async_additional_args_rsa extra_args;
    args->additional_args = &extra_args;
    extra_args.sign_only = sign_only;
    extra_args.verify_only = verify_only;
    extra_args.encrypt_only = encrypt_only;
    extra_args.decrypt_only = decrypt_only;

    for (i = 0; i < sizeof(padding) / sizeof(padding[0]); i++) {
        extra_args.padding = padding[i];
        if (((padding[i] == RSA_PKCS1_OAEP_PADDING) &&
            (sign_only || verify_only)) ||
            ((padding[i] == RSA_X931_PADDING) &&
            (encrypt_only || decrypt_only)))
            continue;
        if (!args->enable_async)
            run_rsa(args);
        else {
            start_async_job(args, run_rsa);
        }
    }
}

/******************************************************************************
* function:
*      tests_run_rsa (TEST_PARAMS *args)
*
* @param args [IN] - the test parameters
*
* description:
*   specify a test case
*
******************************************************************************/

void tests_run_rsa(TEST_PARAMS *args)
{
    rsa_tests_triage(args, args->sign_only, args->verify_only,
                     args->encrypt_only, args->decrypt_only);
}
