/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.secrets.api.EntropyChecker;
import org.sonar.plugins.secrets.api.RegexMatcher;
import org.sonar.plugins.secrets.api.SecretCheck;
import org.sonar.plugins.secrets.api.SecretRule;

@Rule(key="S6290")
public class AwsCheck
extends SecretCheck {
    private static final String NO_MATCH_SUFFIX = "EXAMPLE";

    public AwsCheck() {
        super(new SecretRule("Make sure this AWS Secret Access Key is not disclosed.", EntropyChecker::hasLowEntropy, new RegexMatcher("(?i)aws.{0,50}['\"`]([0-9a-z\\/+]{40})['\"`]"), new RegexMatcher("(?i)\\b(?:AWS)?_?SECRET_?(?:ACCESS)?_?KEY\\b.{0,10}\\b([0-9a-z\\/+]{40})\\b")), new SecretRule("Make sure this AWS Access Key ID is not disclosed.", matchedText -> matchedText.endsWith(NO_MATCH_SUFFIX), new RegexMatcher("\\b((?:AKIA|ASIA)[A-Z0-9]{16})\\b")), new SecretRule("Make sure this AWS Session Token is not disclosed.", new RegexMatcher("(?i)session_?token.*?([0-9a-z\\/+=]{100,})")));
    }
}

