/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.jacoco.WildcardPatternFileScanner;

class ReportPathsProvider {
    private static final Logger LOG = Loggers.get(ReportPathsProvider.class);
    private static final String[] DEFAULT_PATHS = new String[]{"target/site/jacoco/jacoco.xml", "target/site/jacoco-it/jacoco.xml", "build/reports/jacoco/test/jacocoTestReport.xml"};
    static final String REPORT_PATHS_PROPERTY_KEY = "sonar.coverage.jacoco.xmlReportPaths";
    private final SensorContext context;

    ReportPathsProvider(SensorContext context) {
        this.context = context;
    }

    Collection<Path> getPaths() {
        Path baseDir = this.context.fileSystem().baseDir().toPath().toAbsolutePath();
        List patternPathList = Stream.of(this.context.config().getStringArray(REPORT_PATHS_PROPERTY_KEY)).filter(pattern -> !pattern.isEmpty()).collect(Collectors.toList());
        HashSet<Path> reportPaths = new HashSet<Path>();
        if (!patternPathList.isEmpty()) {
            for (String patternPath : patternPathList) {
                List<Path> paths = WildcardPatternFileScanner.scan(baseDir, patternPath);
                if (paths.isEmpty() && patternPathList.size() > 1) {
                    LOG.info("Coverage report doesn't exist for pattern: '{}'", (Object)patternPath);
                }
                reportPaths.addAll(paths);
            }
        }
        if (!reportPaths.isEmpty()) {
            return reportPaths;
        }
        if (!patternPathList.isEmpty()) {
            LOG.warn("No coverage report can be found with sonar.coverage.jacoco.xmlReportPaths='{}'. Using default locations: {}", (Object)String.join((CharSequence)",", patternPathList), (Object)String.join((CharSequence)",", DEFAULT_PATHS));
        } else {
            LOG.info("'sonar.coverage.jacoco.xmlReportPaths' is not defined. Using default locations: {}", (Object)String.join((CharSequence)",", DEFAULT_PATHS));
        }
        return Arrays.stream(DEFAULT_PATHS).map(baseDir::resolve).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }
}

