/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class WildcardPatternFileScanner {
    private static final Logger LOG = Loggers.get(WildcardPatternFileScanner.class);
    private static final int SEARCH_MAX_DEPTH = 64;
    private static final String PATH_MATCHER_SPECIAL_CHAR = "*?";

    private WildcardPatternFileScanner() {
    }

    public static List<Path> scan(Path baseDirectory, String patternPath) {
        String unixLikePatternPath = WildcardPatternFileScanner.toUnixLikePath(patternPath);
        int specialCharIndex = WildcardPatternFileScanner.indexOfMatcherSpecialChar(unixLikePatternPath);
        if (specialCharIndex == -1) {
            return WildcardPatternFileScanner.scanNonWildcardPattern(baseDirectory, unixLikePatternPath);
        }
        int additionalBaseDirectoryPart = unixLikePatternPath.lastIndexOf(47, specialCharIndex);
        if (additionalBaseDirectoryPart != -1) {
            Path additionalBaseDirectory = WildcardPatternFileScanner.toFileSystemPath(unixLikePatternPath.substring(0, additionalBaseDirectoryPart + 1));
            String remainingWildcardPart = unixLikePatternPath.substring(additionalBaseDirectoryPart + 1);
            Path moreSpecificBaseDirectory = baseDirectory.resolve(additionalBaseDirectory);
            return WildcardPatternFileScanner.scanWildcardPattern(moreSpecificBaseDirectory, remainingWildcardPart);
        }
        return WildcardPatternFileScanner.scanWildcardPattern(baseDirectory, unixLikePatternPath);
    }

    private static List<Path> scanNonWildcardPattern(Path baseDirectory, String unixLikePath) {
        Path path = baseDirectory.resolve(WildcardPatternFileScanner.toFileSystemPath(unixLikePath));
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return Collections.singletonList(path);
        }
        return Collections.emptyList();
    }

    private static List<Path> scanWildcardPattern(Path baseDirectory, String unixLikePatternPath) {
        if (!Files.exists(baseDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            Path absoluteBaseDirectory = baseDirectory.toRealPath(new LinkOption[0]);
            if (absoluteBaseDirectory.equals(absoluteBaseDirectory.getRoot())) {
                throw new IOException("For performance reason, wildcard pattern search is not possible from filesystem root");
            }
            ArrayList<Path> paths = new ArrayList<Path>();
            WildcardPattern matcher = WildcardPattern.create((String)(WildcardPatternFileScanner.toUnixLikePath(absoluteBaseDirectory.toString()) + "/" + unixLikePatternPath));
            try (Stream<Path> stream = Files.walk(absoluteBaseDirectory, 64, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> matcher.match(WildcardPatternFileScanner.toUnixLikePath(path.toString()))).forEach(paths::add);
            }
            return paths;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Failed to get Jacoco report paths: Scanning '" + baseDirectory + "' with pattern '" + unixLikePatternPath + "' threw a " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return Collections.emptyList();
        }
    }

    static String toUnixLikePath(String path) {
        return path.indexOf(92) != -1 ? path.replace('\\', '/') : path;
    }

    static Path toFileSystemPath(String unixLikePath) {
        return Paths.get(unixLikePath.replace('/', File.separatorChar), new String[0]);
    }

    static int indexOfMatcherSpecialChar(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (PATH_MATCHER_SPECIAL_CHAR.indexOf(path.charAt(i)) == -1) continue;
            return i;
        }
        return -1;
    }
}

