/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PrivilegeEscalationVector;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6317")
public class PrivilegeEscalationCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Narrow these permissions to a smaller set of resources to avoid privilege escalation.";
    private static final Pattern RESOURCE_NAME_PATTERN = Pattern.compile("arn:[^:]*:[^:]*:[^:]*:[^:]*:(role|user|group)/\\*");

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::IAM::ManagedPolicy")) {
            return;
        }
        PolicyUtils.getPolicies(resource.properties()).forEach(policy -> PrivilegeEscalationCheck.checkPrivilegeEscalation(ctx, policy));
    }

    private static void checkPrivilegeEscalation(CheckContext ctx, Policy policy) {
        policy.statement().stream().filter(PrivilegeEscalationCheck::allowsPrivilegeEscalation).forEach(statement -> ctx.reportIssue(statement.resource().get(), MESSAGE));
    }

    private static boolean allowsPrivilegeEscalation(Policy.Statement statement) {
        return statement.effect().filter(PrivilegeEscalationCheck::isAllowEffect).isPresent() && statement.resource().filter(PrivilegeEscalationCheck::isSensitiveResource).isPresent() && statement.action().filter(PrivilegeEscalationCheck::isSensitiveAction).isPresent() && statement.condition().isEmpty() && statement.principal().isEmpty();
    }

    private static boolean isAllowEffect(Tree effect) {
        return TextUtils.isValue(effect, "Allow").isTrue();
    }

    private static boolean isSensitiveResource(Tree resource) {
        return TextUtils.matchesValue(resource, rsc -> rsc.equals("*") || RESOURCE_NAME_PATTERN.matcher((CharSequence)rsc).matches()).isTrue();
    }

    private static boolean isSensitiveAction(Tree action) {
        if (!(action instanceof SequenceTree)) {
            return false;
        }
        Stream<String> actionPermissions = ((SequenceTree)action).elements().stream().map(TextUtils::getValue).flatMap(Optional::stream);
        return PrivilegeEscalationVector.isSupersetOfAnEscalationVector(actionPermissions);
    }
}

