/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.IacToken;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

public abstract class MetricsVisitor
extends TreeVisitor<InputFileContext> {
    public static final String NOSONAR_PREFIX = "NOSONAR";
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private Set<Integer> linesOfCode;
    private Set<Integer> commentLines;
    private Set<Integer> noSonarLines;

    protected MetricsVisitor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.languageSpecificMetrics();
    }

    protected void languageSpecificMetrics() {
        this.register(IacToken.class, (ctx, token) -> {
            if (!token.value().trim().isEmpty()) {
                TextRange range = token.textRange();
                for (int i = range.start().line(); i <= range.end().line(); ++i) {
                    this.linesOfCode().add(i);
                }
            }
            this.addCommentLines(token.comments());
        });
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.linesOfCode = new HashSet<Integer>();
        this.commentLines = new HashSet<Integer>();
        this.noSonarLines = new HashSet<Integer>();
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        MetricsVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.NCLOC, this.linesOfCode.size());
        MetricsVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COMMENT_LINES, this.commentLines.size());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(ctx.inputFile);
        this.linesOfCode.forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        fileLinesContext.save();
        this.noSonarFilter.noSonarInFile(ctx.inputFile, this.noSonarLines);
    }

    protected void addCommentLines(List<Comment> comments) {
        for (Comment comment : comments) {
            String[] lines = comment.contentText().split("(\r)?\n|\r", -1);
            int currentLine = comment.textRange().start().line();
            for (String line : lines) {
                if (line.contains(NOSONAR_PREFIX)) {
                    this.noSonarLines.add(currentLine);
                } else if (!MetricsVisitor.isBlank(line)) {
                    this.commentLines.add(currentLine);
                }
                ++currentLine;
            }
        }
    }

    private static boolean isBlank(String line) {
        return line.chars().noneMatch(Character::isLetterOrDigit);
    }

    private static void saveMetric(InputFileContext ctx, Metric<Integer> metric, Integer value) {
        ctx.sensorContext.newMeasure().on((InputComponent)ctx.inputFile).forMetric(metric).withValue((Serializable)value).save();
    }

    public Set<Integer> linesOfCode() {
        return this.linesOfCode;
    }

    public Set<Integer> commentLines() {
        return this.commentLines;
    }

    public Set<Integer> noSonarLines() {
        return this.noSonarLines;
    }
}

